	NAME	SLAVE
	INCLUDE	PAGESIZE.INC
	TITLE	.SLAVE - Talk to the slave RESET, GSSTAT, READCH, TEST

;	HISTORY
;	Date	Version   Prog.   COMMENTS
;	2/1/85   1.40     CSM     Added dynamic mod change ability.
;	2/1/85   1.40     CSM     Change needed for mod 5 cursor.
;	2/5/85   1.40	  JSC	  Changed access to MSMODE and MSRMOD
;
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	SLVERR:BYTE,	CURSOR:WORD,	COLROW:WORD,	CURLIN:BYTE
	EXTRN	AUXST:BYTE,	STATUS:BYTE,	TTYPE:BYTE,	TOPLIN:WORD
	EXTRN	PCURSR:WORD,	ILETTE:BYTE,	ATFLAG:BYTE,    SCRNMOD:BYTE
	EXTRN	INITMOD:BYTE,	LSADDR:WORD,	MONB26:BYTE,	VMODE:BYTE
	EXTRN	MEMTAB:BYTE,	NBUF:BYTE
DATA	ENDS

CODE 	SEGMENT	PUBLIC	BYTE
	ASSUME 	CS:CODE
	EXTRN	QEXKY:NEAR,	SVMODE:NEAR,	UPDHBR:NEAR

	PUBLIC	RESET
RESET	PROC	NEAR		; Reset (POR) the slave
	MOV	DX,REG0		; Slave command register
	MOV	AL,LOW C$XPOR	;
	OUT	DX,AL		;

	MOV	DX,XSTART	; Poke the slave
	OUT	DX,AL		; With any ole data...

	CALL	WAITSXL		; Wait 'till done
	
RS1:	MOV	AL,TTYPE	; Reselect terminal type
	CALL	SETTYPE		;

	RET			; 

RESET	ENDP
	PAGE
	PUBLIC	GSSTAT
GSSTAT	PROC	NEAR

      	CALL	GETSMOD		; Check for screen mod change

	MOV	DX,REG0		; Set status read command
	MOV	AL,C$ANCP	; Aux status and cursor position
	OUT	DX,AL		;

	MOV	DX,XSTART	; Fire up the old slave
	OUT	DX,AL		;

	CALL	WAITS		; Wait 'till done

;****** Convert WORD to BYTE I/O for EAGLE 1600 ***************************
GS1:	MOV	DX,REG2		; Get cursor position			***
	IN	AL,DX		; Get high order			***
	MOV	AH,AL		; Put it in place			***
	DEC	DX		; Point to low order register		***
	IN	AL,DX		; Get low order byte			***
;	IN	AX,DX		;					***
;**************************************************************************

	MOV	PCURSR,AX	; Save absolute for TOPLIN change tests

	SUB	AX,TOPLIN	; Remove screen offset

     	MOV	CURSOR,AX	;

 	CMP	SCRNMOD,5	; Check for mod 5 display
	JNZ	SKIP		; Skip next instruction if not mod 5

	ADD	AX,52		; In mod 5, status line is still 80 wide
				; To make following divide come out right
	 			; Add (132-80) or 52 to AX
SKIP: 	XOR	DX,DX		; Clear high word before division
	DIV	COLROW		; 
	MOV	CURLIN,AL	; Compute current line number

	MOV	DX,REG3		; Get aux status
	IN	AL,DX		;
	MOV	AUXST,AL	;

	MOV	DX,REG0		; Get main status
	IN	AL,DX		;
	MOV	STATUS,AL	;

	MOV	AH,AL		; Make a copy of the status
	AND	AH,-1-M$TRIG	; Clear off the  trigger bit

	TEST	AH,M$DIRT+M$CMOV+M$CPOR	; Dirty, Key empty, Move, POR
	JZ	GS3		; No clear needed

	MOV	AL,C$CLST	; Clear status bits
	OUT	DX,AL		;

	MOV	DX,REG3		; Status byte clear mask
	MOV	AL,AH		; Get the status bits back
	OUT	DX,AL		;

	MOV	DX,XSTART	; Get the slave going on the clear 
	OUT	DX,AL		;

	CALL	WAITS		; Wait 'till done

GS3:	RET

GSSTAT	ENDP
	PAGE
	PUBLIC	READCH
READCH	PROC	NEAR
	MOV	DX,REG0		; Read character [SI] from slave buffer
	MOV	AL,C$READ	;
	OUT	DX,AL		;

	MOV	DX,REG1		; Slave read address register
	MOV	AX,SI		;
;****** Convert WORD to BYTE I/O for EAGLE 1600 ***************************
;	OUT	DX,AX		;					***
	OUT	DX,AL		; Low byte				***
	INC	DX		; Point to high byte place		***
	MOV	AL,AH		;					***
	OUT	DX,AL		;					***
;**************************************************************************

	MOV	DX,XSTART	; Kick the slave
	OUT	DX,AL		;

	CALL	WAITS		; Wait 'till done

GTC1:	MOV	DX,REG2		; Get EAB
	IN	AL,DX		;
	XCHG	AH,AL		;

	MOV	DX,REG3		; Get data
	IN	AL,DX		;
	RET

READCH	ENDP
	PAGE
	PUBLIC	SELPEN
SELPEN	PROC	NEAR
	PUSH	AX		; Save selector address

	MOV	DX,REG0		; Read character [SI] from slave buffer
	MOV	AL,C$LPEN	;
	OUT	DX,AL		;

	POP	AX		;
	MOV	DX,REG1		; Slave read address register
;****** Convert WORD to BYTE I/O for EAGLE 1600 ***************************
;	OUT	DX,AX		;					***
	OUT	DX,AL		; Low byte				***
	INC	DX		; Point to high byte place		***
	MOV	AL,AH		;					***
	OUT	DX,AL		;					***
;**************************************************************************

	MOV	DX,XSTART	; Kick the slave
	OUT	DX,AL		;

	CALL	WAITS		; Wait 'till done

LPC1:	RET

SELPEN	ENDP
	PAGE
	PUBLIC	SETTYPE		;
SETTYPE	PROC	NEAR		; Set terminal type
	MOV	DX,REG3		; Set the terminal type
	OUT	DX,AL		;

	MOV	DX,REG0		; Set terminal type command
	MOV	AL,C$SETT	;
	OUT	DX,AL		;

	MOV	DX,XSTART	; Get the slave moving
	OUT	DX,AL		;
	
	CALL	WAITSXL		; Extra long if type has changed

SET2:	RET			; All is well

SETTYPE	ENDP
	PAGE
	PUBLIC	TEST
TEST	PROC	NEAR
	TEST	ILETTE,255
	JZ	TE0A		; No ILETTE
	JMP	TE3		; Skip time tests, ILETTE fails !

TE0A:	MOV	DX,XFLAGS	; See if the slave is IDLE
	CMP	ATFLAG,0FFH
	JZ	TEST1
	MOV	CX,ATCONT
	JMP	SHORT TE0
TEST1:	MOV	CX,TCONT	;

TE0:	IN	AL,DX		; Get current slave state
	TEST	AL,M$BUSY	;
	LOOPNZ	TE0		; Loop if still busy

	JZ	TE1		; Skip error exit iff all is well

	MOV	SLVERR,SE$ID	; Slave should have been idle by now.
	JMP	SHORT TERR	;

TE1:	MOV	DX,REG0		; Give the slave a simple command
	MOV	AL,C$READ	; Read something
	OUT	DX,AL		;

	MOV	DX,REG1		; A real address would be nice
	XOR	AX,AX		;
;****** Convert WORD to BYTE I/O for EAGLE 1600 ***************************
;	OUT	DX,AX		;					***
	OUT	DX,AL		;					***
	INC	DX		; Point to high order place		***
	MOV	AL,AH		;					***
	OUT	DX,AL		;					***
;**************************************************************************

	MOV	DX,XSTART	; Get the slave on the move
	OUT	DX,AL		; 

	MOV	DX,XFLAGS	; Wait for completion
	CMP	ATFLAG,0FFH
	JZ	TEST2
	MOV	CX,ATCONT
	JMP	SHORT TE2
TEST2:	MOV	CX,TCONT	;

TE2:	IN	AL,DX		; Get slave status
	TEST	AL,M$BUSY	;
	LOOPNZ	TE2		;

	JZ	TE3		; Slave responded in time...

	MOV	SLVERR,SE$TO	; Slave did not respond in time
	JMP	SHORT TERR	;

TE3:	STC			; Successful exit
	RET			;

TERR:	CLC			; Error exit
	RET			;

TEST	ENDP

	PUBLIC	WAITS
WAITS	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS

WA0:	CALL	QEXKY
	JZ	WAITX

	MOV	DX,XFLAGS

	MOV	AL,ATFLAG	; Use extra long timeout for IBM PC/AT
	OR	AL,AL
	JZ	WA01
	MOV	CX,ATCONT
	JMP	WA1
	
WA01:	MOV	CX,TCONT

WA1:	IN	AL,DX
	TEST	AL,M$BUSY
	LOOPNZ	WA1
	JZ	WAITX

	TEST	ILETTE,255
	JNZ	WA0

	MOV	SLVERR,SE$TO

WAITX:	POP	DS
	POP	ES
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

WAITS	ENDP

	PUBLIC	WAITSXL
WAITSXL	PROC	NEAR

	PUSH	CX
	PUSH	WORD PTR SLVERR

	CMP	ATFLAG,0FFH
	JNE	ATW0
	MOV	CX,2000
	JMP	SHORT WA2
ATW0:	MOV	CX,500
WA2:	CALL	WAITS
	LOOP	WA2
	POP	WORD PTR SLVERR
	JZ	WA3
	MOV	SLVERR,SE$TO
WA3:	POP	CX
	RET

WAITSXL	ENDP				

	PUBLIC	GETSMOD
GETSMOD	PROC	NEAR

; This procedure checks to see if the screen mod has changed or not.
; If the screen mod has changed svmode will be called to implement this.

	CMP	SCRNMOD,0	; not IRMAvision so don't look for mod change
	JZ	GOBACK

	CMP	INITMOD,5	; If the initial mod is not mod5 go back
	JNZ	GOBACK

	CMP	NBUF,0		; If current screen is recalled from memory
	JNZ	GOBACK		; then goback

	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP

	MOV	BL,SCRNMOD	; Get it near by

	CMP	BL,5		; Is scrnmod already mod 5?
	JZ	TRYM2		; Yes it's mod 5.  Do we go to mod 2?
				; no, it's not mod5. Does it need to be?

	MOV	SI,1F48H
	CALL	READCH		; Get byte in AL from IRMA
	AND	AL,0E0H		; Make lower 5 bits zero

	CMP	AL,0C0H		; Should we become mod 5?
	JNZ	CLEANUP		; Nope, we stay mod 2

	MOV	SCRNMOD,5	; yes, we will now become mod 5!
	MOV	MEMTAB.MSRMOD[0],5 ; Set set-recall SCREENMOD
	MOV	AX,0E7H		; Set ax for SVMODE procedure
	MOV	VMODE,0E7H	; Set VMODE with same
	MOV	MEMTAB.MSMODE[0],AL ; Set set-recall VMODE

	CALL	SVMODE		; Set video parameters on IRMAvision

	CALL	UPDHBR		; Reset horizontal bar

	JMP	CLEANUP

TRYM2:	MOV	SI,1F48H	; Do we need to become mod 2?
	CALL	READCH		; ASK IRMA for byte in AL
	AND  	AL,0E0H		; Make lower five bits zero

	CMP	AL,0		; Did IRMA say become mod 2?
	JNZ	CLEANUP		; NO, stay just like we were

	MOV	SCRNMOD,2	; Yes, now become mod 2!
	MOV	MEMTAB.MSRMOD[0],2 ; Set set-recall SCREENMOD
	MOV	AX,027H		; Set AX for SVMODE to use
	MOV	VMODE,AL   	; Set VMODE with same
	MOV	MEMTAB.MSMODE[0],AL ; Set set-recall VMODE

	CALL	SVMODE		; Go set IRMAvision for mod 2

	CALL	UPDHBR		; Reset horizontal bar

CLEANUP: POP 	BP		; Clean up stack
	POP 	DI
	POP 	SI
	POP 	DX
        POP 	CX
	POP 	BX
	POP 	AX

GOBACK:	RET

GETSMOD	ENDP

CODE	ENDS

	END
