	NAME	LPEN
	INCLUDE	PAGESIZE.INC
	TITLE	.LPEN - Light pen 3278 interface with mouse pen additions

;
;  9-5-84.	Fixed lpen selection to ignore non-detectable field.
;  4-27-85.	Added in a flag to disable routine if necessary, since LPEN
;		electronic inputs on color board float and are not tied high.
;

DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	EXTRN	LPBNC:BYTE,	TOPLIN:WORD,	COLROW:WORD,	LPDLY:BYTE
	EXTRN	LASTFD:BYTE,	LPENFG:BYTE,	DISABLP:BYTE

LPCNTS	EQU	5		; Light pen pick control characters
LPICK	DB	0		; NULL
	DB	10H		; SPACE
	DB	08H		; >
	DB	18H		; ?
	DB	30H		; &

DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	LPENCHK:NEAR,	READCH:NEAR,	SELPEN:NEAR,	TWOCLICK:NEAR
	EXTRN	BEEP:NEAR

	PUBLIC	LPEN,MOPEN
LPEN	PROC	NEAR			; Debounce & clean up LPEN stuff
	CMP	DISABLP,0		; Is the light pen disabled??
	JNZ	LP1			; Jump if light pen is disabled

	CMP	LPDLY,0			; Are we runnable?
	JZ	LPGO			; Yes!

LP1:	RET				; No wait some more

LPGO:	CALL	LPENCHK			; See if there is anything to do
	JC	MAYBE			; 

	MOV	LPBNC,0			; Clear PEN DOWN flag

LPNO0:	RET				; And exit to wait for new picks

MAYBE:	MOV	LPDLY,4			; Wait ~.2S
	TEST	LPBNC,1			; Is the pen already down?
	JZ	YESPEN			; No, this is a new pick

	RET				; Pen still down, back to sleep

YESPEN:	MOV	LPBNC,1			; Set pen down flag

	CMP	CX,80*24		; Is it beyond the end of screen?
	JNAE	NBOUND			; No, it is in bounds

	RET				; Pick is out of bounds

MOPEN	LABEL	NEAR			; Enter w/ mouse address in CX here

NBOUND:	ADD	CX,80			; Move up beyond the status line
	ADD	CX,TOPLIN		; And any big screen offset
	MOV	AX,CX			; Put in place for a DIVIDE
	XOR	DX,DX			; Extension zero
	MOV	BX,COLROW		; Usually 80.
	DIV	BX			; 80

	PUSH	AX			; Save line number (AL)
	MUL	BX			; AX is now line w/o column offset

	MOV	SI,AX			; Offset into screen buffer
	MOV	BH,BL			; Make a copy of the count
	MOV	BL,0			; Field count

; BH=max col, BL=# detectable fields, SI->buffer, CX=light pen address
SCAN:	PUSH	CX			; Save the scan pointer
	CALL	READCH			; Get attribute char from the slave
	POP	CX			;

	CMP	AL,0C0H			; Is this an attribute fellow?
	JNAE	SCAN0			;

	MOV	LASTFD,AL		; save all flags, especially detect.
	AND	AL,00001100B		; Remove all except detect control
	JZ	SCAN0			; Normal, non-detect
	CMP	AL,00001100B		; Non display?
	JZ	SCAN0			; Yes, bogus pick

	PUSH	SI			; Save registers
	PUSH	CX			;

	INC	SI			; Check for pick control character
	CALL	READCH			;

	MOV	SI,-1			; Prepare offset into LPICK table
	MOV	CX,LPCNTS		;

PIK0:	INC	SI			; Point to next entry in LPICK
	CMP	AL,LPICK[SI]		; Is this a valid pick control char?
	LOOPNZ	PIK0			; Until a pick or abandon.
	JNZ	PIK1			; Ran out of possibilitys, no pick.

	INC	BL			; We have counted an attribute

PIK1:	POP	CX			; Restore used registers
	POP	SI			;

SCAN0:	CMP	SI,CX			; Is this the mark?
	JZ	FOUND			; Yes, we are done scanning

	INC	SI			; Next position
	DEC	BH			; Max characters on one line!
	JNZ	SCAN			; More things to see & do.
	JMP	PENXCC			; Bogus light pen location!

FOUND:	CMP	BL,0			; Is this legal?
	JZ	PENXCC			; No, do not bother

	CMP	LPENFG,1
	JNE	FOUND1			; Check for GENX flag = 1.
; Last field found must be detectable
	MOV	AL,LASTFD
	AND	AL,00001100B		; Remove all except detect control
	JZ	PENXCC			; error, normal non-detect
	CMP	AL,00001100B		; Non display  non-detect
	JZ	PENXCC			; error, bogus pick

FOUND1:	POP	AX			; Get line into AL
	MOV	AH,BL			; Setup to send selector pen
	CALL	SELPEN			; Send the pick to IBM
	CALL	TWOCLICK		; Say hello.
	RET

PENXCC:	POP	AX			; This was just hanging around...
	CALL	BEEP			; Complaint department
	RET				; And exit

LPEN	ENDP

CODE	ENDS

	END
