	NAME	CACHE
	INCLUDE	PAGESIZE.INC
	TITLE	.CACHE - Screen save cache & managers CACHEIN, CACHEOUT

DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	CACPOS:WORD,	CACTYP:WORD,	CAVMOD:BYTE,	CACPAG:BYTE
	EXTRN	CASIZE:WORD,	CACHE:BYTE,	VMODE:BYTE,	MONOFLG:BYTE
	EXTRN	CACSHP:BYTE,	SCRNMOD:BYTE
DATA	ENDS
	PAGE
CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	VIDEON:NEAR,	VIDEOFF:NEAR,	SVMODE:NEAR

;HISTORY
;DATE	     	VERSION	      PROG.	COMMENTS
;11-7-85	1.40 	      CSM	Added IRMAvision support

	PUBLIC	CACHEIN
CACHEIN	PROC	NEAR
	MOV	AH,15		; Get current video state
	INT	10H		;

	MOV	CAVMOD,AL	; Video display mode
	MOV	VMODE,AL	; Mode to use for VIDEON
	MOV	CACPAG,BH	; Active page

	MOV	CASIZE,26*80    ; Default monochrome screen size (characters)
	CMP	AL,7		; BW 80 MODE
	JZ	CSN		; Normal screen size

	CMP	AL,4		; This is the first graphics mode
	JC	CSN		; It is less (0-3)

CSN:	MOV	AH,3		; Read current cursor position and type
	INT	10H		;

	MOV	CACPOS,DX	; Save current cursor position
	MOV	CACTYP,CX	; System cursor definition

	CALL	VIDEOFF		; Turn off the display

	MOV	SI,0		; Start with the beginning of the screen
	MOV	CX,CASIZE 	; Number of words on the screen to save

CIN0:	MOV	BL,ES:[SI]	; Get a character from the screen
	MOV	BH,ES:[SI+1]	; One byte at a time for 8086/PC fans...
	MOV	WORD PTR CACHE[SI],BX
	ADD	SI,2		; Next word
	LOOP	CIN0		;

	CALL	VIDEON		; Turn the display back on...

	RET

CACHEIN	ENDP
	PAGE
	PUBLIC	CACHEOUT
CACHEOUT PROC	NEAR

	MOV	SCRNMOD,0	; Reset to normal screen

	MOV	AL,CAVMOD	; Set video mode
	MOV	VMODE,AL	; For VIDEON
	CALL	SVMODE		; WITHOUT FOULING UP COLORS!

	MOV	AH,5		; Current page
	MOV	AL,CACPAG	;
	INT	10H		;

	MOV	AH,1		; Set cursor type

	TEST	CACSHP,255	; Is this an always function?
	JNZ	CDFIX		; Yes, ignore old info.

	MOV	CX,CACTYP	;
	TEST	CX,1110000011100000B ; Check for bogus bits
	JZ	NDFIX		;

CDFIX:	MOV	CX,607H		; Repair the returned cursor type
	CMP	MONOFLG,MF$C	; Is this normal color?
	JZ	NDFIX		; Yes, 607 is Ok. (6,7)

	MOV	CX,0B0CH	; No, monochrome is 11,12

NDFIX:	INT	10H		;

	MOV	AH,2		; Set cursor position
	MOV	BH,CACPAG	;
	MOV	DX,CACPOS	;
	INT	10H		;

	CALL	VIDEOFF		; Turn off the display processor

	MOV	DI,0		; Start at the beginning
	MOV	CX,CASIZE	;

CUT0:	MOV	BX,WORD PTR CACHE[DI]
	MOV	ES:[DI],BL	; Low byte for 8086 fans
	MOV	ES:[DI+1],BH	;
	ADD	DI,2		;
	LOOP	CUT0		;

	CALL	VIDEON		; Turn the display back on...

	RET			;

CACHEOUT ENDP

CODE	ENDS

	END
