	NAME	KYBDCODE
	INCLUDE PAGESIZE.INC
	INCLUDE SKFLAG.INC
	TITLE	.KYBDCODE - BIOS KEYBOARD routine replacement
	INCLUDE PUBLICS.EQU

DATA	SEGMENT PUBLIC BYTE
	ASSUME	DS:DATA

	IFE SKFLAG

	EXTRN	KEYNORM:BYTE, KEYSHFT:BYTE, KEYALT:BYTE,  KEYCTRL:BYTE
	EXTRN	KEYLOCK:BYTE, EKYNORM:BYTE, EKYSHFT:BYTE, EKYALT:BYTE
	EXTRN	EKYCTRL:BYTE, KYPRECD:BYTE, 
	EXTRN	KYCSHFA:BYTE, KYCSHFB:BYTE, KYCCTLA:BYTE, KYCCTLB:BYTE
	EXTRN	KYCALTA:BYTE, KYCALTB:BYTE, KYCCAPA:BYTE, KYCCAPB:BYTE
	EXTRN	KYCNUMA:BYTE, KYCNUMB:BYTE, KYCSCLA:BYTE, KYCSCLB:BYTE
	EXTRN	KYSSUPR:BYTE, KYSBRK:BYTE,  KYSHOLD:BYTE, KYSREST:BYTE
	EXTRN	KYASHF:BYTE,  
	EXTRN	SUPKEY:BYTE,  TRESPAS:BYTE, 
	EXTRN	KEYPASS:BYTE, KEYBUF:WORD,  KYC:BYTE,	  KYS:WORD
	EXTRN	KYCJTAB:WORD, KYSJTAB:WORD, KEYTAB:WORD,  EKEYTAB:WORD
	EXTRN	E1TAB:WORD,   KB_TEST_SW:BYTE

	ENDIF

	EXTRN	OKBSRV:DWORD,	OI24V:WORD,	OKBVEC:WORD,   KFLG:BYTE
	EXTRN	LSADDR:WORD,	RESFLG:BYTE,	SSFLG:BYTE,    KB_LED_STAT:BYTE
	EXTRN	ATFLAG:BYTE,	ALTMOD2:BYTE,	ERICKEY:BYTE, KB_MISC_STAT:BYTE

;******************************************************************************
;*		      R E V I S I O N	 H I S T O R Y			      *
;******************************************************************************
;*									      *
;*	1.32	Added a jump which checked to see if an exit for the PC/AT    *
;*		needed to be performed.  The instigation of this was the      *
;*		fact that the print screen function no longer worked.	      *
;*									      *
;*	1.41	3-1-85	Ericsson PC added. kbd				      *
;*		3-28-85  Olivetti Deluxe keyb.				      *
;*									      *
;*	1.43	SKDRIVER interface added to allow for IRMAKEY		      *
;*		(All changes marked [sk] )				      *
;*									      *
;*	1.44	Added disk write recovery handler INT 24 replacement.	      *
;*									      *
;*	1.48	Added support for the new Enhanced Keyboard		      *
;*									      *
;******************************************************************************

; System defined equates

KBDATA		EQU	60H		; Keyboard data port
KBCTL		EQU	61H		; Keyboard/speaker control port
KBD_STATUS	EQU	64H
ICTL		EQU	20H		; Interrupt control port

BIOSSEG EQU	40H			; BIOS local data segment

BIOSRFG  EQU	72H			; BIOS RESET flag bytes (2)
BIOSBRK  EQU	71H			; BIOS BREAK flag byte
BIOSKFLG EQU	17H			; BIOS shift state flags
BIOSSFLG EQU	18H			; BIOS internal key flags


; KFLG contains bits used to compute current shift status and keyboard state.
;   The lower nybble in this byte is assumed to correspond to the nybbles
;   in the KEYLOCK table (KYL record).	This byte is also assumed to match
;   the format of the BIOS byte KB_FLG.

KFLGNU	EQU	 1H			; Numbers shift key
KFLGSH	EQU	 2H			; Shift key pressed
KFLGCT	EQU	 4H			; Control key
KFLGAL	EQU	 8H			; Alternate key pressed
KFLGSC	EQU	10H			; Scroll lock key activated
KFLGNL	EQU	20H			; Numeric lock key activated
KFLGCL	EQU	40H			; Caps lock key activated
KFLGIN	EQU	80H			; Insert state

; SSFLG contains bits used to manage Shift States such as CAPS LOCK and INS.
;   This byte is assumed to match BIOS byte KB_FLAG_1.

SFLGHH	EQU	 8H			; Hold state
SFLGSC	EQU	KFLGSC			; Scroll lock down
SFLGNL	EQU	KFLGNL			; Numeric lock down
SFLGCL	EQU	KFLGCL			; Caps lock down
SFLGIN	EQU	KFLGIN			; Insert key down

; KB_LED_STAT contains bits used to the keyboard LEDs also there is other
;   support information for the AT BIOS keyboard support.

LED_BITS	EQU    07H		; All three LEDs turned on
;		       01H		; Scroll Lock LED
;		       02H		; Num Lock LED
;		       04H		; Caps Lock LED
KB_ACK_REC	EQU    10H		; Keyboard Acknowledge Received Flag
KB_RESEND	EQU    20H		; Resend Received Flag
UPDATE_IN_PROG	EQU    40H		; LEDs Update in Progress
KBD_ERROR_FLAG	EQU    80H		; Keyboard Transmit Error Occured Flag

; KB_MISC_STAT contains bits used by the Enhanced keyboard in a PC/XT or PC/AT
;   as well as status flags used by the new keyboard protocol.

LAST_WAS_E0	EQU	01H		; The Last Key Scan Code was an E0
LAST_WAS_E1	EQU	02H		; The Last Key Scan Code was an E1
R_CTRL_MADE	EQU	04H		; Right Ctrl Shift Make Code Received
R_ALT_MADE	EQU	08H		; Right Alt Shift Make Code Received
ALT_GRAPH	EQU	08H		; Alt (Graphics) Key Make Received
KYBD_EXTD	EQU	10H		; Enhanced Keyboard Installed
NUM_LOCK_ON	EQU	20H		; Set the Num Lock if Extd KBD & READID
FIRST_ID_BYTE	EQU	40H		; First Byte of a Read ID was Received
READ_ID_ACTIVE	EQU	80H		; Read ID is in Progress

SPECKEYS=	5			; Count of special key templates
SHIFTKEYS=	8

RESEND_REQ	EQU	0FEH
ACK_KBD	EQU	0FAH
DISABLE_KBD	EQU	0ADH
ENABLE_KBD	EQU	0AEH
KBD_ENABLE_CMD	EQU	0F4H
SET_RESET_CMD	EQU	0EDH
KFLG_LED_BITS	EQU	70H
KBD_BUF_FULL	EQU	02H

XTD_RSHF_SET	EQU	01H
XTD_LSHF_SET	EQU	02H
XTD_BITS_SET	EQU	03H

END_OF_INTERRUPT	EQU	20H
RETRY_COUNT		EQU	03H

OFSET	DW	0		; Place to save BX
SAVEARR	DB	100 DUP(0)	; The Data

DATA	ENDS
	PAGE

CODE	SEGMENT PUBLIC BYTE
	ASSUME	CS:CODE

	PUBLIC	KYINSTL, KYRLSE

	IFE	SKFLAG

	PUBLIC	CSHIFT, CNUSHF, CCTRL, CALT,  CCAPS
	PUBLIC	CNUM,	 CSCRL,  CINS,	 SUPERK, SBRK,	SHOLD, SREST
	PUBLIC	SPRNT

	ENDIF

	EXTRN	RINGROOM:NEAR,RINGIN:NEAR,RINGOUT:NEAR,RINGMT:NEAR
	EXTRN	MESSAGE:NEAR,UPDRST:NEAR
	EXTRN	SLVERR:BYTE

	IF	SKFLAG

	EXTRN	SKINIT:NEAR, SKIFACE:NEAR	; [sk]

	ENDIF					; [sk]

KYINSTL PROC	NEAR			; Install keyboard interrupt handler
	PUSH	ES			; Point to interrupt vector area
	PUSH	DS			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX

	CLI				; No interrupts while vectors move!

	IFE	SKFLAG

	MOV	AX,BIOSSEG		; Get keyboard state variables
	MOV	DS,AX			;

	MOV	BL,BYTE PTR DS:[BIOSKFLG]; Get current key states for init
	MOV	BH,BYTE PTR DS:[BIOSSFLG];
	MOV	CL,BYTE PTR DS:[97H]	; Get the IBM KB_FLAG_2 byte
	MOV	CH,BYTE PTR DS:[96H]	; Get the IBM KB_FLAG_3 byte

	ENDIF

	MOV	AX,DATA		; Point to internal data area
	MOV	DS,AX			;

	MOV	KFLG,BL		; Save the key states
	MOV	SSFLG,BH		;
	MOV	KB_LED_STAT,CL
	MOV	KB_MISC_STAT,CH

	XOR	AX,AX			;
	MOV	ES,AX			;

	MOV	AX,WORD PTR ES:[(9*4)+0]; Low half, previous handler
	MOV	BX,WORD PTR ES:[(9*4)+2]; High half
	MOV	WORD PTR OKBVEC[0],AX	; Save it away
	MOV	WORD PTR OKBVEC[2],BX	;

	IFE	SKFLAG

	MOV	WORD PTR ES:[(9*4)+0],OFFSET KBINT ; Place new handler vector
	MOV	WORD PTR ES:[(9*4)+2],SEG    KBINT ;

	ENDIF

	MOV	AX,WORD PTR ES:[(22*4)+0]; Low half, I/O call
	MOV	BX,WORD PTR ES:[(22*4)+2]; High half
	MOV	WORD PTR OKBSRV[0],AX	 ; Save it away
	MOV	WORD PTR OKBSRV[2],BX	 ;

	IFE	SKFLAG

	MOV	WORD PTR ES:[(22*4)+0],OFFSET KBSRV ; Keyboard I/O service
	MOV	WORD PTR ES:[(22*4)+2],SEG    KBSRV ;

	ENDIF

	MOV	AX,WORD PTR ES:[(36*4)+0]; Low half, I/O call.	INT 24 hex
	MOV	BX,WORD PTR ES:[(36*4)+2]; High half
	MOV	WORD PTR OI24V[0],AX	 ; Save it away
	MOV	WORD PTR OI24V[2],BX	 ;

	MOV	WORD PTR ES:[(36*4)+0],OFFSET I24HAN ; int 24h.
	MOV	WORD PTR ES:[(36*4)+2],SEG    I24HAN ; Critical error handler

	STI				; Allow interrupts

	POP	CX
	POP	BX			; Restore user's registers
	POP	AX			;
	POP	DS			;
	POP	ES			;
	RET				; And back to the caller.

KYINSTL ENDP		

KYRLSE	PROC	NEAR			; Release keyboard interrupt
	PUSH	ES			;
	PUSH	DS			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX

	MOV	AX,DATA		; Setup data segment for sure
	MOV	DS,AX			;

	CLI				; No interrupts while vector changes

	XOR	AX,AX			; Point to vector segment
	MOV	ES,AX			;

	IFE	SKFLAG

	MOV	AX,WORD PTR OKBVEC[0]	; Get previous vector
	MOV	BX,WORD PTR OKBVEC[2]	;
	MOV	WORD PTR ES:[(9*4)+0],AX; Put it back where we found it.
	MOV	WORD PTR ES:[(9*4)+2],BX;

	ENDIF

	MOV	AX,WORD PTR OKBSRV[0]	; Previous I/O driver vector
	MOV	BX,WORD PTR OKBSRV[2]	;
	MOV	WORD PTR ES:[(22*4)+0],AX
	MOV	WORD PTR ES:[(22*4)+2],BX


	MOV	AX,WORD PTR OI24V[0]	; Previous Int 24h error handler
	MOV	BX,WORD PTR OI24V[2]	;
	MOV	WORD PTR ES:[(36*4)+0],AX
	MOV	WORD PTR ES:[(36*4)+2],BX

	MOV	BL,KFLG		; Pass on the current keyboard state
	MOV	BH,SSFLG		;
	MOV	CL,KB_LED_STAT
	MOV	CH,KB_MISC_STAT

	IFE	SKFLAG

	MOV	AX,BIOSSEG		; Point to BIOS internal data area
	MOV	DS,AX			;


	MOV	BYTE PTR DS:[BIOSKFLG],BL; Update BIOS information
	MOV	BYTE PTR DS:[BIOSSFLG],BH;
	MOV	BYTE PTR DS:[96H],CH
	MOV	BYTE PTR DS:[97H],CL

	ENDIF

RLS1:	STI				; Re-enable interrupts

	IF	SKFLAG

	CALL	SKIFACE ; [sk]	Restore key formats

	ENDIF

	POP	CX
	POP	BX			; Restore user's registers
	POP	AX			;
	POP	DS			;
	POP	ES			;
	RET				;

KYRLSE	ENDP

I24HAN	PROC	FAR
	MOV	SLVERR,SE$WE		;INT 24h Critical error handler
	MOV	AL,0			; Simulate ignore return to DOS
	IRET
I24HAN	ENDP


KEYBEEP PROC	NEAR			; Keyboard overrun beeper
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX			;

	MOV	BX,128			; Duration of beep (~ .1 second)

	IN	AL,KBCTL		; Keyboard control port
	PUSH	AX			; Status save

BEE0:	AND	AL,0FCH		; Turn off timer & spkr gating
	OUT	KBCTL,AL		;

	MOV	CX,72			; Pitch magic constant
BEE1:	LOOP	BEE1			; Half cycle one

	OR	AL,2			; Turn on speaker
	OUT	KBCTL,AL		;

	MOV	CX,72			; 
BEE2:	LOOP	BEE2			; Half cycle two

	DEC	BX			; One less cycle to do
	JNZ	BEE0			; Do more cycles...

	POP	AX			; Restore keyboard status
	OUT	KBCTL,AL		;

	POP	CX			; Restore user's registers
	POP	BX			;
	POP	AX			;
	RET				; End of BEEEEEEEP!

KEYBEEP ENDP 


	IFE SKFLAG

KBSRV	PROC	FAR			; User keyboard service access
	STI				; Allow interrupt service...

	PUSH	DS			; Save a few neccessary registers
	PUSH	DI			;
	PUSH	DX			;
	PUSH	CX			;
	PUSH	BX			;

	MOV	BX,DATA		; Set up DATA segment
	MOV	DS,BX			;

	PUSH	AX			; Do not disturb during superman check

	TEST	SUPKEY,0FFH		; Is this a SUPER time?
	JTBC	NOMAN			; No, superman not availible now.

	MOV	SUPKEY,0		; We are doing it. Turn off the req.

	TEST	RESFLG,0FFH		; Is the SUPERKEY! feature disallowed
	JTBC	MAN			; Because of residency? Jump if NO.

	MOV	SI,OFFSET TRESPAS	; No passthrough availible
	MOV	DI,LSADDR		; On the status line, if you please.
	CALL	MESSAGE		;
	JMP	SHORT NOMAN		;

MAN:	CALL	KYRLSE			; Allow the normal DOS handler keys

	MOV	SI,OFFSET KEYPASS	; Pass-through key message
	MOV	DI,LSADDR		;
	CALL	MESSAGE		; Say hello!

	MOV	AH,7			; DOS get key w/o echo
	INT	21H			;

	CALL	KYINSTL		; Put the keyboard handler back

NOMAN:	POP	AX			; Restore command

	CMP	AH,2+1			; See if call number too large
	JB	KBS1			; Not too big, continue

KBS0:	POP	BX			; Bogus call
	POP	CX			; Get the heck out of Dodge
	POP	DX			;
	POP	DI			;
	POP	DS			;
	IRET				; Back with no changes...

KBS1:	OR	AH,AH			; Test for ZERO
	JZ	KBREAD			; Read request w/ wait

	DEC	AH			; Test for ONE
	JZ	KBTEST			; Check for character waiting

	DEC	AH			; Test for TWO
	JZ	KBSHFT			; Return current shift status

	JMP	KBS0			; Should never get here...

; Read keystroke from buffer, wait if none availible

KBREAD: CMP	ATFLAG,0FFH		; Is this an IBM PC/AT
	JNE	KBR0			; Jump if not PC/AT

	CALL	GET_LED_STATE		; Get the info about which bits are on

	MOV	DL,KB_LED_STAT
	XOR	DL,AL
	AND	DL,LED_BITS
	JZ	KBR0
	CALL	UPDATE_LEDS

KBR0:	MOV	DI,OFFSET KEYBUF	; Point to keyring

KBRD0:	CALL	RINGOUT		; Try to get a key
	JNC	KBRD0			; Until one appears...

	MOV	AH,AL			; Save the first byte

KBRD1:	CALL	RINGOUT		; Wait for the second byte to show up
	JNC	KBRD1			;

	XCHG	AH,AL			; Position the bytes as needed.

	JMP	KBS0			; Use the easy return route.

; Return shift status bits from KFLG

KBSHFT: MOV	AL,KFLG		; Get the shift flag state
	JMP	KBS0			; And exit the easy way

; Test for keys in buffer.

KBTEST: CLI				; No interrupts during look ahead!

	MOV	DI,OFFSET KEYBUF	; See if characters await!

	PUSH	KEYBUF[0]		; Save input & output pointers
	PUSH	KEYBUF[2]		;

	CALL	RINGOUT		; Get low byte
	JNC	KBT1			; Not enough data in the ring!
	MOV	AH,AL			; 

	CALL	RINGOUT		; Get high byte
	JNC	KBT1			;
	XCHG	AH,AL			; Put them in normal positions

KBT0:	OR	AX,AX			; Set the flags...
	POP	KEYBUF[2]		; Restore ring pointers to usual 
	POP	KEYBUF[0]		;

	STI				; Allow interrupts again

	POP	BX			; Restore registers
	POP	CX			;
	POP	DX			;
	POP	DI			;
	POP	DS			;

	RET	2			; Return w/o restoring flags...

KBT1:	XOR	AX,AX			; Zero with no look ahead!
	JMP	KBT0			; And exit w/ flags intact

KBSRV	ENDP
	PAGE
KBINT	PROC	FAR			; Keyboard interrupt service code
	STI				; Allow other device interrupts
	PUSH	BP			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;
	PUSH	SI			;
	PUSH	DI			;
	PUSH	DS			;
	PUSH	ES			;

	CLD

	MOV	BX,DATA		; Point to local data segment
	MOV	DS,BX			;

	CMP	ATFLAG,0FFH		; Is this an AT PC
	JE	ATKBINT		; Jump If IBM PC AT
	JMP	KBINT1

ATKBINT:
	MOV	AL,DISABLE_KBD
	CALL	SEND_TO_KBD_CONTROL_PORT

	CALL	WAITKBD	; Wait for the keyboard busy status to clear

	IN	AL,KBDATA
	STI

	CMP	AL,RESEND_REQ
	MOV	AH,KB_RESEND
	JZ	ATKBD1

	CMP	AL,ACK_KBD
	MOV	AH,KB_ACK_REC
	JNZ	ATKBD2

ATKBD1: CLI
	OR	KB_LED_STAT,AH
	JMP	KBIXIT

ATKBD2: PUSH	AX
	CALL	GET_LED_STATE

	MOV	DL,KB_LED_STAT
	XOR	DL,AL
	AND	DL,LED_BITS
	JZ	SKIP_UPDATE
	CALL	UPDATE_LEDS

SKIP_UPDATE:	
	POP	AX
	MOV	AH,AL

	CMP	AL,0FFH
	JE	AT1
	JMP	KBI0

AT1:	CALL	KEYBEEP
	JMP	KBIXIT


	PUBLIC	KBINT1
KBINT1: IN	AL,KBDATA		; Get the character
	PUSH	AX			; Save the keycode (AL)

	IN	AL,KBCTL		; Reset the keyboard ready
	MOV	AH,AL			; Save current state
	OR	AL,80H			; Keyboard reset bit
	OUT	KBCTL,AL		;
	XCHG	AH,AL			; Restore previous state
	OUT	KBCTL,AL		;

	POP	AX			; Restore keycode to AL
	MOV	AH,AL			; Make a local copy...

KDBG:	CMP	AL,0FFH		; Has the keyboard been OVERRUN?
	JNE	KBI0			; No, skip the beeper

	CALL	KEYBEEP		; Sound the Alarums!!
	JMP	KBIXIT			; And punt!

KBI0:	MOV	DL,AL			; Save another copy of the key
	AND	AL,07FH		; Remove the key^up bit

	PAGE
;******************************************************************************
;*		     Enhanced Keyboard INT 9 Code			      *
;******************************************************************************

	CMP	AH,00				; TEST CODE
	JNE	XXXXX

	NOP					; FOUND IT

XXXXX:	CMP     AH,0E0H		       	; Is the scan code an E0 byte
	JNE	KBIOA

	OR	KB_MISC_STAT,LAST_WAS_E0	; Set the flag for Last was E0
	JMP	KBIOE				; Jump and exit out without 
						;   clearing flags      

KBIOA:	CMP	AH,0E1H			; Is the scan code an E1 byte
	JNE	KBIOM				; If not jump to next test

	OR	KB_MISC_STAT,LAST_WAS_E1	; Set the flag for Last was E1
	JMP	KBIOE				; Jump and exit out	       
						;  without clearing flags      

KBIOM:	TEST	KB_MISC_STAT, LAST_WAS_E0	; Was the last code an E0 ???
	JTBC	KBIOC				; Jump if not

					; If the last code was an E0 then...
	CMP	AL,02AH			; Is this scan code an AA or 2A byte
	JNE	KBIOP			; Jump if not to next test

	XOR	KB_TEST_SW, XTD_LSHF_SET	; If this is an AA or 2A then 
	JMP	KBIXIT				;   TOGGLE extended shift bit
						;   flag and eat this code 

KBIOP:	CMP	AL,036H			; Is this scan code an B6 or 36 byte
	JNE	KBION			; Jump if not to next test

	XOR	KB_TEST_SW, XTD_RSHF_SET	; If this is an B6 or 36 then 
	JMP	KBIXIT				;   TOGGLE extended shift bit
						;   flag and eat this code 

KBION:	CMP	AL,037H			; Is this special case 124 "PrtSc"
	JNE	KBIOZ			; NO...jump to normal processing

						; This is the "PrtSc" key, So..
	TEST	KB_TEST_SW, XTD_BITS_SET	; Is the extended shift bit 
	JTBS	KBIOO				;    flag set Jump if the bit
						;     is set

					; If the bit is clear then...
	MOV	BL,KFLG			; Get the shift bits into BL
	AND	BL,03H			; Isolate the L&R shift bits
	OR	KB_TEST_SW,BL		; Turn on approiate shift flag
	NOT	BL			; Make bits to clear
	AND	KFLG,BL			; Clear appropriate  bits

	JMP	KBIOZ			; Jump to normal processing

KBIOO:	MOV	BL,KB_TEST_SW
	AND	BL,03H
	OR	KFLG,BL
	NOT	BL
	AND	KB_TEST_SW,BL

	JMP	KBIOZ			; Jump to normal processing

KBIOC:	TEST	KB_MISC_STAT,LAST_WAS_E1	; Was the last code an E1 ???
	JTBC	KBIOZ			; No...Jump to normal processing

				; Last code was an E1, So...
	CMP	AL,1DH		; Was this the Ctrl Key we are expecting (make or break)
	JNE	KBIOC1
KBIOC0:	JMP	KBIOE		; Exit without clearing any flags

KBIOC1:	CMP	AH,0C5H		; Was this the last of break of E1 sequence
	JNE	KBIOC2
	JMP	KBIXIT		; Yes...Exit and Clear flags

KBIOC2:	CMP	AH,45H		; Is this the key we take action on
	JNE	KBIOC0		; Jump if not

	MOV	AL,KFLG		; Load the shift bits
	AND	AL,0FH		; Strip off the non shift bits
	XOR	BH,BH		; Clear out high byte of index
	MOV	BL,AL		; Complete the index
	MOV	BL,KYPRECD[BX]	; Get the valid shift state
	SHL	BL,1		; Make index a word offset (BH still = 0)
	MOV	BX,E1TAB[BX]	; Load the right byte from E1 table

	CMP	BX,0445H	; Is this a hold key ???
	JNE	KBIOC3		; No continue
	JMP	SHOLD

KBIOC3:	JMP	KBIOL		; Process this into the ring

KBIOG:	TEST	AH,80H
	JTBC	KBIOI
	JMP	KBIXIT			; KBIOE  ; Clear flags and exit

KBIOI:	MOV	DI,4			; Set up for Hold Special Key
	JMP	KSPEC

;******************************************************************************
;*			End of Enhanced Keyboard Code			      *
;******************************************************************************
	PAGE
KBIOZ:	CMP	AH,80H			; Is this a key going up?
	JAE	KBI3B			; Yes, skip special key search

	TEST	SSFLG,SFLGHH		; Are we holding?
	JTBC	KBI2			; No, continue normal process

	CMP	AL,BYTE PTR KYSHOLD[0]	; See if this is the stop key again
	JNZ	KBI1			; Yes, punt!
	JMP	KBIXIT			;

KBI1:	AND	SSFLG,NOT SFLGHH	; Turn off the hold bit
	JMP	KBIXIT			; 

KBI2:	MOV	CX,SPECKEYS		; Special control key templates
	MOV	DI,0			;
	
	MOV	AH,KFLG		; Get current shift state
	AND	AH,0FH			; Ignoring shift lock things

	MOV	BL,KYASHF		; Process shift key alias
	TEST	AH,BL			; Is the alternate shift active?
	JTBC	KBI3			; No, skip the transfer of the bit

	NOT	BL			; Turn off the aliased bit
	AND	AH,BL			;
	OR	AH,KFLGSH		; Turn on the real shift bit...

KBI3:	CMP	AX,KYS[DI]		; See if the template matches
	JNE	KBI3A			; No, continue search
	JMP	KSPEC			; Yes, special key process required

KBI3A:	ADD	DI,2			; Increment word pointer
	LOOP	KBI3			; Test the next template

KBI3B:	XCHG	AH,DL			; Restore key w/ up/dn bit

	MOV	DI,0			; Scan control selection table
	MOV	CX,SHIFTKEYS*2		; Seven key types, 2 keys each

KBI3C:	CMP	AL,KYC[DI]		; Is this the special key?
	JNE	KBI3D			;

	CALL	KSHIFT			; Process the shift key
	JMP	KBI3D1			; Then continue on

KBI3D:	INC	DI			; Point to next key entry
	LOOP	KBI3C			; Until no more specials to check

KBI3D1:	CMP	AH,80H			; Is the key going up?
	JNAE	KBI3E			; No, continue
	JMP	KBIXIT			; Yes, no further interest...

KBI3E:	XCHG	AH,DL			; Get shift status back
	PUSH	AX			; Save the key code

	MOV	BL,AL			; Get the shift control byte for key
	XOR	BH,BH			;
	MOV	BL,KEYLOCK[BX]		;

	TEST	KFLG,KFLGNL		; Is numeric lock on?
	JTBS	KBI4			; Yes, allow numeric shifts

	AND	BL,00FH		; Remove NUMLOCK toggle bits

KBI4:	TEST	KFLG,KFLGCL		; Is CAPS lock on?
	JTBS	KBI5			; Yes, allow CAPS shifts

	AND	BL,0F0H		; Remove CAPSLOCK toggle bits

KBI5:	MOV	BH,BL			; Save a copy of the bits
	MOV	CL,4			;
	SHR	BH,CL			; Move NUMLOCK bits over the CAPSLOCK
	OR	BL,BH			; Superimpose lock bits
	AND	BL,0FH			; Remove extra bits...

	XOR	BL,AH			; AH contains active shift bits
	AND	BL,0FH			; Remove extra locks etc.
	XOR	BH,BH			; Make full index to KYPRECD

;******************************************************************************
;*		     Enhanced Keyboard INT 9 Code			      *
;******************************************************************************

	TEST	KB_MISC_STAT,LAST_WAS_E0
	JTBC	KBI6

	MOV	AL,KB_TEST_SW		; If this is an extended code
	AND	AL,03H			; then put the xtd bits
	OR	BL,AL			; into the code

;******************************************************************************
;*			End of Enhanced Keyboard Code			      *
;******************************************************************************

KBI6:	MOV	BH,KYPRECD[BX]		; Get new shift state from table

	POP	AX			; Get key scan code back...
	SHL	AL,1			; Convert to word offset
	MOV	BL,AL			; As a full pointer to keytable

	PAGE
;******************************************************************************
;*		     Enhanced Keyboard INT 9 Code			      *
;******************************************************************************

	TEST	KB_MISC_STAT,LAST_WAS_E0
	JTBS	KBIOK

;******************************************************************************
;*			End of Enhanced Keyboard Code			      *
;******************************************************************************

	MOV	BX,KEYTAB[BX]		; Get keycode word from keytables
	JMP	KBIOL

;******************************************************************************
;*		     Enhanced Keyboard INT 9 Code			      *
;******************************************************************************

KBIOK:	MOV     BX,EKEYTAB[BX]	       ; Get keycode word from extended tables

;******************************************************************************
;*			End of Enhanced Keyboard Code			      *
;******************************************************************************


KBIOL:	OR	BX,BX			; Is this an empty entry (0)?
	JZ	KBIXIT			; Yes, do not put it in the ring!

	PUSH	BX			; Save the key code
	
	MOV	DI,OFFSET KEYBUF	; Point to the keyboard buffer
	CALL	RINGROOM		; Is there room in the in?
	CMP	AX,2			;
	JAE	KBI10			; Yes, skip the complaint

	CALL	KEYBEEP		; Complain and drop key.
	POP	BX			;
	JMP	KBIXIT			; Then exit for more keys...

KBI10:	POP	AX			; Put the characters away
	CALL	RINGIN			; This 'should not' error out...
	XCHG	AH,AL			; Put second byte in place
	CALL	RINGIN			; Ignore errors.

					; Clear either of the E0 or E1 bits 
					;    which may have been set & exit

;******************************************************************************
;*		     Enhanced Keyboard INT 9 Code			      *
;******************************************************************************

KBIXIT: AND	KB_MISC_STAT, NOT LAST_WAS_E0+LAST_WAS_E1

;******************************************************************************
;*			End of Enhanced Keyboard Code			      *
;******************************************************************************

KBIOE:	CLI				; Do not allow keyboard ints during
					;   last stage of keyint service...
	MOV	AL,20H			; Non-specific EOI 
	OUT	ICTL,AL		; 

KBQXT:	CMP	ATFLAG,0FFH		; Is this an IBM PC/AT [1.32]
	JNE	KBQXT1			; Jump if not a PC/AT [1.32]

	MOV	AL,ENABLE_KBD
	CALL	SEND_TO_KBD_CONTROL_PORT

KBQXT1: CLI				; [1.32]
	POP	ES			; Restore main process registers
	POP	DS			;
	POP	DI			;
	POP	SI			;
	POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	AX			;
	POP	BP			;
	IRET				; And leave!
	PAGE
; KSHIFT/KSPEC vector table operations.  Action routines on following pages.
;   KSHIFT routines exit with a NEAR RETURN.  KSPEC routines exit as needed
;   for functionality.	Shift keys can generate application scan codes as
;   well as affecting keyboard state while special keys cannot.
;   An example of a shift class key which generates a scan code is the 
;   INS key which toggles the insert state bit as well as making scan code
;   82*256.

KSHIFT	PROC	NEAR			; Subroutine to modify shift states
	PUSH	AX			; Save key codes

	AND	DI,NOT 1		; Force DI to even address
	MOV	BX,KYCJTAB[DI]		; Get shift key service address
	JMP	BX			; Go to it!

; Simple key up/dn shift operations

CSHIFT: MOV	AL,KFLGSH		; Select ALPHA shift bit
	JMP	SHORT CXXSH		; General purpose shift handler

CNUSHF: MOV	AL,KFLGNU		; Select NUMERIC shift bit
	JMP	SHORT CXXSH		;

CCTRL:	MOV	AL,KFLGCT		; Select CONTROL shift bit
	JMP	SHORT CXXSH		;

CALT:	MOV	AL,KFLGAL		; Select ALTERNATE shift bit
	
CXXSH:	TEST	AH,80H			; Is this key going up?
	JTBS	CXXUP			; Yes, turn off the shift bit

	OR	KFLG,AL		; New shift key down...
	JMP	KSHXIT

CXXUP:	NOT	AL			; Old shift key up
	AND	KFLG,AL
	JMP	KSHXIT

; Alternating action keys 

CCAPS:	MOV	AL,KFLGCL		; Select CAPS LOCK bit
	JMP	SHORT CXXLK		; General purpose alternate action

CNUM:	MOV	AL,KFLGNL		; Select NUM LOCK bit
	JMP	SHORT CXXLK		;

CSCRL:	MOV	AL,KFLGSC		; Select SCROLL LOCK bit
	JMP	SHORT CXXLK		;

CINS:	MOV	AL,KFLGIN		; Select INSERT toggle bit

CXXLK:	TEST	AH,80H			; Is this key going up?
	JTBS	CLKUP			; Yes, fix activity flag

	MOV	AH,AL			; Save a copy of the bit
	AND	AL,SSFLG		; Remove other shift toggle bits
	JZ	CXXND			; We have found a new downer...
	JMP	SHORT KSHXIT		;
	
CXXND:	OR	SSFLG,AH		; Set the key down bit
	XOR	KFLG,AH		; Toggle the lock state

	CMP	ERICKEY,1
	JE	K_ERICSSON		; Ericsson PC
	CMP	ALTMOD2,1
	JNE	SHORT KSHXIT

; Olivetti AT&T PC LED fix
	MOV	AL,1
	CMP	AH,40H
	JE	K_LED			; CAPS LOCK TOGGLE
	MOV	AL,2
	CMP	AH,20H			; NUM LOCK TOGGLE
	JE	K_LED
	JMP	SHORT KSHXIT

K_LED:	AND	AH,KFLG
	JE	K_LED1
	XOR	AL,80H
K_LED1: TEST	BYTE PTR SSFLG,01  ;If dlx kbd #2
	JTBC	K_STAND
	TEST	AL,2		;if num lock
	JTBC	K_STAND
	XOR	AL,80H		;Deluxe keyboard 2
K_STAND: PUSH	AX
K_LED4: IN	AL,KBD_STATUS
	TEST	AL,10B
	JTBS	K_LED4
	MOV	AL,13H
	OUT	KBDATA,AL
K_LED6: IN	AL,KBD_STATUS
	TEST	AL,10B
	JTBS	K_LED6
	POP	AX
	OUT	KBDATA,AL
	JMP	SHORT KSHXIT
		
K_ERICSSON:
	CLI
	PUSH	DS
	MOV	AL,KFLG	;Transfer keyboard shift info
	PUSH	AX
	MOV	AX,BIOSSEG	;Point to BIOS ram
	MOV	DS,AX
	POP	AX
	MOV	BYTE PTR DS:[BIOSKFLG],AL ;update ram
	POP	DS
	STI
	JMP	SHORT KSHXIT

CLKUP:	NOT	AL			; Turn bit into bit mask
	AND	SSFLG,AL		; Turn off key down flag bit
	JMP	SHORT KSHXIT

KSHXIT: POP	AX			; Restore keyboard scan code
	RET				;

KSHIFT	ENDP				; End of shift type operations

; Special class keys do not generate application scan codes and may
;   change machine state drastically.  Each routine exits as appropriate.

KSPEC:	AND	DI,NOT 1		; This should not be needed...
	MOV	BX,KYSJTAB[DI]		; Special key service address
	JMP	BX			; Go to it!

SUPERK: MOV	SUPKEY,1		; Set the superkey process flag
	JMP	KBIXIT			; And let go of the interrupt.


; Break key process

SBRK:	MOV	KEYBUF[0],0		; Empty the keyboard buffer
	MOV	KEYBUF[2],0		; By setting pointers equal

	PUSH	ES			; Set BIOS BREAK flag
	MOV	AX,BIOSSEG		;
	MOV	ES,AX			;
	MOV	BYTE PTR ES:[BIOSBRK],80H
	POP	ES			;

	INT	1BH			; Execute users interrupt code

	JMP	KBIXIT			; 

; Hold key process

SHOLD:	OR	SSFLG,SFLGHH		; Set the machine holding bit

	MOV	AL,20H			; Allow other interrupts
	OUT	ICTL,AL		; Non-specific EOI

	CMP	ATFLAG,0FFH		; Is this an IBM PC/AT [1.44]
	JNE	HOLDIT			; Jump if not a PC/AT [1.44]

	MOV	AL,ENABLE_KBD
	CALL	SEND_TO_KBD_CONTROL_PORT

HOLDIT: TEST	SSFLG,SFLGHH		; Stay here until a non-hold key
	JTBS	HOLDIT			; Tiny little tight loop...

	JMP	KBQXT			; Exit w/o interrupt enable

; Reset key process

SREST:	MOV	AX,BIOSSEG		; Set BIOS RESET FLAG
	MOV	ES,AX			;
	MOV	WORD PTR ES:[BIOSRFG],1234H ; Magic constant

	XOR	AX,AX			; Setup the registers for a reset
	MOV	ES,AX			;
	MOV	SS,AX			;
	MOV	DS,AX			;

	PUSH	AX			; Push a zero flag word
	DEC	AX			; Push a minus one (FFFFH) segment
	PUSH	AX			; for CS
	PUSH	DS			; Push a zero for IP
	IRET				; Return through top of memory

; Print screen request

SPRNT:	MOV	AL,20H			; Allow other interrupts while print
	OUT	ICTL,AL		;

	INT	5H			; Screen print function call
	JMP	KBQXT			; Exit & continue...

KBINT	ENDP

SEND_TO_KBD_CONTROL_PORT	PROC	NEAR

	PUSH	AX
	CLI
	CALL	WAITKBD	; Wait for the keyboard busy status to clear
	POP	AX
	OUT	KBD_STATUS,AL
	STI
	RET

SEND_TO_KBD_CONTROL_PORT	ENDP

WAITKBD PROC	NEAR

	XOR	CX,CX
WAIT1:	IN	AL,KBD_STATUS
	TEST	AL,KBD_BUF_FULL
	LOOPNZ	WAIT1
	RET

WAITKBD ENDP

GET_LED_STATE	PROC	NEAR

	PUSH	CX
	MOV	AL,KFLG
	AND	AL,KFLG_LED_BITS 
	MOV	CL,4
	ROL	AL,CL
	AND	AL,LED_BITS
	POP	CX
	RET

GET_LED_STATE	ENDP

UPDATE_LEDS	PROC	NEAR

	CLI
	TEST	AL,UPDATE_IN_PROG
	JTBS	NO_UPDATE
	
	OR	AL,UPDATE_IN_PROG
	MOV	AL,END_OF_INTERRUPT
	OUT	ICTL,AL

UPDL1:	MOV	AL,SET_RESET_CMD
	CALL	SEND_DATA_TO_KBD

	CLI
	CALL	GET_LED_STATE
	AND	KB_LED_STAT,NOT(LED_BITS)
	OR	KB_LED_STAT,AL

	TEST	KB_LED_STAT,KBD_ERROR_FLAG
	JTBS	ERROR_DETECTED

	CALL	SEND_DATA_TO_KBD
	CLI

	TEST	KB_LED_STAT,KBD_ERROR_FLAG
	JTBC	NO_ERROR

ERROR_DETECTED:
	
	MOV	AL,KBD_ENABLE_CMD
	CALL	SEND_DATA_TO_KBD

	CLI

NO_ERROR:
	AND	KB_LED_STAT,NOT(UPDATE_IN_PROG+KBD_ERROR_FLAG)

NO_UPDATE:
	STI
	RET

UPDATE_LEDS	ENDP

SEND_DATA_TO_KBD	PROC	NEAR

	PUSH	BX
	PUSH	AX
	PUSH	CX

	MOV	BL,AL		; Save away the byte to transmit
	MOV	BH,RETRY_COUNT	; Counter to keep track of retries
SEND1:	CLI			; Disable interrupts before sending byte out
	AND	KB_LED_STAT,NOT(KB_ACK_REC+KB_RESEND)
	CALL	WAITKBD	; Wait for the keyboard busy status to clear
	MOV	AL,BL		; Restore the byte to send to the keyboard
	OUT	KBDATA,AL
	STI			; Turn on the interrupts again
	
	MOV	CX,1A00H	; This is a timer which will wait 10+ ms
TIMER:	TEST	KB_LED_STAT,KB_ACK_REC+KB_RESEND
	JTBS	EXIT_TIMER_LOOP
	LOOP	TIMER

SEND2:	DEC	BH
	JNZ	SEND1

	OR	KB_LED_STAT,KBD_ERROR_FLAG	; Retries failed ... quit
	JMP	XIT_SEND_DATA

EXIT_TIMER_LOOP:
	TEST	KB_LED_STAT,KB_ACK_REC
	JTBC	SEND2				; Was not ACK GO RETRY

XIT_SEND_DATA:
	
	POP	CX
	POP	AX
	POP	BX
	RET

SEND_DATA_TO_KBD	ENDP

UPDATE_LEDS_1	PROC	NEAR

	CLI
	TEST	KB_LED_STAT,UPDATE_IN_PROG
	JTBC	UL1

	STI
	RET

UL1:	OR	KB_LED_STAT,UPDATE_IN_PROG
	JMP	UPDL1

UPDATE_LEDS_1	ENDP

	ENDIF

CODE	ENDS

	END
