	NAME	KEYCODE
	TITLE	.KEYCODE -  3270 Scan and key position tables SCODE, KCODE
	INCLUDE	PAGESIZE.INC
	INCLUDE	SKFLAG.INC
DATA	SEGMENT	PUBLIC BYTE

;	Key 51A (Katakana only) is not supported by this table.
;	Key code 89 represents the KEYBOARD OVERRUN scan code

	PUBLIC	SCODE,FIRKEY,LASKEY
SCODE	LABEL	BYTE

	DB	050H,051H,03DH,021H,022H,023H,024H,025H,026H,027H
	DB	028H,029H,020H,030H,011H,031H,05FH,05EH,052H,053H
	DB	036H,070H,076H,064H,071H,073H,078H,074H,068H,06EH
	DB	06FH,01BH,015H,035H,00CH,00DH,054H,055H,0CCH,060H
	DB	072H,063H,065H,066H,067H,069H,06AH,06BH,07EH,012H
	DB	00FH,008H,00EH,013H,056H,057H,0CDH,009H,079H,077H
	DB	062H,075H,061H,06DH,06CH,033H,032H,014H,0CEH,016H
	DB	01AH,034H,034H,010H,0CFH,018H,040H,041H,042H,043H
	DB	044H,045H,046H,047H,048H,049H,04AH,04BH
	DB	0H

FIRKEY	DB	1	; First valid key number
LASKEY	DB	89	; Last valid key number
	PAGE

KOVER	EQU	89		; Keyboard overrun

SHF	EQU	57
ALT	EQU	75
NUL	EQU	00

KF1	EQU	1		; Keyboard positions
KF2	EQU	2
KF3	EQU	19
KF4	EQU	20
KF5	EQU	37
KF6	EQU	38
KF7	EQU	55
KF8	EQU	56

KESC	EQU	3

K1	EQU	4
K2	EQU	5
K3	EQU	6
K4	EQU	7
K5	EQU	8
K6	EQU	9
K7	EQU	10
K8	EQU	11
K9	EQU	12
K0	EQU	13

KMINUS	EQU	14
KEQUAL	EQU	15
KDEL	EQU	16

KTAB	EQU	21

KQ	EQU	22
KW	EQU	23
KE	EQU	24
KR	EQU	25
KT	EQU	26
KY	EQU	27
KU	EQU	28
KI	EQU	29
KO	EQU	30
KP	EQU	31

KCENT	EQU	32
KBSLASH	EQU	33
KBTAB	EQU	34

KNLOCK	EQU	39

KA	EQU	40
KS	EQU	41
KD	EQU	42
KF	EQU	43
KG	EQU	44
KH	EQU	45
KJ	EQU	46
KK	EQU	47
KL	EQU	48
KSEMI	EQU	49
KSQUOTE	EQU	50
KLBRACE	EQU	51
KCRLF	EQU	52

KSHIFT	EQU	57

KLESS	EQU	58

KZ	EQU	59
KX	EQU	60
KC	EQU	61
KV	EQU	62
KB	EQU	63
KN	EQU	64
KM	EQU	65
KCOMMA	EQU	66
KPERIOD	EQU	67
KSLASH	EQU	68

KUPA	EQU	53
KDNA	EQU	54
KLFA	EQU	70
KRTA	EQU	71

KP1	EQU	17		; PA1/DUP
KP2	EQU	18		; PA2/FIELD MARK
KIC	EQU	35		; Insert character
KDC	EQU	36		; Delete character

KRESET	EQU	72
KALT	EQU	75
KENTER	EQU	76
	
KSPACE	EQU	74

KPF13	EQU	77
KPF14	EQU	78
KPF15	EQU	79
KPF16	EQU	80
KPF17	EQU	81
KPF18	EQU	82
KPF19	EQU	83
KPF20	EQU	84
KPF21	EQU	85
KPF22	EQU	86
KPF23	EQU	87
KPF24	EQU	88
	PAGE
	PUBLIC	KCODE,ECCODE
KCODE	LABEL	WORD

LBLX1	=	$		; Reference to beginning of table
	DB	NUL,NUL		; 0  NUL
	DB	NUL,NUL		; 1  SOH
	DB	NUL,NUL		; 2  STX
	DB	NUL,NUL		; 3  ETX
	DB	NUL,NUL		; 4  EOT
	DB	NUL,NUL		; 5  ENQ
	DB	NUL,NUL		; 6  ACK
	DB	NUL,NUL		; 7  BEL
	DB	NUL,KDEL	; 8  BS   DELETE 
	DB	NUL,KTAB	; 9       TAB
	DB	NUL,KCRLF	; 10 LF   CRLF
	DB	NUL,NUL		; 11 VT
	DB	NUL,NUL		; 12 FF
	DB	NUL,KENTER	; 13 CR	ENTER
	DB	NUL,NUL		; 14 SO
	DB	NUL,NUL		; 15 SI
	DB	NUL,NUL		; 16 DLE
	DB	NUL,NUL		; 17 DC1
	DB	NUL,NUL		; 18 DC2
	DB	NUL,NUL		; 19 DC3
	DB	NUL,NUL		; 20 DC4
	DB	NUL,NUL		; 21 NAK
	DB	NUL,NUL		; 22 SYN
	DB	NUL,NUL		; 23 ETB
	DB	NUL,NUL		; 24 CAN
	DB	NUL,NUL		; 25 EM
	DB	NUL,NUL		; 26 SUB
	DB	NUL,KP2		; 27 ESC   Field mark
	DB	NUL,NUL		; 28 FS
	DB	NUL,NUL		; 29 GS
	DB	NUL,NUL		; 30 RS
	DB	NUL,NUL		; 31 US
	DB	NUL,KSPACE	; 32       SPACE

	IF	SKFLAG
	DB	SHF,K1		; 33 [     Concatanation (solid v bar)
	ELSE
	DB	SHF,KCENT	; 33 !
	ENDIF

	DB	SHF,KSQUOTE	; 34 '
	DB	SHF,K3		; 35 #
	DB	SHF,K4		; 36 $
	DB	SHF,K5		; 37 %
	DB	SHF,K7		; 38 &
	DB	NUL,KSQUOTE	; 39 '
	DB	SHF,K9		; 40 (
	DB	SHF,K0		; 41 )
	DB	SHF,K8		; 42 *
	DB	SHF,KEQUAL	; 43 +
	DB	NUL,KCOMMA	; 44 ,
	DB	NUL,KMINUS	; 45 -
	DB	NUL,KPERIOD	; 46 .
	DB	NUL,KSLASH	; 47 /
	PAGE
	DB	NUL,K0		; 48 0
	DB	NUL,K1		; 49 1
	DB	NUL,K2		; 50 2
	DB	NUL,K3		; 51 3
	DB	NUL,K4		; 52 4
	DB	NUL,K5		; 53 5
	DB	NUL,K6		; 54 6
	DB	NUL,K7		; 55 7
	DB	NUL,K8		; 56 8
	DB	NUL,K9		; 57 9
	DB	SHF,KSEMI	; 58 :
	DB	NUL,KSEMI	; 59 ;
	DB	NUL,KLESS	; 60 <
	DB	NUL,KEQUAL	; 61 =
	DB	SHF,KLESS	; 62 >
	DB	SHF,KSLASH	; 63 ?
                                  
	DB	SHF,K2		; 64 @
	DB	SHF,KA		; 65 A
	DB	SHF,KB		; 66 B
	DB	SHF,KC		; 67 C
	DB	SHF,KD		; 68 D
	DB	SHF,KE		; 69 E
	DB	SHF,KF		; 70 F
	DB	SHF,KG		; 71 G
	DB	SHF,KH		; 72 H
	DB	SHF,KI		; 73 I
	DB	SHF,KJ		; 74 J
	DB	SHF,KK		; 75 K
	DB	SHF,KL		; 76 L
	DB	SHF,KM		; 77 M
	DB	SHF,KN		; 78 N
	DB	SHF,KO		; 79 O
	DB	SHF,KP		; 80 P
	DB	SHF,KQ		; 81 Q
	DB	SHF,KR		; 82 R
	DB	SHF,KS		; 83 S
	DB	SHF,KT		; 84 T
	DB	SHF,KU		; 85 U
	DB	SHF,KV		; 86 V
	DB	SHF,KW		; 87 W
	DB	SHF,KX		; 88 X
	DB	SHF,KY		; 89 Y
	DB	SHF,KZ		; 90 Z
                                  
	IF	SKFLAG            
	DB	NUL,KCENT	; 91  	!
	ELSE                     
	DB	SHF,K1		; 91 	[	Concatanation (solid v bar)
	ENDIF                     

	PAGE

       	DB	NUL,KBSLASH	; 92 \

	IF	SKFLAG
	DB	NUL,KLBRACE	; 93 {
	ELSE
	DB	NUL,KCENT	; 93 ]	Cent sign
	ENDIF

	DB	SHF,K6		; 94 ^ 	Logical not
	DB	SHF,KMINUS	; 95 _
	DB	NUL,KESC	; 96 `
	DB	NUL,KA		; 97 a
	DB	NUL,KB		; 98 b
	DB	NUL,KC		; 99 c
	DB	NUL,KD		; 100 d
	DB	NUL,KE		; 101 e
	DB	NUL,KF		; 102 f
	DB	NUL,KG		; 103 g
	DB	NUL,KH		; 104 h
	DB	NUL,KI		; 105 i
	DB	NUL,KJ		; 106 j
	DB	NUL,KK		; 107 k
	DB	NUL,KL		; 108 l
	DB	NUL,KM		; 109 m
	DB	NUL,KN		; 110 n
	DB	NUL,KO		; 111 o
	DB	NUL,KP		; 112 p
	DB	NUL,KQ		; 113 q
	DB	NUL,KR		; 114 r
	DB	NUL,KS		; 115 s
	DB	NUL,KT		; 116 t
	DB	NUL,KU		; 117 u
	DB	NUL,KV		; 118 v
	DB	NUL,KW		; 119 w
	DB	NUL,KX		; 120 x
	DB	NUL,KY		; 121 y
	DB	NUL,KZ		; 122 z

	IF	SKFLAG
	DB	SHF,KCENT	; 123 !
	ELSE
	DB	NUL,KLBRACE	; 123 {
	ENDIF
	DB	SHF,KBSLASH	; 124 |
	DB	SHF,KLBRACE	; 125 }
	DB	SHF,KESC	; 126 ~
	DB	ALT,KDEL	; 127 APL ON/OFF

	DB	NUL,NUL		; 128 Secondary null (control of ALPHA pad)
	DB	NUL,NUL		; 129 A
	DB	NUL,NUL		; 130 B
	DB	NUL,NUL		; 131 C
	DB	ALT,KLFA	; 132 D	Double speed left arrow
	DB	NUL,NUL		; 133 E
	DB	ALT,KRTA	; 134 F	Double speed right arrow
	DB	NUL,KP1		; 135 G	DUP
	DB	NUL,KP2		; 136 H	FM
	DB	NUL,NUL		; 137 I
	DB	ALT,KP1		; 138 J	PA1
	DB	ALT,KP2		; 139 K	PA2
	DB	NUL,NUL		; 140 L
	DB	SHF,KPERIOD	; 141 M	: for APL users
	DB	SHF,KCOMMA	; 142 N	; for APL users
	DB	NUL,NUL		; 143 O
	DB	NUL,NUL		; 144 P
	DB	NUL,NUL		; 145 Q
	DB	NUL,NUL		; 146 R
	DB	NUL,NUL		; 147 S
	DB	NUL,NUL		; 148 T
	DB	NUL,NUL		; 149 U
	DB	NUL,NUL		; 150 V
	DB	NUL,NUL		; 151 W
	DB	NUL,NUL		; 152 X
	DB	NUL,NUL		; 153 Y
	DB	NUL,NUL		; 154 Z
	DB	NUL,KCENT	; 155 [ Extra left arrow for APL
	DB	NUL,NUL		; 156 \
	DB	SHF,KCENT	; 157 ] Extra right arrow for APL

RECNT=	(512-($-LBLX1))/2	; Number of entrys needed to fill out page
	REPT	RECNT		; Fill out table to 256 entry total
	DB	NUL,NUL		;
	ENDM			;
	PAGE
ECCODE	LABEL	WORD		; Extended character codes
LBLX2	=	$		; Reference for fill out to full size
	DB	NUL,NUL		; 0
	DB	NUL,NUL		; 1
	DB	NUL,NUL		; 2
	DB	NUL,NUL		; 3	Null character
	DB	NUL,NUL		; 4
	DB	NUL,NUL		; 5
	DB	NUL,NUL		; 6
	DB	NUL,NUL		; 7
	DB	NUL,NUL		; 8
	DB	NUL,NUL		; 9
	DB	NUL,NUL		; 10
	DB	NUL,NUL		; 11
	DB	NUL,NUL		; 12	Ctrl UP ARROW
	DB	NUL,NUL		; 13	Ctrl DN ARROW
	DB	ALT,KDEL	; 14	APL ON/OFF
	DB	NUL,KBTAB	; 15	Back tab
	DB	ALT,KQ		; 16	Alternate of QWERTYUIOP
	DB	ALT,KW		; 17	
	DB	ALT,KE		; 18	
	DB	ALT,KR		; 19	
	DB	ALT,KT		; 20	
	DB	ALT,KY		; 21	
	DB	ALT,KU		; 22	
	DB	ALT,KI		; 23	
	DB	ALT,KO		; 24	
	DB	ALT,KP		; 25	

	DB	ALT,KCENT	; 26	APL BOXED ACCENT
	DB	ALT,KBSLASH	; 27	APL UNDERSCORED TRIANGLE
	DB	NUL,NUL		; 28
	DB	NUL,NUL		; 29

	DB	ALT,KA		; 30	Alternate of ASDFGHJKL
	DB	ALT,KS		; 31	
	DB	ALT,KD		; 32	
	DB	ALT,KF		; 33	
	DB	ALT,KG		; 34	
	DB	ALT,KH		; 35	
	DB	ALT,KJ		; 36	
	DB	ALT,KK		; 37	
	DB	ALT,KL		; 38	

	DB	ALT,KSEMI	; 39
	DB	ALT,KSQUOTE	; 40
	DB	ALT,KLBRACE	; 41
	DB	NUL,NUL		; 42
	DB	ALT,KBSLASH	; 43

	DB	ALT,KZ		; 44	     Alternate of ZXCVBNM
	DB	ALT,KX		; 45
	DB	ALT,KC		; 46
	DB	ALT,KV		; 47
	DB	ALT,KB		; 48
	DB	ALT,KN		; 49
	DB	ALT,KM		; 50
	DB	ALT,KCOMMA	; 51
	DB	ALT,KPERIOD	; 52
	DB	ALT,KSLASH	; 53
	DB	NUL,NUL		; 54
	DB	NUL,NUL		; 55
	DB	NUL,NUL		; 56
	DB	NUL,NUL		; 57
	DB	NUL,NUL		; 58

	DB	NUL,KF1		; 59	Function keys (Base case)
	DB	ALT,KF2		; 60
	DB	NUL,KF3		; 61
	DB	ALT,KF4		; 62
	DB	NUL,KF5		; 63
	DB	NUL,KF6		; 64
	DB	NUL,KF7		; 65
	DB	NUL,KF8		; 66
	DB	NUL,KCRLF	; 67	New line
	DB	NUL,KRESET	; 68	Reset
	DB	ALT,KTAB	; 69	ALT TAB
	DB	NUL,NUL		; 70 

	DB	ALT,KBTAB	; 71	HOME
	DB	NUL,KUPA	; 72	UP ARROW
	DB	NUL,NUL		; 73	PAGE UP Shift lock    NUL, KNLOCK   
	DB	NUL,NUL		; 74
	DB	NUL,KLFA	; 75	LEFT ARROW (Cursor pad)
	DB	NUL,NUL		; 76
	DB	NUL,KRTA	; 77	RIGHT ARROW (Cursor pad)
	DB	NUL,NUL		; 78
	DB	NUL,NUL		; 79	END
	DB	NUL,KDNA	; 80	DOWN ARROW
	DB	NUL,NUL		; 81	PAGE DOWN Release shift lock   NUL,SHF
	DB	NUL,KIC		; 82	INS (Below cursor pad)
	DB	NUL,KDC		; 83	DEL (Below cursor pad)
	DB	NUL,NUL		; 84	Shifted function keys
	DB	NUL,NUL		; 85
	DB	NUL,NUL		; 86
	DB	NUL,NUL		; 87
	DB	NUL,NUL		; 88
	DB	NUL,NUL		; 89
	DB	NUL,NUL		; 90
	DB	NUL,NUL		; 91
	DB	NUL,NUL		; 92
	DB	NUL,NUL		; 93
	DB	NUL,NUL		; 94	Control function keys
	DB	NUL,NUL		; 96
	DB	NUL,NUL		; 96
	DB	NUL,NUL		; 97
	DB	NUL,NUL		; 98
	DB	NUL,NUL		; 99
	DB	NUL,NUL		; 100
	DB	NUL,NUL		; 101
	DB	NUL,NUL		; 102
	DB	NUL,NUL		; 103

	DB	ALT,KF1		; 104	SYS REQ Alternate function keys
	DB	NUL,KF2		; 105
	DB	ALT,KF3		; 106	
	DB	NUL,KF4		; 107
	DB	ALT,KF5		; 108	ALT CURSOR
	DB	ALT,KF6		; 109
	DB	ALT,KF7		; 110	IDENT
	DB	ALT,KF8		; 111	TEST
	DB	NUL,NUL		; 112
	DB	ALT,KRESET	; 113	DEV CNCL

	DB	NUL,NUL		; 114	CTRL PRTSC

	DB	ALT,KLFA	; 115	CTRL LEFT ARROW (Cursor pad)
	DB	ALT,KRTA	; 116	CTRL RIGHT ARROW (Cursor pad)

	DB	NUL,NUL		; 117	CTRL END 
	DB	NUL,NUL		; 118	CTRL PG DN
	DB	NUL,KOVER	; 119	CTRL HOME Keyboard overrun

	DB	ALT,K1		; 120	PF1 Alternate of number keys
	DB	ALT,K2		; 121
	DB	ALT,K3		; 122
	DB	ALT,K4		; 123
	DB	ALT,K5		; 124
	DB	ALT,K6		; 125
	DB	ALT,K7		; 126
	DB	ALT,K8		; 127
	DB	ALT,K9		; 128
	DB	ALT,K0		; 129
	DB	ALT,KMINUS	; 130
	DB	ALT,KEQUAL	; 131

	DB	NUL,NUL		; 132	CTRL PG UP

	DB	NUL,NUL		; 133
	DB	NUL,NUL		; 134
	DB	NUL,NUL		; 135
	DB	NUL,NUL		; 136
	DB	NUL,NUL		; 137
	DB	NUL,NUL		; 138
	DB	NUL,NUL		; 139

	DB	NUL,KPF13	; 140 	CTRL of numbers row (123...90-=)
	DB	NUL,KPF14	; 141
	DB	NUL,KPF15	; 142
	DB	NUL,KPF16	; 143
	DB	NUL,KPF17	; 144
	DB	NUL,KPF18	; 145
	DB	NUL,KPF19	; 146
	DB	NUL,KPF20	; 147
	DB	NUL,KPF21	; 148
	DB	NUL,KPF22	; 149
	DB	NUL,KPF23	; 150
	DB	NUL,KPF24	; 151
	DB	NUL,NUL		; 152
	DB	NUL,NUL		; 153
	DB	NUL,NUL		; 154
	DB	NUL,NUL		; 155
	DB	NUL,NUL		; 156
	DB	NUL,NUL		; 157
	DB	NUL,NUL		; 158
	DB	ALT,KUPA	; 159 Entry Assist CR POS
	DB	ALT,KDC		; 160 Entry Assist Word Delete
	

RECNT=	(512-($-LBLX2))/2	; Number of entrys to fill out to 256 total
	REPT	RECNT		;
	DB	NUL,NUL		;
	ENDM

	IF	SKFLAG

	PUBLIC	KC128, KC129
KC128	LABEL	WORD		; PFKEY decode tables
KC129	LABEL	WORD

	DW	32 DUP(0)	; NUL--US

	DB	ALT, K1		; PF1 Normal
	DB	ALT, K2		; PF2
	DB	ALT, K3		; PF3
	DB	ALT, K4		; PF4
	DB	ALT, K5		; PF5
	DB	ALT, K6		; PF6
	DB	ALT, K7		; PF7
	DB	ALT, K8		; PF8
	DB	ALT, K9		; PF9
	DB	ALT, K0		; PF10
	DB	ALT, KMINUS	; PF11
	DB	ALT, KEQUAL	; PF12

	DB	NUL, KPF13	; PF13
	DB	NUL, KPF14	; PF14
	DB	NUL, KPF15	; PF15
	DB	NUL, KPF16	; PF16
	DB	NUL, KPF17	; PF17
	DB	NUL, KPF18	; PF18
	DB	NUL, KPF19	; PF19
	DB	NUL, KPF20	; PF20
	DB	NUL, KPF21	; PF21
	DB	NUL, KPF22	; PF22
	DB	NUL, KPF23	; PF23
	DB	NUL, KPF24	; PF24

	DB	ALT, K1		; PF1 Shift
	DB	ALT, K2		; PF2
	DB	ALT, K3		; PF3
	DB	ALT, K4		; PF4
	DB	ALT, K5		; PF5
	DB	ALT, K6		; PF6
	DB	ALT, K7		; PF7
	DB	ALT, K8		; PF8
	DB	ALT, K9		; PF9
	DB	ALT, K0		; PF10
	DB	ALT, KMINUS	; PF11
	DB	ALT, KEQUAL	; PF12

	DB	SHF, KPF13	; PF13
	DB	SHF, KPF14	; PF14
	DB	SHF, KPF15	; PF15
	DB	SHF, KPF16	; PF16
	DB	SHF, KPF17	; PF17
	DB	SHF, KPF18	; PF18
	DB	SHF, KPF19	; PF19
	DB	SHF, KPF20	; PF20
	DB	SHF, KPF21	; PF21
	DB	SHF, KPF22	; PF22
	DB	SHF, KPF23	; PF23
	DB	SHF, KPF24	; PF24

	DB	ALT, K1		; PF1 Control
	DB	ALT, K2		; PF2
	DB	ALT, K3		; PF3
	DB	ALT, K4		; PF4
	DB	ALT, K5		; PF5
	DB	ALT, K6		; PF6
	DB	ALT, K7		; PF7
	DB	ALT, K8		; PF8
	DB	ALT, K9		; PF9
	DB	ALT, K0		; PF10
	DB	ALT, KMINUS	; PF11
	DB	ALT, KEQUAL	; PF12

	DB	NUL, KPF13	; PF13
	DB	NUL, KPF14	; PF14
	DB	NUL, KPF15	; PF15
	DB	NUL, KPF16	; PF16
	DB	NUL, KPF17	; PF17
	DB	NUL, KPF18	; PF18
	DB	NUL, KPF19	; PF19
	DB	NUL, KPF20	; PF20
	DB	NUL, KPF21	; PF21
	DB	NUL, KPF22	; PF22
	DB	NUL, KPF23	; PF23
	DB	NUL, KPF24	; PF24

	DB	ALT, K1		; PF1 Alt
	DB	ALT, K2		; PF2
	DB	ALT, K3		; PF3
	DB	ALT, K4		; PF4
	DB	ALT, K5		; PF5
	DB	ALT, K6		; PF6
	DB	ALT, K7		; PF7
	DB	ALT, K8		; PF8
	DB	ALT, K9		; PF9
	DB	ALT, K0		; PF10
	DB	ALT, KMINUS	; PF11
	DB	ALT, KEQUAL	; PF12

	DB	ALT, KPF13	; PF13
	DB	ALT, KPF14	; PF14
	DB	ALT, KPF15	; PF15
	DB	ALT, KPF16	; PF16
	DB	ALT, KPF17	; PF17
	DB	ALT, KPF18	; PF18
	DB	ALT, KPF19	; PF19
	DB	ALT, KPF20	; PF20
	DB	ALT, KPF21	; PF21
	DB	ALT, KPF22	; PF22
	DB	ALT, KPF23	; PF23
	DB	ALT, KPF24	; PF24

	PUBLIC	KC134
KC134	LABEL	WORD

	DW	32 DUP(0)	; Control character gap

	DW	32 DUP(0)	; SP - ?
	DB	NUL, NUL	; @  64
	DB	NUL, NUL	; A  65
	DB	NUL, NUL	; B  66
	DB	NUL, NUL	; C  67
	DB	NUL, NUL	; D  68
	DB	NUL, NUL	; E  69
	DB	NUL, NUL	; F  70
	DB	NUL, NUL	; G  71
	DB	NUL, NUL	; H  72
	DB	NUL, NUL	; I  73
	DB	NUL, NUL	; J  74
	DB	NUL, NUL	; K  75
	DB	NUL, NUL	; L  76
	DB	NUL, NUL	; M  77
	DB	NUL, KP1	; N  78
	DB	NUL, KP2	; O  79
	DB	ALT, KBTAB	; P  80
	DB	ALT, KIC	; Q  81
	DB	ALT, KDC	; R  82
	DB	NUL, NUL	; S  83
	DB	NUL, NUL	; T  84
	DB	NUL, NUL	; U  85
	DB	NUL, NUL	; V  86
	DB	ALT, KBTAB	; W  87
	DB	NUL, NUL	; X  88
	DB	NUL, NUL	; Y  89
	DB	NUL, NUL	; Z  90
	DB	NUL, NUL	; [  91
	DB	NUL, NUL	; \  92
	DB	NUL, NUL	; ]  93
	DB	NUL, NUL	; ^  94
	DB	NUL, NUL	; _  95
	DB	NUL, NUL	; `  96
	DB	NUL, NUL	; a  97
	DB	NUL, NUL	; b  98
	DB	NUL, NUL	; c  99
	DB	NUL, NUL	; d 100
	DB	NUL, NUL	; e 101
	DB	NUL, NUL	; f 102
	DB	NUL, NUL	; g 103
	DB	NUL, NUL	; h 104
	DB	NUL, NUL	; i 105
	DB	NUL, NUL	; j 106
	DB	NUL, NUL	; k 107
	DB	NUL, NUL	; l 108
	DB	NUL, NUL	; m 109
	DB	ALT, KP1	; n 110
	DB	ALT, KP2	; o 111
	DB	ALT, KBTAB	; p 112
	DB	ALT, KIC	; q 113
	DB	ALT, KDC	; r 114
	DB	ALT, KUPA	; s 115
	DB	NUL, NUL	; t 116
	DB	NUL, NUL	; u 117
	DB	ALT, KLFA	; v 118
	DB	NUL, NUL	; w 119
	DB	ALT, KRTA	; x 120
	DB	NUL, NUL	; y 121
	DB	ALT, KDNA	; z 122
	DB	NUL, NUL	; { 123
	DB	NUL, NUL	; | 124
	DB	NUL, NUL	; } 125
	DB	NUL, NUL	; ~ 126
	DB	NUL, NUL	;   127				    

	ENDIF

DATA	ENDS

	END
