	TITLE	INIT FOR NONINTERLACED COMPOSITE VIDEO 260 LINES
	PAGE	60,132
;	DEFINITIONS
;
VFROP	EQU	12			;VERTICAL FRONT PORCH
VSYNCW	EQU	2			;VERTICAL SYNC WIDTH
VBAP	EQU	02			;VERTICAL BACK PORCH
HFROP	EQU	5			;HOR FRONT PORCH
HSYNCW	EQU	2			;HOR PULSE WIDTH
HBAP	EQU	3			;HOR BACK PORCH
VFROPC	EQU	0			;VERT FRONTPULSE COUNT
VBAPC	EQU	0			;VERT BACKPULSE COUNT
LINES_CHAR EQU	10			;LINES PER CHARACTER LINE


NX	EQU	80			;CHARACTERS PER LINE
NY	EQU	24			;LINES MAIN FIELD
NYR	EQU	2			;LINES RESERVED FIELD
NYD	EQU	3			;DUMMY LINES

BASE	EQU	40H			;VIDEO BASE SEGMENT

;
;	INTERNAL DEFINITIONS
;
VFIELDL	EQU	LINES_CHAR*(NY+NYR)	;LINES/FIELD
VFIELDD	EQU	LINES_CHAR*NYD		;DUMMY LINES
HFIELD	EQU	NX/2			;DISPLAYED WORDS
LINES	EQU	VFROP+VFIELDL+VBAP+VFROPC+VSYNCW+VBAPC+VFIELDD
WORDS	EQU	HFROP+HFIELD+HBAP+HSYNCW
OAWRDS	EQU	WORDS*LINES+WORDS*VFIELDD
OABYTS	EQU	OAWRDS*2
VBAL	EQU	VBAP*WORDS*2
VFPL	EQU	VFROPC*WORDS*2
VSL	EQU	VSYNCW*WORDS*2
VBPL	EQU	VBAPC*WORDS*2
VFRL	EQU	VFROP*WORDS*2
FLDL	EQU	VFIELDL*WORDS*2
CHKL1	EQU	VBAL+VFPL
CHKL2	EQU	CHKL1+VSL
CHKL3	EQU	CHKL2+VBPL
CHKL4	EQU	CHKL3+VFRL
CHKL5	EQU	CHKL4+FLDL

RTJPADR	EQU	OABYTS+2-VFIELDD*WORDS*2
RTJP	EQU	(BASE SHL 3)+1
;
	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	SRC\VIDMAC.MAC
;
PGROUP	GROUP	PROG
	ASSUME	CS:PGROUP
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	PUBLIC	VDIC260
 	PUBLIC	DATSEG
;
	EXTRN	INIATTR:NEAR,CHRGEN:NEAR
DATSEG	DW	OAWRDS/8+BASE+1		;DATA SEGMENT
VDIC260:
	DW	VDIC260TE
	DB	2			;FLAG NON INTERLACED VIDEO
	DB	LINES_CHAR		;LINES PER CHARACTER
	DW	LINES			;TOTAL LINES
	DW	WORDS			;TOTAL WORDS
	DW	VFIELDL			;ACTIVE VERTICAL LINES
	DW	HFIELD			;ACTIVE WORDS
	DW	BASE			;VIDEO SEGMENT
	DW	2			;VERTICAL SYNCFIELD 1
	DW	0
	DW	CHKL4+2			;EXIT ADR SYNC FIELD 1
	DW	0
	DW	CHKL4			;ADDRESS FIRST ACTIVE LINE
	DW	WORDS*2+2		;OFFSET TO EXIT ADR OF LINE
	DW	HFROP*2			;OFFSET TO ACTIVE PART OF LINE
	DW	OAWRDS+WORDS		;TOTAL WORDS
	DW	VFIELDD			;DUMMY LINES
	DW	OFFSET PGROUP:CHRGEN	;CHARGEN ADDR
	DD	IATTR			;$ INIT ROUT ATTRIBUTES
	DD	SLNKLST			;$ INIT ROUT LINK LIST
	DW	WORDS*2			;BYTES PER LINE
	DW	(HFROP+HSYNCW+HBAP)*2	;LENGTH INVISIBLE PART OF LINE
	DW	LINES_CHAR*2*WORDS	;LENGTH CHARACTER LINE
	DW	LINES*WORDS*2-(HBAP+HSYNCW)*2
	DW	VFIELDL*WORDS*2		;LENGTH ACTIVE FIELD
	DW	NX			;ACTIVE BYTES PER LINE
	DW	NX-1			;MAX X CURSOR
	DW	NY-1			;MAX Y CURSOR
	DW	NYR			;RESERVED CHARACTER LINES
	DW	NYD
VDIC260TE EQU	($-VDIC260)/2
;
SLNKLST	PROC	FAR
	MOV	AX,BASE
	MOV	ES,AX
	MOV	BX,CHKL4+2
	MOV	AX,(BASE SHL 3)+(CHKL4 SHR 1)+2
	MOV	CX,VFIELDL+VFIELDD
LDCLP:
	MOV	ES:[BX],AX
	ADD	BX,WORDS*2
	ADD	AX,WORDS
	LOOP	LDCLP
	MOV	BX,RTJPADR
	MOV	WORD PTR ES:[BX],RTJP
	RET
SLNKLST	ENDP
;
;
IATTR	PROC	FAR
	PUSH	DS
	MOV	BX,OFFSET PGROUP:INIATTRIBU
	JMP	INIATTR
INIEND:
	MOV	DX,ATTRPT
	MOV	AH,30H
	OUT	DX,AX
	POP	DS
	RET
IATTR	ENDP
;
;
INIATTRIBU:
	ADDRS	0,BASE
;
;	VERT BACK PORCH
;
	COUNT	VBAP
VBAPL:
	COUNT	(HFROP+HFIELD+HBAP)
VBAPL1:
	COPY	1,VERT
	RP	VBAPL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)> ;HOR SYNC DURING VERT BACK PORCH
	RP	VBAPL
;
	IF	VFROPC
;	VERT FRONT PULSES
;
	COUNT	VFROPC*2
VFRPUL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2
VFRPUL1:
	COPY	1,VERT
	RP	VFRPUL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	RP	VFRPUL
	SUBA	HSYNCW*2
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	ENDIF
;
;	VERT SYNC
;
	COUNT	VSYNCW*2
VSYNCL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2
VSYNCL1:
	COPY	1,VSYNC
	RP	VSYNCL1
	COPY	HSYNCW,<HSYNCW DUP (VERT)>
	RP	VSYNCL
	SUBA	HSYNCW*4
	COPY	HSYNCW,<HSYNCW DUP (VERT)>
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
;
;	VERTICAL BACK PULSES
;
	IF	VBAPC
	COUNT	VBAPC*2
VBAPUL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2 ;VERT BACK PULSES
VBAPUL1:
	COPY	1,VERT
	RP	VBAPUL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)> ;HOR SYNC AFTER .5H
	RP	VBAPUL
	ENDIF
;
;	VERT FRONT PORCH
;
	COUNT	VFROP
VFROPL:
	ADDA	(HFROP+HFIELD+HBAP)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	VFROPL
;
;	FIELD1
;
	COUNT	VFIELDL+VFIELDD
FIELD:
	COPY	1,LDCNTR
	ADDA	HFROP*2-2
	COUNT	HFIELD
FIELD1:
	COPY	1,NORM
	RP	FIELD1
	ADDA	HBAP*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	FIELD
	COPY	1,LDCNTR
	ENDTB	INIEND
;
;
PROG	ENDS
	END
