	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	\186\186.EQU
	INCLUDE	\186\XINSTR.MAC
	INCLUDE	\186\MPROC.MAC
;
;
	PUBLIC	MSITABL
MSITABL	EQU	2
DELTABL	EQU	5			;LENGTH 10MSEK DELAY CNTR TABLE
;
;ENTRY	1	IS USED BY BOOT PROCEDURE
;	2		BY DYSK DRIVER
;	3	BY SERIAL DRIVER FOR BREAK (ABBORT) DELAY
;
;
PGROUP	GROUP	PROG
DGROUP	GROUP	DATA
	ASSUME	CS:PGROUP,DS:DGROUP,DS:DGROUP,ES:DGROUP
DATA	SEGMENT	WORD PUBLIC 'DATA'
	EXTRN	CHARIOSW:DWORD
	PUBLIC	MSTAB1,MSTAB20,MSC10,MSC100,MSC500,DELTAB,SCROLLP
DELTAB	DW	DELTABL DUP (?)
MSTAB1	DW	4 DUP (?)
MSTAB20	DW	4 DUP (?)
SCROLLP	DW	?			;SCROLL PROCEDURE
SSSV	DW	?
SPSV	DW	?
INTN	DB	?
MSC10	DB	?			;10 MSEC COUNTER
MSC20	DB	?			;20 MSEC COUNTER
MSC100	DB	?			;100 MSEC
MSC500	DB	?			;500 MSEC
M500	DB	?			;500 MSEK DELAY BIT FO BLINK
STCK	DW	100H DUP (?)
ISTACK	EQU	$
DATA	ENDS
;
;
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
;
;
;
;
	EXTRN	KBMODE:NEAR,TOGCURS:NEAR
	EXTRN	DATSEG:WORD
;
;
;
	PUBLIC	TIMRINIT,FRETI

;
;
;
FRETI	PROC	NEAR
	DB	0CBH
FRETI	ENDP
;
;
TIMRINIT PROC				;INIT TIMER INTERUPT
	MOV	SI,OFFSET DGROUP:MSTAB1	;INIT USER INTERUPTS
	MOV	CX,MSITABL*2		;INIT INTERUPT SUB HNDLRS,SCROLL INTERUPT
TIMRINI1:
	MOV	WORD PTR[SI],OFFSET PGROUP:FRETI
	MOV	[SI+2],CS
	ADD	SI,4
	LOOP	TIMRINI1
	INITVC	TINT2,PGROUP:TMR2SRV
	MOV	MSC10,10
	MOV	MSC20,2
	MOV	MSC100,5
	MOV	MSC500,5
	DEC	INTN
	MOV	DX,MAXA2
	MOV	AX,1637			;1009 USEC
	OUT	DX,AX
	MOV	DX,MD2
	MOV	AX,TIM2RTC
	OUT	DX,AX
	MOV	DX,TIMINT		;ENABLE INTERUPTS
	MOV	AX,0
	OUT	DX,AX
	STI
	RET
TIMRINIT ENDP

TMR2SRV:
	PUSH	DS
	MOV	DS,CS:DATSEG
	INC	INTN			;IF INTERUPT NOT NESTED
	JNZ	TM2S1
	MOV	SSSV,SS			;SWITCH STACK
	MOV	SPSV,SP
	MOV	SS,CS:DATSEG
	MOV	SP,OFFSET DGROUP:ISTACK
TM2S1:
	PUSHA
	PUSH	ES
	EOI	TINT0
	STI
; 1MSEC
	CALL	WORD PTR DS:KBMODE
	PUSH	DS
	CALL	DWORD PTR DS:[MSTAB1]
	POP	DS
	PUSH	DS
	CALL	DWORD PTR DS:[MSTAB1.4]
	POP	DS
	CALL	DWORD PTR CHARIOSW
	CALL	WORD PTR DS:SCROLLP	;CALL SCROLL PROCEDURE
	DEC	MSC10
	JNZ	TINTFINI
; 10 MSEC
	MOV	MSC10,10
	MOV	CX,DELTABL		;COUNT DELAY COUNTERS DOWN
	MOV	SI,OFFSET DGROUP:DELTAB
DELLP:
	CMP	WORD PTR[SI],0		;IF COUNTER PRESET
	JZ	DELLP1
	DEC	WORD PTR[SI]		;COUNT ONE DOWN
DELLP1:
	ADD	SI,2
	LOOP	DELLP			;LOOP UNTIL ALL COUNTERS SCANNED
	DEC	MSC20
	JNZ	TINTFINI
;20 MSEC
	MOV	MSC20,2
	PUSH	DS
	CALL	DWORD PTR DS:[MSTAB20]
	POP	DS
	PUSH	DS
	CALL	DWORD PTR DS:[MSTAB20.4]
	POP	DS
	CALL	TOGCURS
	DEC	MSC100
	JNZ	TINTFINI
; 100 MSEC
	MOV	MSC100,5
	DEC	MSC500
	JNZ	TINTFINI
; 500 MSEC
	MOV	MSC500,5
	INC	M500
	MOV	AL,BYTE PTR M500	;GENERATE BLINK SIGNAL
	MOV	DX,BLINK
	OUT	DX,AL
TINTFINI:
	POP	ES
	POPA
	CLI
	DEC	INTN			;IF NESTED INTERUPT
	JGE	TF1			;EXIT
	MOV	SS,SSSV			;ELSE RESTAURATE USER STACK
	MOV	SP,SPSV
TF1:
	STI
	POP	DS
	IRET
PROG	ENDS
	END
D

N



