	TITLE	SETUP HANDLER GIFDIC
	PAGE	62,132
	INCLUDE	\GIFI\SRC\VIDS.S86
DGROUP	GROUP	DATA
PGROUP	GROUP	PROG


;FLGS
;
NDSPS	EQU	1		;DISABLE DISPLAYING OF Y MESSAGE
INSETUP	EQU	2		;IN SETUP MODE
FINISHS	EQU	4		;EXIT OF SETUP REQUESTED
ESCMD	EQU	8		;WAITING FOR 2CND CHAR OF ESC SEQU
INIT	EQU	16		;SETUP INIT MODE

DATA	SEGMENT	WORD PUBLIC 'DATA'
	ASSUME	DS:DGROUP
	EXTRN	XCURS:BYTE,YCURS:BYTE,VIDPAR:NEAR
RTCBUF	DD	2 DUP (?)	;RTC TEMP BUFFER
CALLADR	DD	?		;TEMP FAR CALL TO SETUP PROC
USERTAB	DD	?		;ADDRESS USER TABLE
CURTAB	DD	?		;CURRENT TABLE
CURPNT	DW	?		;CURRENT TABLE POINTER
BITINF	DW	?		;BITCOUNT,BIT
MAXX	DB	?		;# X ENTRYS
MAXY	DB	?		;# Y ENTRYS
FLGS	DB	?		;FLAGS
SX	DB	?		;X TABLE ENTRY SETUP HANDLER
SY	DB	?		;Y TABLE ENTRY SETUP HANDLER
INIX	DB	?		;TEMP DEFAULT X ENTRY
	EXTRN	YLAST:BYTE
DATA	ENDS


	INCLUDE	\GIFI\SRC\GIFMAC.MAC
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP
	PUBLIC	RDSUPB,TSTSUPB,LINKSH,ULINKSH,SETUPS,SETUP
	EXTRN	MOVCURS:NEAR,STAB:NEAR,GIFDIC:FAR,ERSCRN:NEAR
	EXTRN	CLRCURS:NEAR
;
;
;
RDSUPB	PROC	FAR
	MOV	AH,ILLOPC
	STC
	RET
RDSUPB	ENDP
;
;
;
TSTSUPB PROC	FAR
	JMP	RDSUPB
TSTSUPB ENDP
;
;
;
LINKSH	PROC	FAR
	JMP	RDSUPB
LINKSH	ENDP
;
;
;
ULINKSH	PROC	FAR
	JMP	RDSUPB
ULINKSH	ENDP

;READ/WRITE TO RTC 
RTCIO:
	AND	AL,AL	;IF READ
	MOV	BX,RTCDEV*64+READ*4
	JZ	RTCIO1	;READ RTC
	ADD	BL,WRITE*4-READ*4
RTCIO1:
	PUSH	DS
	POP	ES
	MOV	DI,OFFSET DGROUP:RTCBUF
	MOV	DL,8
	MOV	CX,7
	CALL	GIFDIC
	RET
;
;
;
PNTBYTE	PROC	NEAR	;POINT TO BYTE #CH/8 AND LOAD IT INTO AL
	MOV	AH,0
	MOV	AL,CH
	MOV	SI,AX
	SHR	SI,1
	SHR	SI,1
	SHR	SI,1
	ADD	SI,OFFSET DS:RTCBUF
	AND	AL,7
	MOV	BH,AL
	MOV	AL,BYTE PTR[SI]
	RET
PNTBYTE ENDP

;
;
;
MASKL	PROC	NEAR		;CLR 8-CL BITS STARTING AT BIT7 IN AL
	PUSH	CX
	MOV	CH,0
	MOV	AH,0
	JCXZ	MASKL2
MASKL1:
	STC
	RCL	AH,1
	LOOP	MASKL1
MASKL2:
	AND	AL,AH
	POP	CX
	RET
MASKL	ENDP
;
;
;
MASKU	PROC	NEAR		;CLR #CL BITS STARTING AT BIT0 IN AL
	PUSH	CX
	MOV	CH,0
	MOV	AH,0
	NEG	CL
	ADD	CL,8
	JCXZ	MASKU2
MASKU1:
	STC
	RCR	AH,1
	LOOP	MASKU1
MASKU2:
	AND	AL,AH
	POP	CX
	RET
MASKU	ENDP
;
;
;
;
;
;
GETBIT	PROC	NEAR		;GET #CL BITS STARTING AT BIT
	CALL	PNTBYTE		;BIT #CH FROM BUFFER [BX]
	PUSH	CX
	MOV	CL,BH
	ROR	AL,CL
	POP	CX
	CALL	MASKL
	RET
GETBIT	ENDP
;
;
;
STOBIT	PROC	NEAR		;STORE #CL BITS OF AH IN BUFFER
	MOV	BL,AL		;SAVE BYTE
	CALL	PNTBYTE		;[BX] STARTING AT BIT #CH
	PUSH	CX
	MOV	CL,BH
	ROR	AL,CL
	POP	CX
	CALL	MASKU
	PUSH	AX
	MOV	AL,BL
	CALL	MASKL
	MOV	BL,AL
	POP	AX
	OR	AL,BL
	PUSH	CX
	MOV	CL,BH
	ROL	AL,CL
	POP	CX
	MOV	BYTE PTR [SI],AL
	RET
STOBIT	ENDP
;
;
PSET	PROC	NEAR	;PUT STRING POINTED TO BY ES:DI ONTO SCREEN
	TEST	FLGS,NDSPS		;IF OUTPUT DISABLED
	JNZ	PSET1		;YUST POINT TO PARAMETERS
	MOV	XCURS,DL
	IF	0
	PUSH	ES
	CALL	MOVCURS
	POP	ES
	ENDIF
	PUSH	WORD PTR XCURS	;SAVE CURSOR
	MOV	DH,YCURS	;CLR LINE
	PUSH	ES
	CALL	ERSCRN
	POP	ES
PSET1:
	MOV	AL,ES:[DI]	;GET CHAR
	INC	DI
	TEST	AL,80H		;IF AT END OF STRING
	JNZ	PSET3		;EXIT
	TEST	FLGS,NDSPS	;IF DISPLAYING OF MESSAGE DISABLED
	JNZ	PSET2		;JUST SCAN FOR END OF MESSAGE
	GIFCALL	KVDDEV,WRITE,2 ;ELSE WRITE IT TO SCREEN
PSET2:
	JMP	PSET1
PSET3:
	TEST	FLGS,NDSPS		;IF OUTPUT DISABLED
	JNZ	PSET4
	POP	WORD PTR XCURS	;RESTORE CURSOR
	PUSH	ES
	CALL	MOVCURS
	POP	ES
PSET4:
	RET
PSET	ENDP
;
;
;
PNTE	PROC	NEAR		;SEARCH STRING #CL IN TABLE
	CMP	CL,CH		;@ES:DI OF #CH ENTRYS
	JNB	PNTE3		;EXIT IF NOT IN TABLE
	MOV	CH,0
PNTE1:
	ADD	DI,2		;POINT TO ENTRY IN TABLE
	JCXZ	PNTE2		;EXIT IF ENTRY FOUND
	ADD	DI,ES:[DI-2]	;ELSE POINT TO NEXT ENTRY
	DEC	CX
	JMP	PNTE1		;AND LOOP
PNTE2:
	CALL	PSET		;DISPLAY MESSAGE
	MOV	AX,WORD PTR ES:[DI]
	RET
PNTE3:
	STC
	RET
PNTE	ENDP
;
;
;
GY	PROC	NEAR		;POINT TO,DISPLAY Y ENTRY#SY
	MOV	DI,WORD PTR CURTAB	;GET POINTER TO CURRENT TABLE
	MOV	ES,WORD PTR CURTAB+2
	MOV	CL,SY
	MOV	CH,ES:[DI]	;# ENTRYS IN TABLE
	MOV	MAXY,CH		;SAVE
	INC	DI
	MOV	DL,15
	CALL	PNTE
	JB	GY1		;EXIT IF NOT FOUND
	MOV	BITINF,AX	;STORE BIT INFO
	ADD	DI,6
	MOV	AX,ES:[DI-4]
	MOV	MAXX,AL		;ELSE STORE # X ENTRYS
	MOV	INIX,AH		;DEFAULT ENTRY
	MOV	AX,ES:[DI-2]
	MOV	WORD PTR CALLADR,AX
	MOV	CURPNT,DI	;SAVE POINTER
GY1:
	RET
GY	ENDP
;
;
;
GX	PROC	NEAR		;POINT TO,DISPLAY X ENTRY #SX
	MOV	CL,SX
	MOV	CH,MAXX
	MOV	DI,CURPNT
	MOV	DL,50
	CALL	PNTE
	RET
GX	ENDP
;
;
INIWR	PROC	NEAR
	MOV	WORD PTR SX,0
	PUSH	AX
INIWR1:
	CALL	GY
	POP	AX
	PUSH	AX
	OR	AL,AL
	JNZ	INIWR2
	MOV	AL,INIX
	MOV	CX,BITINF
	CALL	STOBIT
	JMP	SHORT INIWR3
INIWR2:
	MOV	CX,BITINF
	CALL	GETBIT
	TEST	AL,1
	CALL	DWORD PTR [CALLADR]
INIWR3:
	INC	SY
	MOV	AL,SY
	CMP	AL,MAXY
	JB	INIWR1
	POP	AX
	MOV	WORD PTR SX,0
	RET
INIWR	ENDP
;
;
;
DEDSPC	PROC	NEAR	;ENTER AND DISPLAY X ENTRY VIA RTC AND SY
	CALL	GY	;ENTER CURRENT Y ENTRY
	MOV	CX,BITINF ;START BIT,# BITS
	CALL	GETBIT	;MASK BITS OUT
	MOV	SX,AL	;= XENTRY
	CALL	GX	;ENTER AND DISPLAY X ENTRY
	RET
DEDSPC	ENDP
;
;
;
SETUPI	PROC	NEAR
	CALL	DEDSPC		;DISPLAY CURRENT ENTRY
SETUPIL:
	AND	FLGS,NOT ESCMD
SETUPIL1:
	TEST	FLGS,FINISHS	;IF SETUP FINISHED
	JZ	SETUPI0
	GIFCALL	KVDDEV,RDFLUSH,0	;FLUSH BUUFER
	RET
SETUPI0:
	GIFCALL	KVDDEV,READ,0
	JB	SETUPIL1
	MOV	CX,WORD PTR SX	;CURRENT X,Y POSITION
	CMP	AL,1BH		;IF ESCAPE
	JNZ	SETUPI01
	TEST	FLGS,ESCMD	;CHECK FOR ESCAPE MODE
	JNZ	SETUPIL		;IF ALREADY ESC MODE - IGNORE
	OR	FLGS,ESCMD	;ELSE FLAG ESC MODE
	JMP	SETUPIL1
SETUPI01:
	TEST	FLGS,ESCMD
	JNZ	SETUPI03
	OR	AL,20H
	CMP	AL,'d'
	JNZ	SETUPI02
	MOV	CL,INIX
	JMP	SETUPI1
SETUPI02:
	CMP	AL,'x'	;IF REINIT
	JNZ	SETUPIL
	XOR	AL,AL
	CALL	INIWR
	JMP	SETUPI
SETUPI03:
	CMP	AL,'D'
	JZ	SIL		;LEFT
	CMP	AL,'C'		;RIGHT
	JZ	SIR
	CMP	AL,'A'		;UP
	JZ	SIU
	CMP	AL,'B'		;DOWN
	JZ	SID
	JMP	SETUPIL
SIL:
	DEC	CL		;DISPLAY IF NO UNDERFLOW
	JGE	SETUPI1
	MOV	CL,MAXX		;ELSE GET LAST ENTRY
	JMP	SIL
SIR:
	INC	CL		;DISPALY IF NO OVERFLOW
	CMP	CL,MAXX
	JB	SETUPI1
	MOV	CL,0		;ELSE GET FIRST ENTRY
	JMP	SETUPI1
SIU:
	DEC	CH		;DISPLAY IF NO UNDERFLOW
	JGE	SETUPI1
	MOV	CH,MAXY		;ELSE GET LAST ENTRY
	JMP	SIU
SID:
	INC	CH		;DISPALY IF NO OVERFLOW
	CMP	CH,MAXY
	JB	SETUPI1
	MOV	CH,0		;ELSE GET FIRST ENTRY
SETUPI1:
	MOV	WORD PTR SX,CX	;SAVE NEW X Y INFO
	MOV	AL,CL
	MOV	CX,BITINF	;UPDATE SETUP MEMORY
	CALL	STOBIT
	JMP	SETUPI		;DISPLAY IT
SETUPI	ENDP
;
NVRMSG:
	DB	"NVR LOST",80H
;
;
SETUPS	PROC	NEAR
	TEST	FLGS,INSETUP		;IF IN SETUP MODE
	JZ	SETUPS1
	OR	FLGS,FINISHS		;FLAG EXIT OF SETUP
	RET				;AND EXIT
SETUPS1:
	MOV	FLGS,INSETUP		;FLAG IN SETUP MODE
SETUP1:
	MOV	WORD PTR CURTAB,OFFSET CS:STAB	;INIT FOR INTERNAL TABL
	MOV	WORD PTR CURTAB+2,PGROUP
	MOV	WORD PTR CALLADR+2,PGROUP ;INIT CS OF IND CALL PNTR
	MOV	WORD PTR SX,0
	TEST	FLGS,INIT		;IF INIT MODE
	JNZ	SETUP11			;NO USE OF VIDEO
	CALL	CLRCURS
	PUSH	WORD PTR XCURS
	MOV	AH,[VIDPAR.YMAXI]	;POINT TO SETUP LINE
	ADD	AH,[VIDPAR.YNR]	;POINT TO SETUP LINE
	MOV	AL,0
	MOV	WORD PTR XCURS,AX
	PUSH	WORD PTR YLAST
	MOV	WORD PTR YLAST,0FFH	;INIT YLAST,SYCURS
	STI
	MOV	XCURS,0
	MOV	DH,YCURS
	CALL	ERSCRN
SETUP11:
	STI
	XOR	AL,AL			;READ RTC INTO BUFFER
	CALL	RTCIO
	JNB	SETUPS2
	PUSH	CS
	POP	ES
	MOV	DI,OFFSET PGROUP:NVRMSG
	MOV	DL,0
	CALL	PSET
	XOR	AL,AL
	CALL	INIWR
SETUPS2:
	TEST	FLGS,INIT	;IF INIT MODE
	JNZ	SETUPS4		;NO ENTERING OF DATA
	GIFCALL	KVDDEV,RDFLUSH,0
	CALL	SETUPI
	MOV	AL,1		;STORE SETUP INFO IN RTC
	CALL	RTCIO
	CALL	SETUP2
SETUPS3:
	MOV	XCURS,0
	MOV	DH,YCURS
	CALL	ERSCRN
	POP	WORD PTR YLAST
	POP	WORD PTR XCURS	;RESTAURATE CURSOR
	MOV	YLAST,0FFH
	CALL	MOVCURS
SETUPS4:
	MOV	FLGS,0		;REINIT FLGS
	RET
SETUPS	ENDP
;
;
;
SETUP	PROC	NEAR
	MOV	FLGS,INSETUP+INIT+NDSPS	;FLAG SETUP HNDLR BUSY,INIT
	CALL	SETUP1
SETUP2:
	MOV	FLGS,NDSPS
	MOV	AL,1
	CALL	INIWR
	RET
SETUP	ENDP
PROG	ENDS
	END

