	TITLE	KB,VIDEO DRIVER COMBINATION MODULE
	PAGE	60,132
	INCLUDE	\GIFI\SRC\GIFMAC.MAC
	INCLUDE	\GIFI\SRC\IDAT.EQU
	INCLUDE	\GIFI\SRC\FIFO.S86
	INCLUDE \186\XINSTR.MAC
	EXTRN	SCRLNG:ABS

DGROUP	GROUP	DATA
DATA	SEGMENT	WORD PUBLIC 'DATA'
	ASSUME	DS:DGROUP
	EXTRN	SCRLF:BYTE,VPROC:DWORD,VFLG:BYTE
DATA	ENDS

PGROUP	GROUP	PROG
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP
;
;
	PUBLIC	KVDTAB,KVDATTR
;
;
	EXTRN	WRAHATB:FAR,DISEN:FAR,SETOTWT:FAR,CLRSCRN:NEAR
	EXTRN	SETOTASK:FAR,SETINWT:FAR,SETITASK:FAR,SETIPROC:FAR
	EXTRN	CDISEN:FAR,SSCRAD:FAR,GIFJMP:FAR
	EXTRN	KB_INIT:NEAR,GIFDIC:FAR,FLUSHI:FAR,IDAT:FAR
	EXTRN	FRETF:FAR,FIFOIO2:FAR,FIFOGSTA:FAR,FIFOIO:FAR,KBINIT:NEAR
	EXTRN	VT52INIT:NEAR
	PUBLIC	KVDGST,KBREAD,VDWRITE,VDFLUSH,KBFLUSH,KVDGSTR
;
;
KVDTAB:
	DW	64+8
	DW	OFFSET PGROUP:KVDRES
	DW	OFFSET PGROUP: KVDGSTR
	DW	OFFSET PGROUP:KVDGST
	DW	OFFSET PGROUP:KVDSSTA
	DW	OFFSET PGROUP:KBREAD
	DW	OFFSET PGROUP:VDWRITE
	DW	OFFSET PGROUP:KBFLUSH
	DW	OFFSET PGROUP:VDFLUSH
	DW	0FFFFH
;
;
;	RESET KVD DEV
;
;
KVDRES	PROC	FAR
	PUSH	DX
	POP	DX
	MOV	DI,OFFSET PGROUP:KBVDRT
	CALL	IDAT
	XOR	AH,AH
	CALL	FLUSHI
	CALL	KB_INIT
	SUB	DX,FIFOERR
	SUB	DX,BX
	CALL	KBINIT
KVDRES1:
	CALL	VT52INIT
	RET
KVDRES	ENDP

;	GET STATUS OF KEYBOARD\VIDEO DEVICE
;
;
;
KVDGSTR	PROC	FAR
	MOV	AL,[BX.FIFOFLGS]	;GET BREAK CHR FLAG
	AND	[BX.FIFOFLGS],NOT BREAKC;RESET BREAK CHR FLAG
	AND	AX,BREAKC
	CMP	[BX.FIFOICNT],0		;TEST FOR INPUT FIFO IS EMPTY
	JZ	KGR1
	OR	AL,RXBRDY+RXRDY		;FLAG RX READY
KGR1:
	TEST	SCRLF,SCRLNG		;IF NO SCROLLING PENDING
	JNZ	KGR2
	OR	AL,TXBRDY+TXRDY		;FLAG TX READY
KGR2:
	OR	AL,DCD+CTS		;FLAG MODEM READY
	CLC
	RET
KVDGSTR	ENDP
;
;
;
;
;	GET KB STATUS
;
;
KVDGST	PROC	FAR
	CALL	FIFOGSTA
	RET
KVDGST	ENDP
;
;
;	KVD SET STATUS
;
;
SVHAD	PROC	FAR			;SET VIDEO HANDLER ADDRESS
	JZ	SVHAD1			;IF RESET - REINIT TO LOCAL HANDLER
	CLI
	MOV	WORD PTR VPROC,DI	;ELSE SET ADDRESS
	MOV	WORD PTR VPROC+2,ES
	OR	VFLG,1			;FLAG EXTERNAL ROUTINE VALID
	STI
	RET
SVHAD1:
	CALL	CLRSCRN
	JMP	SHORT KVDRES1
SVHAD	ENDP
;
;
KVDATTR: DB	KVDATTRE-KVDATTR-3
	DW	OFFSET PGROUP:WRAHATB
	DW	OFFSET PGROUP:DISEN
	DW	OFFSET PGROUP:SETOTWT
	DW	OFFSET PGROUP:SETOTASK
	DW	OFFSET PGROUP:SETINWT
	DW	OFFSET PGROUP:SETITASK
	DW	OFFSET PGROUP:SETIPROC
	DW	OFFSET PGROUP:SVHAD
	DW	OFFSET PGROUP:CDISEN
	DW	OFFSET PGROUP:SSCRAD
KVDATTRE EQU	$
;
;
KVDSSTA	PROC	FAR
	MOV	SI,OFFSET PGROUP:KVDATTR
	JMP	GIFJMP
KVDSSTA	ENDP
;
;
;
;
;	READ KB
;
;
KBREAD	PROC	FAR
	CALL	FIFOIO
	RET
KBREAD	ENDP
;
;
;	WRITE VIDEO
;
;
VDWRITE	PROC	FAR
	PUSHA
	EXTRN	WR52:NEAR
	CALL	WR52
	POPA
	XOR	AH,AH
	RET
VDWRITE	ENDP
;
;
;	FLUSH KB INPUT BUFFER
;
;
KBFLUSH	PROC	FAR
	CALL	FLUSHI
	RET
KBFLUSH	ENDP
;
;
;	FLUSH VIDEO
;
;
VDFLUSH	PROC	FAR
	XOR	AH,AH
	RET
VDFLUSH	ENDP
;
;
;
KBVDRT:
	DW	(KBVDRTE-KBVDRT)/2
	DW	ALLBX,0,FIFOSE
	DW	0,0,0,0
	DD	VIDWAIT
	DD	FRETF
	DD	FRETF
	DW	0,0
	DW	0,1 SHL MODEN,0
	DW	ALLOC,BUFFSIZE
	DW	COPYI,2
	DW	0
	DW	BUFFSIZE
	DD	FIFOIO2
	DD	FRETF
	DD	FRETF
	DW	COPYI,20
	DW	STOCB
	DW	0
	DW	BUFFSIZE-10
	DW	BUFFSIZE-10
	DD	FRETF
KBVDRTE:
PROG	ENDS
	END

