TITLE	INITIALIZATION MODULE OF THE SYSCON HARDWARE GIFDIC PROM
;
NAME	INITSCG
;
	INCLUDE	\SYSCON\SYSCON.EQU
MONITOR	SEGMENT	AT 0FC00H
MONITOR_START LABEL FAR
MONITOR	ENDS

;
; INITIALIZE ROUTINE
;
INISEG	SEGMENT
ASSUME	CS:INISEG
INIT	PROC	FAR
	MOV	DX, UMCSR		; PROGRAM THE UMCS REGISTER
	MOV	AX, UMCSV
	OUT	DX, AX
	MOV	DX, LMCSR		; PROGRAM THE LMCS REGISTER
	MOV	AX, LMCSV
	OUT	DX, AX
	MOV	DX, PACSR		; SET UP THE PERIPHERAL CHIP
; SELECTS (NOTE THE MID-RANGE
; MEMORY CHIP SELECTS ARE NOT
; NEEDED IN THIS SYSTEM, AND
; ARE THUS NOT INITIALIZED
	MOV	AX, PACSV
	OUT	DX, AX
	MOV	DX, MPCSR
	MOV	AX, MPCSV
	OUT	DX, AX
	MOV	DX,DATASTB		;RESET DATA STROBE
	MOV	AL,1
	OUT	DX,AL
	JMP	MONITOR_START
;
; RESET LOCATION
	ORG	030H
	MOV	DX,SYSFAIL		;SET SYSFAIL
	MOV	AL,1
	OUT	DX,AX
	JMP	INIT
INIT	ENDP
;
INISEG	ENDS
;
END
