	TITLE	INIT SYSCON BOOT PROM W GIFDIC V2.0
PAGE	60,132
PGROUP	GROUP	PROG
DGROUP	GROUP	DATA
	ASSUME	DS:DGROUP
	ASSUME	CS:PGROUP

	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	\186\XINSTR.MAC
	INCLUDE	\186\186.EQU

IFT	MACRO	X
	TEST	TFG1,1
	JZ	X
	ENDM

PROG	SEGMENT	BYTE PUBLIC 'PROG'
;
;
;
	PUBLIC	SYSINI,CLRVDIRT,WARMBOOT
;
;
;
	EXTRN	TIMRINIT:NEAR,SETUP:NEAR,VIDINIT:NEAR
	EXTRN	SYSRST:FAR,DATSEG:WORD,TFG1:BYTE,TFG:BYTE
	EXTRN	CLRVDI:NEAR,TFG1:BYTE
;
;
;
SYSINI:
	IFT	TLAB
	TEST	TFG,1
	JZ	TLAB
	MOV	CS:DATSEG,1900H
	JMP	TLAB1
TLAB:
	MOV	DX,PACSR		;INIT IO CHIP SELECTS
	MOV	AX,PACSV+3
	OUT	DX,AX
	MOV	DX,MPCSR
	MOV	AX,MPCSV
	OUT	DX,AX
	JMP	CLRVDI			;CLEAR RAM
CLRVDIRT:
	MOV	BX,SS			;SAVE CHECKSUM
WARMBOOT:
	MOV	DX,MD2			;DISABLE TIMERS
	XOR	AX,AX
	OUT	DX,AX
	MOV	DX,MD1
	OUT	DX,AX
	MOV	DX,MD0
	OUT	DX,AX
	MOV	DX,MSKRG
	MOV	AL,0FDH			;MASK ALL INTERUPTS
	OUT	DX,AX
	MOV	DX,0E181H
	MOV	AL,20H
	OUT	DX,AL
	XOR	DX,DX
	MOV	SI,DX
	MOV	DI,DX
	MOV	DS,DX
	MOV	ES,DX
	MOV	CX,8000H
	REP	MOVSW
	ADD	DX,1000H
	MOV	CX,8000H
	MOV	ES,DX
	MOV	DS,DX
	REP	MOVSW
TLAB1:
	MOV	SS,CS:DATSEG
	MOV	SP,OFFSET DGROUP:STACK
	PUSH	BX
	PUSH	SS
	POP	DS
	MOV	CX,OFFSET DGROUP:DEND	;CLEAR RAM
	PUSH	SS
	POP	ES
	XOR	DI,DI
	MOV	AX,DI
	CLD
	REP	STOSB
	POP	WORD PTR CHKSUM
	MOV	PGRP,CS			;INIT P GROUP
	CALL	SYSRST			;INIT DEVICES
	IFT	XRAMT
	MOV	AX,PGROUP
	SHRAX	4
	JMP	RAMI2
XRAMT:
	MOV	SI,2000H		;TEST FOR XRAM EXISTING
	MOV	ES,SI
	XOR	SI,SI
	PUSH	DS
	MOV	DS,SI
	MOV	WORD PTR DS:[SI],05555H
	MOV	WORD PTR ES:[SI],0AAAAH
	MOV	AX,WORD PTR ES:[SI]
	XOR	AX,WORD PTR DS:[SI]
	POP	DS
	INC	AX
	JNZ	RAMI3
RAMI1:
	MOV	AX,400H
RAMI2:
	MOV	WORD PTR [MEMAX+1],AX
RAMI3:
	MOV	DS,CS:DATSEG
	CALL	SETUP
	CALL	VIDINIT
	IFT	RAMI4
	TEST	TFG,1
	JNZ	TLAB2
RAMI4:
	MOV	DX,INT1RG		;ENABLE KEYBOARD INTERUPTS
	MOV	AX,0
	OUT	DX,AX
	CALL	TIMRINIT		;INIT TIMER
	EXTRN	CHARIOS:NEAR		;ENABLE SCC
	EXTRN	BPROC:NEAR
	CALL	CHARIOS
	IFT	TLAB3
TLAB2:
	TEST	TFG,1
	JZ	TLAB3
	INT	3
TLAB3:
	MOV	WORD PTR NTST,055AAH	;DISABLE RAM,CHECKSUM TEST
	MOV	DX,LAMP			;DISABLE LAMP
	MOV	AL,1
	OUT	DX,AX
	MOV	DX,SYSFAIL
	DEC	AX
	OUT	DX,AX
	JMP	BPROC
;
;
;
PROG	ENDS
DATA	SEGMENT	WORD PUBLIC 'DATA'
	EXTRN	DEND:NEAR,PGRP:WORD,DDFLG:BYTE,MEMAX:WORD,NTST:WORD
CHKSUM	DW	?
	DW	100 DUP (?)		;STACK
STACK	EQU	$
DATA	ENDS
	END
