TITLE	BOOT	PROCEDURE
	.XLIST
	PAGE	60,132

IF1
%OUT	PASS	1...
ELSE
%OUT	PASS	2...
ENDIF

PGROUP	GROUP	PROG
DGROUP	GROUP	DATA
DATA	SEGMENT	WORD PUBLIC 'DATA'
	EXTRN	SSCON:BYTE
DATA	ENDS


BOOTLOC	EQU	1FC0H





BOOTSEG	SEGMENT	AT BOOTLOC
BOOTJMP	LABEL	FAR
BOOTSEG	ENDS
	INCLUDE	\GIFI\SRC\GIFMAC.MAC

PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP
	ASSUME	DS:DGROUP
	EXTRN	MONINIT:NEAR,DATSEG:WORD,GIFDIC:FAR,IBOOT:NEAR
	PUBLIC	BPROC
;
;
BPROC	PROC	NEAR
	MOV	DS,CS:DATSEG
	GIFCALL	KVDDEV,RDFLUSH		;FLUSH BUFFERS
	GIFCALL	DCEDEV,RDFLUSH
	GIFCALL	DTEDEV,RDFLUSH
	MOV	[DELTAB],500		;SETUP 5SEK DELAY COUNTER
	XOR	CX,CX			;CLEAR FLAGS
	MOV	OSNR,CL
BPROC1:
	MOV	DL,GIOST
	GIFCALL	SCONDEV,GSTATRG		;CHECK STATUS
	TEST	AL,BREAKC		;IF BREAK RECEIVED
	JZ	BPROC14
	AND	BL,3			;CHECK FOR DCE OR DTE DEVICE
	JZ	BPROC1			;IF KVDDEV IGNORE BREAK
	MOV	DL,SBITSC		;ELSE INIT CHANNEL TO
	MOV	AL,3			;8 DATA,2 STOP BITS
	GIFCALL	SCONDEV,SSTATUS
	MOV	DL,SPARITY		;AND NO PARITY
	XOR	AL,AL
	GIFCALL	SCONDEV,SSTATUS
	MOV	DL,SBAUDR		;AND SET BAUDRATE
	MOV	AL,7			;START AT 19200 BAUD
BPROC12:
	GIFCALL	SCONDEV,SSTATUS
	GIFCALL	SCONDEV,READ,WAITRDY	;GET CHARACTER
	JB	BPROC13			;IGNORE IF ERROR
	CMP	AL,0DH			;OR NO RETURN
	JZ	BPROC14
BPROC13:
	GIFCALL	SCONDEV,GSTATRG
	DEC	AL			;SELECT NEXT LOWER BAUD RATE
	AND	AL,7
	JMP	BPROC12
BPROC14:
	GIFCALL	SCONDEV,READ,0
	JNB	BPROC2			;SEL DRIVE IF CHARACTER AVAILABLE
	TEST	CL,4			;IF FIRST KEY PRESSED
	JNZ	BPROC1			;KEEP CURRENT CHANNEL
	MOV	DL,GIOST		;GET CURRENT DEVICE
	GIFCALL	SCONDEV,GSTATRG
	MOV	AL,BL
	INC	AL
	CMP	AL,2			;IF DEVICE CODE OVERFLOW
	JBE	BPROC15
	XOR	AL,AL			;RESET
BPROC15:
	MOV	DL,SCON
	GIFCALL	SCONDEV,SSTATUS		;SET NEXT DEVICE
	CMP	DELTAB,0		;TEST FOR TIMEOUT
	JNZ	BPROC1S			;WAIT
	TEST	CL,4			;IF WAITING FOR SUBSEQ KEY
	JNZ	BPROC1S			;WAIT...
	MOV	AL,SSCON		;ELSE SET BACK TO ORIGINAL DEVICE
	GIFCALL	SCONDEV,SSTATUS
	JMP	SHORT BOOT		;BOOT FORM HD IF TIMEOUT
BPROC2:
	OR	CL,4			;FLAG FIRST KEY ENTERED
	CMP	AL,'@'			;IF GIFDIC BOOT DRIVE SELECT
	JNZ	BPROC21
	OR	CL,3			;FLAG DRIVE #  HAS TO BE ENTERED
BPROC1S:
	JMP	BPROC1
BPROC21:
	TEST	CL,2			;IF BOOT DRIVE HAS TO BE ENTERED
	JZ	BPROC22
	SUB	AL,30H
	JB	BPROC1S
	CMP	AL,3H			;CHECK FOR VALID DRIVE
	JA	BPROC1S
	MOV	CH,AL			;STORE DRIVE CODE
	AND	CL,0FDH			;FLAG BOOTDRV ENTERED
	JMP	BPROC1			;ENTER OS NUMBER
BPROC22:
	TEST	CL,1			;IF BOOT FROM PREDEF UNIT
	JNZ	BPROC23			;IGNORE ESCAPE
	CMP	AL,1BH			;ELSE IF ESCAPE THEN BOOT FROM FLOPPY
	JZ	BOOTF
	CMP	AL,'_'			;FLOPPY BOOT
	JZ	BOOTF
	CMP	AL,'!'			;ELSE CHECK FOR MAP INIT AND FLOPPY BOOT
	JB	BPROC23
	CMP	AL,')'
	JA	BPROC23
	SUB	AL,'!'-1
BPROC221:
	MOV	CH,2
	JMP	SHORT BPROC25
BPROC23:
	CMP	AL,'-'			;ELSE IF FLOPPY BOOT WITH
	JNZ	BPROC231		;MAPPED OUT HARDISKS
	MOV	AL,0FFH			;MAP OUT HARD DISKS AND BOOT FROM FLOPPY
	JMP	BPROC221
BPROC231:
	CMP	AL,30H			;ELSE IF NOT SECONDARY OS OR MONDEB
	JNB	BPROC24
	XOR	AL,AL			;BOOT FROM HARDSIK MAP 0
	JMP	BOOT
BPROC24:
	CMP	AL,39H
	JA	BPROC3
	AND	AL,0FH			;ELSE INIT NUMBER OF OS
BPROC25:
	MOV	OSNR,AL
	JMP	BOOT			;AND BOOT FROM HARDDISK
BPROC3:
	OR	AL,20H
	CMP	AL,'M'
	JNZ	BOOT
	CALL	MONINIT
	JMP	BPROC
BOOTF:
	MOV	CH,2			;FLOPPY BOOT
BOOT:
	PUSH	CX
	CALL	IBOOT			;LOG CONTROLLERS
	POP	CX
	CMP	CH,2			;IF FLOPPY BOOT
	JB	BOOT1
	MOV	DL,2			;GET NUMBER OF HARDISK DRIVES
	PUSH	CX
	GIFCALL	DSKDEV,GSTATUS,0
	TEST	CL,CL			;IF NO HARD DRIVES
	POP	CX
	JNZ	BOOT1
	SUB	CH,2			;REMAP FLOPPYS
BOOT1:
	MOV	BOOTDRV,CH
	MOV	AL,CH
	GIFCALL	DSKDEV,RESET,0
	MOV	DL,0
	GIFCALL	DSKDEV,GSTATUS,0
	JB	BTFAIL
	MOV	DL,6
	PUSH	AX
	GIFCALL	DSKDEV,GSTATUS,0
	POP	AX
	MOV	DX,ES			;BOOT RECORD
	MOV	CX,1			;ONE RECORD
	MOV	DI,BOOTSEG
	MOV	ES,DI
	XOR	DI,DI
	GIFCALL	DSKDEV,READ,0
	JB	BTFAIL
	CMP	WORD PTR ES:[DI+3],"OC"
	JNZ	BTFAIL
	JMP	BOOTJMP
ERRMSG	DB	0DH,0AH,"DISK ERROR",0DH,0AH

BTFAIL:
	MOV	SI,OFFSET CS:ERRMSG
	MOV	CX,14
BTFAIL1:
	MOV	AL,CS:[SI]
	GIFCALL	SCONDEV,WRITE,0
	INC	SI
	LOOP	BTFAIL1
	JMP	MONINIT
BPROC	ENDP


DUMMY	PROC	FAR
	RET
DUMMY	ENDP

PROG	ENDS


DATA	SEGMENT	WORD PUBLIC 'DATA'
	EXTRN	DDFLG:BYTE
	EXTRN	DDB:BYTE, MEDCNT:BYTE, FLPMEDS:BYTE
	EXTRN	GIFDICTABLE:WORD, GIFDICJMP:WORD, XBICTAB:BYTE
	EXTRN	DGFTAB:WORD, DSFTAB:WORD
	EXTRN	BOOTDRV:BYTE, DRIVLOG:WORD, MAXDRV:BYTE,PGRP:WORD
	EXTRN	MEMEND:WORD,OSNR:BYTE,DELTAB:WORD
DATA	ENDS


	END
