	page	60,132
TITLE INITIAL I/O INTERFACE FOR UNIX

	include	gifmac.mac
	include	xinstr.mac
	.lall				; list macro expansion

PGROUP	GROUP	PROG

debug	equ	1			; option unix/debug io


stmmcpu segment at 0b000h
stmrf	equ	0bbh			; register file access
	org	0fffeh
stmmcpu0 dw ?
stmmcpu ends

mmcpu segment at 4000h
mmcrf	equ	043h			; register file access
	org	0
ssp0	dw ?
ssp1	dw ?
pc0	dw ?
pc1	dw ?
mmcpu ends

mailbox segment at 4000h
mailrf	equ	043h			; register file access
	org	03f0h
keyin	db ?
	org	03feh
crtout	db ?
	org	03ffh
flags	db ?				; bit 0 = output, bit 1 = input
		; CRB progress flags
	org	0400h
start	db ?		; unix, active = 1, start request
busy	db ?		; syscon, active = 0, request in progress
done	db ?		; syscon, active = 1, request complete
ready	db ?		; unix, active = 0, acknowledge completion
status	db ?		; syscon, active = 1, status report on task
gotst	db ?		; unix, active = 0, status received
abort	db ?		; unix, active = 1, abort task
aborted	db ?		; syscon, active = 0, aborted task
		; CSB starts
	org	0408h
devno	db ?		; device number
devtyp	db ?		; major device type ( 0 = tty, 1 = disc, 2 = rtc
device	dw ?		; device description
maxrq	db ?		; max simultanious requests
nowrq	db ?		; current request count
secsize	dw ?		; physical sector size
sizmsw	dw ?		; msb of last sector
sizlsw	dw ?		; last sector number
sectrk	dw ?		; sectors per track
headno	dw ?		; number of heads
	org	041ch
errcod	dw ?		; error status code
	dw ?		; spare error status
	org	0420h
			; CRB starts
rdevno	db ?		; request on device number
rdevtyp	db ?		; request on major device type
comand	dw ?		; operation code
rqcount	dw ?		; request count
com1	dw ?		; 1st parameter
com2	dw ?		; 2nd parameter
com3	dw ?		; 3rd parameter
com4	dw ?		; 4th parameter
com5	dw ?		; 5th parameter
com6	dw ?		; 6th parameter
	dw ?
	dw ?


mailbox	ends


		; my equates for the interface

unix_drive	equ	3		; use drive D:

unix_start	equ	0800h		; starting address
unix_stack	equ	0800h		; initial stack pointer

rfport	equ	0e204h			; access to register file
drfport	equ	0e204h			; access to dma r file

cr	equ	0dh
lf	equ	0ah
etx	equ	04h

exit	equ	4c00h
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	assume cs:pgroup

begin:			; set up stack
	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke
;
;
	xor	cx,cx
	int	99h			; link up to gifdic
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
;
;
	mov	al,unix_drive
	gifcall dskdev,reset,0		; reset the hard disk
;
;
	mov	dx,rfport		; register file port
	mov	al,mmcrf		; start of mmcpu
	out	dx,al			; set it up
	mov	ax,seg mmcpu		; access address
	mov	ds,ax
	assume	ds:mmcpu

	mov	cl,8			; for swap
	mov	ssp0,0			; initial stack pointer upper
	mov	ssp1,unix_stack		; initial stack
	ror	ssp1,cl			; swap
	mov	pc0,0			; initial code start upper
	mov	pc1,unix_start		; initial code start
	ror	pc1,cl			; swap


	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	assume	ds:mailbox

	xor	ax,ax			; zero ax
	mov	bx,ax
	dec	bx			; 0ffffh in bx
	mov	flags,al
	mov	start,al
	mov	busy,bl
	mov	done,al
	mov	ready,bl
	mov	status,al		; clear all flags
	mov	gotst,bl
	mov	abort,al
	mov	aborted,bl

	mov	devno,1
	mov	devtyp,1
	mov	device,0
	mov	maxrq,1
	mov	nowrq,0
	mov	secsize,512
	ror	secsize,cl		; swap
	mov	sizmsw,0
	mov	sizlsw,088aah
	ror	sizlsw,cl		; swap
	mov	sectrk,11
	ror	sectrk,cl
	mov	headno,6
	ror	headno,cl		; swap
	mov	errcod,0
					; all mailbox set up.


	push	cs
	pop	es
	mov	di,offset signon	; say hello to the folks
	call	ptext


	mov	dx,rfport		; start up the 68k cpu
	mov 	al,stmrf
	out	dx,al
	mov	ax,seg stmmcpu
	mov	ds,ax
	assume	ds:stmmcpu
	mov	ax,stmmcpu0


domailbox:			; check round the mailboxes

	if	debug

	mov	dx,rfport		; register file port
	mov	al,4dh
	out	dx,al			; set it up
	mov	ax,0a000h
	mov	ds,ax


	test	byte ptr ds:1000h,01
	jz	checkin

	mov	al,ds:1004h
	push	ds
	gifcall	kvddev,write,noopt
	pop	ds
	jc	checkin			; if busy, leave it till later

	and	byte ptr ds:1000h,0feh

checkin:
	test	byte ptr ds:1001h,01h
	jnz	checkdisk

	push	ds
	gifcall	kvddev,read,noopt	; read if available
	pop	ds
	jc	checkdisk

	cmp	al,03h			; ^C ??
	jne	noabort
	mov	ax,exit
	int	21h

noabort:
	mov	ds:1002h,al
	or	byte ptr ds:1001h,01h

	else

	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	assume	ds:mailbox


	test	flags,01h		; any output ?
	jz	checkin

	mov	al,crtout
	push	ds
	gifcall	kvddev,write,noopt
	pop	ds
	jc	checkin			; if busy, leave it till later

	and	flags,0feh		; clear output flag

checkin:
	test	flags,02h		; input empty?
	jnz	checkdisk

	push	ds
	gifcall	kvddev,read,noopt	; read if available
	pop	ds
	jc	checkdisk

	cmp	al,03			; ^C = abort
	jne	nabort
	mov	ax,exit
	int	21h
nabort:
	mov	keyin,al		; set up byte
	or	flags,02h		; tell unix

	endif

checkdisk:

	if	debug

	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax

	assume	ds:mailbox
	
	endif

	mov	al,ready		; 0 if no activity
	and	done,al			; then clear any at idle
	mov	al,start		; get any
	and	al,busy			; not yet started
	jz	domailbox		; do nothing

	cmp	al,1			; only valid CRB
	jz	goodcrb

	mov	di,offset badcrb
	call	ptext
	jmp	domailbox

goodcrb:
	xor	busy,al			; flag action
	push	ax			; save bit


	cmp	rdevno,1		; good device?
	je	goodev
	jmp	baddev
goodev:
	cmp	rdevtyp,1		; good type
	je	goodtype
	jmp	badtype
goodtype:
	mov	ax,comand
	mov	cx,8
	ror	ax,cl
	and	ax,7fffh		; mask flush bit
	mov	ax,comand
	cmp	al,01h
	je	goodcom1
	jmp	badcomand
goodcom1:
	and	ah,7fh
	cmp	ah,01
	je	goodcom2
	cmp	ah,02
	je	goodcom2
	jmp	badcomand
goodcom2:
	cmp	com1,0			; upper sector
	je	goodsect1
	jmp	badsect
goodsect1:
	mov	ax,com2			; lower sector
	ror	ax,cl
	mov	bx,sizlsw
	ror	bx,cl
	cmp	bx,ax
	jnc	goodsect2
	jmp	badsect
goodsect2:

	mov	ax,com4			; get upper address
	ror	ax,cl
	add	ax,40h			; start address offset on vme
	and	ax,00f8h		; upper 5 bits
	mov	bx,com6			; vme code
	ror	bx,cl
	and	bx,0007h		; valid bits
	or	ax,bx			; data for rf in al
	mov	bx,com4			; upper data
	ror	bx,cl
	mov	dx,com5			; lower dma
	ror	dx,cl
	mov	cx,4
	shr	dx,cl			; reduce to segment size
	shl	bx,cl			; bits up in bl
	or	dh,bl
	and	dx,7fffh		; clear msb
	add	dx,4000h		; last move
	mov	es,dx			; got it in seg reg
	mov	di,com5
	mov	cx,8
	ror	di,cl
	and	di,0fh			; offset
	mov	bx,com3			; sector count
	ror	bx,cl
	push	bx
	mov	bx,com2			; start sector number
	ror	bx,cl
	pop	cx

		; nb no check on dma across boundary


	test	comand,0200h		; write ?
	jne	diskwrite

	mov	dx,drfport		; dma rf port
	out	dx,al			; set up rf
	mov	dx,bx			; use this start address
	mov	al,3			; drive 3 (d:)
	gifcall	dskdev,read,noopt	; do it
	jmp	errorexit		; do exit


diskwrite:
	mov	dx,rfport		; share port with mbox
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	gifcall	dskdev,write,noopt	; do it


errorexit:
	pushf
	push	ax			; save end status

	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	assume	ds:mailbox

	pop	ax
	popf				; restore exit status
	mov	al,0			; not valid status in al
	mov	errcod,ax		; send it
	; jnc	discexit		; if error, should do status
					; abort.

discexit:
	pop	ax			; recover bit
	xor	done,al			; flag completion
	xor	busy,al			; clear activity

	if	debug
	mov	start,0
	endif

	jmp	domailbox


badcomand:
	mov	di,offset comerr
	jmp	perr
badsect:
	mov	di,offset secerr
	jmp	perr
baddev:
	mov	di,offset deverr
	jmp	perr
badtype:
	mov	di,offset typerr

perr:
	call	ptext
	mov	ah,01h
	stc
	jmp	errorexit



ptext:		; print all characters from es:di to 04h ( etx )
	push	cs
	pop	es			; messages are in cs
	jmp	ptext1			; starting point
printone:
	push	es
	push	di
	gifcall	kvddev,write,waitnr	; print 1, no return till done
	pop	di
	pop	es
ptext1:
	mov	al,es:[di]		; get character
	inc	di			; next
	cmp	al,etx
	jne	printone		; output one
	ret


signon:	db	lf,lf,cr,'1st level UNIX I/O System',cr,lf
	db	'Starting UNIX now.',lf,cr,etx

badcrb:	db	cr,lf,'Illegal CRB requested !',cr,lf,etx

comerr:	db	cr,lf,'Bad disc command.',cr,lf,etx
secerr:	db	cr,lf,'Bad disc sector.',cr,lf,etx
deverr:	db	cr,lf,'Bad disc device.',cr,lf,etx
typerr:	db	cr,lf,'Bad disc type.',cr,lf,etx


;
gifdic	label	dword
gifl	dw	?
gifh	dw	?
;

		; space for system stack

	dw	80h dup (?)
STACKE:

PROG	ENDS

	end	begin		; program start address

	




n

	page	60,132
TITLE INITIAL I/O INTERFACE FOR UNIX

	include	gifmac.mac
	include	xinstr.mac
	.lall				; list macro expansion

PGROUP	GROUP	PROG

stmmcpu segment at 0b000h
stmrf	equ	0bbh			; register file access
	org	0fffeh
stmmcpu0 dw ?
stmmcpu ends

mmcpu segment at 4000h
mmcrf	equ	043h			; register file access
	org	0
ssp0	dw ?
ssp1	dw ?
pc0	dw ?
pc1	dw ?
mmcpu ends

mailbox segment at 4000h
mailrf	equ	043h			; register file access
	org	03f0h
keyin	db ?
	org	03feh
crtout	db ?
	org	03ffh
flags	db ?				; bit 0 = output, bit 1 = input
		; CRB progress flags
	org	0400h
start	db ?		; unix, active = 1, start request
busy	db ?		; syscon, active = 0, request in progress
done	db ?		; syscon, active = 1, request complete
ready	db ?		; unix, active = 0, acknowledge completion
status	db ?		; syscon, active = 1, status report on task
gotst	db ?		; unix, active = 0, status received
abort	db ?		; unix, active = 1, abort task
aborted	db ?		; syscon, active = 0, aborted task
		; CSB starts
	org	0408h
devno	db ?		; device number
devtyp	db ?		; major device type ( 0 = tty, 1 = disc, 2 = rtc
ldevice	db ?		; device description
udevice	db ?		; device description
maxrq	db ?		; max simultanious requests
nowrq	db ?		; current request count
lsecsize	db ?		; physical sector size
usecsize	db ?		; physical sector size
sizb3	db ?
sizb4	db ?		; last sector number
sizb1	db ?
sizb2	db ?
sectrk	db ?		; sectors per track
	db ?
headno	db ?		; number of heads
	db ?
	org	041ch
errcod	db ?		; error status code
	db ?		; spare error status
	db ?
	db ?
	org	0420h
			; CRB starts
rdevno	db ?		; request on device number
rdevtyp	db ?		; request on major device type
comtyp	db ?		; device command type
comand	db ?		; operation code
rqcount	dw ?		; request count
com1	db ?		; 1st parameter
com2	db ?		; 2nd parameter
com3	db ?		; 3rd parameter
com4	db ?		; 4th parameter
com5	db ?		; 5th parameter
com6	db ?		; 6th parameter
com7	db ?
com8	db ?
com9	db ?
com10	db ?
com11	db ?
com12	db ?
com13	db ?
com14	db ?
com15	db ?
com16	db ?


mailbox	ends


		; my equates for the interface

unix_drive	equ	3		; use drive D:

unix_start	equ	0800h		; starting address
unix_stack	equ	0800h		; initial stack pointer

rfport	equ	0e204h			; access to register file
drfport	equ	0e204h			; access to dma r file

cr	equ	0dh
lf	equ	0ah
etx	equ	04h
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	assume cs:pgroup

begin:			; set up stack
	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke
;
;
	xor	cx,cx
	int	99h			; link up to gifdic
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
;
;
	mov	al,unix_drive
	gifcall dskdev,reset,0		; reset the hard disk
;
;
	mov	dx,rfport		; register file port
	mov	al,mmcrf		; start of mmcpu
	out	dx,al			; set it up
	mov	ax,seg mmcpu		; access address
	mov	ds,ax
	assume	ds:mmcpu

	mov	ssp0,0			; initial stack pointer upper
	mov	ssp1,unix_stack		; initial stack
	mov	pc0,0			; initial code start upper
	mov	pc1,unix_start		; initial code start


	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	assume	ds:mailbox

	xor	ax,ax			; zero ax
	mov	bx,ax
	dec	bx			; 0ffffh in bx
	mov	flags,al
	mov	start,al
	mov	busy,bl
	mov	done,al
	mov	ready,bl
	mov	status,al		; clear all flags
	mov	gotst,bl
	mov	abort,al
	mov	aborted,bl

	mov	devno,1
	mov	devtyp,1
	mov	device,0
	mov	maxrq,1
	mov	nowrq,0
	mov	secsize,512
	mov	sizmsw,0
	mov	sizlsw,088aah
	mov	sectrk,11
	mov	headno,6
	mov	errcod,0
					; all mailbox set up.


	push	cs
	pop	es
	mov	di,offset signon	; say hello to the folks
	call	ptext


	mov	dx,rfport		; start up the 68k cpu
	mov 	al,stmrf
	out	dx,al
	mov	ax,seg stmmcpu
	mov	ds,ax
	assume	ds:stmmcpu
	mov	ax,stmmcpu0


domailbox:			; check round the mailboxes
	mov	dx,rfport		; register file port
	mov	al,4dh
	out	dx,al			; set it up
	mov	ax,0a000h
	mov	ds,ax


	test	byte ptr ds:1000h,01
	jz	checkin

	mov	al,ds:1004h
	push	ds
	gifcall	kvddev,write,noopt
	pop	ds
	jc	checkin			; if busy, leave it till later

	and	byte ptr ds:1000h,0feh

checkin:
	test	byte ptr ds:1001h,01h
	jnz	checkdisk

	push	ds
	gifcall	kvddev,read,noopt	; read if available
	pop	ds
	jc	checkdisk

	mov	ds:1002h,al
	or	byte ptr ds:1001h,01h

checkdisk:
	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	assume	ds:mailbox

	mov	al,ready		; 0 if no activity
	and	done,al			; then clear any at idle
	mov	al,start		; get any
	and	al,busy			; not yet started
	jz	domailbox		; do nothing

	cmp	al,1			; only valid CRB
	jz	goodcrb

	mov	di,offset badcrb
	call	ptext
	jmp	domailbox

goodcrb:
	xor	busy,al			; flag action
	push	ax			; save bit


	cmp	rdevno,1		; good device?
	je	goodev
	jmp	baddev
goodev:
	cmp	rdevtyp,1		; good type
	je	goodtype
	jmp	badtype
goodtype:
	cmp	comand,101h		; read
	jnc	goodcom1
	jmp	badcomand
goodcom1:
	cmp	comand,103h		; write + 1
	jc	goodcom2
	jmp	badcomand
goodcom2:
	cmp	com1,0			; upper sector
	je	goodsect1
	jmp	badsect
goodsect1:
	mov	ax,com2			; lower sector
	cmp	sizlsw,ax		; compare max
	jnc	goodsect2
	jmp	badsect
goodsect2:

	mov	ax,com4			; get upper address
	and	ax,00f8h		; upper 5 bits
	mov	bx,com6			; vme code
	and	bx,0007h		; valid bits
	or	ax,bx			; data for rf in al
	add	al,40h			; adjust for offset
	mov	bx,com4			; upper data
	mov	dx,com4			; lower dma
	mov	cx,4
	shr	dx,cl			; reduce to segment size
	shl	bx,cl			; bits up in bl
	or	dh,bl
	and	dx,7fffh		; clear msb
	add	dx,4000h		; last move
	mov	es,dx			; got it in seg reg
	mov	di,com5
	and	di,0fh			; offset
	mov	bx,com2			; start sector number
	mov	cx,com3			; sector count

		; nb no check on dma across boundary


	cmp	comand,0101h		; read ??
	jne	diskwrite

	mov	dx,drfport		; dma rf port
	out	dx,al			; set up rf
	mov	dx,bx			; use this start address
	mov	al,3			; drive 3 (d:)
	gifcall	dskdev,read,noopt	; do it
	jmp	errorexit		; do exit


diskwrite:
	mov	dx,rfport		; share port with mbox
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	gifcall	dskdev,write,noopt	; do it


errorexit:
	pushf
	push	ax			; save end status

	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	assume	ds:mailbox

	pop	ax
	popf				; restore exit status
	mov	al,0			; not valid status in al
	mov	errcod,ax		; send it
	; jnc	discexit		; if error, should do status
					; abort.

discexit:
	pop	ax			; recover bit
	mov	start,0		; *********** temp for test
	xor	done,al			; flag completion
	xor	busy,al			; clear activity
	jmp	domailbox


badcomand:
	mov	di,offset comerr
	jmp	perr
badsect:
	mov	di,offset secerr
	jmp	perr
baddev:
	mov	di,offset deverr
	jmp	perr
badtype:
	mov	di,offset typerr

perr:
	call	ptext
	mov	ah,01h
	stc
	jmp	errorexit



ptext:		; print all characters from es:di to 04h ( etx )
	push	cs
	pop	es			; messages are in cs
	jmp	ptext1			; starting point
printone:
	push	es
	push	di
	gifcall	kvddev,write,waitnr	; print 1, no return till done
	pop	di
	pop	es
ptext1:
	mov	al,es:[di]		; get character
	inc	di			; next
	cmp	al,etx
	jne	printone		; output one
	ret


signon:	db	lf,lf,cr,'1st level UNIX I/O System',cr,lf
	db	'Starting UNIX now.',lf,cr,etx

badcrb:	db	cr,lf,'Illegal CRB requested !',cr,lf,etx

comerr:	db	cr,lf,'Bad disc command.',cr,lf,etx
secerr:	db	cr,lf,'Bad disc sector.',cr,lf,etx
deverr:	db	cr,lf,'Bad disc device.',cr,lf,etx
typerr:	db	cr,lf,'Bad disc type.',cr,lf,etx


;
gifdic	label	dword
gifl	dw	?
gifh	dw	?
;

		; space for system stack

	dw	80h dup (?)
STACKE:

PROG	ENDS

	end	begin		; program start address

c

d

