TITLE MMCPU 68000 DEBUGGER

openfile equ 3dh
readfile equ 3fh
closfile equ 3eh
read equ 0
prtmsg	equ 9
exit equ 4c00h
cr	equ 0dh
lf	equ 0ah

prom segment at 0fc80h
	org	1e20h
rdkb label far
	org	1e45h
wrscrn label far
prom ends

stmmcpu segment at 0b000h
	org	0fffeh
stmmcpu0 dw ?
stmmcpu ends

mmcpu segment at 04000h
	org	3feh
crtdat	db ?
	org	3ffh
flags   db ?
	org	3fch
kbddat  db ?
	org	3f0h
wrtprt	db ?
mmcpu ends

code segment
	assume cs:code

start:
	push	cs
	pop	ds
	lea	dx, filename
	mov	al, read
	mov	ah, openfile
	int	21h
	jc	festage
; File opened
	mov	bx, ax
	lea	dx, wtmsg
	mov	ah, prtmsg
	int	21h

savefile:
	mov	dx, 204h
	mov	ax, 43h
	out	dx, al
	mov	ax, 4000h
	mov	ds, ax
	mov	es, ax
	mov	cx, 0a000h
	mov	dx, 0
	mov	ah, readfile
	int	21h
festage:
	jc	filerr
	mov	ah, closfile
	int	21h
	jc	filerr

	mov	dx, 204h
	mov 	ax, 0bbh
	out	dx, al
	mov	ax, seg stmmcpu
	mov	ds, ax
	assume	ds:stmmcpu
	mov	ax, stmmcpu0
	call	sendmes
	mov	ax, seg mmcpu
	mov	ds, ax
	assume	ds:mmcpu

	mov	dx, 204h
	mov	ax, 43h
	out	dx, al
rdwait:
;	mov	wrtprt,al
	test	flags, 1
	jz	wrtwait
	mov	al, crtdat
	and	flags, 0feh
	push	ax
	push	bx
	push	cx
	call	wrscrn
	pop	cx
	pop	bx
	pop	ax
;	jmp	rdwait
wrtwait:
	test	flags, 2
	jne	rdwait
	mov	ah, 6
	mov	dl, 0ffh
	int	21h
	jz	rdwait
	cmp	al, 3
	je	ending
	mov	kbddat, al
	or	flags, 02h
	mov	ax, 0
	jmp	rdwait

ending:
	mov	ax, exit
	int	21h


filerr:
	lea	dx, filerrmsg
	mov	ah, prtmsg
	int	21h
	jmp	ending
sendmes:
	push	ds
	push	dx
	push	cs
	pop	ds
	lea	dx, okmsg
	mov	ah, prtmsg
	int	21h
	pop	dx
	pop	ds
	ret


filename db 'A:\68KASM\DEBUG.BIN',0
filerrmsg db 'FILE ERROR!', cr, lf, '$'
wtmsg db '68000 DEBUGGER.', cr, lf, 'Loading on MMCPU at offset 0.$'
okmsg db cr, lf, 'DEBUGGER LOADED$'

code ends

stack segment stack
	dw	80 dup (?)
stack ends

end start
