	PAGE	60,80
TITLE	INITIAL	I/O INTERFACE FOR UNIX


	INCLUDE	GIFDIC.MAC
	INCLUDE	80186.MAC

NEW_68K	EQU	0			; USING NEW BOARD
LOW_DEBUG EQU	1			; NOT CRB MESSAGES
WRITE_PROTECT EQU 0			; NO WRITES FOR TESTS
USE_BOOT EQU	1			; LOAD IN BOOT

	.LALL

;**********************************************************
;
;	MAILBOX DATA STRUCTURES
;
;**********************************************************


;**********************************************************
;
;	CHANNEL STATUS BLOCKS
;
;**********************************************************

CSB	STRUC				; MAIN PART OF CSB

DEVNO	DB	?			; DEVICE NUMBER
DEVTYP	DB	?			; MAJOR DEVICE TYPE ( 0 = TTY, 1 = DISK, 2 = RTC )
DEVICE	DW	?			; DEVICE DESCRIPTION
MAXRQ	DB	?			; MAX SIMULTANIOUS REQUESTS
NOWRQ	DB	?			; CURRENT REQUEST COUNT

	DW	13 DUP (?)

CSB	ENDS


	PAGE
;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  SYSTEM DEVICE
;
;**********************************************************

CSB_SYS	STRUC

	DB	?			; CSB NUMBER ( DEVICE NUMBER )
	DB	?			; DEVICE TYPE
	DW	?			; DEVICE DESCRIPTION
	DB	?			; REQUEST MAX
	DB	?			; CURRENT REQUEST COUNT

RAMMSW	DW	?			; UPPER RAM SIZE
RAMLSW	DW	?			; LOWER RAM SIZE
	DW	11 DUP (?)

CSB_SYS	ENDS


;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  DISK DEVICES
;
;**********************************************************


CSB_DISK STRUC

	DB	?			; CSB NUMBER ( DEVICE NUMBER )
	DB	?			; DEVICE TYPE
	DW	?			; DEVICE DESCRIPTION
	DB	?			; REQUEST MAX
	DB	?			; CURRENT REQUEST COUNT

SECSIZE	DW	?			; PHYSICAL SECTOR SIZE
SIZMSW	DW	?			; MSB OF LAST SECTOR
SIZLSW	DW	?			; LAST SECTOR NUMBER
SECTRK	DW	?			; SECTORS PER TRACK
HEADNO	DW	?			; NUMBER OF HEADS
	DW	2 DUP (?)
ERRDSK	DW	?			; ERROR STATUS CODE
	DW	?			; SPARE ERROR STATUS

	DW	4 DUP (?)

CSB_DISK ENDS


	PAGE
;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  REAL TIME CLOCK
;
;**********************************************************

CSB_RTC	STRUC

	DB	?			; CSB NUMBER ( DEVICE NUMBER )
	DB	?			; DEVICE TYPE
	DW	?			; DEVICE DESCRIPTION
	DB	?			; REQUEST MAX
	DB	?			; CURRENT REQUEST COUNT

TIMMSW	DW	?			; TIME MSB
TIMLSW	DW	?			; TIME LSB
	DW	5 DUP (?)		; SPARE
ERRRTC	DW	?
	DW	?			; ERROR FIELDS
	DW	4 DUP(?)

CSB_RTC	ENDS


;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  CHARACTER DEVICES
;	CONSOLE, SERIAL PORTS, LINE PRINTER
;
;**********************************************************

CSB_TTY	STRUC

	DB	?			; CSB NUMBER ( DEVICE NUMBER )
	DB	?			; DEVICE TYPE
	DW	?			; DEVICE DESCRIPTION
	DB	?			; REQUEST MAX
	DB	?			; CURRENT REQUEST COUNT

STATTY	DW	?			; TTY STATUS BIT FLAGS
	DW	6 DUP (?)		; SPARE
ERRTTY	DW	?			; ERROR CODES
	DW	?

	DW	4 DUP (?)

CSB_TTY	ENDS


	PAGE
;**********************************************************
;
;	CHANNEL REQUEST BLOCKS
;
;**********************************************************

;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; SYSTEM DEVICE
;
;**********************************************************

CRB	STRUC

RDEVNO	DB	?			; REQUEST ON DEVICE NUMBER
RDEVTYP	DB	?			; REQUEST ON MAJOR DEVICE TYPE
COMAND	DW	?			; OPERATION CODE
RQCOUNT	DW	?			; REQUEST COUNT

	DW	13 DUP (?)

CRB	ENDS

;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; SYSTEM DEVICE
;
;**********************************************************

CRB_SYS	STRUC

	DB	?			; DEVICE NUMBER
	DB	?			; DEVICE TYPE
	DW	?			; COMMAND CODE
	DW	?			; REQUEST COUNT

CRB_SYS	ENDS


	PAGE
;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; DISK DEVICE
;
;**********************************************************

CRB_DISK STRUC

	DB	?			; DEVICE NUMBER
	DB	?			; DEVICE TYPE
	DW	?			; COMMAND CODE
	DW	?			; REQUEST COUNT

SECNUP	DW	?			; UPPER SECTOR NUMBER
SECNLO	DW	?			; DOWN SECTOR NUMBER
SECOUNT	DW	?			; SECTOR COUNT
DMAMSW	DW	?			; DMA UPPER ADDRESS
DMALSW	DW	?			; DMA LOWER ADDRESS
DMAVME	DW	?			; VME ACCESS CODE
LASUP	DW	?			; LOOK AHEAD SECTOR NUMBER UPPER
LASLO	DW	?			; LOOK AHEAD SECTOR NUMBER LOWER
LASIZE	DW	?			; LOOK AHEAD SIZE

	DW	4 DUP (?)

CRB_DISK ENDS


;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; REAL TIME CLOCK
;
;**********************************************************

CRB_RTC	STRUC

	DB	?			; DEVICE NUMBER
	DB	?			; DEVICE TYPE
	DW	?			; COMMAND CODE
	DW	?			; REQUEST COUNT

TIMEUP	DW	?			; TIME UPPER WORD
TIMELO	DW	?			; TIME LOWER WORD

	DW	11 DUP (?)

CRB_RTC	ENDS


	PAGE
;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; CHARACTER DEVICES
;
;**********************************************************

CRB_TTY	STRUC

	DB	?			; DEVICE NUMBER
	DB	?			; DEVICE TYPE
	DW	?			; COMMAND CODE
	DW	?			; REQUEST COUNT

INPTR	DW	?			; INPUT POINTER
; BIT 0=1 : ENABLE DTR
; BIT 1,2 : NO STOP
;	  : 1 STOP
;	  : 1.5 STOP
;	  : 2 STOP
; BIT 3=1 : OUTPUT HALT XOFF
; BIT 4=1 : OUTPUT HALT XANY
; BIT 5=1 : INPUT HALT XOFF
; BIT 6=1 : SEND BREAK
; BIT 7,8 : 5 BIT DATA
;	  : 6 BIT DATA
;	  : 7 BIT DATA
;         : 8 BIT DATA
; BIT 9=1 : STRIP BIT 8
; BIT A=1 : ENABLE PARITY (I/O)
; BIT B=1 : ODD PARITY (I/O)
OUTPTR	DW	?			; OUTPUT POINTER
; VALUE 0 : NOT VALID
; VALUE 1 : 50 BAUD
; VALUE 2 : 75 BAUD
; VALUE 3 : 110 BAUD
; VALUE 4 : 134.5 BAUD
; VALUE 5 : 150 BAUD
; VALUE 6 : 200 BAUD
; VALUE 7 : 300 BAUD
; VALUE 8 : 600 BAUD
; VALUE 9 : 1200 BAUD
; VALUE A : 1800 BAUD
; VALUE B : 2400 BAUD
; VALUE C : 4800 BAUD
; VALUE D : 9600 BAUD
; VALUE E : 19200 BAUD
; VALUE F : EXTERNAL CLOCK
COUNT	DW	?			; SIZE / COUNT
ADDUP	DW	?			; UPPER ADDRESS
ADDLO	DW	?			; LOWER ADDRESS
VMEAX	DW	?			; VME ACCESS CODE

	DW	7 DUP (?)

CRB_TTY	ENDS

;**************************************************
;
;	INTERNAL FIFOS FOR CHARACTER OUTPUT
;
;**************************************************

FIFO	STRUC

INPUT	DW	0
OUTPUT	DW	0
MAXIZE	DW	400H

BUFFER	DB	400H DUP (?)

FIFO	ENDS


	PAGE


;********************************************************
;
;	REAL TIME CLOCK BUFFER
;
;********************************************************

RTC	STRUC

SECONDS	DB	?
MINUTES	DB	?
HOURS	DB	?
DATE	DB	?
MONTH	DB	?
YEAR	DB	?

RTC	ENDS

;*********************************************************
;
;	WORKING DATA AREAS
;
;*********************************************************

PGROUP	GROUP	PROG

	IF	NEW_68K

RAM_68K	EQU	0H			; WAS 40H : UPPER START ADDRESS

STMMCPU	SEGMENT	AT 04000H
STMRF	EQU	05H+RAM_68K		; REGISTER FILE ACCESS
	ORG	00000H
STMMCPU0 DW	?
STMMCPU	ENDS

	ELSE

RAM_68K	EQU	40H			; UPPER START ADDRESS

STMMCPU	SEGMENT	AT 0B000H
STMRF	EQU	0FBH-RAM_68K		; OLD START TECNIQUE
	ORG	0FFFEH
STMMCPU0 DW	?
STMMCPU	ENDS

	ENDIF


MMCPU	SEGMENT	AT 4000H
MMCRF	EQU	003H+RAM_68K
	ORG	0
SSP0	DW	?
SSP1	DW	?
PC0	DW	?
PC1	DW	?
MMCPU	ENDS

	PAGE
MAILBOX	SEGMENT	AT 4000H
MAILRF	EQU	003H+RAM_68K		; REGISTER FILE ACCESS

; CRB PROGRESS FLAGS
	ORG	0400H

STARTX	DW	?
START	DW	?			; UNIX, ACTIVE = 1, START REQUEST

BUSYX	DW	?
BUSY	DW	?			; SYSCON, ACTIVE = 0, REQUEST IN PROGRESS

DONEX	DW	?
DONE	DW	?			; SYSCON, ACTIVE = 1, REQUEST COMPLETE

READYX	DW	?
READY	DW	?			; UNIX, ACTIVE = 0, ACKNOWLEDGE COMPLETION

STATUSX	DW	?
STATUS	DW	?			; SYSCON, ACTIVE = 1, STATUS REPORT ON TASK

GOTSTX	DW	?
GOTST	DW	?			; UNIX, ACTIVE = 0, STATUS RECEIVED

ABORTX	DW	?
ABORT	DW	?			; UNIX, ACTIVE = 1, ABORT TASK

DUNABX	DW	?
DUNAB	DW	?			; SYSCON, ACTIVE = 0, ABORTED TASK


	PAGE
; CSB STARTS

	ORG	0420H

CSB0	CSB_SYS	<>			; SYSTEM DEVICE

CSB1	CSB_DISK <>			; DISK 1

CSB2	CSB_DISK <>			; DISK 2

CSB3	CSB_DISK <>			; DISK 3

CSB4	CSB_DISK <>			; DISK 4

CSB5	CSB_DISK <>			; DISK 5

CSB6	CSB_DISK <>			; DISK 6

CSB7	CSB_RTC	<>			; RTC

CSB8	CSB_TTY	<>			; CONSOLE

CSB9	CSB_TTY	<>			; PRINTER

CSB10	CSB_TTY	<>			; DTE

CSB11	CSB_TTY	<>			; DCE

CSB12	CSB_TTY	<>			; SPARE

CSB13	CSB_TTY	<>			; SPARE

CSB14	CSB_TTY	<>			; SPARE

CSB15	CSB_TTY	<>			; SPARE

	PAGE
	ORG	0620H
; START OF CRBS

CRB0	CRB	<>
CRB1	CRB	<>
CRB2	CRB	<>
CRB3	CRB	<>
CRB4	CRB	<>
CRB5	CRB	<>
CRB6	CRB	<>
CRB7	CRB	<>
CRB8	CRB	<>
CRB9	CRB	<>
CRB10	CRB	<>
CRB11	CRB	<>
CRB12	CRB	<>
CRB13	CRB	<>
CRB14	CRB	<>
CRB15	CRB	<>
CRB16	CRB	<>
CRB17	CRB	<>
CRB18	CRB	<>
CRB19	CRB	<>
CRB20	CRB	<>
CRB21	CRB	<>
CRB22	CRB	<>
CRB23	CRB	<>


	ORG	0900H

BYTEIN	DB	?
BYTOUT	DB	?			; OUTPUT BYTE
FLAGIN	DB	?
FLAGOUT	DB	?			; BIT 0 = OUTPUT

SAVE	DW	?			; SAVE PENDING OPS
SAVEX	DW	?			; PENDX

TESTFLG1 DB	?
TESTFLG2 DB	?
TESTFLG3 DB	?
TESTFLG4 DB	?
TESTFLG5 DB	?
TESTFLG6 DB	?
TESTFLG7 DB	?
TESTFLG8 DB	?

TOCK	DB	?			; UNIX TICK TOCK

MAILBOX	ENDS

	PAGE

UNIX_DRIVE EQU	3			; USE DRIVE D:

	IF	USE_BOOT

STACK_UP EQU	0000H
STACK_LO EQU	1000H
PROG_UP	EQU	0005H
PROG_LO	EQU	0000H

	ELSE

STACK_UP EQU	0000H
STACK_LO EQU	1000H
PROG_UP	EQU	0000H
PROG_LO	EQU	1000H

	ENDIF

RFPORT	EQU	0E204H			; ACCESS TO REGISTER FILE
RFDMA	EQU	0E206H			; ACCESS TO DMA R FILE

CR	EQU	0DH
LF	EQU	0AH
ETX	EQU	04H

EXIT	EQU	4C00H

CRB_SIZE EQU	32			; SIZE OF ONE CRB
CRBMAX	EQU	7
;
DISK1	EQU	3			; D = UNIX DISK 1
DISK2	EQU	1			; B = UNIX DISK 2
DISK3	EQU	2			; NEXT DISK FOR UNIX
DISK6	EQU	2			; C = UNIX DISK 6


	PAGE
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP

BEGIN:					; SET UP STACK
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET PGROUP:STACKE

	MOV	CS:SYS_FLAG,0		; SET DEBUG PRINT OFF

	CALL	TEST_BOOT		; COLD / WARM START
	TEST	BYTE PTR CS:REBOOT,0FFH	; COLD
	JNZ	WBOOT1

	MOV	DX,RFPORT		; REGISTER FILE PORT
	MOV	AL,MMCRF		; MAILBOX ACCESS
	ADD	AL,08H			; UPPER PARAGRAPH
	OUT	DX,AL			; SET IT UP
	MOV	AX,SEG MMCPU		; ACCESS ADDRESS
	MOV	DS,AX

	CALL	CLEAR_RAM

	MOV	DX,RFPORT		; REGISTER FILE PORT
	MOV	AL,MMCRF		; MAILBOX ACCESS
	OUT	DX,AL			; SET IT UP
	MOV	AX,SEG MMCPU		; ACCESS ADDRESS
	MOV	DS,AX
	ASSUME	DS:MMCPU

	CALL	CLEAR_RAM

RESTART:

	PUSH	CS
	POP	SS
	MOV	SP,OFFSET PGROUP:STACKE

	MOV	BYTE PTR CS:REBOOT,0

	CALL	SET_MAIL

	PUTI	SSP0,STACK_UP		; UPPER STACK POINTER
	PUTI	SSP1,STACK_LO		; LOWER STACK POINTER
	PUTI	PC0,PROG_UP		; UPPER PC
	PUTI	PC1,PROG_LO		; LOWER PC


	MOV	AX,CS
	SUB	AX,10H			; RIGHT DS
	MOV	DS,AX			; SEGMENT FOR FILE
;
	IF	USE_BOOT
	CALL	GET_BOOT		; READ IN BOOT FILE
	ENDIF
WBOOT1:

	XOR	CX,CX
	INT	99H			; LINK UP TO GIFDIC
	MOV	AX,ES:[DI.GHNDLR]
	MOV	CS:GIFL,AX
	MOV	AX,ES:[DI.SPGROUP]
	MOV	CS:GIFH,AX
;

;

	MOV	AL,00
	GIFCALL	DSKDEV,RESET,NOOPT
	MOV	AL,01
	GIFCALL	DSKDEV,RESET,NOOPT
	MOV	AL,02
	GIFCALL	DSKDEV,RESET,NOOPT
	MOV	AL,03
	GIFCALL	DSKDEV,RESET,NOOPT
;
	PAGE

	TEST	BYTE PTR CS:REBOOT,0FFH
	JNZ	WBOOT2
;


	CALL	SET_MAIL		; POINT TO MAILBOXES
	ASSUME	DS:MAILBOX

	MOV	DI,OFFSET MAILBOX:STARTX
	MOV	SI,OFFSET CS:MAIL_COPY
	MOV	CX,(1000H-400H)/2

	PUSH	DS
	POP	ES
	PUSH	CS
	POP	DS			; GET SOURCE FROM CS
MOVE_MBOX:
	MOV	AX,[SI]
	PUT	ES:[DI],AX		; CORRECT FOR 68K
	ADD	SI,2
	ADD	DI,2
	LOOP	MOVE_MBOX		; REPEAT


	PUSH	CS
	POP	ES
	MOV	DI,OFFSET SIGNON	; SAY HELLO TO THE FOLKS
	CALL	PTEXT


	MOV	DX,RFPORT		; START UP THE 68K CPU
	MOV	AL,STMRF
	OUT	DX,AL
	MOV	AX,SEG STMMCPU
	MOV	DS,AX
	ASSUME	DS:STMMCPU
	MOV	AX,STMMCPU0

	MOV	CS:PENDX,0
	MOV	CS:PEND,0		; NO PENDING ACTION

WBOOT2:

	TEST	BYTE PTR CS:REBOOT,0FFH
	JZ	WBOOT3

	CALL	SET_MAIL
	ASSUME	DS:MAILBOX

	MOV	AX,SAVE			; RECOVER PEND
	MOV	BX,SAVEX		; RECOVER PENDX

	AND	AX,0FEFFH		; FORCE NO START, SYS

	MOV	CS:PEND,AX
	MOV	CS:PENDX,AX		; USE THESE

	AND	START,0FEFFH		; FORCE NO START, SYS
	OR	BUSY,0100H		; CLEAR BUSY
	OR	DONE,0100H		; SET DONE



WBOOT3:

DOMAILBOX:				; CHECK ROUND THE MAILBOXES

	CALL	SET_MAIL		; POINT TO MAILBOXES
	ASSUME	DS:MAILBOX

	TEST	FLAGOUT,01H		; ANY OUTPUT ?
	JZ	NO_BYTES
	MOV	AL,BYTOUT		; GET IT
	PUSH	DS
	GIFCALL	KVDDEV,WRITE,NOOPT
	POP	DS
	JC	NO_BYTES
	AND	FLAGOUT,0FEH		; CLEAR FLAG
NO_BYTES:

	TEST	FLAGIN,01H		; INPUT
	JNZ	NO_INBYTE
	PUSH	DS
	GIFCALL	KVDDEV,READ,NOOPT	; READ IT
	POP	DS
	JC	NO_INBYTE
	MOV	DS:BYTEIN,AL
	OR	DS:FLAGIN,01
NO_INBYTE:


	MOV	DI,OFFSET CS:CON_FIFO
	MOV	BX,KVDDEV		; DO CONSOLE FIFO
	CALL	FIFO_OUT

	MOV	DI,OFFSET CS:PRN_FIFO
	MOV	BX,PRTDEV		; DO PRINTER FIFO
	CALL	FIFO_OUT

	MOV	DI,OFFSET CS:DTE_FIFO
	MOV	BX,DTEDEV		; DO DTE FIFO
	CALL	FIFO_OUT

	MOV	DI,OFFSET CS:DCE_FIFO
	MOV	BX,DCEDEV		; DO DCE FIFO
	CALL	FIFO_OUT

;***************************************************
;
;	NOW DO REAL MAILBOXES
;
;****************************************************

	MOV	AX,READY		; 0 IF NO ACTIVITY
	AND	DONE,AX			; THEN CLEAR ANY AT IDLE

	MOV	AX,READYX		; 0 IF NO ACTIVITY
	AND	DONEX,AX		; THEN CLEAR ANY AT IDLE

	MOV	AX,START		; GET ANY
	MOV	BX,CS:PEND		; WAITING FOR NO START
	AND	CS:PEND,AX		; UPDATE PENDING IF NO START
	XOR	BX,CS:PEND		; WHATS NEW
	XOR	BUSY,BX			; CLEAR BUSY
	XOR	DONE,BX			; SET DONE

	NOT	AX
	AND	BUSY,AX			; FORCE BUSY IF START

	MOV	AX,BUSY			; GET IT
	OR	AX,CS:PEND		; ACTION REQUIRED

	SWAP	AX
	XOR	AX,0FFFFH		; INVERT LOGIC
	JZ	DO_OTHER

	MOV	SI,OFFSET MAILBOX:CRB0	; POINT TO FIRST CRB
	MOV	DI,OFFSET CS:PEND	; POINTER
	CALL	DO_THIS_BIT

DO_OTHER:

	MOV	AX,STARTX		; GET ANY
	MOV	BX,CS:PENDX		; WAITING FOR NO START
	AND	CS:PENDX,AX		; UPDATE PENDING IF NO START
	XOR	BX,CS:PENDX		; WHATS NEW
	XOR	BUSYX,BX		; CLEAR BUSY
	XOR	DONEX,BX		; SET DONE

	NOT	AX
	AND	BUSYX,AX		; FORCE BUSY IF START

	MOV	AX,BUSYX		; GET IT
	OR	AX,CS:PENDX		; ACTION REQUIRED

	SWAP	AX
	XOR	AX,0FFFFH		; INVERT LOGIC
	JZ	DONE_OTHER

	MOV	SI,OFFSET MAILBOX:CRB16	; POINT TO NEXT CRBS
	MOV	DI,OFFSET CS:PENDX	; POINTER
	CALL	DO_THIS_BIT
DONE_OTHER:
	JMP	DOMAILBOX


DO_THIS_BIT:
	MOV	BX,1

CHECK_CRB:
	TEST	AX,BX			; THIS CRB ?
	JZ	NOT_THIS
	PUSHA				; SAVE THE STATE
	CALL	DO_CRB			; DO THE CRB
	PUSHF
	CALL	SET_MAIL		; POINT TO MAILBOX AGAIN
	POPF
	POPA				; RESTORE ALL
	JC	NOT_THIS		; NOT FINISHED
	SWAP	BX
	OR	CS:[DI],BX		; FLAG IT DONE
	SWAP	BX
	XOR	AX,BX			; CLEAR THIS BIT
	JNZ	NOT_THIS
	RET				; DONE ALL BITS

NOT_THIS:
	ADD	SI,CRB_SIZE		; POINT TO NEXT
	SHL	BX,1			; NEXT BIT
	JNC	CHECK_CRB		; DO ALL CRBS
	RET				; DONE 16

CRBMES:	DB	'CRB : ',ETX

DO_CRB:

	IF	LOW_DEBUG

	MOV	DI,OFFSET CS:CRBMES
	CALL	PTEXT
	MOV	DI,SI
	MOV	CX,13
PCRB_LOOP:
	MOV	AX,[DI]
	INC	DI
	INC	DI
	PUSH	DI
	PUSH	CX
	PUSH	AX
	CALL	PHEX
	POP	AX
	SWAP	AX
	CALL	PHEX
	CALL	PSPACE
	POP	CX
	POP	DI
	LOOP	PCRB_LOOP
	MOV	DI,OFFSET CS:EOM
	CALL	PTEXT

	ENDIF

	CMP	[SI].RDEVTYP,02		; TTY ??
	JNZ	NOTCON
	JMP	CONSOLE
NOTCON:
	CMP	[SI].RDEVTYP,01		; DISK ??
	JNZ	NOTDISK
	JMP	IS_DISK
NOTDISK:
	CMP	[SI].RDEVTYP,00		; SYSTEM ??
	JNZ	NOTSYS
	JMP	SYSTEM
NOTSYS:
	CMP	[SI].RDEVTYP,03		; RTC
	JNZ	NOTRTC
	JMP	DO_RTC
NOTRTC:
	CALL	BADCRB
	CLC
	RET				; CLEAR REQUEST AND EXIT

IS_DISK:
	CMP	[SI].DEVNO,01		; DISK CSB
	JC	NOT_DISK
	CMP	[SI].DEVNO,07
	JC	GOODDEV
NOT_DISK:
	CALL	BADCRB
	CLC
	RET				; ERROR EXIT

GOODDEV:
	CMP	[SI].DEVNO,1		; FIRST DRIVE ??
	MOV	CS:DRVNO,DISK1		; IF SO, USE DRIVE 1
	JZ	GOT_DRIVE
	CMP	[SI].DEVNO,2		; SECOND DRIVE ??
	MOV	CS:DRVNO,DISK2		; IF SO, USE DRIVE 2
	JZ	GOT_DRIVE
	CMP	[SI].DEVNO,3		; THIRD DRIVE
	MOV	CS:DRVNO,DISK3		; IF SO, USE DRIVE 3
	JZ	GOT_DRIVE
	CMP	[SI].DEVNO,6		; SIXTH
	MOV	CS:DRVNO,DISK6		; IF SO, USE FLOPPY
	JZ	GOT_DRIVE
	JMP	BADDISK
GOT_DRIVE:
	GET	AX,[SI].COMAND		; GET REQUEST
	CMP	AH,01			; UPPER BYTE
	JNZ	BADDISK
	AND	AL,7FH			; MASK FLUSH BIT
	CMP	AL,01			; READ
	JZ	DISK_RW
	CMP	AL,02			; WRITE
	IF	WRITE_PROTECT
	JZ	DISK_WITE		; ************* TEMP ONLY
	ELSE
	JZ	DISK_RW
	ENDIF
	CMP	AL,03			; GET STATUS
	JZ	DISK_STAT
	CMP	AL,04			; FORMAT
	JZ	DISK_FORMAT
BADDISK:
	CALL	BADCOMAND
	CLC
	RET

DISK_RW:
	JMP	DISK_WRAP		; DO REAL DISK READ/WRITE

;*********************************************
;
;	FOR DEBUG PURPOSES
;
;*********************************************

DISK_FORMAT:
	MOV	DI,OFFSET FORMES
	CALL	PTEXT
	CALL	PDISK
	MOV	DI,OFFSET FEND
	CALL	PTEXT
	CLC
	RET

DISK_STAT:

	PUSHA				; SAVE DRIVE
	MOV	DI,OFFSET CS:DO_DSTAT
	CALL	PTEXT
	POPA
	MOV	AL,CS:DRVNO		; DISK
	MOV	DL,MEDCHK
	GIFCALL	DSKDEV,GSTATUS,NOOPT	; CHECK IT
	JNC	STAT_GOOD
DISK_REC:
	MOV	AL,CS:DRVNO		; DISK
	GIFCALL	DSKDEV,RESET,NOOPT	; CLEAR ERROR
	MOV	AL,CS:DRVNO		; DISK
	MOV	DL,MEDCHK
	GIFCALL	DSKDEV,GSTATUS,NOOPT	; CHECK IT
STAT_GOOD:
	PUSH	DX
	PUSH	AX
	CALL	GET_CSB			; WHERE TO PUT IT
	POP	AX
	AND	AX,0FF00H		; CLEAR BAD STATUS
	MOV	[DI].ERRDSK,AX		; ERROR STATUS
	JZ	GOOD_STATUS
	POP	DX
	CLC
	RET

DO_DSTAT DB	'Disk status request.',CR,LF,ETX

GOOD_STATUS:
	POP	DX			; RESTORE MEDIA
	CMP	DL,0			; HARD ??
	JZ	DONE_STATUS
	PUSH	DX
	MOV	DH,DL			; GET MEDIA BYTE
	MOV	AL,CS:DRVNO		; DRIVE
	MOV	DL,MEDSET
	GIFCALL	DSKDEV,SSTATUS,NOOPT	; SET IT
	POP	DX
	PUTI	[DI].SECSIZE,512	; SET UP SECTOR SIZE
	MOV	[DI].SIZMSW,0		; NO UPPER SECTOR
	MOV	SI,OFFSET CS:DISKTAB	; TABLE OF VALUES
	AND	DL,0FH			; LOWER BITS
	MOV	AL,6			; 3 WORDS
	MUL	DL			; OFFSET
	ADD	SI,AX			; POINT TO IT
	MOV	AX,CS:[SI]		; FIRST
	PUT	[DI].SIZLSW,AX
	MOV	AX,CS:[SI].2
	PUT	[DI].SECTRK,AX
	MOV	AX,CS:[SI].4
	PUT	[DI].HEADNO,AX
DONE_STATUS:
	CLC
	RET

	IF	WRITE_PROTECT
DISK_WITE:
	MOV	DI,OFFSET DWRIT
	CALL	PTEXT
	CALL	PDISK
	MOV	DI,OFFSET CS:DWEND
	CALL	PTEXT
	CLC
	RET
	ENDIF

PDISK:
	MOV	AL,[SI].RDEVNO		; GET DRIVE
	ADD	AL,30H			; TO ASCII
	CALL	SYS_PRN
	RET

	IF	WRITE_PROTECT
DWRIT:	DB	'Pretend to write to disk ',ETX
DWEND:	DB	'.',CR,LF,ETX
	ENDIF

FORMES:	DB	CR,LF,'Pretend to format drive ',ETX
FEND:	DB	'.',CR,LF,ETX

DISKTAB:
	DW	2CFH,9,1
	DW	59FH,9,2
	DW	27FH,8,1
	DW	4FFH,8,2
	DW	167H,9,1
	DW	2CFH,9,2
	DW	13FH,8,1
	DW	27FH,8,2
	DW	167H,9,1
	DW	2CFH,9,2
	DW	13FH,8,1
	DW	27FH,8,2
	DW	0B3H,9,1
	DW	167H,9,2
	DW	09FH,8,1
	DW	13FH,8,2

;*****************************************************
;
;	THIS CODE DOES DISK READ/WRITE EVEN ACROSS
;	PAGE AND 1/2 MB BOUNDARIES
;
;*****************************************************


DISK_WRAP:

	CMP	[SI].SECOUNT,0		; DONE ALL ??
	JNZ	DOSOME
	CLC
	RET				; GOOD RETURN
DOSOME:
	MOV	BX,[SI].DMAMSW		; UPPER ADDRESS
	SWAP	BX			; BYTE SWAP
	AND	BX,07			; BITS BELOW 1/2 MB
	MOV	DX,[SI].DMALSW		; LOWER ADDRESS
	SWAP	DX			; BYTE SWAP
	MOV	CX,0			; SECTORS DONE
	MOV	AX,511			; SECTOR SIZE - 1
LOOPSEC:
	ADD	DX,AX			; ADDRESS OF END OF BLOCK
	MOV	AX,512
	JC	ISCARRY			; CARRY INTO BX
NEXTSEC:
	INC	CX
	SWAP	CX			; BYTE SWAP
	CMP	CX,[SI].SECOUNT		; DONE ALL SECTORS
	PUSHF
	SWAP	CX			; BYTE SWAP
	POPF
	JNZ	LOOPSEC			; NO, GO BACK
	JMP	DISKEX			; EXECUTE DISK

ISCARRY:
	INC	BX			; DO CARRY
	TEST	BX,07			; OVER A BOUNDARY ??
	JNZ	NEXTSEC			; GO ONWARD TILL DONE
	CMP	CX,0			; ANY TO DO ??
	JZ	GOODISK			; NO, SKIP
	PUSH	[SI].SECOUNT		; SAVE TOTAL SECTOR COUNT
	PUSH	DX			; LOWER ADDRESS
	PUSH	BX			; UPPER ADDRESS
	PUSH	CX			; GOOD SECTORS
	SWAP	CX
	MOV	[SI].SECOUNT,CX		; DO THIS NUMBER
	PUSH	SI
	CALL	DISKEX			; DO SO FAR
	MOV	BP,AX			; SAVE ERROR CODE
	POP	SI			; POINT TO CRB AGAIN
	POP	CX
	POP	BX
	POP	DX
	POP	AX
	SWAP	AX			; GET IT OUR WAY ROUND
	CMP	BP,0			; NO ERRORS ??
	JZ	GOODISK
	CLC				; QUITING, FLAG DONE
	RET
GOODISK:
	SUB	AX,CX			; SECTORS LEFT
	MOV	BX,[SI].SECNLO		; GET START SECTOR
	SWAP	BX
	ADD	BX,CX			; INCREASE THE START SECTOR
	PUSHF
	SWAP	BX
	POPF
	MOV	[SI].SECNLO,BX		; STORE IT AWAY
	JNC	NOEXTRA
	MOV	BX,[SI].SECNUP		; DO UPPER BYTE
	SWAP	BX
	INC	BX
	SWAP	BX
	MOV	[SI].SECNUP,BX		; STORE IT BACK
NOEXTRA:
	SWAP	AX
	MOV	[SI].SECOUNT,AX		; NEW SECTOR COUNT
	MOV	AX,[SI].DMAMSW		; UPPER ADDRESS
	SWAP	AX
	AND	AX,0FFF8H		; MASK LOWER BITS TO ZERO
	ADD	AX,0008H		; NEXT BOUNDARY
	SWAP	AX
	MOV	[SI].DMAMSW,AX		; STORE IT BACK
	INC	DX			; START OF NEXT SECTOR
	SWAP	DX
	MOV	[SI].DMALSW,DX		; NEW LOWER BOUNDARY
	SWAP	DX
	CMP	DX,512			; IF EXACT SECTOR
	JNZ	DOBITWISE		; HERE IS TROUBLE
	MOV	[SI].DMALSW,0		; BACK TO START
	JMP	DISK_WRAP		; PROCEED

DOBITWISE:
	TEST	[SI].COMAND,0100H	; READ BIT
	JNZ	SKIP_MOVE		; IF ITS A READ
	CALL	MOVE_DATA		; COPY OVER BEFORE WRITE
SKIP_MOVE:
	CALL	DISK_BIT		; DO THE PHYSICAL I/O
	JNC	GOOD_BIT		; NO ERRORS
	JMP	DISK_EXIT		; ELSE REPORT AND END
GOOD_BIT:
	TEST	[SI].COMAND,0100H	; READ BIT
	JZ	DONE_MOVE		; IF ITS A WRITE
	CALL	MOVE_DATA		; IF ITS A READ
DONE_MOVE:
	JMP	DISK_WRAP		; DONE

MOVE_DATA:
	PUSH	DS
	PUSH	SI			; SAVE THESE

	MOV	BX,[SI].DMALSW		; GET LOWER ADDRESS
	PUSH	BX			; AND SAVE LOWER ADDRESS
	MOV	AX,[SI].DMAMSW		; GET UPPER ADDRESS
	PUSH	AX			; SAVE UPPER ADDRESS

	SWAP	AX
	DEC	AX			; DOWN ONE
	SWAP	AX
	MOV	[SI].DMAMSW,AX		; REDUCED UPPER ADDRESS

	SWAP	BX
	PUSH	BX			; SAVE SECOND COUNT
	MOV	AX,512			; SECTOR SIZE
	SUB	AX,BX			; FIRST SIZE
	SUB	BX,512			; REDUCE LOWER ADDRESS
	SWAP	BX
	MOV	[SI].DMALSW,BX		; PUT IT AWAY
	MOV	CS:START_MOVE,OFFSET PGROUP:DBUFFER
	CALL	REAL_MOVE
	CALL	SET_MAIL		; BACK TO MAILBOXES
	POP	AX			; NEXT COUNT
	MOV	[SI].DMALSW,00		; LOWER ADDRESS START AT 0
	POP	BX			; NEW UPPER ADDRESS
	MOV	[SI].DMAMSW,BX		; SET IT UP
	CALL	REAL_MOVE
	CALL	SET_MAIL		; BOXES AGAIN
	POP	BX
	MOV	[SI].DMALSW,BX		; NEW LOWER ADDRESS
	POP	SI
	POP	DS			; RESTORE
	RET


REAL_MOVE:
	PUSH	DS
	PUSH	SI
	PUSH	AX			; SAVE COUNT
	LEA	SI,[SI].DMAMSW		; POINT TO ADDRESS
	CALL	GET_ADDR		; GET ADDRESS MAKEUP
	POP	CX			; COUNT
	POP	BX			; USE AS POINTER
	PUSH	BX
	MOV	SI,CS:START_MOVE
	PUSH	SI
	ADD	SI,CX			; FINAL ADDRESS
	MOV	CS:START_MOVE,SI	; SET UP FOR PART 2
	POP	SI
	TEST	[BX].COMAND,0100H	; READ ??
	PUSH	CS
	POP	DS
	MOV	DX,RFPORT		; GET REGISTER FILE
	OUT	DX,AL			; DO VME ACCESS
	JNZ	NO_SWAP
	PUSH	ES
	PUSH	DS
	XCHG	DI,SI			; SWAP THESE
	POP	ES
	POP	DS
NO_SWAP:
	CLD
	REP	MOVSB			; MOVE IT
	POP	SI
	POP	DS
	RET

DISK_BIT:
	MOV	DX,[SI].SECOUNT		; SECTOR COUNT
	SWAP	DX
	DEC	DX			; ONE LESS
	SWAP	DX
	MOV	[SI].SECOUNT,DX		; STORE IT BACK
	MOV	DX,[SI].SECNLO		; START NUMBER
	SWAP	DX
	PUSH	DX			; SAVE FOR US
	INC	DX
	PUSHF				; SAVE CARRY
	SWAP	DX
	MOV	[SI].SECNLO,DX		; VALUE FOR NEXT
	POPF				; RESTORE FLAGS
	JNC	NO_OVERFLOW
	MOV	DX,[SI].SECNUP		; UPPER SECTOR
	SWAP	DX
	INC	DX			; INCREMENT UPPER
	SWAP	DX
	MOV	[SI].SECNUP,DX		; STORE BACK
NO_OVERFLOW:
	POP	DX
	MOV	CX,1			; ONE SECTOR
	PUSH	SI
	PUSH	DS
	PUSH	CS
	POP	ES			; DESTINATION SEGMENT
	MOV	DI,OFFSET PGROUP:DBUFFER
	MOV	AX,[SI].SECNUP		; UPPER SECTOR
	SHRI	AX,5			; SEMISWAP
	ADD	AL,CS:DRVNO		; ADD DISK NUMBER
	TEST	[SI].COMAND,0100H	; READ BIT
	JZ	BIT_WRITE
	GIFCALL	DSKDEV,READ,NOOPT
	JMP	WAS_READ
BIT_WRITE:
	GIFCALL	DSKDEV,WRITE,NOOPT
;
WAS_READ:
	POP	DS
	POP	SI
	RET				; DONE PHYSICAL DISK

;******************************************
;
;	DO PHYSICAL DISK READ/WRITE
;
;******************************************


DISKEX:
	TEST	[SI].COMAND,0100H	; READ BIT
	JZ	DISK_WRITE


DISK_READ:
	CALL	SET_DISK		; TEST & SET PARAMETERS
	MOV	DX,RFDMA		; OWN RF
	OUT	DX,AL			; SET IT UP
	MOV	DX,RFPORT
	OUT	DX,AL
	MOV	DX,BX			; GET START
	MOV	AL,CS:DRVNO		; GET DRIVE
	GIFCALL	DSKDEV,READ,NOOPT	; DO IT
	JMP	DISK_EXIT


DISK_WRITE:
	CALL	SET_DISK		; TEST & SET PARAMETERS
	MOV	DX,RFPORT		; SHARE PORT WITH MBOX
	OUT	DX,AL			; SET IT UP
	MOV	DX,RFDMA
	OUT	DX,AL
	MOV	DX,BX			; GET START
	MOV	AL,CS:DRVNO		; GET DRIVE
	GIFCALL	DSKDEV,WRITE,NOOPT	; DO IT
;
DISK_EXIT:
	PUSH	AX
	PUSH	SI			; SAVE OUR POINTER
	CALL	SET_MAIL		; POINT TO MAIL BOXES
	POP	SI
	MOV	AX,[SI].LASUP
	OR	AX,[SI].LASLO		; ANY LOOK AHEAD
	JZ	NO_LOOK_AHEAD
	TEST	[SI].LASIZE,0FFFFH
	JZ	NO_LOOK_AHEAD
	MOV	DI,OFFSET CS:LOOK_START
	CALL	PTEXT
	MOV	AL,[SI].RDEVNO
	CALL	PHEX
	MOV	DI,OFFSET CS:LOOK_AHEAD
	CALL	PTEXT
	MOV	AX,[SI].LASUP
	CALL	PHEX
	GET	AX,[SI].LASUP
	CALL	PHEX
	MOV	AX,[SI].LASLO
	CALL	PHEX
	GET	AX,[SI].LASLO
	CALL	PHEX
	MOV	DI,OFFSET CS:LOOK_SIZE
	CALL	PTEXT
	MOV	AX,[SI].LASIZE
	CALL	PHEX
	GET	AX,[SI].LASIZE
	CALL	PHEX
	MOV	DI,OFFSET CS:FEND
	CALL	PTEXT
NO_LOOK_AHEAD:
	CALL	GET_CSB			; POINT TO CSB
	POP	AX
	AND	AX,0FF00H		; AL NOT VALID
	MOV	[DI].ERRDSK,AX		; STATUS
	JZ	NO_DISK_ERROR
	PUSH	AX
	PUSH	DI
	CALL	DISK_REC		; RE INIT DISK
	POP	DI
	POP	AX
	MOV	[DI].ERRDSK,AX		; STATUS
NO_DISK_ERROR:
	CLC
	RET

LOOK_START: DB	'Drive : ',ETX
LOOK_AHEAD: DB	' look ahead request block : ',ETX
LOOK_SIZE: DB	', count : ',ETX


SET_DISK:
	PUSH	SI
	LEA	SI,[SI].DMAMSW		; ADDRESS DATA
	CALL	GET_ADDR		; GET VME DATA
	POP	SI
	MOV	CX,[SI].SECOUNT		; SECTOR COUNT
	SWAP	CX
	MOV	BX,[SI].SECNLO		; START SECTOR NUMBER
	SWAP	BX
	RET


; END OF DISK HANDLER CODE


;**********************************************
;
;	NOW DO CHARACTER DEVICES
;
;**********************************************

CONSOLE:
	MOV	BX,KVDDEV		; CONSOLE
	MOV	DI,OFFSET CS:CON_FIFO	; OUTPUT FIFO
	CMP	[SI].RDEVNO,08		; CONSOLE DEVICE ??
	JZ	GOOD_CON
	MOV	BX,DTEDEV		; DTE SERIAL
	MOV	DI,OFFSET CS:DTE_FIFO	; OUTPUT FIFO
	CMP	[SI].RDEVNO,10		; DTE
	JZ	GOOD_CON
	MOV	BX,DCEDEV		; DCE SERIAL
	MOV	DI,OFFSET CS:DCE_FIFO	; OUTPUT FIFO
	CMP	[SI].RDEVNO,11		; DCE
	JZ	GOOD_CON
	MOV	BX,PRTDEV		; PRINTER
	MOV	DI,OFFSET CS:PRN_FIFO	; OUTPUT FIFO
	CMP	[SI].RDEVNO,09		; PRINTER
	JZ	GOOD_CON
	CALL	BADCRB
	CLC
	RET

GOOD_CON:
	CMP	[SI].COMAND,0302H	; FIFO MODE
	JZ	ALLFIN
	CMP	[SI].COMAND,0102H	; INPUT ?
	JZ	ALL_IN
	CMP	[SI].COMAND,0202H	; OUTPUT ??
	JNZ	NOT_ALLOUT
	JMP	ALLOUT
NOT_ALLOUT:
	CMP	[SI].COMAND,0502H	; GET STATUS
	JZ	ALL_STAT
	CMP	[SI].COMAND,0402H	; SET UP CHANNEL
	JNZ	BAD_CON_COM
	JMP	ALL_SETUP
BAD_CON_COM:
	CALL	BADCOMAND
	CLC
	RET



ALL_STAT:
	CLC
	RET				; NULL FOR NOW



ALL_IN:
	PUSH	DS
	GIFCALL	,READ,NOOPT		; TRY IT
	POP	DS
	JC	NO_INPUT
	PUSH	AX
	LEA	SI,[SI].ADDUP		; POINT TO ADDRESS
	CALL	SET_ADDR		; POINT TO IT
	POP	AX
	MOV	ES:[DI],AL		; SET IT UP
	CLC
NO_INPUT:
	RET



ALLFIN:					; INPUT TO FIFO
	TEST	BYTE PTR CS:FIRST,00
	JNZ	NOT_FIRST
	MOV	BYTEIN,0
	MOV	FLAGIN,01
	MOV	CS:FIRST,0FFH
NOT_FIRST:
	GET	AX,[SI].INPTR		; INPUT POINTER
	GET	CX,[SI].OUTPTR		; OUT POINTER
	GET	DX,[SI].COUNT		; FIFO SIZE
	PUSH	AX			; OLD POINTER
	INC	AX			; NEXT
	CMP	AX,DX			; WRAP ROUND ?
	JNZ	NOWRAP
	XOR	AX,AX			; RESTART
NOWRAP:
	PUSH	AX			; NEXT POINTER
	CMP	AX,CX			; POINTERS SAME ??
	JNZ	TRYINPUT
FIFEXIT:
	POP	AX
	POP	AX			; CLEAR STACK
	STC				; NOT FINISHED
	RET

TRYINPUT:
	PUSH	DS
	GIFCALL	,READ,NOOPT		; BX IS CHANNEL
	POP	DS
	JC	FIFEXIT			; NO DATA
	PUSH	AX
	PUSH	SI			; SAVE POINTER TO CRB
	LEA	SI,[SI].ADDUP		; POINT TO ADDRESS
	CALL	SET_ADDR		; POINT TO IT
	POP	SI			; RECOVER CRB
	POP	AX			; RECOVER DATA
	POP	DX			; NEW POINTER
	POP	BX			; OLD POINTER
	CMP	AL,00			; ^@
	JNZ	DO_IN_FIFO
	CMP	[SI].DEVNO,8		; CONSOLE ?
	JNZ	DO_IN_FIFO
	JMP	MSDOS
DO_IN_FIFO:
	MOV	ES:[BX.DI],AL		; SET IT UP
	MOV	BL,DH			; SAVE POINTER
	MOV	BH,DL			; WITH SWAP
	CALL	SET_MAIL		; RESTORE MAILBOXES
	MOV	[SI].INPTR,BX		; NEW POINTER
	STC
	RET				; NOT FINISHED


;********************************************************
;
;	MOVE BLOCKS OF CHARACTERS TO THE OUTPUT FIFOS
;
;********************************************************

ALLOUT:
	MOV	AX,CS:[DI].OUTPUT	; GET OUTPUT POINTER
	SUB	AX,CS:[DI].INPUT	; HOW MUCH SPACE
	DEC	AX			; ADJUST ( 0=MT NOT FULL )
	AND	AX,3FFH			; NORMALISE TO FIFO SIZE
	GET	CX,[SI].COUNT		; GET BLOCK SIZE
	CMP	AX,CX			; NUF SPACE FOR WHOLE BLOCK ?
	JA	OUT_OK			; YES, SKIP
	STC
	RET				; SORRY

OUT_OK:
	PUSH	DI			; SAVE FIFO POINTER
	PUSH	CX			; SAVE LENGTH

	LEA	SI,[SI].ADDUP
	CALL	SET_ADDR		; POINT TO DATA

	MOV	SI,DI			; SOURCE POINTER
	POP	CX			; RECOVER COUNT
	POP	DI			; TARGET POINTER
MOVE_BLOCK:
	MOV	AL,ES:[SI]		; BYTE POINTER
	MOV	BX,CS:[DI].INPUT	; GET FIFO INPUT POINTER
	MOV	CS:[DI.BX].BUFFER,AL	; MOVE DATA
	INC	BX
	CMP	BX,CS:[DI].MAXIZE	; IN RANGE ??
	JNZ	NO_WRAP_OUT		; YES, SKIP
	MOV	BX,0			; RESTART
NO_WRAP_OUT:
	MOV	CS:[DI].INPUT,BX	; SAVE NEW POINTER
	INC	SI			; NEXT SOURCE
	LOOP	MOVE_BLOCK		; REPEAT TILL DONE

	CLC
	RET

ALL_SETUP:
; FOR NOW WE JUST PRINT A MESSAGE
	MOV	DI,OFFSET CS:SETUP1
	CALL	PTEXT
	MOV	AL,[SI].RDEVNO		; GET DEVICE NUMBER
	MOV	DI,OFFSET CS:DEVTAB
	XOR	AH,AH
	SUB	AX,8
	SHL	AX,1			; *2
	ADD	DI,AX			; CALCULATE ADDRESS
	MOV	DI,CS:[DI]		; GET MESSAGE
	CALL	PTEXT
	MOV	DI,OFFSET CS:SETUP2	; NEXT MESSAGE
	CALL	PTEXT
	MOV	DI,OFFSET CS:BAUD1
	CALL	PTEXT
	GET	AX,[SI].OUTPTR		; BAUD RATE NUMBER
	TEST	AX,0FFF0H		; 0-15 ONLY
	JZ	GOOD_BAUD
	XOR	AX,AX
GOOD_BAUD:
	MOV	DI,OFFSET CS:BAUTAB
	ADD	DI,AX
	ADD	DI,AX
	MOV	DI,CS:[DI]
	CALL	PTEXT
	MOV	DI,OFFSET CS:DTRMES
	TEST	[SI].INPTR,0100H	; BIT 0
	JNZ	SET_DTR
	MOV	DI,OFFSET CS:DTNRMS
SET_DTR:
	CALL	PTEXT
	GET	AX,[SI].INPTR		; GET SET WORD
	AND	AX,180H			; DATA BITS
	SHRI	AX,7
	ADD	AL,35H			; ASCII 5-8
	PUSH	DS
	CALL	SYS_PRN
	MOV	DI,OFFSET CS:BITMES
	CALL	PTEXT
	GET	AX,[SI].INPTR		; GET WORD
	AND	AL,6			; GET BITS
	PUSH	AX
	JPE	PARITYE			; 0 OR TWO
	MOV	AL,31H			; 1
	CALL	SYS_PRN
	POP	AX
	CMP	AL,2			; ONE BIT
	JZ	DUNSTOP
	MOV	AL,2EH
	CALL	SYS_PRN
	MOV	AL,35H
	CALL	SYS_PRN
	JMP	DUNSTOP
PARITYE:
	POP	AX
	MOV	AL,30H			; 0 BITS
	JZ	GOTBITS
	ADD	AX,2
GOTBITS:
	CALL	SYS_PRN
DUNSTOP:
	POP	DS
	MOV	DI,OFFSET CS:STOPMS
	CALL	PTEXT
	MOV	DI,OFFSET CS:XNONMS	; NO XOFF INPUT
	TEST	[SI].INPTR,800H
	JZ	NOXON
	MOV	DI,OFFSET CS:XONMES
	CALL	PTEXT
	MOV	DI,OFFSET CS:XNANMS
	TEST	[SI].INPTR,1000H
	JZ	NOXON
	MOV	DI,OFFSET CS:XANYMS
NOXON:
	CALL	PTEXT
	MOV	DI,OFFSET CS:XNOFMS
	TEST	[SI].INPTR,2000H
	JZ	XNOFF
	MOV	DI,OFFSET CS:XOFFMS
XNOFF:
	CALL	PTEXT
	TEST	[SI].INPTR,4000H
	JZ	NOBREAK
	MOV	DI,OFFSET CS:BRKMES
	CALL	PTEXT
NOBREAK:
	MOV	DI,OFFSET CS:NO_PARITY
	TEST	[SI].INPTR,0004H	; PARITY ?
	JZ	DO_PARITY
	MOV	DI,OFFSET CS:EVEN_PARITY
	TEST	[SI].INPTR,0008H
	JZ	DO_PARITY
	MOV	DI,OFFSET CS:ODD_PARITY
DO_PARITY:
	CALL	PTEXT
	MOV	DI,OFFSET CS:NBRKMS
	CALL	PTEXT

	CALL	GET_CSB			; POINT TO CSB
	MOV	[DI].STATTY,0100H	; SHOW DCD
	CLC
	RET				; NULL FOR NOW

; MESSAGES FOR DUMMY SETUP

DEVTAB:	DW	CONMES
	DW	PRNMES
	DW	DTEMES
	DW	DCEMES
	DW	NULMES
	DW	NULMES
	DW	NULMES
	DW	NULMES

SETUP1:	DB	CR,LF,'Set up ',ETX
SETUP2:	DB	' device : ',ETX
CONMES:	DB	'CONSOLE',ETX
PRNMES:	DB	'PRINTER',ETX
DTEMES:	DB	'DTE SERIAL',ETX
DCEMES:	DB	'DCE SERIAL',ETX
NULMES:	DB	'NULL',ETX

BAUD1:	DB	'Baud rate : ',ETX
BAUTAB:	DW	BADMES
	DW	B50
	DW	B75
	DW	B110
	DW	B134
	DW	B150
	DW	B200
	DW	B300
	DW	B600
	DW	B1200
	DW	B1800
	DW	B2400
	DW	B4800
	DW	B9600
	DW	B19200
	DW	BEXT
BADMES:	DB	'BAD ',ETX
B50:	DB	'50 ',ETX
B75:	DB	'75 ',ETX
B110:	DB	'110 ',ETX
B134:	DB	'134.5 ',ETX
B150:	DB	'150 ',ETX
B200:	DB	'200 ',ETX
B300:	DB	'300 ',ETX
B600:	DB	'600 ',ETX

B1200:	DB	'1200 ',ETX
B1800:	DB	'1800 ',ETX
B2400:	DB	'2400 ',ETX
B4800:	DB	'4800 ',ETX
B9600:	DB	'9600 ',ETX
B19200:	DB	'19200 ',ETX
BEXT:	DB	'EXTERNAL ',ETX

DTRMES:	DB	', DTR, ',ETX
DTNRMS:	DB	', no DTR, ',ETX
BITMES:	DB	' data bits,',CR,LF,ETX
STOPMS:	DB	' stop bits, ',ETX
XNONMS:	DB	'ignore XOFF, ',ETX
XONMES:	DB	'stop on XOFF, ',ETX
XNANMS:	DB	'start on XON, ',ETX
XANYMS:	DB	'start on XANY, ',ETX
XNOFMS:	DB	'dont use XOFF',ETX
XOFFMS:	DB	'use XOFF control',ETX
BRKMES:	DB	', send BREAK'
NO_PARITY: DB	', no',ETX
EVEN_PARITY: DB	', even',ETX
ODD_PARITY: DB	', odd',ETX
NBRKMS:	DB	' parity.',CR,LF,ETX

;*****************************************************
;
;	ATTEMPT TO OUTPUT FROM CHARACTER FIFOS
;
;*****************************************************

FIFO_NEXT:
	MOV	AX,CS:[DI].OUTPUT	; GET IT
	INC	AX			; NEXT
	CMP	AX,CS:[DI].MAXIZE	; TOO MUCH ??
	JNZ	FIFO_WRAP
	MOV	AX,0			; WRAP POINTER
FIFO_WRAP:
	MOV	CS:[DI].OUTPUT,AX

FIFO_OUT:

	MOV	BP,CS:[DI].OUTPUT	; GET FIFO OUTPUT POINTER
	CMP	BP,CS:[DI].INPUT	; ANYTHING ??
	JNZ	GOT_CHARS		; IF SO SKIP
	RET				; ELSE QUIT

GOT_CHARS:
	MOV	AL,CS:[DI.BP].BUFFER	; GET DATA
	PUSHA				; SAVE REGISTERS
	GIFCALL	,WRITE,NOOPT		; TRY TO WRITE
	POPA
	JNC	FIFO_NEXT		; TRY ANOTHER
	RET

;**********************************************************
;
;		SYSTEM COMMANDS
;
;**********************************************************

SYSTEM:
	CMP	[SI].COMAND,0100H	; REBOOT ?
	JNZ	IS_MSDOS		; PREHAPS
;************** RESET 68K BOARD IF POSSIBLE
	JMP	RESTART			; RESTART MY SIDE
IS_MSDOS:
	CMP	[SI].COMAND,0200H	; GO MSDOS
	JNZ	NOT_MSDOS		; SKIP
MSDOS:
	CALL	SET_BOOT		; SET UP WARM BOOT
	MOV	AH,04CH			; EXIT COMMAND
	INT	21H			; QUIT TO MSDOS

NOT_MSDOS:
	CALL	BADCOMAND
	CLC
	RET

;*******************************************************
;
;	REAL TIME CLOCK ACCESS
;
;*******************************************************

DO_RTC:
	CMP	[SI].COMAND,0103H	; READ CLOCK
	JZ	READ_RTC
	CMP	[SI].COMAND,0203H	; WRITE CLOCK
	JNZ	RTC_BADCOM
	JMP	WRITE_RTC
RTC_BADCOM:
	CALL	BADCOMAND
	CLC
	RET

READ_RTC:

	PUSHA
	PUSH	DS
	PUSH	CS
	POP	ES
	MOV	DI,OFFSET CS:RTC_BUFFER
	MOV	CX,6			; READ FIRST SIX
	MOV	DX,0
	GIFCALL	RTCDEV,READ,NOOPT
	POP	DS
	POPA				; RESTORE REGISTERS
	JNC	NO_READ_ERR
	JMP	RTC_ERROR
NO_READ_ERR:
	CALL	GET_CSB			; GET THE CSB
	PUSH	DI			; SAVE CSB POINTER
	MOV	AL,CS:RTC_BUFFER.YEAR	; GET YEAR
	CALL	GET_HEX
	SUB	AX,70			; YEARS SINCE -1
	JNC	ADD_CENT
	ADD	AX,100			; CORRECT IT
ADD_CENT:
	PUSH	AX
	MOV	SI,365			; DAYS PER YEAR
	MUL	SI			; YEARS * DAYS
	MOV	SI,AX			; SAVE IT
	POP	AX			; YEARS AGAIN
	INC	AX			; ADJUST
	CMP	CS:RTC_BUFFER.MONTH,3	; AFTER FEB ??
	JC	NOT_FEB
	INC	AX			; NOTHER YEAR
NOT_FEB:
	SHRI	AX,2			; /4 FOR LEAP YEARS
	ADD	SI,AX			; ADD TO DAYS
	XOR	CH,CH			; CLEAR IT
	MOV	CL,CS:RTC_BUFFER.MONTH	; GET MONTH
	DEC	CX			; MINUS ONE
	JZ	DUN_MONTH		; IF JAN
	CALL	ADD_MONTH		; DO MONTHS
DUN_MONTH:
	MOV	AL,CS:RTC_BUFFER.DATE	; ODD DAYS
	CALL	GET_HEX
	DEC	AX			; DAYS 1-31 ETC
	ADD	SI,AX			; ADD THEM IN
	MOV	AX,5180H		; HOURS PER DAY -10000
	MUL	SI			; SECONDS PASSED
	ADD	SI,DX			; EXTRA WORD
	MOV	DI,AX			; SAVE IT
	MOV	AL,CS:RTC_BUFFER.HOURS
	CALL	GET_HEX			; CONVERT
	MOV	BX,60			; MINUTES
	MUL	BX			; 
	MOV	BX,AX			; SAVE IT
	MOV	AL,CS:RTC_BUFFER.MINUTES
	CALL	GET_HEX			; CONVERT
	ADD	AX,BX			; TOTAL MINUTES
	MOV	BX,60			; TO SECONDS
	MUL	BX			; GOT IT
	MOV	BX,AX			; SAVE IT
	MOV	AL,CS:RTC_BUFFER.SECONDS
	CALL	GET_HEX			; CONVERT
	ADD	AX,BX
	JNC	NO_XTRA_SEC
	INC	DX			; UPPER BITS
NO_XTRA_SEC:
	ADD	AX,DI			; FINAL LOWER
	JNC	NO_EXTRA_SEC
	INC	DX
NO_EXTRA_SEC:
	ADD	DX,SI			; FINAL ANSWER
	POP	DI			; RECOVER CSB
	PUT	[DI].TIMMSW,DX
	PUT	[DI].TIMLSW,AX		; SAVE RESULT
	CLC
	RET


ADD_MONTH:
	ADD	SI,31			; JAN
	LOOP	JAN
	RET
JAN:	ADD	SI,28			; FEB
	LOOP	FEB
	RET
FEB:	ADD	SI,31			; MARCH
	LOOP	MARCH
	RET
MARCH:	ADD	SI,30			; APRIL
	LOOP	APRIL
	RET
APRIL:	ADD	SI,31			; MAY
	LOOP	MAY
	RET
MAY:	ADD	SI,30			; JUNE
	LOOP	JUNE
	RET
JUNE:	ADD	SI,31			; JULY
	LOOP	JULY
	RET
JULY:	ADD	SI,31			; AUGUST
	LOOP	AUGUST
	RET
AUGUST:	ADD	SI,30			; SEPTEMBER
	LOOP	SEPT
	RET
SEPT:	ADD	SI,31			; OCTOBER
	LOOP	OCT
	RET
OCT:	ADD	SI,30			; NOVEMBER
	RET


GET_HEX:				; CONVERT 2 NIBBLES TO HEX
	PUSH	AX			; SAVE IT
	SHRI	AL,4			; UPPER NIBBLE
	MOV	CL,10			; TEN
	MUL	CL			; AL * CL
	POP	CX
	AND	CX,0FH			; LOWER ONLY
	ADD	AX,CX			; RESULT IN AX
	RET


WRITE_RTC:
	GET	DX,[SI].TIMEUP
	GET	AX,[SI].TIMELO
	MOV	BX,0A8C0H		; 60 * 60 * 12
	DIV	BX			; AX = DAYS * 2, DX = SECS
	XOR	BX,BX			; CLEAR HOURS & MINS
	MOV	CH,BH			; CLEAR SECS
	SHR	AX,1			; /2
	PUSH	AX			; 
	MOV	AX,DX			; GET REMAINING SECONDS
	MOV	DX,0			; CLEAR UPPER PART
	JNC	NOT_12_HRS		; DONT ADD 12 HOURS
	ADD	AX,0A8C0H		; 12 * 60 * 60
	JNC	NOT_12_HRS		; NO CARRY
	INC	DX
NOT_12_HRS:
	MOV	SI,60			; SEC/MIN
	DIV	SI			; DIV DX.AX/60
	MOV	CS:RTC_BUFFER.SECONDS,DL; REMAINING SECONDS
	XOR	DX,DX			; CLEAR UPPER
	DIV	SI			; MIN/60 = HOURS
	MOV	CS:RTC_BUFFER.MINUTES,DL
	MOV	CS:RTC_BUFFER.HOURS,AL	; SAVE RESULTS
	POP	AX			; DAYS
	XOR	DX,DX			; CLEAR UPPER
	MOV	SI,365			; DAYS PER YEAR
	DIV	SI			; AX = YEARS, DX = DAYS
	ADD	AX,2			; NORMALISE FOR LEAP YEARS
	MOV	BL,AL			; SAVE YEARS
	SHRI	AX,2			; /4
	SUB	DX,AX			; REMOVE LEAP DAYS
	JNC	NO_LEAPS		; OK
	DEC	BL			; ONE YEAR LESS
	ADD	DX,365			; RESTORE TO DAYS
NO_LEAPS:
	ADD	BL,68			; ADD OFFSET
	CMP	BL,99			; RANGE CHECK
	JC	GOOD_YEAR
	SUB	BL,100			; ADJUST
GOOD_YEAR:
	MOV	CS:RTC_BUFFER.YEAR,BL	; SAVE YEARS

	CALL	UNDO_MONTH		; GET MONTH

	INC	DL			; DAYS 1-31 ETC
	MOV	CS:RTC_BUFFER.MONTH,CL	; SAVE MONTH
	MOV	CS:RTC_BUFFER.DATE,DL	; SAVE DATE


; CONVERT ALL TIMES TO NIBBLES
	MOV	AL,CS:RTC_BUFFER.SECONDS
	CALL	PUT_HEX
	MOV	CS:RTC_BUFFER.SECONDS,AL
	MOV	AL,CS:RTC_BUFFER.MINUTES
	CALL	PUT_HEX
	MOV	CS:RTC_BUFFER.MINUTES,AL
	MOV	AL,CS:RTC_BUFFER.HOURS
	CALL	PUT_HEX
	MOV	CS:RTC_BUFFER.HOURS,AL
	MOV	AL,CS:RTC_BUFFER.DATE
	CALL	PUT_HEX
	MOV	CS:RTC_BUFFER.DATE,AL
	MOV	AL,CS:RTC_BUFFER.MONTH
	CALL	PUT_HEX
	MOV	CS:RTC_BUFFER.MONTH,AL
	MOV	AL,CS:RTC_BUFFER.YEAR
	CALL	PUT_HEX
	MOV	CS:RTC_BUFFER.YEAR,AL

	PUSH	CS
	POP	ES
	MOV	DI,OFFSET CS:RTC_BUFFER
	MOV	CX,6			; MOVE SIX BYTES
	MOV	DX,0			; START AT BEGINING
	PUSH	DS
	PUSH	SI
	GIFCALL	RTCDEV,WRITE,NOOPT	; SEND IT
	POP	SI
	POP	DS
	JC	RTC_ERROR
	CLC
	RET				; DONE

RTC_ERROR:
	PUSH	AX
	CALL	GET_CSB			; GET THE CSB
	POP	AX
	XOR	AL,AL
	MOV	[DI].ERRRTC,AX		; SET UP ERROR CODE
	CLC
	RET

UNDO_MONTH:
	MOV	CL,1
	CMP	DX,31			; JANUARY
	JC	GOT_MONTH
	SUB	DX,31			; REMOVE DAYS
	INC	CL
	MOV	BX,28			; NON LEAP YEARS
	TEST	CS:RTC_BUFFER.YEAR,3	; CHECK IT
	JNZ	IS_NOT_LEAP
	INC	BX			; 29
IS_NOT_LEAP:
	CMP	DX,BX
	JC	GOT_MONTH
	SUB	DX,BX
	INC	CL
	CMP	DX,31			; MARCH
	JC	GOT_MONTH
	SUB	DX,31
	INC	CL
	CMP	DX,30			; APRIL
	JC	GOT_MONTH
	SUB	DX,30
	INC	CL
	CMP	DX,31			; MAY
	JC	GOT_MONTH
	SUB	DX,31
	INC	CL
	CMP	DX,30			; JUNE
	JC	GOT_MONTH
	SUB	DX,30
	INC	CL
	CMP	DX,31			; JULY
	JC	GOT_MONTH
	SUB	DX,31
	INC	CL
	CMP	DX,31			; AUGUST
	JC	GOT_MONTH
	SUB	DX,31
	INC	CL
	CMP	DX,30			; SEPTEMBER
	JC	GOT_MONTH
	SUB	DX,30
	INC	CL
	CMP	DX,31			; OCTOBER
	JC	GOT_MONTH
	SUB	DX,31
	INC	CL
	CMP	DX,30			; NOVEMBER
	JC	GOT_MONTH
	SUB	DX,30
	INC	CL
GOT_MONTH:
	RET


PUT_HEX:
	XOR	AH,AH			; CLEAR TOP
	MOV	BX,10
	DIV	BL			; DIVIDE AL BY 10
	SHLI	AL,4			; MOVE BITS IN AH
	ADD	AL,AH			; RESULT
	RET


;******************************************************
;
;	UTILITIES
;
;******************************************************

GET_CSB:
; MAKE DS:DI POINT TO THE RELEVENT CSB

	MOV	AL,[SI].RDEVNO		; GET THE DEVICE (CSB) NUMBER
	XOR	AH,AH			; CLEAR AH
	SALI	AX,5			; MULTIPLY BY 32
	MOV	DI,OFFSET MAILBOX:CSB0	; START
	ADD	DI,AX			; POINTER
	RET

TO_HEX:					; CONVERT HEX - ASCII
	AND	AL,0FH
	ADD	AL,30H
	CMP	AL,3AH
	JC	IS_HEX
	ADD	AL,7H
IS_HEX:
	RET


SET_ADDR:				; POINT TO VME ADDRESS
	CALL	GET_ADDR		; CALCULATE
	MOV	DX,RFPORT		; RF PORT ADDRESS
	OUT	DX,AL			; SET UP RF
	RET				; DONE

GET_ADDR:				; CALCULATE VME ADDRESS

	MOV	AX,[SI]			; UPPER ADDRESS
	SWAP	AX
	ADD	AX,RAM_68K		; START ADDRESS OFFSET ON VME
	AND	AX,00F8H		; UPPER 5 BITS
	MOV	BX,[SI+4]		; VME ACCESS CODE
	SWAP	BX
	AND	BX,0007H		; VALID BITS
	OR	AX,BX			; DATA FOR RF IN AL
	MOV	BX,[SI]			; UPPER ADDRESS
	SWAP	BX
	MOV	DX,[SI+2]		; LOWER ADDRESS
	SWAP	DX
	MOV	CX,4
	SHR	DX,CL			; REDUCE TO SEGMENT SIZE
	SHL	BX,CL			; BITS UP IN BL
	OR	DH,BL
	AND	DX,7FFFH		; CLEAR MSB
	ADD	DX,4000H		; LAST MOVE
	MOV	ES,DX			; GOT IT IN SEG REG
	MOV	DI,[SI+2]		; LOWER ADDRESS
	SWAP	DI
	AND	DI,0FH			; OFFSET
	RET

TEST_BOOT:
	MOV	BYTE PTR CS:REBOOT,0	; FLAG COLD BOOT
	CALL	DO_BOOT
	CLD
	REPE	CMPSB			; TEST IT
	JNZ	CLR_BOOT
	PUSH	ES
	POP	DS
	MOV	AL,TOCK			; UNIX TICK
	MOV	CX,80H
TICKING:
	CMP	AL,TOCK
	LOOPE	TICKING
	JE	CLR_BOOT
	MOV	BYTE PTR CS:REBOOT,0FFH	; FLAG IT
CLR_BOOT:
	CALL	DO_BOOT
	MOV	AX,0			; CLEAR
	CLD
	REP	STOSB			; CLEAR IT
	RET

SET_BOOT:
	CALL	DO_BOOT
	CLD
	REP	MOVSB			; COPY IT
	RET

DO_BOOT:
	CALL	SET_MAIL		; SET MAILBOXES
	PUSH	CS
	PUSH	DS
	POP	ES
	POP	DS
	MOV	SI,OFFSET CS:STBOOT
	MOV	DI,OFFSET MAILBOX:TESTFLG1
	MOV	CX,LENBOOT		; BYTE COUNT
	RET

CLEAR_RAM:
	MOV	BX,4000H
	MOV	AX,0
CLEAR_SEG:
	MOV	ES,BX
	MOV	DI,AX
	MOV	CX,8000H
	REP	STOSW
	ADD	BX,1000H
	CMP	BX,0C000H
	JNZ	CLEAR_SEG
	RET

SET_MAIL:				; ACCESS MAILBOXES
	MOV	DX,RFPORT		; REGISTER FILE PORT
	MOV	AL,MAILRF		; MAILBOX ACCESS
	OUT	DX,AL			; SET IT UP
	MOV	AX,SEG MAILBOX		; ACCESS ADDRESS
	MOV	DS,AX
	RET


GET_BOOT:
	MOV	DI,68H
	XOR	AL,AL
	MOV	CX,20H
	PUSH	DS
	POP	ES			; SORT OURSEGMENTS
	REP	STOSB			; CLEAR FCB
	MOV	DX,05CH
	MOV	AH,0FH			; OPEN FILE
	INT	21H
	CMP	AL,0
	JZ	FILEOPEN

	MOV	DI,05CH			; FCB
	PUSH	DS
	POP	ES
	PUSH	CS
	POP	DS			; SWAP SEGMENTS AROUND
	MOV	SI,OFFSET CS:BOOTNAME
	MOV	CX,37			; NO OF BYTES
	REP	MOVSB			; COPY IT
	PUSH	ES
	POP	DS			; RESTORE DS

	MOV	DX,05CH
	MOV	AH,0FH			; OPEN FILE
	INT	21H
	CMP	AL,0
	JZ	FILEOPEN
	MOV	DX,OFFSET PGROUP:ERRMES
	ADD	DX,100H
	MOV	AH,9			; PRINT STRING
	INT	21H
	MOV	AH,4CH			; TERMINATE
	INT	21H			; QUIT
FILEOPEN:
	MOV	DX,RFPORT
	MOV	AL,MMCRF		; 50000H ON 68K IS DESTINATION
	OUT	DX,AL
	MOV	DX,RFDMA
	OUT	DX,AL			; SET BOTH RFS FOR TRANSFER
	MOV	AX,9000H
	MOV	BX,0FF80H		; 0-80H
	PUSH	AX
	PUSH	BX
	PUSH	DS			; SAVEIT
GETBLOCK:
	POP	AX			; REALLY DS
	POP	DX
	POP	DS			; DESTINATION DS:DX
	ADD	DX,80H			; ONE BLOCK
	PUSH	DS
	PUSH	DX			; SAVE FOR NEXT TIME
	PUSH	AX			; SAVE IT AGAIN
	MOV	AH,1AH
	INT	21H			; SET DMA

	POP	DS
	PUSH	DS			; GET AND SAVE DS
	MOV	DX,5CH			; POINT TO FCB
	MOV	AH,14H			; READ
	INT	21H
	CMP	AL,00
	JZ	GETBLOCK		; REPEAT TILL DONE

	POP	AX
	POP	AX
	POP	AX
	RET


ERRFULL:
	MOV	DI,OFFSET FIFOFLOW
	JMP	PERR


BADCRB:
	MOV	AX,0100H		; BAD CALL
	MOV	DI,OFFSET CRBERR
	JMP	PERR
BADCOMAND:
	MOV	AX,0400H
	MOV	DI,OFFSET COMERR
	JMP	PERR
BADSECT:
	MOV	AX,0900H		; SECTOR NOT FOUND
	MOV	DI,OFFSET SECERR
	JMP	PERR
BADDEV:
	MOV	AX,0300H		; BAD DEVICE
	MOV	DI,OFFSET DEVERR
	JMP	PERR
BADTYPE:
	MOV	AX,0300H		; BAD DEVICE
	MOV	DI,OFFSET TYPERR

PERR:
	PUSH	DI
	PUSH	AX
	CALL	GET_CSB			; GET THE CSB
	POP	AX
	MOV	[DI].ERRDSK,AX		; ERROR CODE
	POP	DI
PTEXT:					; PRINT ALL CHARACTERS FROM ES:DI TO 04H ( ETX )
	PUSH	DS
	PUSH	SI			; SAVE THESE
	PUSH	CS
	POP	ES			; MESSAGES ARE IN CS
	JMP	PTEXT1			; STARTING POINT
PRINTONE:
	PUSH	ES
	PUSH	DI
	CALL	SYS_PRN
	POP	DI
	POP	ES
PTEXT1:
	MOV	AL,ES:[DI]		; GET CHARACTER
	INC	DI			; NEXT
	CMP	AL,ETX
	JNE	PRINTONE		; OUTPUT ONE
	POP	SI
	POP	DS			; RESTORE THESE
	RET

PHEX:					; PRINT A HEX BYTE AS TWO ASCII BYTES
	PUSH	AX
	SARI	AL,4			; MSB
	CALL	PNIBBLE
	POP	AX
PNIBBLE:
	AND	AL,0FH
	OR	AL,30H			; ADD BITS
	CMP	AL,3AH
	JC	DECIMAL
	ADD	AL,7			; ADJUST
DECIMAL:
	CALL	SYS_PRN
	RET

PSPACE:
	MOV	AL,20H			; SPACE
	JMP	SYS_PRN


SYS_PRN:
	CMP	CS:SYS_FLAG,0
	JNZ	DO_PRINT
	RET
DO_PRINT:
	GIFCALL	KVDDEV,WRITE,WAITRDY
	RET


SIGNON:	DB	LF,LF,CR,'Phase 2 UNIX I/O System',CR,LF
	DB	'Starting UNIX now.',LF,CR,ETX

CRBERR:	DB	CR,LF,'Illegal CRB requested !',CR,LF,ETX

COMERR:	DB	CR,LF,'Bad command.',CR,LF,ETX
SECERR:	DB	CR,LF,'Bad disk sector.',CR,LF,ETX
DEVERR:	DB	CR,LF,'Bad disk device.',CR,LF,ETX
TYPERR:	DB	CR,LF,'Bad disk type.',CR,LF,ETX

EOM	DB	CR,LF,ETX

BOOTNAME: DB	0,'NEWBOOT UNX'
	DB	22 DUP (0)		; DEFAULT FILE NAME

ERRMES:	DB	0AH,0DH,'Boot.unx file not found.',0AH,0DH,'$'

FIFOFLOW: DB	'.',ETX

;
GIFDIC	LABEL	DWORD
GIFL	DW	?
GIFH	DW	?
;
;
START_MOVE DW	?			; POINTER TO BUFFER

RTC_BUFFER RTC	<>			; REAL TIME CLOCK BUFFER

DRVNO	DB	?

STBOOT	DB	01H,80H,05H,0A0H,045H,0A2H,055H,0AAH
LENBOOT	EQU	$-STBOOT

FIRST	DB	0			; FISRT FIFO IN
SYS_FLAG DB	1			; PRINT SYS INFO

REBOOT	DB	0			; ASSUME COLD BOOT

PENDX	DW	?
PEND	DW	?


DBUFFER	DB	512 DUP (?)		; DISK BUFFER FOR WRAP


CON_FIFO FIFO	<>
PRN_FIFO FIFO	<>
DTE_FIFO FIFO	<>
DCE_FIFO FIFO	<>



; SOURCE OF MAILBOXES

MAIL_COPY:

	DW	0,0			; START
	DW	0FFFFH,0FFFFH		; BUSY
	DW	0,0			; DONE
	DW	0,0			; READY
	DW	0,0			; STATUS
	DW	0FFFFH,0FFFFH		; STATUS AKNOWLEDGE
	DW	0,0			; ABORT
	DW	0FFFFH,0FFFFH		; ABORT AKNOWLEDGE

	CSB_SYS	<0,0,0,0,1,10H,0>

	CSB_DISK <1,1,1,0,1,512,0,88AAH,11H,6>

	CSB_DISK <1,2,1,0,1,512,0,22AAH,11H,6>

	CSB_DISK <1,3,1,0,1,512,0,88AAH,11H,6>

	CSB_DISK <1,4,0,0,0,0,0,0,0,0>
	CSB_DISK <1,5,0,0,0,0,0,0,0,0>

	CSB_DISK <1,6,2,0,0,0,0,0,0,0>	; FLOPPY

	CSB_RTC	<3,7,0,0,1,0,0>

	CSB_TTY	<2,8,1,0,2,1>		; CONSOLE ALWAYS ON LINE

	CSB_TTY	<2,9,3,0,1,0>

	CSB_TTY	<2,10,2,0,2,0>

	CSB_TTY	<2,11,2,0,2,0>

	CSB_TTY	<2,12,2,0,0,0>
	CSB_TTY	<2,13,2,0,2,0>
	CSB_TTY	<2,14,2,0,0,0>
	CSB_TTY	<2,15,2,0,0,0>

	DW	1264 DUP (0)

MAIL_SIZE EQU	$-MAIL_COPY		; SIZE TO COPY


; SPACE FOR SYSTEM STACK

	DW	200H DUP (?)
STACKE:

PROG	ENDS
	END	BEGIN			; PROGRAM START ADDRESS






T



