TITLE	---	HEXIN ROUTINE, TO INPUT HEX, DEC, BIN AND OCT NUMBERS WHICH
;	  ARE ECHOED AND CHECKED. EDITING FUNCTIONS VIA SPECIAL CONTROL
;	  KEYS ARE PROVIDED, AND USER PROGRAMMABLE.


;	  SPECIFICATION PREPARED  BY :  C.Y. KO
;	  PROGRAMMER :  L. CHOW
;	  APPROVED BY : M. FRANK
;	  DATE : 2ND AUGUST L984

INCLUDE	\186\XINSTR2.MAC
INCLUDE	SRC\HEXIN.EQU
INCLUDE	SRC\LEDTOR.EQU
INCLUDE	\GIFI\SRC\GIFMAC.MAC

PGROUP	GROUP	PROG


PROG	SEGMENT	BYTE PUBLIC 'PROG'

	EXTRN	BINASC:NEAR, ASCBIN:NEAR, ASCII:NEAR, DISPCHR:NEAR
	ASSUME	CS:PGROUP


; FUNCTION : HEXADECIMAL INPUT ROUTINE, PERFORM HEX, BIN, DEC & OCT INPUT
; INPUT :  ES:DI    HEX BUFFER
;	   DS:SI    ASCII BUFFER
;	   CL	    NUMBER OF DIGITS (ASCII BUFFER LENGTH)
;	   BX	    DEVICE GIFDIC HANDLE (DCE, DTE, KVD)
;	   DX	    COMMAND REGISTER
;	   SS:AX    CONTROL CHARACTER TABLE (CCT)
;
; OUTPUT : ES:DI    IMMEDIATE AFTER THE LAST CHARACTER FILLED IN
;	   DS:SI    IMMEDIATE AFTER THE LAST CHARACTER READ FROM
;	   CY	    IF GIFDIC ERROR
;
; DESTROYED : NONE OF OTHER REGISTERS


NPROCEDURE HEXIN
	PUSH	CX
	PUSH	BP
	XOR	BP, BP
	ENTER	<SIZE HEXDAT>, 0
	PUSH	BP
	MOV	BP, SP
	ADD	BP, 2
	MOV	[BP.GIFDEV], BX		; SAVE THE GIFDIC DEVICE
	MOV	[BP.CCTPTR], AX		; SAVE THE CCT POINTER
	XOR	CH, CH
	MOV	[BP.LEN], CX		; SAVE THE LENGTH
	MOV	[BP.CMD], DX
	MOV	[BP.ASCBUFIRST], SI	; SAVE ASCII BUFFER POINTER
	MOV	[BP.HEXBUFIRST], DI	; SAVE HEX BUFFER POINTER
HEXINIT:
	MOV	CX, [BP.LEN]		; CX IS THE INPUT COUNTER
	MOV	[BP.FCHAR], 1		; FCHAR = 1 MEANS FIRST CHAR
	AND	[BP.INSTT], NOT TOABORT	; RESET ABORT AND LEAD BIT
	AND	[BP.INSTT], NOT TOLEAD
BIN2ASC:
	MOV	AX, ES			; EXCHANGE DS AND ES
	PUSH	DS
	POP	ES
	MOV	DS, AX
	XCHG	DI, SI			; EXCHANGE DI AND SI
	CALL	BINASC			; CONVERT BINARY TO ASCII
	MOV	AX, ES			; RESUME DS AND ES
	PUSH	DS
	POP	ES
	MOV	DS, AX
	XCHG	DI, SI
	DEC	CX			; DISPLAY (LEN - 1) SPACES
	MOV	BX, [BP.GIFDEV]
	TEST	DX,ECHOM		; ONLY IF ECHO ENABLED
	JZ	HEXCONT
DISSPACE:
	MOV	AL, SP_C
	CALL	DISPCHR
	JNC	NXTSPC
	JMP	HEXRET
NXTSPC:
	LOOP	DISSPACE
DISBUF:
	CALL	DISPASCII
	JNC	HEXCONT			; RETURN IF ERROR OR ABORT CODE SET
	JMP	HEXRET
HEXCONT:
	TEST	DX, OUTPUTM
	JZ	HEXCONT3
	JMP	ASC2BIN
HEXCONT3:
	TEST	[BP.INSTT], TOABORT
	JZ	HEXCONT1
	JMP	ASC2BIN
HEXCONT1:
	MOV	CX, [BP.LEN]
GETCHR:
	MOV	BX, [BP.GIFDEV]
	OR	BX, READOPR
	CALL	ASCII
	PUSHF
	TEST	[BP.INSTT], TOLEAD
	JNZ	LEADHDL
	POPF
	JC	SEARCHCTT
; NOW PUT THE CHARACTER INTO BUFFER
	CMP	[BP.FCHAR], 0		; TEST WHETHER IT IS THE FIRST CHAR
	JE	PUTCONT
; CLEAR THE BUFFER
CLRLP:
	MOV	BYTE PTR [SI], "0"
	INC	SI
	LOOP	CLRLP
	MOV	CX, [BP.LEN]		; RESUME LEN TO CX AND ASCBUF FIRST TO
; SI
	MOV	SI, [BP.ASCBUFIRST]
	MOV	[BP.FCHAR], 0
PUTCONT:
	PUSH	CX
	MOV	CX, [BP.LEN]
	DEC	CX
SHLEFT:					; USE A LOOP TO SHIFT LEFT CHARS IN THE
	INC	SI			; ASCII BUFFER
	MOV	AH, BYTE PTR [SI]
	MOV	BYTE PTR [SI-1], AH
	LOOP	SHLEFT
	MOV	BYTE PTR [SI], AL
	MOV	SI, [BP.ASCBUFIRST]
	POP	CX
	CALL	DISPASCII
	JC	HEXRET
	TEST	DX, INLIMITM
	JZ	GETCHR
	DEC	CX
	JNZ	GETCHR
ASC2BIN:
	MOV	CX, [BP.LEN]
	CALL	ASCBIN
	ADD	SI, CX
	SHR	CX, 1
	ADD	DI, CX
	MOV	AL, [SI-1]
	MOV	BX, [BP.GIFDEV]
	CALL	DISPCHR
	JMP	SHORT HEXRET
LEADHDL:
	MOV	[BP.FCHAR], 0
	POPF

	OR	AL, 80H			; SET BIT 7 OF INPUT CHAR
	AND	[BP.INSTT], NOT TOLEAD	; RESET LEAD BIT
	MOV	DX, [BP.CMD]		; RESTORE COMMAND
SEARCHCTT:
	MOV	[BP.FCHAR], 0
	MOV	BX, [BP.CCTPTR]
	PUSH	CX
	MOV	CX, SS:[BX]
LPSENTRY:
	INC	BX
	INC	BX
	CMP	AL, SS:[BX]
	JNE	CCTNXTENTRY
	MOV	AL, SS:[BX+1]
	JMP	SHORT MATCHED
CCTNXTENTRY:
	LOOP	LPSENTRY
	MOV	AL, 0FFH
MATCHED:
	POP	CX
	CMP	AL, 0FFH
	JNE	HEXCONT2
	JMP	GETCHR
HEXCONT2:
	CMP	AL, SERVERMAX
	JLE	MATCHCONT
	JMP	GETCHR
MATCHCONT:
	XOR	AH, AH
	SHL	AX, 1
	MOV	BX, OFFSET PGROUP:SERVERTAB
	ADD	BX, AX
	JMP	WORD PTR CS:[BX]
HEXRET:
	MOV	BX, [BP.GIFDEV]
	MOV	AX, [BP.CCTPTR]
	MOV	DX, [BP.CMD]
	POP	BP
	LEAVE
	POP	BP
	POP	CX
	RET

HEXIN	ENDP

SERVERTAB DW	OFFSET PGROUP:GETCHR	;IGNORE
	DW	OFFSET PGROUP:ABORT	;ABORT
	DW	OFFSET PGROUP:REINIT	;REINIT
	DW	OFFSET PGROUP:DELETE	;DELETE LAST
	DW	OFFSET PGROUP:CLEAR	;CLEAR
	DW	OFFSET PGROUP:LEAD	;LEAD
	DW	OFFSET PGROUP:EXIT	;EXIT


REINIT:
	CALL	DISPBSPACE
	JNC	REINITCONT
	JMP	HEXRET
REINITCONT:
	JMP	HEXINIT

ABORT:
	CALL	DISPBSPACE
	JNC	ABORTCONT
	JMP	HEXRET
ABORTCONT:
	MOV	CX, [BP.LEN]
	OR	[BP.INSTT], TOABORT
	JMP	BIN2ASC

LEAD:
	OR	[BP.INSTT], TOLEAD
	OR	DX, ASCIIM
	AND	DX, NOT CAPLCK
	JMP	GETCHR

CLEAR:
;	CALL DISPBSPACE
;	JNC CLEARCONT
;	JMP HEXRET
CLEARCONT:
	MOV	CX, [BP.LEN]
LPCLRASCBUF:
	MOV	BYTE PTR [SI], "0"
	INC	SI
	LOOP	LPCLRASCBUF
	MOV	SI, [BP.ASCBUFIRST]
	MOV	CX, [BP.LEN]
	JMP	DISBUF

DELETE:
;	CALL DISPBSPACE
;	JNC DELETECONT
;	JMP HEXRET
DELETECONT:
	PUSH	CX
	MOV	CX, [BP.LEN]
	DEC	CX
	MOV	AH, [SI]
LPSHRASCBUF:
	INC	SI
	XCHG	[SI], AH
	LOOP	LPSHRASCBUF
	POP	CX
	MOV	SI, [BP.ASCBUFIRST]
	MOV	BYTE PTR [SI], "0"
	TEST	DX, INLIMITM
	JNZ	DELCONT
	JMP	DISBUF
DELCONT:
	CMP	CX, [BP.LEN]
	JL	DELCONT1
	JMP	DISBUF
DELCONT1:
	INC	CX
	JMP	DISBUF

EXIT:
	JMP	ASC2BIN



; FUNCTION : TO DISPLAY THE CONTENT OF ASCII BUFFER
; IN : DS:SI POINTING THE ASCII BUFFER
; OUT : NIL, BUT CY IF ERROR
; DESTROYED: NIL

NPROCEDURE DISPASCII
	TEST	DX, ECHOM		; CHECK WHETHER TO ECHO ASCII BUFFER CONTENT
	JZ	DASCIIRET
	PUSH	CX
	PUSH	AX
	CALL	DISPBSPACE
	JNC	DASCIICONT
	JMP	DASCIIRET
DASCIICONT:
	MOV	CX, [BP.LEN]
	TEST	DX, Z2SPM		; TEST WHETHER TO CONVERT LEADING "0" TO SPACE
	JZ	LPDISBUF
	DEC	CX
LPZ2SP:					; USE A LOOP TO CONVERT LEADING "0" TO SPACE
	CMP	BYTE PTR [SI], "0"
	JNE	OUTZ2SP
	MOV	BYTE PTR [SI], SP_C
	INC	SI
	LOOP	LPZ2SP
OUTZ2SP:
	MOV	SI, [BP.ASCBUFIRST]
	MOV	CX, [BP.LEN]
	MOV	BX, [BP.GIFDEV]
LPDISBUF:				; THEN USE A LOOP TO DISPLAY ASCII BUFFER CONTENT
	MOV	AL, [SI]
	CALL	DISPCHR
	JNC	LPNXTDIGIT
	MOV	SI, [BP.ASCBUFIRST]
	JMP	DASCIIRET
LPNXTDIGIT:
	INC	SI
	LOOP	LPDISBUF
	MOV	SI, [BP.ASCBUFIRST]
	TEST	DX, Z2SPM
	JZ	RESUMEALL
	MOV	CX, [BP.LEN]
LPSP2Z:
	CMP	BYTE PTR [SI], SP_C
	JNE	OUTSP2Z
	MOV	BYTE PTR [SI], "0"
	INC	SI
	LOOP	LPSP2Z
OUTSP2Z:
	MOV	SI, [BP.ASCBUFIRST]
RESUMEALL:
	MOV	BX, [BP.GIFDEV]
	MOV	AL, BSP_C
	CALL	DISPCHR
	POP	AX
	POP	CX
DASCIIRET:
	RET
DISPASCII ENDP

; FUNCTION : TO DISPLAY LEN-1 BACKSPACE
; IN : NIL
; OUT : CY WHEN ERROR
; DESTROYED : BX

NPROCEDURE DISPBSPACE

	PUSH	CX
	PUSH	AX
	MOV	CX, [BP.LEN]		; FIRST DISPLAY LEN -1 BACKSPACE
	DEC	CX
	MOV	BX, [BP.GIFDEV]
DISBSPACE:
	MOV	AL, BSP_C
	CALL	DISPCHR
	JC	DISPBSPRET
	LOOP	DISBSPACE
DISPBSPRET:
	POP	AX
	POP	CX
	RET
DISPBSPACE ENDP



PROG	ENDS

END









