TITLE	GIFDIC Init Module

pgroup	group prog
dgroup	group data


; MSDOS Function
opndev	equ 3dh
iodev	equ 2
rdkey	equ 8
clsdev	equ 3eh
rddev	equ 3fh
wrdev	equ 40h

; GIFSYS99 Device
sysinit	equ 0
sysprom	equ 1
sysmap	equ 2

; Constant
caps	equ 0dfh
maxdrv	equ 7
parm	equ 80h



data	segment word public 'data'

; GIAT
syscmd	label byte
db sysinit	; GIFSYS99 init
db sysprom	; PROM info.
db giatl	; Word count
dd dgroup:giat	; Buffer
giatcnt	equ $-syscmd

giat	label word
	dw ?
	dw ?
prompg	dw ?
	dw ?
gifdicc	dw ?
giatl	equ ($-giat)/2

; GIFSYS99 Device
sysname	db 'GIFSYS99', 0

; GIFDIC Call
public	gifdic
gifdic	label dword
gfdloc	dw ?
gfdseg	dw ?

data	ends

prog	segment byte public 'prog'
	assume cs:pgroup, ds:dgroup, es:dgroup


; SCANDRV	Scan the parameter area in offset 80h from ES
;		for Drive Specification (' X:' where X is the drive
;		name).
;	Input	: ES - Program Prefix
;	Output	: AL - Drive Number if found
;		  CY - Set if Not found (AL=FF)
;	Destroy	: None
public	scandrv
scandrv	proc near
	push	cx
	push	di
	mov	di, parm
	xor	cx, cx
	mov	cl, [di]
	jcxz	sderr
	mov	al, ':'
	inc	di
	repne	scasb
	je	sd1
sderr:
	mov	al, -1
	jmp	short sdexit
sd1:
	cmp	byte ptr [di-3], ' '
	jne	sderr
	mov	al, [di-2]
	and	al, caps
	sub	al, 'A'
	jl	sderr
	cmp	al, maxdrv
	jg	sderr
sdexit:
	cmp	al, -1
	cmc
	pop	di
	pop	cx
	ret
scandrv	endp


; OPNSYS	Open GIFSYS99 device
;	Input	: None
;	Output	: BX - GIFSYS99 Handle if OK
;		  CY - Set if error
;	Destroy	: None
public	opnsys
opnsys	proc near
	push	ax
	push	cx
	push	dx
	mov	ah, opndev
	mov	al, iodev
	mov	dx, offset ds:sysname
	int	21h
	jc	osexit
	mov	bx, ax
; Write GIFSYS99
	mov	ah, wrdev
	mov	dx, offset ds:syscmd
	mov	cx, giatcnt
	int	21h
	jc	osexit
; GIFDIC Entry
	mov	ax, gifdicc
	mov	gfdloc, ax
	mov	ax, prompg
	mov	gfdseg, ax
osexit:
	pop	dx
	pop	cx
	pop	ax
	ret
opnsys	endp


; DRVCVT	Drive Convertion From MS-DOS to GIFDIC
;	Input	: AL - MSDOS Drive
;		  BX - GIFSYS99 Handle
;	Output	: AL - GIFDIC Drive if OK (Bit 7 - Hard Flag)
;		  CY - Set if error
;	Destroy	: AH
public	drvcvt
drvcvt	proc near
	push	cx
	push	dx
	mov	syscmd, sysmap
	mov	syscmd[1], al
	mov	dx, offset ds:syscmd
	mov	ah, wrdev
	mov	cx, 2
	int	21h
	jc	dcexit
	mov	ah, rddev
	mov	cx, 1
	int	21h
	jc	dcexit
	mov	al, syscmd
dcexit:
	pop	dx
	pop	cx
	ret
drvcvt	endp


; CLOSYS	Close GIFSYS99 Device
;	Input	: BX - GIFSYS99 Handle
;	Output	: CY - Set if error
;	Destroy	: None
public	closys
closys	proc near
	push	ax
	mov	ah, clsdev
	int	21h
	pop	ax
	ret
closys	endp


prog	ends

end
