TITLE	ASCII	CHARACTER INPUT

PGROUP	GROUP	PROG
DGROUP	GROUP	DATA

INCLUDE	\GIFI\SRC\GIFMAC.MAC

A	EQU	(1 SHL 0)
CPSLCK	EQU	(1 SHL 1)
DATA	SEGMENT	WORD PUBLIC 'data'
	ASSUME	DS:DGROUP
DATA	ENDS


PROG	SEGMENT	BYTE PUBLIC 'prog'
	ASSUME	CS:PGROUP
EXTRN	GIFDIC:FAR

;	DESTROYED : AH (THOSE DESTROYED BY GIFDIC SHOULD BE SAVED)
PUBLIC	ASCII
ASCII	PROC	NEAR
	PUSH	DX
	MOV	AH, WAITRDY
; SAVE REGISTERS DESTROYED BY GIFDIC
	CALL	GIFDIC
; RESTORE REGISTERS

	CMP	AL, 7FH
	JGE	ASCERR

	TEST	DL, A
	JZ	NUMOD
; ASCII MODE
	TEST	DL, CPSLCK
	JZ	ASCOK
	CALL	CAPSLOCK
ASCOK:
	CLC
ASCEXIT:
	POP	DX
	RET

ASCERR:
	STC
	JMP	ASCEXIT

NUMJMP	LABEL	WORD
DW	BIN
DW	OCT
DW	DEC
DW	HEX

; NUMERIC
NUMOD:
	CMP	AL, '0'
	JL	ASCERR
	CALL	CAPSLOCK
	AND	DX, 7			; RIGHTMOST 3 BITS
	MOV	BX, DX
	JMP	CS:[BX.NUMJMP]

BIN:
	CMP	AL, '1'
	JG	ASCERR
	JMP	ASCOK

OCT:
	CMP	AL, '7'
	JG	ASCERR
	JMP	ASCOK

DEC:
	CMP	AL, '9'
	JG	ASCERR
	JMP	ASCOK

HEX:
	CMP	AL, '9'
	JLE	ASCOK
	CMP	AL, 'A'
	JL	ASCERR
	CMP	AL, 'F'
	JG	ASCERR
	JMP	ASCOK
ASCII	ENDP

CAPSLOCK PROC	NEAR
	CMP	AL, 'a'
	JL	NOCL
	CMP	AL, 'z'
	JG	NOCL
	SUB	AL, 'a'-'A'
NOCL:
	RET
CAPSLOCK ENDP

PROG	ENDS


END

	