	TITLE	'TSC 8080 TEXT EDITING SYSTEM (F)'
	PAGE	54
*
* TSC 8080 TEXT EDITING SYSTEM
*
* COPYRIGHT (C) 1978 BY
* TECHNICAL SYSTEMS CONSULTANTS, INC.
* BOX 2574 W. LAFAYETTE, IN 47906
*
	ORG	100H

START	JMP	INITZ
RSTRT	JMP	PEDIT

* EXTERNAL I/O ROUTINES

INCH	PUSH	H		;INPUT CHARACTER ROUTINE
	PUSH	D		;SAVE REGISTERS
	PUSH	B
	MVI	C,1		;READ CONSOLE FUNCTION
	CALL	BDOS
	PUSH	PSW
	CPI	08		;BACKSPACE ?
	JZ	EBCKSP		;ECHO IF SO
	CPI	18H		;CANCEL ?
	JNZ	INCH1		;SKIP IF NOT
	LXI	H,CNECHO	;ECHO CANCEL
	JMP	ECHO
EBCKSP	LXI	H,BSECHO	;BACKSPACE ECHO
ECHO	CALL	PDATA
INCH1	POP	PSW
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	RET

OUTCH	PUSH	H		;OUTPUT CHARACTER ROUTINE
	PUSH	D		;SAVE REGISTERS
	PUSH	B
	PUSH	PSW
	MOV	E,A
	MVI	C,2		;WRITE CONSOLE FUNCTION
	CALL	BDOS
	POP	PSW
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	RET

WARMS	LDA	LOGDR		;GET DRIVE WHICH WAS
	MOV	E,A		;LOGGED IN ON ENTRY
	MVI	C,SLECTF	;SELECT DRIVE
	CALL	BDOS
	JMP	0000		;REBOOT DOS

* CHECK FOR INPUT FROM TERMINAL

CHKIN	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	MVI	C,11		;CONSOLE READY FUNCTION
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	RAR			;GET STATUS INTO CARRY
	RNC
	CALL	INCH		;GET CHAR IF READY
	STC
	RET

* DISK EQUATES

SLECTF	EQU	14
OPENF	EQU	15
CLOSEF	EQU	16
DELETF	EQU	19
READF	EQU	20
WRITEF	EQU	21
MAKEF	EQU	22
RENAMF	EQU	23
IDNF	EQU	25
SDMAF	EQU	26
BDOS	EQU	0005
TBUFF	EQU	0080H

* COMMAND TABLE

TABLE	DB	'APPEND'
	DB	0
	DW	APEND
	DB	'ABORT'
	DB	0
	DW	ABORT
	DB	'A'
	DB	0
	DW	APEND
	DB	'BOTTOM'
	DB	0
	DW	BOTTM
	DB	'B'
	DB	0
	DW	BOTTM
	DB	'CCHANGE'
	DB	0
	DW	CCHNG
	DB	'CHANGE'
	DB	0
	DW	CHNGE
	DB	'COPY'
	DB	0
	DW	COPY
	DB	'CO'
	DB	0
	DW	COPY
	DB	'CC'
	DB	0
	DW	CCHNG
	DB	'C'
	DB	0
	DW	CHNGE
	DB	'DELETE'
	DB	0
	DW	DLETE
	DB	'D'
	DB	0
	DW	DLETE
	DB	'EXPAND'
	DB	0
	DW	EXPND
	DB	'EXP'
	DB	0
	DW	EXPND
	DB	'FIND'
	DB	0
	DW	CFIND
	DB	'F'
	DB	0
	DW	CFIND
	DB	'HEADER'
	DB	0
	DW	HEADR
	DB	'H'
	DB	0
	DW	HEADR
	DB	'INSERT'
	DB	0
	DW	INSRT
	DB	'I'
	DB	0
	DW	INSRT
	DB	'LOG'
	DB	0
	DW	DEXIT
	DB	'MERGE'
	DB	0
	DW	MERGE
	DB	'MOVE'
	DB	0
	DW	MOVE
	DB	'MO'
	DB	0
	DW	MOVE
	DB	'NEW'
	DB	0
	DW	NEW
	DB	'NEXT'
	DB	0
	DW	NEXT
	DB	'NUMBERS'
	DB	0
	DW	NMSET
	DB	'NU'
	DB	0
	DW	NMSET
	DB	'N'
	DB	0
	DW	NEXT
	DB	'OVERLAY'
	DB	0
	DW	OVRLY
	DB	'O'
	DB	0
	DW	OVRLY
	DB	'PRINT'
	DB	0
	DW	PRINT
	DB	'P'
	DB	0
	DW	PRINT
	DB	'READ'
	DB	0
	DW	READ
	DB	'RENUMBER'
	DB	0
	DW	RENUM
	DB	'REN'
	DB	0
	DW	RENUM
	DB	'REPLACE'
	DB	0
	DW	RPLCE
	DB	'R'
	DB	0
	DW	RPLCE
	DB	'SET'
	DB	0
	DW	SETCM
	DB	'STOP'
	DB	0
	DW	DEXIT
	DB	'S'
	DB	0
	DW	DEXIT
	DB	'TAB'
	DB	0
	DW	TAB
	DB	'TOP'
	DB	0
	DW	TOP
	DB	'T'
	DB	0
	DW	TOP
	DB	'VERIFY'
	DB	0
	DW	VRSET
	DB	'V'
	DB	0
	DW	VRSET
	DB	'WRITE'
	DB	0
	DW	WRITE
	DB	'W'
	DB	0
	DW	WRITE
	DB	'X'
	DB	0
	DW	XCTRL
	DB	'ZONE'
	DB	0
	DW	SZONE
	DB	'Z'
	DB	0
	DW	SZONE
	DB	'USER'
	DB	0
	DW	CLRED
	DB	0

* ON/OFF TABLE

ONOFT	DB	'ON'
	DB	0
	DW	ON
	DB	'OFF'
	DB	0
	DW	OFF
	DB	0

* SPECIAL CHARACTER TABLE

CHRTB	DB	'TAB'
	DB	0
	DW	TABCH
	DB	'FILL'
	DB	0
	DW	FILL
	DB	'EOL'
	DB	0
	DW	EOL
	DB	'LINO'
	DB	0
	DW	LINO
	DB	'DCC'
	DB	0
	DW	DCCHR
	DB	'CRC'
	DB	0
	DW	CRC
	DB	0

* PRINT STRINGS

CRLF	DB	0DH,0AH,04,00,00,00,00
TSCED	DB	'TSC Text Editor',04
NEWFL	DB	'NEW FILE:',04
ERRST	DB	'ILLEGAL COMMAND',04
NFNDS	DB	'NO SUCH LINE',04
SNTXS	DB	'SYNTAX ERROR',04
NONES	DB	'STRING '
CFNDS	DB	'NOT FOUND',04
ZOKST	DB	'...ZONES OK?',04
NRCHS	DB	'TARGET NOT REACHED!',04
	DB	'YOU SURE? ',04
NLDLS	DB	'NO LINES DELETED',04
CCHGS	DB	'CHANGE? ',04
BFRST	DB	'BOTTOM OF FILE REACHED',04
OVRLS	DB	' OVERLAY ',04
OVLPS	DB	'SOURCE OVERLAPS DESTINATION',04
RENOS	DB	'SOME LINES RENUMBERED',04
NORMS	DB	'NOT ENOUGH ROOM',04
CCSTR	DB	00,00,00,00,00,00,04

* DISK PRINT STRINGS

BSECHO	DB	08,04,00,00,00
CNECHO	DB	07,04,00,00,00
EXT	DB	'TXT '
CLRFCB	DB	0,'           ',00,00,00,00

DELBAK	DB	'DELETE BACKUP FILE (Y-N)? ',04
OPTERR	DB	'OPTION ERROR',04
NSFERR	DB	'FILE NOT FOUND',04
NFEERR	DB	'NEW '
FEERR	DB	'FILE EXISTS',04
NDSERR	DB	'NO DIRECTORY SPACE',04
DFERR	DB	'DISK FULL',04
OFERR	DB	'OPEN FILE ERROR',04
IFSERR	DB	'ILLEGAL FILE SPECIFICATION',04
MSNERR	DB	'MUST SPECIFY NEW FILE',04
CERR	DB	'CLOSE ERROR',04
WERR	DB	'WRITE ERROR',04
RERR	DB	'READ ERROR',04


* PRINT ROUTINES

OUTSP	MVI	A,20H		;PRINT A SPACE
	JMP	OUTCH
PCRLF	PUSH	H		;SAVE H AND L
	LXI	H,CRLF
	CALL	PDATA		;PRINT CR AND LF
	POP	H		;RESTORE H AND L
	RET
PSNXT	INX	H
PSTRG	CALL	PCRLF
PDATA	MOV	A,M		;GET A CHARACTER
	CPI	04		;IS IT EOT ?
	RZ
	CALL	OUTCH		;IF NOT, PRINT CHARACTER
	INX	H
	JMP	PDATA		;DO NEXT

* INITIALIZATION ROUTINE

INITZ	LXI	H,0000
	DAD	SP		;GET CURRENT STACK PTR
	SHLD	OLDSP		;SAVE IT
	LXI	SP,STACK	;SETUP NEW STACK
	LXI	H,TSCED		;PRINT HEADER
	CALL	PSTRG
	CALL	PCRLF
	LHLD	BEGPT
	SHLD	FLBEG		;SET FILE BEGIN POINTER
	SHLD	FLEND		;SET FILE END POINTER
	LXI	H,0001
	SHLD	ZONE1		;SETUP ZONES
	LXI	H,0136
	SHLD	ZONE2
	MVI	A,70
	STA	HEDCT		;SET DEFAULT HDR COUNT
	XRA	A
	STA	TABBF		;INITIALIZE TAB BUFFER
	DCR	A
	STA	INZFL		;SET FLAGS
	STA	NUMFG
	STA	VERFG
DEDIT	XRA	A
	STA	ALLIN		;CLEAR FLAGS
	STA	INZFL
	STA	DOPT
	CMA			;SET BUFFER POINTERS
	STA	NEWBUF
	MVI	A,7FH
	STA	OLDBUF
	MVI	A,07		;SET DEFAULT FILL PERCENT
	STA	SOPT
	MVI	C,IDNF		;GET LOGGED DRIVE
	CALL	BDOS
	STA	LOGDR		;SAVE IT
	LXI	H,CLRFCB	;INITIALIZE NEW FCB
	LXI	D,NEWFCB
	CALL	XFR16
	LXI	H,TBUFF		;FIND END OF COMMAND
	MOV	A,M
	INX	H
	PUSH	H
	CALL	ADAHL
	MVI	M,0DH		;INSERT CARRIAGE RETURN
	POP	H
	CALL	SKIP		;SKIP SPACES
	LXI	D,OLDFCB
	CALL	GETFN		;GET FILE NBR 1 SPEC
	JC	ILLFL		;EXIT IF ERROR
	CALL	SKIP
	CPI	0DH
	JZ	DEDIT0		;SKIP IF CARRIAGE RETURN
	CPI	'['		;START OF OPTIONS ?
	JZ	PARSE2		;SKIP IF SO
	LXI	D,NEWFCB
	CALL	GETFN		;GET FILE NBR 2 SPEC
	JC	ILLFL		;EXIT IF ERROR
	CALL	SKIP
	CPI	0DH
	JZ	DEDIT0		;SKIP IF RETURN
	CPI	'['		;START OF OPTIONS ?
	JZ	PARSE2		;SKIP IF SO
	LXI	H,SNTXS		;ELSE, A SYNTAX ERROR
	JMP	PREXIT
PARSE2	INX	H
	MOV	A,M		;GET NEXT CHAR
	CPI	0DH
	JZ	DEDIT0		;SKIP IF CARRIAGE RETURN
	CPI	']'
	JZ	DEDIT0		;OR IF END OF OPTIONS
	CALL	VALID1		;CHECK CHAR
	JNC	ILLOPT		;EXIT IF INVALID
	CPI	'D'		;DELETE OPTION ?
	JNZ	PARSE3
	STA	DOPT		;IF SO SET THAT OPTION
	JMP	PARSE2		;LOOP BACK
PARSE3	SUI	'0'
	CPI	08		;A DIGIT FROM 0-7 ?
	JNC	ILLOPT		;ERROR IF NOT
	STA	SOPT		;SET BUFFER FILL PERCENT
	JMP	PARSE2		;LOOP BACK
ILLOPT	LXI	H,OPTERR	;REPORT OPTION ERROR
	JMP	PREXIT
ILLFL	LXI	H,IFSERR	;REPORT ILLEGAL FILE SPEC
	JMP	PREXIT
DEDIT0	LHLD	BDOS+1		;GET AVBL MEMORY SIZE
	DCX	H
	SHLD	MMEND		;SAVE MEMORY END
	LDA	BEGPT+1
	MOV	B,A		;FIND ONE-EIGHTH SIZE
	MOV	A,H		;OF BUFFER SPACE
	SUB	B
	RRC
	RRC
	RRC
	ANI	1FH
	STA	SIZE		;SAVE IT AS SIZE

* NOW CHECK FOR FILE NBR 1

DEDIT2	LXI	D,OLDFCB
	CALL	OPEN		;OPEN FILE NBR 1
	CPI	-1
	JZ	DEDIT7		;JUMP IF NOT FOUND
	LDA	NEWFCB+1	;IS FILE NBR 2 SPECIFIED ?
	CPI	20H
	JZ	DEDIT3		;SKIP IF NOT
	LXI	D,NEWFCB
	CALL	OPEN		;OPEN FILE NBR 2
	CPI	-1
	JZ	DEDIT9		;PROCEED IF NOT THERE
	LXI	H,NFEERR	;ELSE, REPORT FILE EXISTS
PREXIT	CALL	PSTRG
PEXIT1	LDA	LOGDR		;GET DRIVE WHICH WAS
	MOV	E,A		;LOGGED IN ON ENTRY
	MVI	C,SLECTF	;SELECT IT
	CALL	BDOS
	LHLD	OLDSP
	SPHL			;RESTORE OLD STACK PTR
	RET

* AT THIS POINT, (FILE1) EXISTS WHILE NO (FILE2) WAS
* SPECIFIED. WE MUST NOW CHECK FOR A BACKUP FILE OF
* THE SAME NAME AS (FILE1).

DEDIT3	LXI	H,OLDFCB+9	;CHECK TO SEE IF
	MOV	A,M		;FILE NBR 1 HAS A .BAK EXT
	CPI	'B'
	JNZ	DEDIT4
	INX	H
	MOV	A,M
	CPI	'A'
	JNZ	DEDIT4
	INX	H
	MOV	A,M
	CPI	'K'
	JNZ	DEDIT4
	LXI	H,MSNERR	;AN ERROR IF SO
	JMP	PREXIT
DEDIT4	CALL	OLDNEW		;COPY FILENAME INTO FCB
	LXI	H,NEWFCB+9
	MVI	M,'B'		;CHANGE EXTENSION TO .BAK
	INX	H
	MVI	M,'A'
	INX	H
	MVI	M,'K'
	LDA	OLDFCB+33
	STA	NEWFCB+33	;SET DRIVE NBR
	LDA	DOPT		;AUTO DELETE ?
	ORA	A
	JNZ	DEDIT5		;SKIP IF SO
	LXI	D,NEWFCB
	CALL	OPEN		;IS BAK FILE ON DISK ?
	CPI	-1
	JZ	DEDIT5		;SKIP IF NOT
	LXI	H,DELBAK
	CALL	PSTRG		;ASK TO DELETE BACKUP
	CALL	INCH		;GET RESPONSE
	ANI	5FH		;ENSURE UPPER CASE
	CPI	'Y'
	JNZ	PEXIT1		;EXIT IF NOT YES
DEDIT5	LXI	D,NEWFCB
	CALL	SELECT
	MVI	C,DELETF	;DELETE EXISTING BAK
	CALL	BDOS

* RENAME OLD FILE TO .BAK AND SET NEW FILE TO OLD NAME

	LXI	H,NEWFCB	;SETUP FOR A RENAME
	LXI	D,OLDFCB+16
	CALL	XFR16
	CALL	OLDNEW		;COPY NEW FILENAME
	LXI	D,OLDFCB
	MVI	C,RENAMF	;RENAME OLD FILE
	CALL	BDOS
	LXI	H,OLDFCB+16
	LXI	D,OLDFCB	;FIX OLD FCB
	CALL	XFR16
	LXI	D,OLDFCB
	CALL	OPEN		;OPEN RENAMED FILE
	CPI	-1
	JNZ	DEDIT9
	LXI	H,OFERR		;REPORT OPEN ERROR
	JMP	PREXIT

* HERE (FILE1) WAS SPECIFIED BUT NOT FOUND

DEDIT7	LDA	NEWFCB+1	;WAS FILE NBR 2 SPECIFIED ?
	CPI	20H
	JZ	DEDIT8		;SKIP IF NOT
	LXI	H,NSFERR	;FILE NOT FOUND ERROR
	JMP	PREXIT
DEDIT8	CALL	OLDNEW		;COPY NEW FILE NAME
	LDA	OLDFCB+33
	STA	NEWFCB+33	;SET DRIVE NBR
	MVI	A,1
	STA	ALLIN
	STA	INZFL
	LXI	H,NEWFL		;PRINT NEW FILE MESSAGE
	CALL	PSTRG

* CREATE THE NEW FILE

DEDIT9	LXI	D,NEWFCB
	MVI	C,MAKEF		;MAKE NEW FILE
	CALL	BDOS
	CPI	-1
	JNZ	DEDITA
	LXI	H,NDSERR	;NO SPACE ERROR
	JMP	PREXIT
DEDITA	XRA	A
	STA	OLDFCB+32	;CLEAR NEXT RECORD BYTES
	STA	NEWFCB+32
	LDA	SOPT
	LHLD	FLBEG		;SET POINTERS
	SHLD	NEWPS
	JMP	NEW2		;GO FILL BUFFER

* RESTART ENTRY POINT

PEDIT	MVI	A,1		;DISABLE COMMAND REPEAT
	STA	CMRPT
	LHLD	FLBEG		;SETUP CURRENT POSITION
REDT1	SHLD	CURPS

* CLEAR MULTIPLE STATEMENTS PER LINE FLAG AND EDIT

CLRED	XRA	A		;CLEAR MSPL FLAG
	STA	MSPLF
	JMP	EDIT		;GO EDIT

* CHECK FOR MULTIPLE STATEMENTS PER LINE AND EDIT

CHKED	CALL	CKMSL		;CHECK FOR MSPL

* MAIN EDIT LOOP

EDIT	LXI	SP,STACK	;SETUP STACK
	PUSH	H		;SAVE POINTER
	LHLD	CURPS
	SHLD	NEWPS
	LXI	D,CHRCT+1	;CLEAR STORAGE AREA
	LXI	H,PSTZF
EDIT1	MVI	M,0		;CLEAR A BYTE
	INX	H
	CALL	CMPDH		;AT END OF AREA ?
	JNZ	EDIT1		;LOOP IF NOT
	POP	H		;RESTORE POINTER
	LDA	INZFL
	ORA	A		;JUST STARTED EDITOR ?
	JZ	EDIT2		;SKIP IF NOT
	XRA	A
	STA	INZFL		;IF SO, CLEAR FLAG
	JMP	INSR4		;GO INSERT
EDIT2	LDA	MSPLF		;MULTIPLE STATEMENTS ?
	ORA	A
	JNZ	EDIT5		;SKIP IF SO
	STA	CHRCT+1		;IF NOT, CLEAR CHAR COUNT
	CALL	PCRLF		;PRINT CR AND LF
	LXI	H,BUFFR		;POINT TO BUFFER
	LDA	PRMPT
	CALL	OUTCH		;OUTPUT PROMPT
EDT28	LDA	RPTCH		;GET REPEAT CHAR
	MOV	B,A
	CALL	INCH		;GET INPUT CHAR
	CMP	B		;IS IT REPEAT CHAR ?
	JZ	EDT29		;SKIP IF SO
	MOV	D,A		;IF NOT, GO INTO
	LDA	BCKSP		;NORMAL INPUT MODE
	MOV	B,A
	MOV	A,D
	CALL	INP15
	JMP	EDT31		;THEN SKIP
EDT29	LDA	CMRPT		;IS REPEAT ENABLED ?
	ORA	A
	JNZ	ERROR		;IF NOT, REPORT ERROR
	JMP	EDIT4		;IF SO WE'VE GOT COMMAND
EDIT3	CALL	INPUT		;GET INPUT CHAR
EDT31	JZ	EDIT		;REPEAT IF A DELETE
	MOV	M,A		;PUT INTO BUFFER
	CPI	0DH		;IS IT CARRIAGE RETURN ?
	JZ	EDIT4		;EXIT LOOP IF SO
	CALL	BUFLM		;CHECK FOR BUFFER OVERFLOW
	JMP	EDIT3		;LOOP BACK
EDIT4	LXI	H,BUFFR
	SHLD	BUFPT		;SET BUFFER POINTER
	XRA	A
	STA	CMRPT		;ENABLE COMMAND REPEAT
EDIT5	XRA	A
	STA	MSPLF		;CLEAR MSPL FLAG
	CALL	FINDL		;GET COMMAND START LINE
	XRA	A
	STA	LINEF		;CLEAR FLAGS
	STA	DRCTN
	SHLD	NEWPS		;MAKE IT NEW POSITION
	LHLD	BUFPT
	CALL	SKPSP		;SKIP SPACES
	SHLD	BUFPT		;SAVE POINTER
	CPI	'='		;EQUALS COMMAND ?
	JNZ	EDIT6		;SKIP IF NOT
	INX	H		;IF SO BUMP BUFFER PTR
	SHLD	BUFPT
	LXI	H,EQULS
	JMP	EDIT8		;JUMP TO EQUALS COMMAND
EDIT6	CALL	CKEND		;NULL COMMAND ?
	JNZ	EDIT7		;SKIP IF NOT
	LXI	H,PRINT
	JMP	EDIT8		;IF SO JUMP TO PRINT
EDIT7	SHLD	TEMP		;SAVE POINTER
	LXI	D,TABLE		;POINT TO COMMAND TABLE
NXTLT	LDAX	D		;SEARCH THRU THE TABLE
	ORA	A		;FOR THE COMMAND
	JZ	GOTCM
	CMP	M		;DO LETTERS MATCH ?
	JZ	MATCH		;SKIP IF SO
	ADI	20H		;CHECK LOWER CASE ALSO
	CMP	M		;DO THEY MATCH ?
	JNZ	NXTCM		;IF NOT, NEXT COMMAND
MATCH	INX	H		;POINT TO NEXT LETTER
	INX	D
	JMP	NXTLT		;LOOP BACK
NXTCM	INX	D
	LDAX	D
	ORA	A		;IS THE NEXT A ZERO ?
	JNZ	NXTCM		;IF NOT, NEXT COMMAND
	INX	D		;IF SO, PASS UP ADDRESS
	INX	D
	INX	D
	LDAX	D		;GET NEXT CHAR
	ORA	A		;CHECK FOR ZERO
	JZ	ERROR		;ERROR IF CMD NOT FOUND
	LHLD	TEMP		;RESTORE POINTER
	JMP	NXTLT
GOTCM	SHLD	BUFPT		;IF FOUND, GET THE
	XCHG			;COMMAND'S ADRS INTO
	INX	H		;THE H/L REGISTER
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	LXI	D,INSRT
	CALL	CMPDH		;IS COMMAND INSERT ?
	JNZ	EDIT8		;SKIP IF NOT
	LDA	INTOP		;IF SO CHK FOR 'IN TOP'
	ORA	A
	JNZ	EDIT9		;SKIP IF SET
EDIT8	CALL	CKOVR		;OVER FILE LIMITS ?
	JNZ	NTFND		;IF SO, REPORT ERROR
	XRA	A
	STA	OVRBG		;ELSE, CLEAR FLAGS
	STA	OVRED
EDIT9	LDA	SETON		;ENTERED FROM SET CMD ?
	ORA	A
	JNZ	SETC		;IF SO, JUMP TO SET
	PCHL			;ELSE JUMP TO COMMAND

* ERROR ROUTINE

ERROR	LXI	H,ERRST		;REPORT ILLEGAL

* PRINT ERROR ROUTINE

PRERR	CALL	PSTRG		;PRINT STRING
	STA	CMRPT		;DISABLE COMMAND REPEAT
	JMP	CLRED		;CLEAR AND EDIT

* SYNTAX ERROR ROUTINE

SYNTX	LXI	H,SNTXS		;REPORT SYNTAX ERROR
	JMP	PRERR

* REPORT LINE NOT FOUND

NTFND	LXI	H,NFNDS		;NO SUCH LINE
	JMP	PRERR

* REPORT STRING NOT FOUND

NONEF	LXI	H,NONES		;STRING NOT FOUND
	JMP	PRERR

* SKIP SPACES ROUTINE
* USES A,H,L

SKPSP	MOV	A,M		;GET CHARACTER
	CPI	20H		;IS IT A SPACE ?
	RNZ			;RETURN IF NOT
	INX	H		;ELSE, GET NEXT
	JMP	SKPSP

* INPUT AND CHECK CHARACTER
* USES A,B,D,E,H,L

INPUT	LDA	BCKSP		;SETUP BACKSPACE
	MOV	B,A
INPT1	CALL	INCH		;GET CHARACTER
INP15	CMP	B		;IS IT BACKSPACE ?
	JNZ	INPT2		;IF NOT, CONTINUE
	LXI	D,BUFFR
	CALL	CMPDH
	JZ	INPT4
	DCX	H		;ELSE, BACKUP ONE
	CALL	DCRCH
	JMP	INPT1
INPT2	MOV	B,A
	LDA	DELET
	CMP	B		;IS IT A DELETE ?
	JZ	INPT4		;IF SO, EXIT
	MVI	A,1FH
	CMP	B		;A CONTROL CHARACTER ?
	JC	INPT3		;IF NOT, IT'S GOOD
	MVI	A,0DH		;CARRIAGE RETURN
	CMP	B
	JZ	INPT3		;CR IS GOOD
	MVI	A,09H
	CMP	B		;ALSO, A TAB CHAR
	JNZ	INPUT		;ELSE, GET ANOTHER
INPT3	LDA	CHRCT+1		;INCREMENT CHAR COUNT
	INR	A
	STA	CHRCT+1
	MOV	A,B		;PUT CHAR INTO A
	RET
INPT4	MVI	A,1
	STA	CMRPT		;DISABLE COMMAND REPEAT
	XRA	A		;CLEAR ZERO FLAG
	RET

* CHECK FOR BUFFER OVERFLOW
* USES A,B,D,E,H,L

BUFLM	INX	H
	LXI	D,BUFFR+136
	CALL	CMPDH		;AT END OF BUFFER ?
	RNZ			;RETURN IF NOT
	LDA	BCKSP
	MOV	B,A
OVER	LDA	BELL		;IF SO, RING BELL
	CALL	OUTCH
	CALL	INCH		;GET CHARACTER
	CMP	B
	JNZ	OVER		;LOOP IF NOT BACKSPACE
	DCX	H
DCRCH	LDA	CHRCT+1		;DECREMENT CHAR COUNT
	DCR	A
	STA	CHRCT+1
	RET

* PROCESS LINE ROUTINE

FINDL	CALL	SKPSP		;SKIP SPACES
	CPI	'='		;EQUALS ?
	JZ	FNDL0
	MVI	A,1		;IF NOT, SET FLAG
	STA	LINEF
	CALL	CLASS		;CLASSIFY CHARACTER
	JZ	TGT1
	JM	TARGT
FNDL0	LHLD	NEWPS		;SET POSITION
	RET

* TARGET ENTRY POINT

FINDT	CALL	FNDT0		;GET TARGET
	SHLD	TRGLN		;STORE IT
	RET
FNDT0	XRA	A		;SET FORWARD DIRECTION
	STA	DRCTN
	CALL	SKCLS		;CLASSIFY NEXT CHAR
	JZ	TGT9		;JUMP IF A NUMBER
	JP	SYNTX		;ERROR IF A LETTER
TARGT	XRA	A
	STA	DRCTN		;SET FORWARD DIRECTION
	LDA	LINO
	CMP	M		;IS IT LINO ?
	JNZ	TGT4
	INX	H
	CALL	SKPSP		;IF SO, POINT TO NEXT
	SHLD	BUFPT
TGT1	CALL	BCDCV		;GET NUMBER
	XCHG
	LHLD	NEWPS
	LDA	NUMBR		;COMPARE NUMBER TO PRESENT
	CMP	M		;POSITION IN FILE
	JNZ	TGT2
	INX	H
	LDA	NUMBR+1
	CMP	M
	JNZ	TGT2
	INX	H
	LDA	NUMBR+2
	CMP	M
TGT2	JNC	TGT3		;SET DIRECTION ACCORDINGLY
	MVI	A,1
	STA	DRCTN
TGT3	XCHG
	CALL	FNDNO		;FIND THE LINE
	RZ
	STA	NOCRL		;LINE NOT FOUND
	JMP	BKONE
TGT4	LHLD	BUFPT		;RESTORE POINTER
	CALL	CKEND		;CHECK NEXT CHAR FOR CR
	JNZ	TGT5
	LHLD	NEWPS		;IF SO, SET POSITION
	LDA	NXTFG
	ORA	A
	RZ			;AND RETURN
	JMP	UPONE
TGT5	CPI	'^'		;TOP-OF-FILE DESIGNATOR ?
	JNZ	TGT6
	MVI	A,1
	STA	DRCTN		;IF SO, SET DIRECTION
	INX	H
	SHLD	BUFPT
	LHLD	FLBEG		;POINT TO TOP-OF-FILE
	RET
TGT6	CPI	21H		;(EXCLAIM) BOTTOM-OF-FILE CHAR ?
	JNZ	TGT7
	INX	H
	SHLD	BUFPT
	LHLD	FLEND		;POINT TO BOTTOM-OF-FILE
	JMP	BKONE		;BACKUP AND RETURN
TGT7	CPI	'+'		;FORWARD IN FILE ?
	JZ	TGT8
	CPI	'-'		;BACKWARD IN FILE ?
	JNZ	TGT12
	MVI	A,1		;SET DIRECTION
	STA	DRCTN
TGT8	INX	H
	CALL	SKCLS		;CLASSIFY NEXT CHAR
	JZ	TGT9		;JUMP ACCORDINGLY
	JM	TGT12
	LDA	LINEF		;CHECK LINE FLAG
	ORA	A
	JZ	SYNTX		;SYNTAX ERROR
	CALL	CLRNO
	LHLD	NEWPS		;SET POSITION
	JMP	TGT11
TGT9	CALL	BCDCV		;GET NUMBER
	LHLD	NEWPS
	LDA	LINEF
	ORA	A		;CHECK LINE FLAG
	JNZ	TGT10
	CALL	CKNUM		;CHECK NUMBER
	RZ			;RETURN IF ZERO
	CALL	DECNO
TGT10	CALL	CKNUM		;CHECK NUMBER FOR ZERO
	RZ
	CALL	DECNO		;DECREMENT NUMBER
TGT11	CALL	NXTLN		;GO TO NEXT LINE
	CALL	CKOVR		;OVER FILE LIMITS ?
	JZ	TGT10
	LDA	OVRED
	ORA	A
	RNZ			;RETURN IF OVER END
	CALL	CKNUM		;ELSE, IS NUMBER ZERO ?
	RNZ
	MVI	A,1
	STA	INTOP		;IF SO, SET 'IN TOP' FLAG
	RET
TGT12	CALL	STDLM		;SET DELIMITER
	CALL	ZONE		;GET THE ZONES
	LHLD	NEWPS
	CALL	NXTLN		;GO TO NEXT LINE
TGT13	INX	H		;PASS UP LINE NUMBERS
	INX	H
	INX	H
	CALL	FIXZN		;FIX THE FIRST ZONE
TGT14	CALL	DECNO		;DECREMENT COLUMN COUNT
	JZ	TGT17		;JUMP IF AT ZONE 1
	MOV	A,M
	CPI	0DH		;IS CHARACTER CR ?
	JZ	TGT15		;EXIT IF SO
	INX	H		;ELSE, GET NEXT
	JMP	TGT14
TGT15	LDA	CHGFG
	ORA	A		;RETURN IF FROM CHANGE
	RNZ
	INX	H
	CALL	CMPFE		;AT END OF FILE ?
	JNZ	TGT16
	MVI	A,1		;IF SO, SET OVER END FLAG
	STA	OVRED
	RET
TGT16	DCX	H
TG165	DCX	H		;ELSE, GO TO NEXT LINE
	CALL	NXTLN
	CALL	CKOVR		;OVER END LIMITS ?
	RNZ
	JMP	TGT13		;LOOP IF NOT
TGT17	CALL	FIXZN		;RESET THE ZONE
	CALL	STRNG		;GO SEARCH FOR STRING
	LDA	CHGFG
	ORA	A		;RETURN IF FROM CHANGE
	RNZ
	LDA	FOUND		;WAS STRING FOUND ?
	ORA	A
	JZ	TG165		;LOOP IF NOT
	CALL	BKTBG		;BACKUP TO START OF LINE
	SHLD	TRGLN		;SET TARGET LINE
	RET

* SETUP DELIMITERS
* USES A,B,C,H,L

STDLM	MOV	A,M		;GET CHARACTER
	STA	DELIM		;SAVE AS DELIMITER
	MOV	C,A
	MVI	B,0
	INX	H
	SHLD	STRBG		;SAVE STRING BEGIN POINTER
STDL1	CALL	CKEND		;END OF LINE ?
	JZ	STDL2
	CMP	C		;IS IT DELIMITER ?
	JZ	STDL2
	INX	H		;CHECK THE NEXT CHAR
	INR	B		;INCREMENT STRING COUNT
	JMP	STDL1
STDL2	SHLD	STRED		;STRING END POINTER
	CALL	CKEND		;END OF LINE ?
	JZ	STDL3
	INX	H		;IF NOT, BUMP POINTER
STDL3	SHLD	BUFPT		;SAVE BUFFER POINTER
	MOV	A,B
	STA	STRCT		;SAVE STRING COUNT
	RET

* GET THE ZONES
* USES A,B,D,E,H,L

ZONE	XRA	A
	STA	PSTZF		;CLEAR ZONE FLAG
	CALL	CLASS		;CLASSIFY CHAR
	JNZ	ZONEB
	CALL	BCDCV		;GET NUMBER
	LXI	D,ZONE1+1	;POINT TO ZONE 1
	CALL	CPDNR		;COMPARE TO NBR
	JC	ZONEB
	CALL	CMPZ2		;COMPARE ZONE 2
	JNC	ZONEB
	JZ	ZONEB
	MVI	A,1
	STA	PSTZF		;SET ZONE FLAG
ZONEA	LDA	NUMBR		;PUT NBR INTO ZONE BUFFER
	STA	ZONBF+1
	LDA	NUMBR+1
	STA	ZONBF
	RET
ZONEB	LDA	ZONE1		;PUT ZONE 1 INTO ZONE BUFFER
	STA	ZONBF
	LDA	ZONE1+1
	STA	ZONBF+1
	RET

* PUT CORRECT ZONE IN NUMBER
* USES A

FIXZN	LDA	ZONBF+1		;PUT CONTENTS OF ZONE
	STA	NUMBR		;BUFFER INTO NUMBER
	LDA	ZONBF
	STA	NUMBR+1
	RET

* COMPARE ZONE 2 TO NUMBER
* USES A

CMPZ2	PUSH	D		;SAVE D
	LXI	D,ZONE2+1	;POINT TO ZONE 2
	CALL	CPDNR		;COMPARE TO NUMBER
	POP	D
	RET

* COMPARE D/E INDIRECT TO NUMBER (FORWARD)
* USES A

CPDNF	PUSH	D
	XCHG
	LDA	NUMBR
	CMP	M		;COMPARE M.S. HALF
	JNZ	CPDN1
	INX	H
CPDN0	LDA	NUMBR+1
	CMP	M		;COMPARE L.S. HALF
CPDN1	XCHG
	POP	D
	RET

* COMPARE D/E INDIRECT TO NUMBER (REVERSE)
* USES A

CPDNR	PUSH	D
	XCHG
	LDA	NUMBR
	CMP	M		;COMPARE M.S. HALF
	JNZ	CPDN1
	DCX	H
	JMP	CPDN0		;GO COMPARE L.S. HALF

* CHECK FOR TERMINATOR (CR OR EOL)
* USES A

CKEND	MOV	A,M		;GET CHAR
	CPI	0DH		;IS IT CR ?
	RZ
	PUSH	H
	LXI	H,EOL
	CMP	M		;IS IT EOL ?
	POP	H
	RET

* TEST FOR CARRIAGE RETURN
* USES A,H,L

TFRCR	LHLD	BUFPT
	CALL	SKPSP		;GET NEXT CHAR
	CALL	CKEND		;IS IT END CHAR ?
	RZ
	JMP	SYNTX		;SYNTAX ERROR IF NOT

* FIND THE NEXT CARRIAGE RETURN
* USES A,H,L

FNDCR	MVI	A,0DH
FDCR1	INX	H		;GET NEXT CHAR
	CMP	M		;IS IT CR ?
	JNZ	FDCR1		;LOOP IF NOT
	RET

* BUMP NUMBER BY 1.0, 0.1, OR 0.01 PER INCAM
* USES A,B

BMPNO	LDA	NUMBR+2
	MOV	B,A		;PUT FRACTION INTO B
	LDA	INCAM		;GET INCREMENT AMOUNT
	ORA	A
	JZ	INCNO		;ZERO MEANS INCR BY 1
	ADD	B		;ELSE, ADD IN 0.1 OR 0.01
	DAA
	STA	NUMBR+2		;PUT BACK INTO NUMBER
	RNC

* INCREMENT NUMBER BY ONE
* USES A,B

INCNO	MVI	B,0
	MVI	A,1
INCN1	PUSH	H
	LXI	H,NUMBR+1	;POINT TO NUMBER
	ADD	M		;ADD TO L.S. HALF
	DAA
	MOV	M,A		;PUT AWAY
	MOV	A,B
	DCX	H
	ADC	M		;ADD TO M.S. HALF
	DAA
	MOV	M,A		;PUT AWAY
	POP	H
	RET

* DECREMENT NUMBER BY ONE
* USES A,B

DECNO	MVI	B,99H		;SETUP FOR COMPLEMENT
	MOV	A,B
	CALL	INCN1

* CHECK NUMBER FOR ZERO
* USES A

CKNUM	LDA	NUMBR
	ORA	A		;CHECK M.S. HALF
	RNZ
	LDA	NUMBR+1
	ORA	A		;CHECK L.S. HALF
	RET

* PUT NUMBER AT H/L INDIRECT
* USES A,D,E

PUTNO	LXI	D,NUMBR		;POINT D TO NUMBER
PUTN1	LDAX	D
	MOV	M,A		;PUT M.S. PART AT H
	INX	D
	INX	H
	LDAX	D
	MOV	M,A		;PUT L.S. PART AT H+1
	INX	D
	INX	H
	LDAX	D
	MOV	M,A		;PUT FRACTION AT H+3
	DCX	H
	DCX	H
	RET

* GET NUMBER FROM H/L INDIRECT
* USES A,D,E

GETNO	XCHG
	LXI	H,NUMBR		;POINT TO NUMBER
	CALL	PUTN1		;GO GET IT
	XCHG
	DCX	H		;RESTORE VALUE AT H
	DCX	H
	RET

* ROUTINE TO CLEAR NUMBER
* USES A

CLRNO	XRA	A
	STA	NUMBR		;ZERO OUT NUMBER
	STA	NUMBR+1
	STA	NUMBR+2
	RET

* GO TO NEXT LINE ROUTINE
* USES A,B,H,L

NXTLN	LDA	DRCTN		;GET DIRECTION
	ORA	A
	JNZ	BKONE		;BACK UP IF NEGATIVE

* MOVE UP ONE LINE
* USES A,H,L

UPONE	CALL	CMPFE		;AT END OF FILE ?
	JZ	UPON1		;IF SO, JUMP AHEAD
	CALL	FNDCR		;ELSE, GO TO END OF LINE
	INX	H
	CALL	CMPFE		;CHECK FOR END OF FILE
	RNZ
UPON1	MVI	A,1
	STA	OVRED		;SET OVER END FLAG

* MOVE BACK ONE LINE
* USES A,B,H,L

BKONE	MVI	B,1
	CALL	CMPFB		;AT BEGINNING OF FILE ?
	JZ	BKON2
BKON1	DCX	H		;BACK UP ONE CHAR
	CALL	CMPFB		;AT BEGINNING OF FILE ?
	JZ	BKON2
	MOV	A,M
	CPI	0DH		;IS CHAR CR ?
	JNZ	BKON1		;LOOP IF NOT
	DCR	B		;DO AGAIN ?
	JP	BKON1		;LOOP IF SO
	INX	H		;POINT TO START OF LINE
	RET
BKON2	MOV	A,B
	STA	OVRBG		;SET OVER BEGINNING FLAG
	RET

* MOVE BACK TO BEGINNING OF LINE
* USES A,B,H,L

BKTBG	MVI	B,0
	JMP	BKON1		;BACKUP TO FIRST CR

* CHECK FOR OVER END LIMITS
* USES A

CKOVR	LDA	OVRBG
	ORA	A		;OVER BEGINNING ?
	RNZ
	LDA	OVRED
	ORA	A		;OVER END ?
	RET

* CHECK FOR AN EMPTY FILE
* USES A,H,L

CKEMP	LHLD	FLBEG
	CALL	CMPFE		;COMPARE BEGIN TO END
	JZ	CHKED		;EXIT IF FILE IS EMPTY
	RET

* COMPARE FILE END TO H/L
* USES A

CMPFE	PUSH	D
	XCHG
	LHLD	FLEND		;POINT TO END OF FILE
CMPF1	XCHG
	CALL	CMPDH		;COMPARE TO H/L INDIRECT
	POP	D
	RET

* COMPARE FILE BEGIN TO H/L
* USES A

CMPFB	PUSH	D
	XCHG
	LHLD	FLBEG		;POINT TO FILE BEGIN
	JMP	CMPF1		;GO COMPARE

* COMPARE D/E TO H/L
* USES A

CMPDH	MOV	A,H
	CMP	D		;COMPARE D TO H
	RNZ
	MOV	A,L
	CMP	E		;COMPARE E TO L
	RET

* RENUMBER THE FILE
* USES A,B,D,E,H,L

RENUM	CALL	TFRCR
	LHLD	FLBEG		;POINT TO BEGIN OF FILE
	XRA	A
	STA	INCAM		;SET INCREMENT OF ONE
	CALL	CLRNO
RENO2	CALL	BMPNO		;BUMP NUMBER BY ONE
	CALL	PUTNO		;PUT NUMBER INTO FILE
RENO3	CALL	UPONE		;GO TO NEXT LINE
	LDA	OVRED
	ORA	A		;OVER END OF FILE ?
	JZ	RENO2		;LOOP IF NOT
	LDA	CHKFL
	ORA	A
	RNZ			;RETURN IF CHECK FLAG SET
	JMP	CHKED		;ELSE, CHECK AND EDIT

* RENUMBER THE REMAINDER OF THE FILE
* USES A,B,D,E,H,L

RENFL	XRA	A
	STA	OVRBG		;SET FLAGS AND VALUES
	STA	OVRED
	STA	INCAM
	STA	NUMBR+2
	INR	A
	STA	CHKFL
	CALL	BKONE		;BACKUP ONE LINE
	CALL	CLRNO
	LDA	OVRBG
	ORA	A		;AT BEGINNING OF FILE ?
	JNZ	RENO2		;IF SO, GO RENUMBER
	CALL	GETNO		;ELSE, GET LAST LINE NBR
	XRA	A
	STA	NUMBR+2
	JMP	RENO3		;RENUMBER REST OF FILE

* FIND NUMBERED LINE
* USES A,B,H,L

FNDNO	LHLD	FLBEG		;START AT BEGINNING
	MVI	B,0
FNDN1	CALL	CMPFE		;AT FILE END ?
	JNZ	FNDN3
	MVI	A,1
	STA	OVRED		;IF SO SET OVER END FLAG
FNDN2	MVI	A,1
	ORA	A		;SET ERROR FLAG
	RET
FNDN3	XCHG
	CALL	CPDNF		;COMPARE TO NUMBER
	XCHG
	JZ	FNDN5		;THEY ARE EQUAL
	JNC	FNDN4		;NUMBER IS LESS
FND35	DCR	B		;FIRST LINE OF FILE ?
	JP	FNDN2
	MVI	A,1
	STA	INTOP		;IF SO, SET 'IN TOP'
	JMP	FNDN2
FNDN4	LDA	CHKFL		;EXAMINE CHECK FLAG
	ORA	A
	JNZ	FNDN6		;EXIT IF SET
	CALL	FNDCR		;GO TO NEXT LINE
	INX	H
	MVI	B,1
	JMP	FNDN1		;LOOP BACK
FNDN5	INX	H		;GET FRACTION
	INX	H
	LDA	NUMBR+2
	CMP	M		;COMPARE TO NUMBER
	DCX	H
	DCX	H
	JC	FND35		;GREATER THAN
	JNZ	FNDN4		;LESS THAN
	LDA	SNGLN		;SINGLE LINE ?
	ORA	A
	JNZ	FNDN6		;EXIT IF SO
	LDA	CHKFL		;CHECK FLAG ?
	ORA	A
	JNZ	FNDN2
FNDN6	XRA	A		;SET FOUND LINE FLAG
	RET

* LOAD POSITION POINTERS
* USES D,E,H,L

LDPSP	LHLD	NEWPS		;LOAD NEW POSITION
	XCHG
	LHLD	TRGLN		;LOAD TARGET LINE
	RET

* LOAD BUFFER POINTER, SKIP SPACES AND CLASSIFY
* USES A,B,H,L

BFSKC	LHLD	BUFPT		;LOAD BUFFER POINTER

* SKIP SPACES AND CLASSIFY CHARACTER
* USES A,B,H,L

SKCLS	CALL	SKPSP		;SKIP SPACES

* CLASSIFY A CHARACTER
* USES A,B

CLASS	SHLD	BUFPT
	MOV	A,M		;GET THE CHAR
	MVI	B,0
	CPI	'0'		;CHECK FOR A NUMBER
	JC	CLAS3
	CPI	'9'+1
	JNC	CLAS1
	INR	B		;IF SO SET B=1
	JMP	CLAS3
CLAS1	CPI	'A'		;CHECK FOR AN UPPER
	JC	CLAS3		;CASE LETTER
	CPI	'Z'+1
	JC	CLAS2		;IF SO, SET B=2
	CPI	61H		;CHECK FOR A LOWER
	JC	CLAS3		;CASE LETTER
	CPI	7BH
	JNC	CLAS3		;IF NOT, LEAVE B=0
CLAS2	MVI	B,2		;IF SO, SET B=2
CLAS3	MOV	A,B
	CPI	1		;COMPARE B TO 1
	RET

* CONVERT ASCII TO BCD
* USES A,B,C,H,L

BCDCV	CALL	CLRNO		;ZERO OUT NUMBER
BCD1	CALL	CLASS		;CLASSIFY A CHAR
	JZ	BCD3		;JUMP IF A NUMBER
	MOV	A,M
	CPI	'.'		;IS IT A DECIMAL POINT ?
	JZ	BCD4		;JUMP IF SO
BCD2	SHLD	BUFPT		;SAVE BUFFER POINTER
	RET
BCD3	PUSH	D
	XCHG
	LHLD	NUMBR		;GET NUMBER
	MOV	A,H		;PUT IN ORDER
	MOV	H,L
	MOV	L,A
	DAD	H		;SHIFT LEFT FOUR
	DAD	H
	DAD	H
	DAD	H
	LDAX	D		;GET FIRST ASCII
	ANI	0FH		;MASK OFF ASCII BIAS
	ADD	L		;ADD TO NUMBER
	MOV	L,H
	MOV	H,A
	SHLD	NUMBR		;SAVE OUT NUMBER
	XCHG
	POP	D
	INX	H		;POINT TO NEXT ASCII
	JMP	BCD1		;LOOP BACK
BCD4	MVI	B,2		;SET COUNTER
BCD5	INX	H
	PUSH	B
	CALL	CLASS		;CHECK CHARACTER
	POP	B
	MOV	A,M
	JZ	BCD55		;JUMP IF A NUMBER
	DCX	H		;ELSE RESET BUFFER POINTER
	XRA	A		;PUT IN A ZERO
BCD55	ANI	0FH		;MASK OFF ASCII BIAS
	MOV	C,A
	LDA	NUMBR+2		;GET FRACTION
	ADD	A		;SHIFT LEFT FOUR
	ADD	A
	ADD	A
	ADD	A
	ADD	C		;ADD IN VALUE
	STA	NUMBR+2		;SAVE IT
	DCR	B
	JNZ	BCD5		;LOOP IF NOT TWICE
BCD6	INX	H
	CALL	CLASS		;CHECK NEXT CHARACTER
	JZ	BCD6		;LOOP IF A NUMBER
	JMP	BCD2		;ELSE, EXIT

* OUTPUT A BCD NUMBER
* USES A,B,C,H,L

OTBCD	LDA	NUMFG		;NUMBERS ON ?
	ORA	A
	JZ	OBCD5		;SKIP IF NOT
	LXI	B,0803H		;SET COUNTERS
OBCD1	CALL	OUTSP		;PRINT A SPACE
OBCD2	MOV	A,C
	RRC			;ODD OR EVEN ?
	MOV	A,M
	JNC	OBCD3		;SKIP IF EVEN
	DCX	H		;ELSE, BACKUP POINTER
	RRC			;SHIFT TO RIGHT HALF
	RRC
	RRC
	RRC
OBCD3	INX	H
	ANI	0FH		;MASK OFF LEFT HALF
	JNZ	OBCD4		;SKIP IF NONZERO
	DCR	B		;ANYTHING OUTPUT YET ?
	JM	OBCD4		;SKIP IF SO
	DCR	C		;ONE'S DIGIT YET ?
	JP	OBCD1		;GO SPACE IF NOT
	INR	C
OBCD4	CALL	OUTHR		;PRINT DIGIT
	MVI	B,-1		;SET FLAG SHOWING OUTPUT
	DCR	C		;DECREMENT OUTPUT COUNT
	MOV	A,C
	CPI	-3		;FINISHED ?
	JZ	OBCD5		;EXIT IF SO
	CPI	-1		;TIME FOR DECIMAL POINT ?
	JNZ	OBCD2
	MVI	A,'.'		;IF SO, PRINT ONE
	CALL	OUTCH
	JMP	OBCD2		;LOOP BACK
OBCD5	MVI	A,'='		;PRINT EQUALS SIGN
	JMP	OUTCH		;AND RETURN

* OUTPUT RIGHT HALF DIGIT ROUTINE
* USES A

OUTHR	ANI	0FH		;MASK OFF LEFT HALF
	ADI	30H		;ADD IN ASCII BIAS
	JMP	OUTCH		;OUTPUT DIGIT

* STRING PROCESSOR ROUTINE
* USES ALL

STRNG	MVI	C,0
	SHLD	LASTN		;SAVE LAST LOCATION
	LDA	STRCT		;GET STRING COUNT
	ORA	A		;EQUAL TO ZERO ?
	JNZ	STRG1
	INR	C		;IF SO SET FOUND FLAG
	JMP	STRG8		;AND GO EXIT
STRG1	XCHG
	LHLD	STRBG		;POINT TO STRING
	XCHG
STRG2	LDA	DCCHR
	MOV	B,A		;DON'T CARE CHAR INTO B
STRG3	MVI	A,0DH		;CARRIAGE RETURN
	CMP	M		;AT END OF EDIT LINE ?
	JZ	STRG5		;IF SO STRING NOT FOUND
	LDAX	D		;GET STRING CHAR
	CMP	B		;IS IT DON'T CARE ?
	JZ	STRG6		;IF SO, AUTOMATIC MATCH
	CMP	M		;ELSE IS IT A REAL MATCH ?
	JZ	STRG6
	LDA	PSTZF		;IF NOT CHECK ZONE FLAG
	ORA	A
	JNZ	STRG5		;IF SET, STRING NOT FOUND
	ORA	C		;MATCHED SO FAR ?
	JNZ	STRG4		;JUMP IF SO
	INX	H
	SHLD	LASTN		;SAVE LOCATION
	CALL	INCNO		;INCREMENT COLUMN NBR
	CALL	CMPZ2		;PAST ZONE 2 YET ?
	JZ	STRG2
	JC	STRG2		;LOOP IF NOT
	JMP	STRG5		;ELSE, NOT FOUND
STRG4	LHLD	LASTN		;GET POSITION POINTER
	INX	H
	CALL	INCNO		;NEXT COLUMN
	CALL	CMPZ2		;PAST ZONE 2 YET ?
	JZ	STRNG
	JC	STRNG		;REPEAT IF NOT
STRG5	MVI	C,0		;CLEAR FOUND FLAG
	JMP	STRG8		;GO EXIT
STRG6	INX	H		;INCR EDIT LINE POINTER
	INR	C		;SET FOUND FLAG
	INX	D		;INCR STRING POINTER
	PUSH	H
	LHLD	STRED
	CALL	CMPDH		;AT STRING END ?
	POP	H
	JNZ	STRG3		;LOOP IF NOT
	LDA	STRCT		;IF SO, GET STRING COUNT
	MOV	D,A
STRG7	CALL	INCNO		;FIX COLUMN COUNT TO
	DCR	D		;BE AT END OF STRING
	JNZ	STRG7
STRG8	MOV	A,C
	STA	FOUND		;SAVE FOUND FLAG
	LHLD	LASTN		;GET POSITION POINTER
	RET

* VERIFY LINE ROUTINE
* USES ALL

VFYLN	SHLD	NEWPS		;SAVE POSITION
	INX	H		;POINT TO FRACTION
	INX	H
	MOV	D,H		;SAVE IT'S LOC IN D/E
	MOV	E,L
	CALL	FNDCR		;FIND END OF LINE
	SHLD	SPCP2
VFYL0	DCX	H		;BACK UP
	CALL	CMPDH		;AT FRACTION YET ?
	JZ	VFYL1		;JUMP IF SO
	MVI	A,20H
	CMP	M		;IS CHAR A SPACE ?
	JZ	VFYL0		;LOOP IF NOT
VFYL1	INX	H
	SHLD	SPCP1
	CALL	DLCHR		;DELETE TRAILING SPACES
	LHLD	NEWPS		;RESTORE POSITION
	LDA	VERFG		;VERIFY ON ?
	ORA	A
	JZ	VFYL2		;SKIP IF NOT
	CALL	OUTLN		;PRINT THE LINE
	CALL	BKONE		;BACK TO IT'S BEGINNING
VFYL2	MVI	C,8		;SET FLAG
	CALL	ESCAP		;LOOK FOR ESCAPE
	SHLD	CURPS		;SAVE POSITIONS
	SHLD	NEWPS
	RET

* PRINT OUT ONE LINE
* USES A,H,L

OUTLN	PUSH	B		;SAVE B/C
	CALL	PCRLF		;PRINT CR AND LF
	LDA	NUMFG		;NUMBERS ON ?
	ORA	A
	JNZ	OUTL1		;IF SO JUMP AHEAD
	CALL	OUTSP		;PRINT A SPACE
	INX	H		;SKIP OVER LINE NUMBER
	INX	H
	JMP	OUTL2
OUTL1	CALL	OTBCD		;PRINT OUT LINE NUMBER
	DCX	H
OUTL2	INX	H
	MOV	A,M		;GET CHAR
	CPI	0DH		;IS IT A CR ?
	JZ	OUTL3		;IF SO, EXIT
	CALL	OUTCH		;ELSE PRINT THE CHAR
	JMP	OUTL2		;REPEAT
OUTL3	INX	H
	POP	B		;RESTORE B/C
	RET

* PRINT ROUTINE

PRINT	CALL	CKEMP		;CHECK FOR EMPTY FILE
	LHLD	BUFPT
	CALL	FINDT		;FIND TARGET LINE
	MVI	C,1		;CLEAR LAST FLAG
	LHLD	NEWPS
	SHLD	CURPS
PRNT1	XCHG
	LHLD	TRGLN		;GET TARGET LINE
	XCHG
	CALL	CMPDH		;THERE YET ?
	JNZ	PRNT2
	MVI	C,0		;IF SO, SET LAST FLAG
PRNT2	CALL	OUTLN		;PRINT A LINE
	DCR	C		;THE LAST ONE ?
	JM	PRNT3		;IF SO, EXIT
	CALL	ESCAP		;LOOK FOR ESCAPE
	INR	C
	LDA	DRCTN		;FIND DIRECTION
	ORA	A
	JZ	PRNT1		;LOOP BACK IF FORWARD
	DCX	H
	DCX	H
	CALL	BKONE		;ELSE, BACKUP ONE
	JMP	PRNT1		;NOW LOOP
PRNT3	CALL	BKONE		;BACK TO START OF LINE
	SHLD	CURPS
PRNT4	JMP	CHKED		;CHECK AND EDIT

* ESCAPE ROUTINE
* USES A,B,H,L

ESCAP	CALL	CHKIN		;CHECK FOR INPUT CHARACTER
	RNC			;RETURN IF NONE
	MOV	B,A		;ELSE, PUT IT INTO B
	LDA	BRKCH
	CMP	B		;WAS IT A BREAK ?
	JZ	ESCP2		;HALT IF SO
	LDA	ESC		;WAS IT ESCAPE ?
	CMP	B
	RNZ			;RETURN IF NOT
ESCP1	CALL	INCH		;GET ANOTHER CHAR
	MOV	B,A		;PUT INTO B
	LDA	BRKCH		;IS IT BREAK ?
	CMP	B
	JZ	ESCP2		;IF SO, HALT
	LDA	ESC		;IS IT ESCAPE ?
	CMP	B
	JNZ	ESCP1		;IF NOT, WAIT FOR ONE
	RET			;IF SO, RETURN
ESCP2	CALL	CMPFE		;AT FILE END ?
	JZ	ESCP3
	MOV	A,C		;CHECK FLAG
	CPI	8
	JZ	REDT1		;GO EDIT IF CLEAR
ESCP3	CALL	BKONE		;BACK UP ONE
	JMP	REDT1		;GO EDIT

* SET NUMBERS ON OR OFF

NMSET	LXI	D,NUMFG		;POINT TO NUMBER FLAG
SETFG	PUSH	D
	CALL	ONOFF		;CHECK FOR ON OR OFF
	POP	D
	ORA	A
	JZ	SETF3		;TURN IT ON
	JM	SETF2		;TOGGLE IT
	XRA	A		;TURN IT OFF
	JMP	SETF4
SETF2	LDAX	D		;GET FLAG
SETF3	CMA			;COMPLEMENT IT
SETF4	STAX	D		;SAVE FLAG
SETF5	LHLD	NEWPS
	SHLD	CURPS
	JMP	CHKED		;CHECK AND EDIT

* SET VERIFY ON OR OFF

VRSET	LXI	D,VERFG		;POINT TO VERIFY FLAG
	JMP	SETFG		;GO SET IT

* CHECK FOR ON OR OFF

ONOFF	LHLD	BUFPT		;GET BUFFER POINTER
	CALL	SKPSP		;SKIP SPACES
	SHLD	BUFPT
	SHLD	TEMP		;SAVE POINTER
	LXI	D,ONOFT		;POINT TO ON/OFF TABLE
	CALL	CKEND		;LOOK FOR EOL
	JNZ	NXTLT		;GO SEARCH TABLE
	MVI	A,-1		;SETUP TOGGLE
	RET

* ON OFF ROUTINES

ON	XRA	A		;CLEAR A FOR ON
	RET
OFF	MVI	A,1		;SET A FOR OFF
	RET

* CURSOR CONTROL COMMAND 'X'

XCTRL	CALL	TFRCR		;TEST FOR CR
	LXI	H,CCSTR		;POINT TO CURSOR STRING
	CALL	PDATA		;OUTPUT IT
	JMP	SETF5		;BACK TO EDIT

* SET POINTER TO TOP

TOP	CALL	TFRCR		;TEST FOR CR
	CALL	CKEMP		;GET FILE BEGIN INTO H/L
	JMP	BTTM1		;GO EDIT

* SET POINTER FOR BOTTOM

BOTTM	CALL	TFRCR		;TEST FOR CR
BTTM0	CALL	CKEMP		;EXIT IF EMPTY FILE
	LHLD	FLEND		;POINT TO END OF FILE
	CALL	BKONE		;BACK TO START OF LINE
BTTM1	SHLD	CURPS
	JMP	CHKED		;GO EDIT

* CHECK FOR MULTIPLE STATEMENTS PER LINE
* USES A,H,L

CKMSL	LHLD	BUFPT		;GET BUFFER POINTER
	DCX	H
CKMS1	INX	H
	CALL	CKEND		;END OF LINE ?
	JNZ	CKMS1		;LOOP IF NOT
	CPI	0DH		;IS IT CR ?
	RZ			;RETURN IF SO
	INX	H
	SHLD	BUFPT		;ELSE SAVE BUFFER POINTER
	MVI	A,1
	STA	MSPLF		;SET MSPL FLAG
	RET			;RETURN

* NEXT COMMAND

NEXT	MVI	A,1
	STA	NXTFG		;SET NEXT FLAG

* FIND COMMAND

CFIND	CALL	CKEMP		;CHECK FOR EMPTY FILE
	MVI	A,1
	STA	LINEF		;SET LINE FLAG
	CALL	OCCUR		;FIND OCCURRENCE COUNT
	LHLD	TRGLN		;GET TARGET LINE
	CALL	CKOVR		;OVER END LIMITS ?
	JZ	CFND4
	LDA	NXTFG		;IF SO, CHECK NEXT FLAG
	ORA	A
	JNZ	CFND6		;VERIFY LINE AND EXIT
	JMP	CFND2		;REPORT 'NOT FOUND'
CFND1	LDA	ALLFG		;CHECK ALL FLAG
	ORA	A
	JNZ	CHKED		;EXIT IF SET
CFND2	LXI	H,CFNDS		;REPORT 'NOT FOUND'
	CALL	PSTRG
	LXI	D,0001
	LHLD	ZONE1		;COMPARE ZONE1 TO 1
	CALL	CMPDH
	JNZ	CFND3		;SKIP IF NOT EQUAL
	LXI	D,0136		;????
	LHLD	ZONE2		;COMPARE ZONE2 TO 136
	CALL	CMPDH
	JZ	CLRED		;EXIT IF EQUAL
CFND3	LXI	H,ZOKST		;ASK IF ZONES ARE OK
	CALL	PDATA
	JMP	CLRED		;EXIT THE ROUTINE
CFND4	CALL	LDPSP		;GET POSITION POINTERS
	CALL	CMPDH		;AT TARGET LINE ?
	JZ	CHKED		;EXIT IF SO
	SHLD	NEWPS
	LDA	OCRFG		;GET OCCURRENCE FLAG
	ORA	A
	JZ	CFND6		;IF ZERO, VERIFY AND EXIT
	LDA	NXTFG		;CHECK NEXT FLAG
	ORA	A
	JNZ	CFND5		;SKIP IF SET
	CALL	VFYLN		;VERIFY LINE
CFND5	CALL	NXTOC		;GET NEXT OCCURRENCE
	CALL	CKOVR		;OVER END LIMITS ?
	JZ	CFND4		;LOOP IF NOT
	LDA	NXTFG		;CHECK NEXT FLAG
	ORA	A
	JZ	CFND1		;GO CHECK ZONES
CFND6	CALL	VFYLN		;VERIFY LINE
	JMP	CHKED		;EXIT ROUTINE

* CHECK FOR OCCURRENCE

OCCUR	LHLD	BUFPT		;GET BUFFER POINTER
	SHLD	BUFSV		;SAVE IT
	XRA	A
	STA	ALLFG		;CLEAR FLAGS
	STA	OCRFG
	CALL	FINDT		;FIND TARGET
	CALL	BFSKC		;CLASSIFY NEXT CHAR
	JZ	OCCR3		;JUMP IF A NUMBER
	MOV	A,M		;ELSE, GET CHAR
	CPI	'*'		;IS IT 'ALL' SYMBOL ?
	RNZ			;RETURN IF NOT
	MVI	A,1
	STA	ALLFG		;SET ALL FLAG
	JMP	OCCR4
OCCR3	CALL	BCDCV		;GET OCCURRENCE NBR
	CALL	CKNUM		;IS IT ZERO ?
	RZ			;IF SO, RETURN
	CALL	DECNO		;DECREMENT BY ONE
	RZ
	CALL	SVOCR		;SAVE OCCURRENCE COUNT
OCCR4	MVI	A,1
	STA	OCRFG		;SET OCCURRENCE FLAG
	RET			;RETURN

* SAVE PRESENT OCCURRENCE COUNT

SVOCR	LDA	NUMBR		;PUT NUMBER IN
	STA	OCRCT		;OCCURRENCE COUNT REG
	LDA	NUMBR+1
	STA	OCRCT+1
	RET

* PROCESS NEXT OCCURRENCE

NXTOC	LDA	ALLFG		;CHECK ALL FLAG
	ORA	A
	JNZ	NXTO1		;SKIP IF SET
NXTO0	LDA	OCRCT		;GET OCCURRENCE COUNT
	STA	NUMBR		;AND PUT IT INTO NUMBER
	LDA	OCRCT+1
	STA	NUMBR+1
	CALL	DECNO		;DECR OCCURRENCE COUNT
	JZ	NXTO2		;JUMP IF ZERO
	CALL	SVOCR		;ELSE, SAVE NEW COUNT
NXTO1	LDA	CHGFG		;ENTERED FROM CHANGE ?
	ORA	A
	RNZ			;IF SO, EXIT
	LHLD	BUFSV		;ELSE RESTORE BUFFER PTR
	JMP	FINDT		;AND FIND THE TARGET
NXTO2	XRA	A
	STA	OCRFG		;CLEAR OCCURRENCE FLAG
	JMP	NXTO1

* EQUALS COMMAND

EQULS	CALL	CKEMP		;CHECK FOR EMPTY FILE
	LHLD	BUFPT		;GET BUFFER POINTER
	XRA	A
	STA	BMPFL		;CLEAR BUMP FLAG
	INR	A
	STA	SNGLN		;SET SINGLE LINE FLAG
	STA	EQUFL		;SET EQUALS FLAG
	LDA	NOCRL		;CURRENT LINE ?
	ORA	A
	JNZ	INSR1		;GO INSERT IF NOT
	LHLD	NEWPS
	SHLD	TRGLN		;SET NEW TARGET
	CALL	GETNO		;GET LINE NBR
	MVI	A,1
	STA	REPFG		;SET REPLACE FLAG
	LDA	CHRCT+1
	STA	TPCHR		;SAVE CHAR COUNT
	JMP	DLET2		;GO DELETE THEN INSERT

* INSERT COMMAND

INSRT	LHLD	BUFPT		;GET BUFFER POINTER
	XRA	A
	STA	BMPFL		;CLEAR BUMP FLAG
	MOV	A,M		;GET CHAR
	CPI	0DH		;CR
	JZ	INSR4		;JUMP AHEAD IF CR
	MVI	A,1
	STA	SNGLN		;ELSE SET SINGLE LINE FLAG
	INX	H		;POINT TO NEXT
INSR1	SHLD	BUFPT
	XCHG
	LXI	H,BUFFR		;POINT TO BUFFER
	LDA	CHRCT+1		;GET CHAR COUNT
	MOV	B,A
INSR2	CALL	CMPDH		;POINTER = BUFFER PTR ?
	JZ	INSR3
	DCR	B		;IF NOT, DECR CHAR COUNT
	INX	H		;INCREMENT POINTER
	JMP	INSR2		;LOOP
INSR3	MOV	A,B
	ADI	3		;ADD IN LINE NBR BYTES
	STA	CHRCT+1		;SAVE CHAR COUNT
INSR4	MVI	A,1
	STA	CMRPT		;DISABLE COMMAND REPEAT
	LHLD	NEWPS
	SHLD	CURPS
	LDA	EQUFL		;CHECK FOR EQUALS
	ORA	A
	JZ	INS42		;SKIP IF NOT
	LDA	OVRBG		;IF SO, CHECK OVER BEGIN
	ORA	A
	JZ	INS43		;IF NOT, GET A LINE NBR
	JMP	INSR5		;IF SO, GO INSERT
INS42	CALL	GETNO		;GET NBR FROM FILE
	LDA	INTOP		;IN TOP FLAG SET ?
	ORA	A
	JZ	INS43		;SKIP IF NOT
	CALL	CMPFE		;AT FILE END ?
	JZ	INS43		;SKIP IF SO
	XRA	A
	STA	NUMBR		;CLEAR NUMBER
	STA	NUMBR+1
	MOV	B,A
	JMP	INSR5		;GO INSERT AT TOP
INS43	CALL	UPONE		;GO TO NEXT LINE
	INX	H
	INX	H
	MOV	B,M		;PUT FRACTION INTO B
	DCX	H
	DCX	H
	LDA	OVRED		;OVER END LIMITS ?
	ORA	A
	JZ	INSR5		;IF NOT, GO INSERT
INS45	MVI	B,0
	LHLD	FLBEG		;GET FILE BEGINNING
	XCHG
	LHLD	FLEND		;GET FILE END
	CALL	CMPDH		;IS FILE EMPTY ?
	JNZ	INSR5		;SKIP IF NOT
	CALL	CLRNO		;ZERO THE LINE NBR

* CALCULATE LINE NUMBER INCREMENT

INSR5	SHLD	SPCP1
	LDA	EQUFL		;FROM EQUALS COMMAND ?
	ORA	A
	JNZ	INS60		;IF SO, HAVE LINE NBR
	LDA	OVRED		;OVER END LIMITS ?
	ORA	A
	JZ	INS51		;SKIP IF NOT
	XRA	A
	STA	NUMBR+2		;IF SO, CLEAR FRACTION
	JMP	INSR6		;GO INSERT
INS51	LDA	BMPFL		;CHECK BUMP FLAG
	ORA	A
	JNZ	INSR6		;SKIP IF SET
	LDA	NUMBR+2
	ORA	B		;DOES FRACTION = B = 0 ?
	JZ	INS55		;IF SO, INCR AMOUNT = 0.1
	LDA	INTOP		;IN TOP OF FILE ?
	ORA	A
	JZ	INS52		;IF NOT INCR AMOUNT = 0.01
	XRA	A		;IF SO SET FRACTION TO 0
	STA	NUMBR+2
INS52	MVI	A,1		;SET INCREMENT TO 0.01
	JMP	INS56
INS55	MVI	A,10H		;SET INCREMENT TO 0.1
INS56	STA	INCAM		;SAVE INCR AMOUNT

* ENTER BUFFERED INPUT MODE

INSR6	CALL	BMPNO		;BUMP NUMBER
	LDA	SNGLN		;SINGLE LINE ?
	ORA	A
	JZ	INS61		;SKIP IF NOT
INS60	LHLD	BUFPT		;IF SO, SET POINTER
	JMP	INS71		;GO INSERT
INS61	XRA	A
	STA	INTOP		;CLEAR IN TOP FLAG
	CALL	PCRLF
	LXI	H,NUMBR		;PRINT LINE NBR
	CALL	OTBCD
	XRA	A
	STA	CHRCT		;SET CHAR COUNT = 3
	MVI	A,3
	STA	CHRCT+1
	STA	BMPFL		;SET BUMP FLAG
	LXI	H,BUFFR
INS62	CALL	INPUT		;GET A CHAR
	JZ	INS61		;REPEAT IF A DELETE
	CPI	0DH		;CR
	JZ	INSR7		;EXIT LOOP IF CR
	MOV	M,A		;PUT CHAR INTO BUFFER
	CALL	BUFLM		;CHECK FOR FULL BUFFER
	JMP	INS62		;LOOP BACK
INSR7	MOV	M,A		;PUT THE CR INTO BUFFER
	LXI	H,BUFFR
INS71	SHLD	BUFPT		;SAVE BUFFER POINTER
	LDA	LINO
	CMP	M		;IS FIRST CHAR A LINO ?
	JZ	INSR9		;EXIT INSERT IF SO

* ACTUAL LINE INSERT

INS72	CALL	MKSPC		;MAKE SPACE FOR INSERT
	LHLD	TEMP
	SHLD	NEWPS
	CALL	PUTNO		;PUT NUMBER IN FILE
	INX	H		;PASS IT UP
	INX	H
	INX	H
	XCHG
INS75	LHLD	BUFPT
	MOV	A,M		;GET A CHAR FROM BUFFER
	INX	H
	SHLD	BUFPT
	STAX	D		;PUT IT INTO FILE
	INX	D
	CPI	0DH		;IS IT CARRIAGE RETURN ?
	JNZ	INS75		;LOOP IF NOT
	CALL	EXPLN		;EXPAND TABS
	LDA	SNGLN		;SINGLE LINE ?
	ORA	A
	JNZ	INS92		;JUMP ACCORDINGLY
	JMP	INSR4

* CHECK IF RENUMBERING IS NECESSARY

INSR9	LDA	CHRCT+1
	SUI	3		;DECR CHAR COUNT BY 3
	STA	CHRCT+1
	INX	H
INS92	SHLD	TEMP		;SAVE BUFFER POINTER
	LHLD	NEWPS
	CALL	UPONE		;GO TO NEXT LINE
	LDA	OVRED		;OVER END LIMITS ?
	ORA	A
	JNZ	INS94		;NO RENUMBERING IF SO
	MVI	A,1
	STA	CHKFL		;ELSE, SET CHECK FLAG
	CALL	FNDN3		;COMPARE LINE NUMBERS
	JNZ	INS94		;SKIP IF LESS
	XRA	A		;ELSE SET FLAGS
	STA	INCAM
	STA	NUMBR+2
	CALL	RENO2		;RENUMBER REST OF FILE
	LXI	H,RENOS		;REPORT RENUMBERING
	CALL	PSTRG
INS94	LHLD	TEMP
	LDA	SNGLN		;CHECK FOR SINGLE LINE
	ORA	A
	JZ	INS96		;IF NOT, SET MSPL FLAG
	LHLD	NEWPS
	SHLD	CURPS		;SET POSITION
	JMP	EDIT		;BACK TO EDIT
INS96	MVI	A,1
	STA	MSPLF		;SET MULTIPLE STMTS PER LINE FLAG
	JMP	EDIT		;BACK TO EDIT

* MAKE ROOM FOR INSERT
* USES ALL

MKSPC	MVI	C,0
	LHLD	SPCP1		;GET SPACE POINTER
	SHLD	TEMP
	XCHG
	LHLD	FLEND
	CALL	CMPDH		;COMPARE TO FILE END
	JNZ	MKSP1		;SKIP IF NOT THERE
	INR	C		;ELSE SET NO-SPACE FLAG
MKSP1	SHLD	SPCP1		;SAVE POINTER
	XCHG
	PUSH	B		;SAVE C REG
	LDA	CHRCT+1		;GET CHAR COUNT INTO B/C
	MOV	C,A
	LDA	CHRCT
MKS15	MOV	B,A
	ORA	A		;L.S. HALF = 0 ?
	JNZ	MKSP2
	ORA	C		;M.S. HALF = 0 ?
	JZ	MKSP7		;IF SO, JUMP AHEAD
MKSP2	LHLD	MMEND
	CALL	CMPDH		;COMPARE TO MEMORY END
	JZ	MKSP6		;IF EQUAL, JUMP AHEAD
	INX	D
	LDA	DRCTN		;CHECK DIRECTION
	ORA	A
	JZ	MKSP4		;SKIP IF FORWARD
MKSP3	LDA	CPYDR		;CHECK COPY DIRECTION
	ORA	A
	JZ	MKSP5		;SKIP IF FORWARD
	LHLD	NEWPS
	INX	H		;INCREMENT OUR POSITION
	SHLD	NEWPS		;SAVE IT
MKSP4	LHLD	TRGLN
	INX	H		;INCREMENT TARGET LINE
	SHLD	TRGLN		;SAVE IT
MKSP5	MOV	A,C
	SUI	1		;DECREMENT CHAR COUNT
	MOV	C,A
	MOV	A,B
	SBI	0
	JMP	MKS15		;GO CHECK FOR ZERO
MKSP6	LXI	H,NORMS		;REPORT 'NOT ENOUGH ROOM'
	CALL	PSTRG
	POP	B		;RESTORE FLAG IN C
	JMP	CLRED		;CLEAR AND EDIT
MKSP7	XCHG
	SHLD	FLEND		;SET NEW FILE END
	SHLD	SPCP2
	POP	B		;RESTORE NO-SPACE FLAG
	MOV	A,C
	ORA	A		;CHECK IT
	LHLD	SPCP2
	MOV	B,H		;PUT SPCP2 INTO B/C
	MOV	C,L
	LHLD	TEMP
	XCHG			;PUT TEMP INTO D/E
	LHLD	SPCP1		;PUT SPCP1 INTO H/L
	RNZ			;RET IF NO SPACE NEEDED
MKSP9	CALL	CMPDH		;FINISHED ?
	RZ			;RETURN IF SO
	DCX	H
	DCX	B
	MOV	A,M		;GET CHAR FROM FILE
	STAX	B		;MOVE IT UP
	JMP	MKSP9		;LOOP BACK

* REPLACE LINES ROUTINE

RPLCE	MVI	A,1
	STA	REPFG		;SET REPLACE FLAG

* DELETE LINES ROUTINE

DLETE	LHLD	BUFPT		;GET BUFFER POINTER
	CALL	FINDT		;FIND TARGET LINE
	CALL	CKOVR		;CHECK OVER END LIMITS
	JZ	DLET2		;SKIP IF NOT
DLET0	LXI	H,NRCHS		;REPORT TARGET NOT HIT
	CALL	PSTRG
	CALL	PSNXT		;ASK IF HE'S SURE
	STA	CMRPT		;DISABLE COMMAND REPEAT
	LXI	H,BUFFR
DLET1	CALL	INPUT		;GET INPUT CHAR
	JZ	DLET0		;REPEAT IF A DELETE
	MOV	M,A		;ELSE, PUT INTO BUFFER
	INX	H
	CPI	0DH		;IS IT CR ?
	JNZ	DLET1		;LOOP IF NOT
	LXI	H,BUFFR
	CALL	SKPSP		;GET FIRST CHAR
	CPI	'Y'		;WAS IT Y FOR YES ?
	JZ	DLET2		;IF SO, CONTINUE DELETE
	LXI	H,NLDLS		;ELSE, REPORT NO DELETION
	CALL	PSTRG
	JMP	DLET7		;GO EXIT THE COMMAND
DLET2	LHLD	NEWPS
	LDA	DRCTN		;CHECK DIRECTION
	ORA	A
	JZ	DLET4		;SKIP IF FORWARD
	CALL	UPONE		;ELSE, MOVE UP ONE LINE
	LDA	OVRED
	ORA	A		;OVER END LIMIT ?
	JZ	DLET3
	LHLD	FLEND		;IF SO, SET PTR TO END
DLET3	SHLD	SPCP2		;SETUP THE POINTERS
	LHLD	TRGLN		;NECESSARY FOR THE
	SHLD	CURPS		;DELETE CHAR BLOCK
	SHLD	SPCP1		;ROUTINE TO DELETE
	LHLD	SPCP2		;A BACKWARD BLOCK
	JMP	DLET5
DLET4	SHLD	SPCP1		;SETUP THE POINTERS
	SHLD	CURPS		;NECESSARY TO DELETE
	LHLD	TRGLN		;A CHARACTER BLOCK
	CALL	UPONE		;IN A FORWARD DIRECTION
	LDA	OVRED		;OVER END LIMIT ?
	ORA	A
	JZ	DLET5		;SKIP IF NOT
	LHLD	FLEND		;SET POINTER TO FILE END
DLET5	SHLD	SPCP2
	CALL	DLCHR		;DELETE THE CHAR BLOCK
	LDA	REPFG		;FROM REPLACE OR EQUALS ?
	ORA	A
	JZ	DLET7		;SKIP IF NOT
	LHLD	CURPS
	CALL	BKONE		;BACKUP ONE LINE
	LDA	EQUFL		;FROM EQUALS COMMAND ?
	ORA	A
	JNZ	DLET9		;IF SO, JUMP AHEAD
	LDA	OVRBG		;ELSE, CHECK OVER BEGIN
	ORA	A
	JZ	DLET6		;SKIP IF NOT OVER
	STA	CMRPT		;DISABLE COMMAND REPEAT
	CALL	CLRNO		;ZERO THE NUMBER
	SHLD	NEWPS
	JMP	INSR5		;GO INSERT LINES
DLET6	SHLD	NEWPS
	XRA	A
	STA	BMPFL		;CLEAR BUMP FLAG
	JMP	INSR4		;GO INTO INSERT MODE
DLET7	LHLD	CURPS
	CALL	CMPFE		;ARE WE AT FILE END ?
	JNZ	DLET8
	CALL	BKONE		;IF SO, BACKUP ONE
	PUSH	H		;SAVE POINTER
	LXI	H,BFRST		;REPORT BOTTOM OF FILE
	CALL	PSTRG
	POP	H		;RESTORE POINTER
DLET8	SHLD	CURPS
	JMP	CHKED		;CHECK AND EDIT
DLET9	SHLD	NEWPS
	XRA	A
	STA	BMPFL		;CLEAR BUMP FLAG
	STA	CHRCT
	LDA	TPCHR		;RESTORE CHAR COUNT
	STA	CHRCT+1
	LHLD	BUFPT		;GET BUFFER POINTER
	JMP	INSR1		;GO INSERT LINES

* DELETE A CHARACTER BLOCK ROUTINE
* USES A,D,E,H,L

DLCHR	LHLD	SPCP1		;GET SPACE POINTER
	XCHG
	LDA	DRCTN		;CHECK DIRECTION
	ORA	A
	JNZ	DCHR2		;SKIP IF BACKWARDS
	PUSH	B
	LHLD	TRGLN		;ELSE GET TARGET INTO B/C
	MOV	B,H
	MOV	C,L
	LHLD	SPCP2		;GET SPACE POINTER
	INX	B
DCHR1	DCX	B		;DECREMENT TARGET LINE
	CALL	CMPDH		;FINISHED ?
	DCX	H
	JNZ	DCHR1		;LOOP IF NOT
	MOV	H,B		;PUT NEW TARGET INTO H/L
	MOV	L,C
	SHLD	TRGLN		;SAVE IT
	POP	B
DCHR2	LHLD	SPCP2		;GET SPACE POINTER
	CALL	CMPDH		;ANY TO DELETE ?
	RZ			;RETURN IF NOT
DCHR3	CALL	CMPFE		;AT END OF FILE ?
	JZ	DCHR4		;EXIT IF SO
	MOV	A,M		;GET CHAR
	INX	H
	STAX	D		;PUT INTO NEW SPOT
	INX	D
	JMP	DCHR3		;LOOP BACK
DCHR4	XCHG
	SHLD	FLEND		;SET NEW FILE END
	RET

* MERGE TWO LINES ROUTINE

MERGE	CALL	CKEMP		;CHECK FOR EMPTY FILE
	CALL	TFRCR		;TEST FOR EOL
	LHLD	NEWPS		;GET PRESENT POSITION
	SHLD	CURPS
	CALL	FNDCR		;FIND END OF LINE
	SHLD	SPCP1		;SAVE IT
	INX	H
	CALL	CMPFE		;AT END OF FILE ?
	JZ	MERG1		;EXIT IF SO
	INX	H		;ELSE PASS UP LINE NBR
	INX	H
	INX	H
	SHLD	SPCP2		;SAVE POINTER
	CALL	DLCHR		;DELETE CR AND LINE NBR
MERG1	LHLD	CURPS		;RESTORE POSITION
	CALL	VFYLN		;VERIFY THE LINE
	JMP	CHKED		;CHECK AND EDIT

* CCHANGE COMMAND

CCHNG	MVI	A,1
	STA	CCHGF		;SET CONTROLLED CHANGE FLAG

* CHANGE COMMAND

CHNGE	CALL	CKEMP		;CHECK FOR EMPTY FILE
	CALL	BFSKC		;CLASSIFY NEXT CHAR
	JZ	CHG9		;A COLUMN NUMBER ?
	JP	SYNTX		;ERROR IF A LETTER
CHG0	CALL	CKEND		;AT END OF LINE ?
	JZ	SYNTX		;IF SO, IT'S AN ERROR
	MVI	A,1
	STA	CHGFG		;SET CHANGE FLAG
	CALL	STDLM		;SETUP DELIMITER
	MVI	B,0
CHG1	CALL	CKEND		;AT END OF LINE ?
	JZ	CHG2		;EXIT LOOP IF SO
	CMP	C		;IS CHAR A DELIMITER ?
	JZ	CHG2		;EXIT LOOP IF SO
	MOV	D,A
	LDA	CRC
	CMP	D		;IS IT CR CHAR ?
	JNZ	CHG15		;SKIP IF NOT
	LDA	CRFLG
	DCR	A		;ELSE CHECK FLAG
	JP	ERROR		;ERROR IF ALREADY SET
	MVI	A,1
	STA	CRFLG		;OTHERWISE, SET IT
	INR	B		;ADD 3 TO STRING COUNT
	INR	B
	INR	B
CHG15	INX	H		;POINT TO NEXT
	INR	B
	JMP	CHG1		;LOOP BACK
CHG2	MOV	A,B
	STA	ST2CT		;SAVE STRING 2 COUNT
	CALL	CKEND		;AT END ?
	JZ	CHG22		;SKIP IF SO
	INX	H
CHG22	SHLD	BUFPT		;SAVE BUFFER POINTER
	CALL	SVSTR		;SAVE STRING DATA
	XRA	A
	STA	CHGFG
	CALL	OCCUR		;GET TARGET AND OCCURRENCE
	MVI	A,1
	STA	CHGFG
	CALL	RSSTR		;RESTORE STRING DATA
	LHLD	OCRCT
	SHLD	OCRTP		;SAVE OCCURRENCE COUNT
	LDA	PSTZ1		;CHECK ZONE FLAG
	ORA	A
	JZ	CHG28		;SKIP IF CLEARED
	LDA	OCRFG		;CHECK OCCURRENCE FLAG
	ORA	A
	JNZ	ERROR		;NO OCCUR ALLOWED HERE
CHG28	LDA	OCRFG		;CHECK OCCURRENCE FLAG
	ORA	A
	JZ	CHG3		;SKIP IF CLEARED
	LDA	STRCT		;ELSE CHECK STRING COUNT
	ORA	A
	JZ	ERROR		;ERROR IF NULL STRING

* DO CHANGE ON ONE LINE

CHG3	XRA	A
	STA	FOUND		;CLEAR FOUND FLAG
	CALL	LDPSP		;LOAD POSITION POINTERS
	XCHG
	CALL	CMPDH		;ARE WE AT TARGET ?
	JNZ	CHG4		;SKIP IF NOT
	MVI	A,1
	STA	LASTF		;ELSE, SET LAST FLAG
CHG4	LDA	CRFLG		;IS THERE A CR CHAR ?
	ORA	A
	JZ	CHG42		;SKIP IF NOT
	LDA	LASTF		;IS TARGET = PRESENT ?
	ORA	A
	JZ	ERROR		;IF NOT, IT'S AN ERROR
CHG42	INX	H		;PASS UP LINE NBR
	INX	H
	INX	H
	SHLD	CHGPT		;SAVE CHANGE POINTER
	XRA	A
	STA	CHGON
	CALL	ZONEB		;PUT ZONE 1 INTO ZONE BUFFER
	LDA	PSTZ1
	STA	PSTZF		;SETUP ZONE FLAG
	ORA	A
	JZ	CHG45		;SKIP IF ZERO
	LHLD	ZBFSV		;GET COLUMN NBR
	SHLD	ZONBF		;SAVE IN ZONE BUFFER
CHG45	LHLD	CHGPT		;GET CHANGE POINTER
	CALL	FIXZN		;GET ZONE INTO NUMBER
	CALL	TGT14		;SEARCH FOR STRING
	JMP	CHG6

* LOOP THRU STRING OCCURRENCES

CHG5	XRA	A
	STA	CHGON		;CLEAR CHANGE STARTED FLAG
CHG51	LHLD	CHGPT		;GET CHANGE POINTER
	CALL	FIXZN		;GET ZONE INTO NUMBER
	CALL	CMPZ2		;COMPARE TO ZONE 2
	JZ	CHG52
	JNC	CHG7		;EXIT IF PAST ZONE 2
CHG52	CALL	TGT17		;SEARCH FOR STRING
CHG6	CALL	ZONEA		;SAVE ZONE
	LDA	FOUND
	ORA	A		;DID WE FIND STRING ?
	JZ	CHG7		;EXIT IF NOT
	LDA	OCRFG		;CHECK FOR OCCURRENCE
	ORA	A
	JZ	STRRP		;IF NOT, MAKE THE CHANGE
	LDA	ALLFG		;IS ALL FLAG SET ?
	ORA	A
	JNZ	STRRP		;IF SO, MAKE THE CHANGE
	CALL	NXTO0		;GET NEXT OCCURRENCE
	LHLD	LASTN		;RESET STRING POINTER
	INX	H		;BUMP IT
	SHLD	CHGPT		;SAVE AS CHANGE PTR
	JMP	CHG5		;LOOP BACK

* CHECK FOR NEXT LINE TO CHANGE

CHG7	CALL	RSOCR		;RESTORE OCCURRENCE COUNT
	LDA	FNDON		;FOUND ONE YET ?
	ORA	A
	JNZ	CHG75		;SKIP IF SO
	LDA	LASTF		;ARE WE AT LAST LINE ?
	ORA	A
	JNZ	NONEF		;IF SO, REPORT NONE FOUND
CHG75	LHLD	NEWPS
	LDA	CHGON		;READY TO VERIFY ?
	ORA	A
	JZ	CHG8		;SKIP IF NOT
	CALL	VFYLN		;ELSE, DO VERIFY
CHG8	LDA	LASTF		;AT LAST LINE ?
	ORA	A
	JNZ	CHKED		;IF SO, EXIT COMMAND
	CALL	NXTLN		;ELSE, GO TO NEXT
	SHLD	NEWPS
	JMP	CHG3		;REPEAT THE LOOP
CHG9	CALL	ZONE		;GET THE ZONE
	LDA	PSTZF
	STA	PSTZ1		;SAVE THE ZONE FLAG
	PUSH	H
	LHLD	ZONBF
	SHLD	ZBFSV		;SAVE THE ZONE
	POP	H
	CALL	SKCLS		;CLASSIFY NEXT CHAR
	JMP	CHG0

* STRING REPLACE ROUTINE

STRRP	MVI	A,1
	STA	FNDON		;SET FOUND ONE FLAG
	LDA	CCHGF		;CHECK FOR CCHANGE
	ORA	A
	JZ	STRR1		;SKIP IF NOT
	LDA	CHGON		;ANY CHANGED YET ?
	ORA	A
	JNZ	STRR1		;SKIP IF SO
	LHLD	LASTN
	CALL	BKTBG		;BACKUP TO START OF LINE
	CALL	OUTLN		;PRINT THE LINE
STRR0	LXI	H,CCHGS		;ASK TO CHANGE
	CALL	PSTRG
	LDA	BRKCH
	MOV	B,A		;PUT BREAK CHAR INTO C
	CALL	INCH		;GET RESPONSE
	CMP	B		;IS IT BREAK ?
	JZ	CLRED		;EXIT IF SO
	CPI	'N'		;IS IT A 'NO' ?
	JZ	CHG7		;IF SO, GO TO NEXT
	CPI	'Y'		;IS IT A 'YES' ?
	JNZ	STRR0		;REPEAT IF NOT
STRR1	LHLD	LASTN
	SHLD	SPCP1		;SET SPACE POINTER
	LDA	STRCT
	MOV	B,A		;PUT STRING 1 COUNT INTO B
	LDA	ST2CT		;GET STRING 2 COUNT
	CMP	B		;COMPARE THEM
	JZ	STRR4		;JUMP ACCORDINGLY
	JNC	STRR3
	MOV	C,B
	MOV	B,A
	MOV	A,C
	SUB	B		;TAKE STRING 1 - STRING 2
	MOV	B,A		;PUT DIFFERENCE INTO B
STRR2	INX	H		;BUMP THE SPACE POINTER
	DCR	B		;DECREMENT THE DIFFERENCE
	JNZ	STRR2		;LOOP IF NOT ZERO
	SHLD	SPCP2
	CALL	DLCHR		;DELETE EXTRA SPACE
	JMP	STRR4		;GO PUT STRING
STRR3	SUB	B		;TAKE STRING 2 - STRING 1
	STA	CHRCT+1		;SAVE CHAR COUNT
	XRA	A
	STA	CHRCT
	CALL	MKSPC		;MAKE ROOM FOR STRING
STRR4	LDA	CRC
	MOV	C,A		;GET CR CHAR INTO C
	LHLD	STRED		;GET STRING POINTERS
	XCHG
	LHLD	LASTN
	LDA	ST2CT		;GET STRING 2 COUNT
	ORA	A
	JZ	STRR7		;SKIP IF ZERO
	MOV	B,A		;PUT IT INTO B
STRR5	INX	D
	LDAX	D		;GET CHAR FROM STRING
	CMP	C		;IS IT CR CHAR ?
	JNZ	STRR6		;SKIP IF NOT
	MVI	M,0DH		;IF SO, PUT IN A CR
	MVI	A,3		;SET LINE NBR COUNT
STR55	DCR	B
	INX	H		;MAKE ROOM FOR LINE NBR
	MOV	M,A
	DCR	A
	JNZ	STR55		;LOOP UNTIL DONE
STRR6	MOV	M,A		;PUT CHAR INTO FILE
	INX	H		;POINT TO NEXT
	DCR	B
	JNZ	STRR5		;LOOP UNTIL DONE
STRR7	SHLD	LASTN		;SAVE POINTERS
	SHLD	CHGPT
	LDA	CRFLG		;WAS THERE A CR ?
	ORA	A
	JZ	STRR9		;SKIP IF NOT
	CALL	RENFL		;RENUMBER REST OF FILE
	LHLD	CHGPT
	CALL	BKONE		;POINT TO 1ST OF 2 LINES
	CALL	VFYLN		;VERIFY IT
	CALL	UPONE		;POINT TO THE 2ND
	SHLD	NEWPS		;MAKE IT THE NEW POSITION
STRR9	MVI	A,1
	STA	CHGON		;SET CHANGE ON FLAG
	CALL	RSOCR		;RESET OCCURRENCE COUNT
	LDA	ALLFG		;CHECK THE ALL FLAG
	ORA	A
	JZ	CHG75		;JUMP ACCORDINGLY
	JMP	CHG51

* SAVE STRING POINTERS
* USES A,H,L

SVSTR	LHLD	STRBG
	SHLD	STRB1		;SAVE STRING BEGIN
	LHLD	STRED
	SHLD	STRE1		;SAVE STRING END
	LDA	STRCT
	STA	STRC1		;SAVE STRING COUNT
	RET

* RESTORE STRING POINTERS
* USES A,H,L

RSSTR	LHLD	STRB1
	SHLD	STRBG		;RESTORE STRING BEGIN
	LHLD	STRE1
	SHLD	STRED		;RESTORE STRING END
	LDA	STRC1
	STA	STRCT		;RESTORE STRING COUNT
	RET

* RESET OCCURRENCE COUNT
* USES A,D,E,H,L

RSOCR	LDA	PSTZ1		;CHECK ZONE FLAG
	ORA	A
	JNZ	RSOC1		;SKIP IF SET
	LXI	D,0000
	LHLD	OCRTP		;GET OCCURRENCE COUNT
	SHLD	OCRCT
	CALL	CMPDH		;IS IT ZERO ?
	MVI	A,1
	JNZ	RSOC2		;SKIP IF NOT
RSOC1	XRA	A
RSOC2	STA	OCRFG		;SET OCCURRENCE FLAG
	RET

* MOVE COMMAND

MOVE	MVI	A,1
	STA	MOVFG		;SET MOVE FLAG
	CALL	COPY		;COPY THE BLOCK
	LDA	CPYDR
	STA	DRCTN		;SET DIRECTION
	LHLD	TRGLN
	SHLD	SPCP2		;SET SPACE POINTER 2
	LHLD	NEWPS
	SHLD	SPCP1		;SET SPACE POINTER 1
	LHLD	CURPS
	SHLD	TRGLN		;SET THE TARGET LINE
	CALL	DLCHR		;DELETE ORIGINAL BLOCK
	LHLD	TRGLN
	SHLD	CURPS		;SET NEW POSITION
	JMP	CHKED		;CHECK AND EDIT

* COPY COMMAND

COPY	CALL	CKEMP		;CHECK FOR EMPTY FILE
	LHLD	BUFPT
	MVI	A,1
	STA	NXTFG		;SET NEXT FLAG
	STA	LINEF		;SET LINE FLAG
	CALL	FINDT		;FIND DESTINATION TARGET
	CALL	CKOVR		;OVER END LIMITS ?
	JNZ	NTFND		;IF SO, REPORT ERROR
	XRA	A
	STA	NXTFG		;CLEAR FLAGS
	STA	LINEF
	PUSH	H
	LHLD	NEWPS
	CALL	CMPFB		;ARE WE AT FILE BEGIN ?
	POP	H
	JZ	COPY1		;SKIP IF SO
	LDA	DRCTN
	STA	CPYDR		;ELSE, SET COPYDR=DRCTN
COPY1	XRA	A
	STA	DRCTN		;CLEAR DIRECTION
	CALL	FNDCR		;GO TO END OF LINE
	INX	H
	SHLD	SPCP1		;SAVE SPACE POINTER
	LHLD	BUFPT
	CALL	FINDT		;FIND RANGE TARGET
	CALL	CKOVR		;OVER END LIMITS ?
	JNZ	NTFND		;IF SO, REPORT ERROR
	CALL	LDPSP		;ELSE, LOAD POINTERS
	LDA	DRCTN		;CHECK DIRECTION
	ORA	A
	JZ	COPY2		;SKIP IF FORWARD
	XCHG			;REVERSE POINTERS
COPY2	CALL	FNDCR		;FIND END OF LINE
	INX	H
	SHLD	TRGLN		;SAVE TARGET
	XCHG
	SHLD	NEWPS		;GET PRESENT POSITION
	LXI	B,0000
COPY3	INX	H		;INCREMENT POINTER
	INX	B		;INCR CHAR COUNT
	CALL	CMPDH		;ARE WE THERE YET ?
	JZ	COPY4		;EXIT LOOP IF SO
	PUSH	D
	XCHG
	LHLD	SPCP1		;GET SPACE POINTER 1
	XCHG
	CALL	CMPDH		;ARE WE THERE YET ?
	POP	D
	JNZ	COPY3		;LOOP IF NOT
	LXI	H,OVLPS		;ELSE, REPORT OVERLAP
	JMP	PRERR
COPY4	MOV	L,B		;SAVE CHAR COUNT
	MOV	H,C
	SHLD	CHRCT
	MVI	A,1
	STA	DRCTN		;SET DIRECTION
	CALL	MKSPC		;MAKE SPACE FOR COPY
	MOV	H,B		;GET NEW CURRENT POSITION
	MOV	L,C
	SHLD	CURPS		;SAVE IT
	CALL	LDPSP		;LOAD POSITION POINTERS
	CALL	MKSP9		;PERFORM COPY
	MOV	L,C		;GET ADDRESS INTO H/L
	MOV	H,B
	CALL	RENFL		;RENUMBER REST OF FILE
	LHLD	CURPS
	CALL	BKONE		;BACKUP ONE LINE
	SHLD	CURPS
	LDA	MOVFG		;ENTERED FROM MOVE ?
	ORA	A
	RNZ			;RETURN IF SO
	JMP	CHKED		;ELSE, CHECK AND EDIT

* HEADER COMMAND

HEADR	MVI	C,0
	LXI	H,TABBF		;POINT TO TAB BUFFER
	SHLD	TABPT		;SAVE IT
	LHLD	BUFPT		;GET BUFFER POINTER
HEAD0	CALL	SKCLS		;CLASSIFY NEXT CHAR
	JZ	HEAD3		;CHECK SYNTAX
	JP	HEAD1
	CALL	CKEND		;CHECK FOR EOL
	JZ	HEAD5		;IF SO, USE OLD HDR COUNT
	JMP	SYNTX		;REPORT ERROR
HEAD1	MOV	A,M		;GET CHAR
	ANI	5FH		;FORCE UPPER CASE
	CPI	'D'		;IS CHAR A 'D' ?
	JNZ	SYNTX		;IF NOT, SYNTAX ERROR
	INR	C		;IF SO SET DOUBLE FLAG
HEAD2	INX	H
	JMP	HEAD0		;GET NEXT CHAR
HEAD3	CALL	BCDCV		;GET HEADER COUNT
	SHLD	BUFPT
	CALL	CKNUM		;CHECK THE NUMBER
	JZ	SETF5		;EXIT IF ZERO
	MVI	D,0
HEAD4	INR	D		;GET HEADER COUNT INTO D
	CALL	DECNO
	JNZ	HEAD4
	MOV	A,D		;SAVE IT
	STA	HEDCT
HEAD5	LDA	HEDCT		;GET HEADER COUNT
	MOV	D,A
	CPI	10+1		;IS IT OVER 10 ?
	JC	HED75		;IF NOT, SINGLE LINE
	DCR	D
	DCR	D
	MOV	A,C		;CHECK DOUBLE FLAG
	ORA	A
	JZ	HEAD7		;SKIP IF NOT SET
	CALL	HDSPC		;PRINT SPACES
	MVI	C,0
	CALL	HDSP1
HEAD6	CALL	SPC8		;SPACE OVER
	MOV	A,D
	CMP	C		;ENOUGH NUMBERS PRINTED ?
	JC	HEAD7		;IF SO, GO DO NEXT LINE
	CALL	INCNO		;IF NOT, GET NEXT
	INR	C
	INR	C
	LDA	NUMBR+1		;GET NUMBER
	CALL	OUTHR		;OUTPUT TEN'S DIGIT
	XRA	A
	CALL	OUTHR		;OUTPUT A ZERO
	JMP	HEAD6
HEAD7	INR	D		;CORRECT THE HEADER COUNT
	INR	D
HED75	CALL	HDSPC
	LHLD	TABPT
	MVI	C,0		;ZERO THE COUNT
HEAD8	CALL	INCNO		;GET NEXT COLUMN
	INR	C
	MOV	A,C
	CMP	M		;EQUAL TO TAB POSITION ?
	JNZ	HEAD9		;JUMP IF NOT
	MVI	A,'-'
	CALL	OUTCH		;PRINT A MINUS SIGN
	INX	H		;POINT TO NEXT TAB
	JMP	HEADA
HEAD9	LDA	NUMBR+1		;GET THE NUMBER
	CALL	OUTHR		;PRINT THE DIGIT
HEADA	MOV	A,D		;GET THE HEADER COUNT
	CMP	C		;ENOUGH NUMBERS ?
	JNZ	HEAD8		;LOOP IF NOT
	JMP	SETF5

* HEADER SPACE
* USES A,B,C

HDSPC	CALL	CLRNO		;CLEAR NUMBER
	CALL	PCRLF		;PRINT A CR AND LF
	LDA	NUMFG		;NUMBERS ON ?
	ORA	A
	JZ	HDSP1		;SKIP IF NOT
	CALL	SPC8		;PRINT 8 SPACES
HDSP1	CALL	OUTSP		;PRINT 1 SPACE
	INR	C		;INCREMENT COUNT
	RET

* OUTPUT 8 SPACES
* USES A,B,C

SPC8	MVI	B,8		;SET COUNTER
SPC81	CALL	OUTSP		;OUTPUT A SPACE
	INR	C		;INCR THE COLUMN COUNT
	DCR	B
	JNZ	SPC81		;LOOP IF NOT DONE
	RET

* SETUP ZONE COLUMNS COMMAND

SZONE	LXI	D,0001		;PUT A 1 INTO D/E
	CALL	BFSKC		;CLASSIFY NEXT CHAR
	JM	SZON1
	JNZ	SYNTX		;ERROR IF A LETTER
	CALL	SZBCD		;GET NUMBER INTO D/E
	JMP	SZON2
SZON1	CALL	CKEND		;IS CHAR AN EOL ?
	JZ	SZON2
	INX	H		;IF NOT, SKIP IT
SZON2	XCHG
	SHLD	ZONE1		;PUT VALUE INTO ZONE 1
	XCHG
	LXI	D,0136H		;???? PUT 136 INTO D/E
SZON3	CALL	SKCLS		;CLASSIFY NEXT CHAR
	JZ	SZON4		;SKIP IF A NUMBER
	JP	SYNTX		;ERROR IF A LETTER
	CALL	CKEND		;IS IT AN EOL ?
	JZ	SZON5
	INX	H		;IF NOT, GET NEXT
	JMP	SZON3
SZON4	CALL	SZBCD		;GET NUMBER INTO D/E
SZON5	XCHG
	SHLD	ZONE2		;PUT VALUE INTO ZONE 2
	JMP	SETF5

* GET BCD NUMBER INTO D/E
* USES ALL

SZBCD	CALL	BCDCV		;GET THE NUMBER
	XCHG
	CALL	ZONEA		;GET NBR IN ZONE BUFFER
	LHLD	ZONBF		;GET NUMBER INTO H/L
	XCHG			;PUT IT INTO D/E
	RET

* APPEND COMMAND

APEND	CALL	CKEMP		;CHECK FOR EMPTY FILE
	CALL	BFSKC		;CLASSIFY NEXT CHAR
	JP	SYNTX		;ERROR IF ALPHANUMERIC
	CALL	CKEND		;IS IT AN EOL ?
	JZ	SYNTX		;IF SO, SYNTAX ERROR
	CALL	STDLM		;SETUP DELIMITER
	CALL	CLASS		;CLASSIFY NEXT CHAR
	JNZ	APND2		;SKIP IF NON-NUMERIC
	CALL	BCDCV		;GET NUMBER
	CALL	CKNUM
	JZ	APND2		;SKIP IF EQUAL TO ZERO
	MVI	C,0
APND1	INR	C		;GET COLUMN NBR IN C
	CALL	DECNO
	JNZ	APND1
	MOV	A,C
	STA	APCOL		;SAVE IT
APND2	CALL	SVSTR		;SAVE STRING DATA
	LHLD	BUFPT
	CALL	FINDT		;FIND TARGET LINE
	CALL	RSSTR		;RESTORE STRING DATA
	XRA	A
	STA	CHRCT		;CLEAR CHAR COUNT
APND3	CALL	LDPSP		;LOAD POSITION POINTERS
	XCHG
	CALL	CMPDH		;ARE WE AT TARGET ?
	JNZ	APND4		;SKIP IF NOT
	MVI	A,1
	STA	LASTF		;ELSE, SET LAST FLAG
APND4	INX	H		;PASS UP LINE NUMBER
	INX	H
	INX	H
	LDA	APCOL		;GET APPEND COLUMN
	ORA	A
	JNZ	APND5		;SKIP IF NON-ZERO
	DCX	H
	CALL	FNDCR		;ELSE, FIND END OF LINE
	SHLD	SPCP1		;SET SPACE POINTER
	JMP	APND8		;GO APPEND TO END
APND5	MOV	C,A
APN52	DCR	C		;DECR COLUMN COUNT
	JZ	APND7		;EXIT IF AT COLUMN
	MOV	A,M
	CPI	0DH		;IS CHAR A CR ?
	JZ	APND6		;IF SO, WE NEED SPACE
	INX	H		;ELSE, POINT TO NEXT
	JMP	APN52
APND6	SHLD	SPCP1		;SET SPACE POINTER
	MOV	A,C
	STA	CHRCT+1		;SET CHAR COUNT
	PUSH	B
	CALL	MKSPC		;MAKE ROOM FOR SPACES
	MOV	H,B
	MOV	L,C
	SHLD	SPCP1		;RESET POINTER
	POP	B
	XCHG
APN65	MVI	M,20H		;PUT IN A SPACE
	INX	H
	DCR	C		;DECREMENT THE COUNT
	JNZ	APN65		;LOOP UNTIL DONE
	JMP	APND8		;GO APPEND
APND7	SHLD	SPCP1		;SET SPACE POINTER
	DCX	H
	CALL	FNDCR		;FIND END OF LINE
	SHLD	SPCP2		;SET SPACE POINTER
	CALL	DLCHR		;DELETE BLOCK OF CHARS
APND8	LHLD	SPCP1
	LDA	STRCT		;GET STRING COUNT
	ORA	A
	JZ	APND9		;EXIT IF ZERO
	STA	CHRCT+1		;PUT IN CHAR COUNT
	CALL	MKSPC		;MAKE ROOM FOR STRING
	LHLD	STRBG		;GET STRING POINTER
	LDA	STRCT		;GET STRING COUNT
	MOV	B,A
APN85	MOV	A,M		;GET A CHAR FROM STRING
	STAX	D		;PUT IT INTO THE FILE
	INX	H		;BUMP THE POINTERS
	INX	D
	DCR	B		;DONE YET ?
	JNZ	APN85		;LOOP IF NOT
	XCHG
APND9	CALL	BKTBG		;BACK TO START OF LINE
	CALL	VFYLN		;VERIFY IT
	LDA	LASTF		;WAS IT THE LAST LINE ?
	ORA	A
	JNZ	APNDA		;IF SO, EXIT
	CALL	NXTLN		;ELSE, GO TO NEXT
	SHLD	NEWPS
	JMP	APND3		;REPEAT
APNDA	SHLD	CURPS
	JMP	CHKED		;CHECK AND EDIT

* OVERLAY COMMAND

OVRLY	CALL	CKEMP		;CHECK FOR EMPTY FILE
	XRA	A
	STA	DRCTN		;SET FORWARD DIRECTION
	MVI	A,20H
	STA	DELIM		;SET DELIMITER TO SPACE
	LHLD	BUFPT
	MOV	A,M		;GET A CHAR
	CPI	0DH		;IS IT A CR ?
	JZ	OVRL1		;SKIP IF SO
	CALL	CLASS		;CLASSIFY IT
	JP	SYNTX		;ERROR IF A LETTER
	MOV	A,M
	STA	DELIM		;ELSE, MAKE IT DELIMITER
	INX	H
	MOV	A,M		;GET NEXT CHAR
	CPI	0DH		;IS IT A CR ?
	JNZ	OVR35		;SKIP IF NOT
OVRL1	MVI	A,1
	STA	CMRPT		;DISABLE COMMAND REPEAT
	LHLD	NEWPS		;GET NEW POSITION
	CALL	OUTLN		;PRINT THE LINE
	LDA	NUMFG		;ARE NUMBERS ON ?
	ORA	A
	JNZ	OVR15		;SKIP IF SO
	LXI	H,OVRLS+8	;POINT TO A SPACE
	JMP	OVR18
OVR15	LXI	H,OVRLS		;POINT TO OVERLAY STRING
OVR18	CALL	PSTRG
	LXI	H,BUFFR
OVRL2	CALL	INPUT		;GET INPUT CHAR
	JZ	OVRL1		;REPEAT IF IT'S A DELETE
	CPI	0DH		;CR ?
	JZ	OVRL3		;EXIT LOOP IF A CR
	MOV	M,A		;PUT CHAR INTO BUFFER
	CALL	BUFLM		;CHECK FOR BUFFER OVERFLOW
	JMP	OVRL2		;LOOP BACK
OVRL3	MOV	M,A		;PUT CR INTO BUFFER
	LXI	H,BUFFR		;RESET POINTER
OVR35	XCHG
	LHLD	NEWPS		;GET NEW POSITION
	XCHG
	INX	D		;PASS UP LINE NBR
	INX	D
	DCX	H
OVRL4	INX	H		;POINT TO NEXT BUFFER CHAR
OVR41	MOV	A,M		;GET IT
	CPI	0DH		;CR ?
	JZ	OVRL8		;EXIT IF A CR
	INX	D
	LDA	LASTF		;CHECK ALL CHAR FLAG
	ORA	A
	JNZ	OVRL5		;IF SET, GO PUT CHAR
	LDAX	D		;GET CHAR FROM FILE
	CPI	0DH		;IS IT A CR ?
	JZ	OVRL6		;SKIP IF SO
	LDA	DELIM
	CMP	M		;IS BUFFER CHAR = DELIM ?
	JZ	OVRL4		;LOOP IF SO
OVRL5	MOV	A,M		;ELSE, GET BUFFER CHAR
	STAX	D		;PUT IT INTO THE FILE
	JMP	OVRL4		;REPEAT LOOP
OVRL6	SHLD	BUFPT
	XRA	A
	STA	CHRCT		;CLEAR CHAR COUNT
	MOV	C,A
	MVI	A,0DH		;CR
OVRL7	INX	H		;LOOK FOR END OF LINE
	INR	C		;BUMPING C AS WE GO
	CMP	M
	JNZ	OVRL7		;LOOP IF NOT THERE YET
	MOV	A,C
	STA	CHRCT+1		;SET CHARACTER COUNT
	XCHG
	SHLD	SPCP1		;SET SPACE POINTER
	CALL	MKSPC		;MAKE ROOM FOR OVERLAY
	LHLD	BUFPT
	MVI	A,1
	STA	LASTF		;SET ALL CHAR FLAG
	DCX	D
	JMP	OVR41		;GO FINISH OVERLAY
OVRL8	LHLD	NEWPS
	CALL	VFYLN		;VERIFY THE LINE
	JMP	CLRED		;CLEAR AND EDIT

* SET SPECIAL CHARACTERS COMMAND

SETCM	LHLD	BUFPT		;GET BUFFER POINTER
	CALL	SKPSP		;SKIP SPACES
	SHLD	TEMP		;SAVE POINTER
	MVI	A,1
	STA	SETON		;SET FLAG
	LXI	D,CHRTB		;POINT TO CHAR TABLE
	JMP	NXTLT		;SEARCH FOR NAME
SETC	XCHG
	LHLD	BUFPT
	CALL	SKPSP		;GET NEXT CHAR
	CPI	'='		;IS IT AN = SIGN ?
	JNZ	SYNTX		;ERROR IF NOT
	CALL	CKFQU		;CHECK FOR QUOTE
	JNZ	SYNTX		;ERROR IF NOT
	CALL	CKFQU		;ANOTHER QUOTE ?
	JNZ	SETC1		;SKIP IF NOT
	MVI	C,0		;SET CHAR TO NULL
	JMP	SETC2
SETC1	CALL	CLASS		;CLASSIFY THE CHAR
	JP	SYNTX		;ERROR IF ALPHANUMERIC
	MOV	A,M
	CPI	0DH		;IS IT A CR ?
	JZ	SYNTX		;IF SO, AN ERROR
	MOV	C,A		;ELSE, PUT IT INTO C
	CALL	CKFQU		;CHECK FOR LAST QUOTE
	JNZ	SYNTX		;ERROR IF NOT
SETC2	INX	H
	SHLD	BUFPT		;SAVE BUFFER POINTER
	CALL	TFRCR		;CHECK FOR EOL
	MOV	A,C		;GET CHAR
	STAX	D		;STORE IT IN ITS PLACE
	LDA	FILL		;CHECK FILL CHAR
	ORA	A
	JNZ	SETC3		;SKIP IF NOT ZERO
	MVI	A,20H		;ELSE, SET IT TO A SPACE
	STA	FILL
SETC3	LDA	LINO		;CHECK LINO CHAR
	ORA	A
	JNZ	SETF5		;EXIT IF NOT ZERO
	MVI	A,'#'		;ELSE, SET IT TO A '#'
	STA	LINO
	JMP	SETF5		;EXIT

* CHECK FOR QUOTE
* USES A,H,L

CKFQU	INX	H		;BUMP POINTER
	CALL	SKPSP		;SKIP SPACES
	CPI	27H		;COMPARE CHAR TO QUOTE
	RET

* TAB SET COMMAND

TAB	LXI	H,TABBF
	SHLD	TABPT		;SET TAB POINTER
	XCHG
	LHLD	BUFPT		;GET BUFFER POINTER
TAB1	CALL	SKCLS		;CLASSIFY NEXT CHAR
	JZ	TAB2		;JUMP IF A NUMBER
	JP	SYNTX		;ERROR IF A LETTER
	CALL	CKEND		;IS IT AN EOL ?
	JZ	TAB4		;EXIT IF SO
	INX	H		;BUMP POINTER
	JMP	TAB1		;LOOP BACK
TAB2	CALL	BCDCV		;GET NUMBER
	CALL	CKNUM
	JZ	TAB4		;EXIT IF ZERO
	MVI	C,0
TAB3	INR	C		;GET TAB POSITION INTO C
	CALL	DECNO
	JNZ	TAB3
	MOV	A,C		;SAVE TAB POSITION
	STAX	D
	INX	D		;INCREMENT TAB POINTER
	PUSH	H
	LXI	H,TBEND		;GET TAB BUFFER END
	CALL	CMPDH		;ARE WE THERE ?
	POP	H
	JNZ	TAB1		;LOOP IF NOT
TAB4	XRA	A
	STAX	D		;PUT A ZERO IN
	SHLD	BUFPT
	JMP	SETF5		;EXIT

* EXPAND TABS COMMAND

EXPND	CALL	CKEMP		;CHECK FOR EMPTY FILE
	LHLD	BUFPT
	CALL	FINDT		;FIND TARGET
EXPD1	CALL	LDPSP		;LOAD POINTERS
	XCHG
	SHLD	CURPS
	CALL	CMPDH		;AT TARGET YET ?
	JNZ	EXPD2		;SKIP IF NOT
	MVI	A,1
	STA	LASTF		;SET LAST FLAG
EXPD2	CALL	EXPLN		;EXPAND ONE LINE
	LHLD	NEWPS		;SET NEW POSITION
	MVI	C,8		;SET FLAG
	CALL	ESCAP		;CHECK FOR ESCAPE
	LDA	LASTF		;FINISHED ?
	ORA	A
	JNZ	SETF5		;EXIT IF SO
	CALL	NXTLN		;ELSE, GO TO NEXT LINE
	SHLD	NEWPS
	JMP	EXPD1		;LOOP BACK

* EXPAND TABS IN ONE LINE
* USES ALL

EXPLN	LDA	TABCH		;GET TAB CHAR
	MOV	C,A
	LDA	FILL		;GET FILL CHAR
	CMP	C		;ARE THEY SAME ?
	RZ			;RETURN IF SO
	LXI	D,TABBF		;POINT TO TAB BUFFER
	XRA	A
	MOV	B,A		;CLEAR COLUMN COUNT
	STA	CHRCT
	LHLD	NEWPS
	CALL	CMPFE		;ARE WE AT FILE END ?
	JZ	CLRED		;EXIT IF SO
	INX	H		;PASS UP LINE NBR
	INX	H
	INX	H
EXPL1	INR	B		;INCR COLUMN COUNT
	MOV	A,M		;GET A CHAR
	CPI	0DH		;IS IT A CR ?
	RZ			;EXIT IF SO
	CMP	C		;IS IT A TAB CHAR ?
	JZ	EXPL2		;JUMP AHEAD IF SO
	INX	H		;ELSE, POINT TO NEXT
	JMP	EXPL1
EXPL2	LDAX	D		;GET TAB COLUMN
	ORA	A
	RZ			;RETURN IF ZERO
	CMP	B		;COMPARE COLUMN
	INX	D		;POINT TO NEXT TAB
	JZ	EXPL2		;SKIP IF LESS THAN
	JC	EXPL2
EXPL3	MVI	C,-1		;SET COUNTER
EXPL4	INR	C
	INR	B		;INCREMENT COLUMN COUNT
	CMP	B		;AT TAB COLUMN YET ?
	JNZ	EXPL4		;LOOP IF NOT
	MOV	A,C
	STA	CHRCT+1		;ELSE, SET CHAR COUNT
	SHLD	SPCP1		;SET SPACE POINTER
	CALL	MKSPC		;GO MAKE SPACE
	LDA	CHRCT+1
	MOV	B,A		;RESTORE COLUMN COUNT
	INR	B
	LDA	FILL		;GET FILL CHAR
EXPL5	MOV	M,A		;PUT INTO FILE
	INX	H
	DCR	B		;ENOUGH FILL ?
	JNZ	EXPL5		;LOOP IF NOT
	JMP	EXPLN		;REPEAT PROCEDURE

* 'NEW' COMMAND

NEW	CALL	BFSKC		;CLASSIFY FIRST CHAR
	JZ	NEW1		;SKIP IF A NUMBER
	JP	SYNTX		;ERROR IF A LETTER
	MOV	A,M
	CPI	0DH		;CR ?
	JNZ	SYNTX
	MVI	A,7		;IF SO, DEFAULT TO 7 PERCENT
	JMP	NEW2
NEW1	MOV	A,M
	SUI	'0'
	CPI	7+1		;IS DIGIT 0-7 ?
	JNC	ERROR
	MOV	B,A
	INX	H		;CHECK NEXT CHAR
	MOV	A,M
	CPI	0DH		;CR ?
	JNZ	SYNTX		;ERROR IF NOT
	MOV	A,B
NEW2	MOV	C,A		;SAVE BUFFER FILL PERCENT
	LDA	SIZE		;GET 1/8 BUFFER SIZE
	MOV	B,A
	XRA	A
NEW3	DCR	C		;CALC MOST SIGNIFICANT
	JM	NEW4		;HALF OF BUFFER END
	ADD	B		;ADDRESS
	JMP	NEW3
NEW4	LHLD	BEGPT
	ADD	H		;ADD TO BUFFER BEGIN
	MOV	H,A
	SHLD	MEMTOP		;SAVE TOP ADDRESS
	LHLD	NEWPS
	SHLD	SPCP2		;SETUP DELETE POINTERS
	XCHG
	LHLD	FLBEG
	SHLD	SPCP1
	CALL	CMPDH		;ANY FILE PRESENT ?
	JZ	NEW5		;SKIP IF NOT
	XRA	A
	STA	EXTWR
	CALL	RECORD		;SAVE OUT FROM BUFFER
	CALL	DLCHR		;DELETE FROM BUFFER
NEW5	LDA	ALLIN		;ANY FILE LEFT ON DISK ?
	ORA	A
	JNZ	PEDIT		;GO TO EDIT IF NOT
	STA	EXTRD
	LHLD	MEMTOP		;ELSE SET LOAD END
	XCHG
	CALL	FILLBF		;READ INTO BUFFER
	JMP	PEDIT		;GO EDIT

* READ EXTERNAL FILE COMMAND

READ	LXI	D,EXTBUF+1
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	CALL	BFSKC		;CLASSIFY NEXT CHAR
	LXI	D,EXTFCB
	CALL	GETFN		;GET THE FILE SPEC
	JNC	READ0
	LXI	H,IFSERR	;IF ERROR, REPORT IT
	JMP	PRERR
READ0	CALL	OPEN		;OPEN THE FILE
	CPI	-1
	JNZ	READ1
	LXI	H,NSFERR	;ERROR IF NOT FOUND
	JMP	PRERR
READ1	MVI	A,7FH
	STA	EXTBUF		;SET BUFFER POINTER
	STA	EXTRD
	XRA	A
	STA	EXTFCB+32	;CLEAR NR BYTE
	LHLD	MMEND
	DCR	H		;GET BUFFER LOAD END
	XCHG
	CALL	FILLBF		;READ INTO BUFFER
	LHLD	FLEND
	CALL	BKONE		;SET FILE POINTER
	JMP	REDT1		;GO BACK TO EDIT
* FILL EDIT BUFFER FROM DISK
FILLBF	LHLD	FLEND		;GET FIRST ADDRESS
	CALL	CMPDH		;IS BUFFER ALREADY FULL ?
	RNC			;RETURN IF SO
FILBF3	MOV	M,D		;ROOM FOR LINE NUMBER
	INX	H
	MOV	M,D
	INX	H
	MOV	M,D
	INX	H
FILBF4	CALL	READCH		;GET A CHAR FROM DISK
	CPI	1AH		;EOD ?
	JZ	FILBF7		;SKIP IF END OF DATA
	CPI	0DH		;CR ?
	JZ	FILBF6		;SKIP IF CR
	CPI	09H		;A TAB CHAR ?
	JZ	FILBF5		;IF SO, PUT INTO BUFFER
	CPI	1FH+1		;A CONTROL CHAR ?
	JC	FILBF4		;GET ANOTHER IF SO
FILBF5	MOV	M,A		;PUT CHAR INTO BUFFER
	INX	H		;BUMP POINTER
	JMP	FILBF4		;LOOP BACK
FILBF6	MOV	M,A		;PUT CR IN
	INX	H
	CALL	CMPDH		;IS BUFFER FULL ?
	JC	FILBF3		;LOOP BACK IF NOT
	LDA	EXTRD
	ORA	A		;EXTERNAL READ OPERATION ?
	JZ	FILBF8		;SKIP IF NOT
	CALL	READCH		;GET ANOTHER CHAR
	JC	FILBF8
	CPI	1AH		;EOD ?
	JZ	FILBF8		;SKIP IF END OF DATA
	PUSH	H
	LXI	H,NORMS		;ELSE REPORT NO ROOM
	CALL	PSTRG
	POP	H
	JMP	FILBF8
FILBF7	LDA	EXTRD
	ORA	A		;EXTERNAL READ OPERATION ?
	JNZ	FILBF8		;SKIP IF SO
	MVI	A,1
	STA	ALLIN		;SET ALL IN FLAG
FILBF8	MVI	A,1
	STA	CMRPT		;DISABLE COMMAND REPEAT
	CALL	BKTBG		;BACKUP TO LINE START
	XCHG
	LHLD	FLEND		;GET OLD FILE END
	XCHG
	SHLD	FLEND		;SET NEW FILE END
	XCHG
	CALL	RENFL		;RENUMBER REMAINDER
	RET

* WRITE EXTERNAL FILE ROUTINE

WRITE	CALL	CKEMP		;CHECK FOR EMPTY FILE
	LHLD	BUFPT
	CALL	FINDT		;GET TARGET LINE
	PUSH	H		;SAVE IT
	LXI	D,EXTBUF+1
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	CALL	BFSKC
	LXI	D,EXTFCB
	CALL	GETFN		;GET FILE SPECIFICATION
	JNC	WRITE0
	LXI	H,IFSERR	;REPORT IF AN ERROR
	JMP	PRERR
WRITE0	CALL	OPEN		;OPEN THE FILE
	CPI	-1
	JZ	WRITE1
	LXI	H,FEERR		;ERROR IF ALREADY THERE
	JMP	PRERR
WRITE1	LXI	D,EXTFCB
	MVI	C,MAKEF		;CREATE THE FILE
	CALL	BDOS
	CPI	-1
	JNZ	WRITE2		;SKIP IF NO ERROR
	LXI	H,NDSERR	;ELSE NO SPACE ERROR
	JMP	PRERR
WRITE2	XRA	A
	STA	EXTFCB+32	;CLEAR NR BYTE
	MVI	A,0FFH
	STA	EXTBUF		;SET BUFFER POINTER
	POP	H		;RESTORE TARGET ADDRESS
	XCHG
	LHLD	NEWPS		;GET CURRENT ADDRESS
	LDA	DRCTN
	ORA	A		;CHECK DIRECTION
	JNZ	WRITE3
	XCHG			;SWAP IF FORWARD
WRITE3	CALL	FNDCR
	INX	H		;INCLUDE THIS LINE
	XCHG
	MVI	A,1
	STA	EXTWR
	CALL	RECORD		;WRITE TO DISK
WRITE4	MVI	A,1
	STA	CMRPT		;DISABLE COMMAND REPEAT
	LHLD	NEWPS
	SHLD	CURPS		;SET CURRENT POSITION
	JMP	CLRED		;GO TO EDIT

* ROUTINE TO WRITE FILE TO DISK

RECORD	CALL	CMPDH		;ANYTHING TO WRITE ?
	JZ	RECRD2		;EXIT IF NOT
	INX	H		;SKIP LINE NUMBER
	INX	H
	INX	H
RECRD1	MOV	A,M		;GET A CHAR
	CALL	WRTCH		;WRITE TO DISK
	INX	H
	CPI	0DH		;WAS IT A CR ?
	JNZ	RECRD1		;LOOP IF NOT
	MVI	A,0AH		;ELSE WRITE A LINEFEED
	CALL	WRTCH		;ALSO (LF)
	JMP	RECORD		;LOOP BACK
RECRD2	LDA	EXTWR
	ORA	A		;EXTERNAL WRITE OPERATION ?
	RZ			;RETURN IF NOT
	MVI	A,1AH		;EOD
	CALL	WRTCH		;WRITE END OF FILE CHAR
CLOSE	LXI	H,NEWBUF	;GET PROPER BUFFER
	LDA	EXTWR		;ADDRESS, DEPENDING ON STATE
	ORA	A		;OF EXTWR FLAG
	JZ	CLOSE1
	LXI	H,EXTBUF
CLOSE1	MOV	A,M
	ORA	A		;IS DMA BUFFER FULL ?
	JZ	CLOSE2		;SKIP IF SO
	MVI	A,1AH		;EOD
	CALL	WRTCH		;WRITE EOD OUT
	JMP	CLOSE1		;LOOP UNTIL FULL
CLOSE2	LXI	D,NEWFCB	;GET PROPER FCB ADDRESS
	LDA	EXTWR
	ORA	A
	JZ	CLOSE3
	LXI	D,EXTFCB
CLOSE3	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,CLOSEF	;CLOSE THE FILE
	CALL	BDOS
	CPI	-1
	JNZ	CLOSE4
	LXI	H,CERR		;REPORT ANY ERROR
	CALL	PSTRG
CLOSE4	LDA	EXTWR		;EXTERNAL WRITE OPERATION ?
	ORA	A
	RNZ			;RETURN IF SO
	JMP	WARMS		;ELSE EXIT EDITOR

* READ A CHARACTER FROM DISK

READCH	PUSH	H		;SAVE H/L
	LXI	H,OLDBUF	;GET PROPER DMA BUFFER
	LDA	EXTRD		;ADDRESS DEPENDING ON STATE
	ORA	A		;OF EXTRD FLAG
	JZ	READC1
	LXI	H,EXTBUF
READC1	INR	M		;INCR DMA BUFFER PTR
	MOV	A,M
	CPI	80H		;IS BUFFER DEPLETED ?
	JNZ	READC3		;SKIP IF NOT
RDDSK	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	INX	H		;ADJUST BUFFER POINTER
	XCHG
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,OLDFCB	;GET PROPER FCB ADDRESS
	LDA	EXTRD
	ORA	A
	JZ	RDDSK1
	LXI	D,EXTFCB
RDDSK1	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,READF		;READ A SECTOR
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	CPI	0
	JZ	READC2		;SKIP IF NO ERRORS
	CPI	1		;READ PAST EOF ?
	JNZ	RDERR		;SKIP IF NOT
	MVI	M,7FH		;SET BYTES
	MVI	A,1AH		;EOD
	POP	H		;RESTORE H/L
	STC			;SET ERROR FLAG
	RET
READC2	MOV	M,A		;SET DMA BUFFER POINTER
READC3	INX	H
	CALL	ADAHL		;GET BYTE ADDRESS
	MOV	A,M		;GET THE CHAR
	ORA	A		;CLEAR CARRY
	POP	H		;RESTORE H/L
	RET
RDERR	LXI	H,RERR		;REPORT READ ERROR
	CALL	PSTRG
	LDA	EXTRD		;EXTERNAL READ OPERATION ?
	ORA	A
	JNZ	PEDIT		;EDIT IF SO
	CMA
	STA	ALLIN		;ELSE SET ALL IN FLAG
	JMP	DEXIT		;EXIT THE EDITOR

* WRITE A CHARACTER TO DISK

WRTCH	PUSH	H
	PUSH	PSW		;SAVE THE CHAR
	LXI	H,NEWBUF	;GET PROPER BUFFER ADDRESS
	LDA	EXTWR		;DEPENDING ON THE STATE
	ORA	A		;OF THE EXTWR FLAG
	JZ	WRTCH1
	LXI	H,EXTBUF
WRTCH1	INR	M		;INCR DMA BUFFER PTR
	MOV	A,M
	CPI	80H		;IS BUFFER FULL ?
	JNZ	WRTCH3		;SKIP IF NOT
WRDSK	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	INX	H
	XCHG
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,NEWFCB	;GET PROPER FCB ADDRESS
	LDA	EXTWR
	ORA	A
	JZ	WRDSK1
	LXI	D,EXTFCB
WRDSK1	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,WRITEF	;WRITE A SECTOR
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	CPI	0		;ANY ERRORS ?
	JZ	WRTCH2		;SKIP IF NOT
	CPI	2		;IS DISK FULL ?
	JNZ	WRDSK2		;SKIP IF NOT
	LXI	H,DFERR		;POINT TO FULL STRING
	JMP	WRDSK3
WRDSK2	LXI	H,WERR		;POINT TO ERROR STRING
WRDSK3	CALL	PSTRG		;PRINT IT
	POP	PSW		;ADJUST STACK
	POP	PSW
	POP	PSW
	CALL	CLOSE2		;CLOSE THE FILE
	JMP	WRITE4
WRTCH2	MOV	M,A		;SET DMA BUFFER PTR
WRTCH3	INX	H
	CALL	ADAHL		;GET CHAR ADDRESS
	POP	PSW		;RESTORE THE CHARACTER
	MOV	M,A		;PUT IT INTO BUFFER
	POP	H
	RET

* GET FILE SPECIFICATION ROUTINE

GETFN	PUSH	D
	PUSH	H
	XCHG
	SHLD	FCBADR		;SAVE FCB ADDRESS
	MOV	D,H
	MOV	E,L
	MVI	A,33
	CALL	ADAHL		;POINT TO DRIVE NUMBER
	LDA	LOGDR
	MOV	M,A		;SET TO LOGIN DRIVE
	LXI	H,CLRFCB
	CALL	XFR16		;INITIALIZE THE FCB
	POP	H
	POP	D
	INX	D		;POINT TO FCB NAME
	INX	H		;POINT TO 2ND CHAR
	MOV	A,M
	CPI	':'		;IS IT DRIVE SEPARATOR ?
	JZ	SETDRV		;IF SO, SET DRIVE
	DCX	H		;ELSE BACKUP POINTER
GETFN3	MOV	A,M		;GET A CHAR
	CALL	VALID2		;A VALID LETTER ?
	JNC	GFNERR		;ERROR IF NOT
	MVI	C,8		;SET MAX LENGTH
	CALL	GETNM		;GET THE NAME
	JC	GFNERR		;JUMP IF ERROR
	CPI	'.'		;WAS DELIMITER A '.' ?
	JNZ	DFTEXT		;DEFAULT EXTENSION IF NOT
	INX	H		;PASS UP PERIOD
GETFN4	XCHG
	LHLD	FCBADR		;GET EXTENSION ADDRESS
	MVI	A,9		;WITHIN THE FCB
	CALL	ADAHL
	XCHG
	MVI	C,3		;SET MAX LENGTH
	CALL	GETNM		;GET EXTENSION
	JC	GFNERR		;SKIP IF ERROR
	CPI	'.'		;CHECK TERMINATOR
	JZ	GFNERR		;PERIOD IS INVALID
	ORA	A		;CLEAR CARRY
GETFN5	XCHG
	LHLD	FCBADR		;RESTORE FCB ADDRESS
	XCHG
	RET
GFNERR	STC			;SET ERROR FLAG
	JMP	GETFN5		;GO RESTORE FCB ADDRESS
DFTEXT	PUSH	H
	LXI	H,EXT		;POINT TO DEFAULT EXTENSION
	CALL	GETFN4		;COPY INTO FCB
	POP	H
	RET
SETDRV	DCX	H		;POINT TO DRIVE CHAR
	MOV	A,M
	SUI	'A'		;CHECK FOR A TO D
	JC	GFNERR
	CPI	4
	JNC	GFNERR		;ERROR IF NOT
	PUSH	H
	PUSH	PSW
	LHLD	FCBADR		;PUT IN DRIVE NUMBER
	MVI	A,33		;POSITION OF FCB
	CALL	ADAHL
	POP	PSW
	MOV	M,A
	POP	H
	INX	H
	INX	H
	JMP	GETFN3		;NOW GET NAME

* GET NAME FROM H/L INTO D/E

GETNM	INR	C
GETNM1	MOV	A,M		;GET A CHAR
	CALL	VALID		;A VALID NAME CHAR ?
	JNC	GETNM2		;EXIT IF NOT
	DCR	C		;DECR MAX COUNT
	JZ	SETCRY		;AN ERROR IF HIT MAX
	STAX	D		;PUT INTO FCB
	INX	D
	INX	H
	JMP	GETNM1		;GO GET NEXT CHAR
GETNM2	CALL	ISTERM	;SPACE LEFT BRACKET COMMA PERIOD OR CR ?
	JC	CLRCRY		;RETURN IF ONE OF ABOVE
	STC			;SET ERROR FLAG IF NOT
	RET

* CHECK FOR NAME TERMINATOR

ISTERM	CPI	'['
	JZ	SETCRY		;LEFT BRACKET IS OK
	CPI	'.'
	JZ	SETCRY		;PERIOD IS OK
ISTRM1	CPI	' '
	JZ	SETCRY		;SPACE IS OK
	CPI	','
	JZ	SETCRY		;COMMA IS OK
	CPI	0DH		;CR ?
	JZ	SETCRY		;CR IS OK
CLRCRY	ORA	A		;ELSE NOT A DELIMITER
	RET
SETCRY	STC
	RET

* CHECK FOR A VALID FILE NAME CHARACTER

VALID	CPI	'-'
	JZ	SETCRY		;HYPHEN IS VALID
	CPI	'_'
	JZ	SETCRY		;UNDERSCORE IS VALID
VALID1	CPI	'0'		;CHECK FOR A DIGIT
	JC	VALID2
	CPI	'9'+1
	JC	SETCRY		;A VALID DIGIT
VALID2	CPI	61H		;CHECK FOR LOWER CASE
	JC	VALID3
	CPI	7AH+1
	JNC	VALID3
	SUI	20H		;CONVERT TO UPPER CASE
VALID3	CPI	'A'		;CHECK FOR A LETTER
	JC	CLRCRY
	CPI	'Z'+1
	JC	SETCRY		;A VALID LETTER
	ORA	A
	RET

* SKIP SPACES AND ONE COMMA

SKIP	CALL	SKPSP		;SKIP SPACES
	CPI	','		;IS NEXT CHAR A COMMA ?
	RNZ			;RETURN IF NOT
	INX	H		;ELSE, PASS IT UP
	CALL	SKPSP		;SKIP SPACES
	RET

* SELECT THE PROPER DRIVE

SELECT	PUSH	D		;SAVE FCB ADDRESS
	XCHG
	MVI	A,33		;GET DRIVE NBR FROM FCB
	CALL	ADAHL
	MOV	E,M		;PUT INTO E
	MVI	C,SLECTF	;SELECT THAT DRIVE
	CALL	BDOS
	POP	D		;RESTORE FCB ADDRESS
	RET

* OPEN FILE ROUTINE

OPEN	CALL	SELECT		;SELECT THE DRIVE
	MVI	C,OPENF		;OPEN THE FILE
	CALL	BDOS
	RET

* COPY FROM H/L INTO D/E

OLDNEW	LXI	H,OLDFCB	;GET OLD FCB ADDRESS
	LXI	D,NEWFCB	;GET NEW ADDRESS
XFR16	MVI	B,16		;SETUP FOR 16 BYTE COPY
TRNSFR	MOV	A,M		;COPY CHARACTERS
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	TRNSFR
	RET

* ADD A REGISTER TO H/L REGISTER PAIR

ADAHL	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET

* ABORT ROUTINE

ABORT	CALL	TFRCR
	LXI	D,NEWFCB
	CALL	SELECT
	MVI	C,DELETF	;DELETE NEW FILE
	CALL	BDOS
	JMP	WARMS		;EXIT EDITOR

* ROUTINE TO EXIT EDITOR

DEXIT	CALL	TFRCR
	XRA	A
	STA	EXTRD
	STA	EXTWR
DEXIT1	LHLD	FLEND
	SHLD	SPCP2		;SETUP DELETE POINTERS
	XCHG
	LHLD	FLBEG
	SHLD	SPCP1
	CALL	CMPDH		;ANYTHING IN BUFFER ?
	JZ	DEXIT2		;CLOSE FILE IF NOT
	CALL	RECORD		;WRITE OUT FROM BUFFER
	CALL	DLCHR		;DELETE BUFFER CONTENTS
	LDA	ALLIN
	ORA	A		;MORE FILE ON DISK ?
	JNZ	DEXIT2		;CLOSE FILE IF NOT
	LHLD	MMEND
	DCR	H		;SET LOAD END ADDRESS
	XCHG
	CALL	FILLBF		;READ IN ANOTHER BUFFER
	JMP	DEXIT1		;LOOP UNTIL DONE
DEXIT2	MVI	A,1AH		;EOD
	CALL	WRTCH		;WRITE AN END OF FILE
	JMP	CLOSE		;CLOSE AND EXIT


* SYSTEM PARAMETERS

TABCH	DB	00
FILL	DB	' '
LINO	DB	'#'
EOL	DB	00
DCCHR	DB	00
CRC	DB	00

* USER-DEFINABLE SYSTEM PARAMETERS

PRMPT	DB	'#'		;PROMPT CHARACTER
DELET	DB	18H		;DELETE CHARACTER    (CTL-X)
BCKSP	DB	08		;BACKSPACE CHARACTER (CTL-H)
BELL	DB	07		;BELL CHARACTER      (CTL-G)
RPTCH	DB	02		;REPEAT CHARACTER    (CTL-B)
BRKCH	DB	03		;BREAK CHARACTER     (CTL-C)
ESC	DB	1BH		;ESCAPE CHARACTER    (CTL-[)

* EDIT FILESPACE POINTERS

BEGPT	DW	MMBEG		;FIRST LOCATION OF WORKSPACE
MMEND	DW	MMBEG+128	;LAST LOCATION OF WORKSPACE

* TAB BUFFER

TABBF	DS	20
TBEND	DB	00

* COMMAND BUFFER

BUFFR	DS	136

* PROGRAM STACK

STKED	DS	39
STACK	DS	1

* TEMPORARY STORAGE

FLBEG	DS	2		;BEGINNING OF EDIT FILE
FLEND	DS	2		;END OF EDIT FILE (+1)
TEMP	DS	2
BUFPT	DS	2
BUFSV	DS	2
CURPS	DS	2
NEWPS	DS	2
MSPLF	DS	1
CMRPT	DS	1
DELIM	DS	1
STRBG	DS	2
STRED	DS	2
STRB1	DS	2
STRE1	DS	2
CHGPT	DS	2
OCRTP	DS	2
TRGLN	DS	2
LASTN	DS	2
SPCP1	DS	2
SPCP2	DS	2
PSTZF	DS	1
PSTZ1	DS	1
FOUND	DS	1
OVRBG	DS	1
OVRED	DS	1
NOCRL	DS	1
LINEF	DS	1
NXTFG	DS	1
ALLFG	DS	1
OCRFG	DS	1
OCRCT	DS	2
CHGFG	DS	1
CHGON	DS	1
SETON	DS	1
CRFLG	DS	1
APCOL	DS	1
CCHGF	DS	1
FNDON	DS	1
STRC1	DS	1
LASTF	DS	1
STRCT	DS	1
ST2CT	DS	1
INCAM	DS	1
BMPFL	DS	1
EQUFL	DS	1
INTOP	DS	1
MOVFG	DS	1
REPFG	DS	1
TPCHR	DS	1
CHKFL	DS	1
SNGLN	DS	1
PRTFG	DS	1
CPYDR	DS	1
DRCTN	DS	1
CHRCT	DS	2
ZONBF	DS	2
ZBFSV	DS	2
TABPT	DS	2
NUMBR	DS	3
NUMFG	DS	1
VERFG	DS	1
INZFL	DS	1
HEDCT	DS	1
ZONE1	DS	2
ZONE2	DS	2

* DISK BUFFERS AND VARIABLES

OLDFCB	DS	34
NEWFCB	DS	34
EXTFCB	DS	34
OLDBUF	DS	129
NEWBUF	DS	129
EXTBUF	DS	129

FCBADR	DS	2
MEMTOP	DS	2
OLDSP	DS	2
LOGDR	DS	1
SIZE	DS	1
ALLIN	DS	1
EXTRD	DS	1
EXTWR	DS	1
DOPT	DS	1
SOPT	DS	1


* FILE BEGINS HERE

MMBEG	EQU	$


	END
