/*
 *			I N T E R P - H . G
 *
 *  Note that "lread/lwrite" are for lores, "read/write" for word
 *  mode, and "hread/hwrite" for hires.
 *
 *  -Mike Muuss
 */

/* (y)<<>16 */
#define putpixel(x, y, s) { \
	reserve MDR, MAR; \
 \
	MDR = s; \
	MAR = ((x) | HR(y))$ \
	hwrite mash; \
}
/* getpixel is a macro for reading a pixel from frame buffer memory */
#define getpixel(x, y, val) { \
	reserve MAR; 			/* protect the MAR */ \
	MAR = (HR (y)| (x))$	 	/* calculate the address */ \
	hread mash$ 			/* assert the bus function code and \
					   force a new instruction */ \
	val = BUS; 			/* gate the data off the bus into the \
					   result register */ \
	}

main()
{
	doit(256);
/* 	doit(512); */
}

#define a2(a,b,s)	((((((a>>s)&0xFF)+((b>>s)&0xFF))>>1)&0xFF)<<s)
#define avg2(a,b)	(a2(a,b,0) | a2(a,b,8) | a2(a,b,16))

#define a4(a,b,c,d,s)	(((((a>>s)&0xFF)+((b>>s)&0xFF)+((c>>s)&0xFF)+ \
			   ((d>>s)&0xFF)>>2)&0xFF)<<s)
#define avg4(a,b,c,d)	(a4(a,b,c,d,0) | a4(a,b,c,d,8) | a4(a,b,c,d,16))

doit(size)
int size;
{
	register int ul, ur;	/* upper left, upper right */
	register int ll, lr;	/* lower left, lower right */
	register int val;
	register int x2,y2;
	register int x,y;

	for( y=0; y<size-1; y++ )  {
		putpixel( 0, y, 0x40ff0000 );
		putpixel( 1, y, 0x4000ff00 );
		putpixel( 2, y, 0x400000ff );
		putpixel( y, 0, 0x40ff0000 );
		putpixel( y, 1, 0x4000ff00 );
		putpixel( y, 2, 0x400000ff );
		putpixel( y, y, 0x40ff40ff );
	}
}
