/*
 *			R T D I R . H
 *
 * Ray Tracing program, GED database internal directory structure.
 *
 * Author -
 *	Michael John Muuss
 *  
 *  Source -
 *	SECAD/VLD Computing Consortium, Bldg 394
 *	The U. S. Army Ballistic Research Laboratory
 *	Aberdeen Proving Ground, Maryland  21005
 *  
 *  Copyright Notice -
 *	This software is Copyright (C) 1985 by the United States Army.
 *	All rights reserved.
 *
 *  $Header: rtdir.h,v 3.0 86/06/10 01:32:21 mike Exp $
 */

extern int	read();
extern long	lseek();

/*
 * The object directory
 */
struct directory  {
	char		*d_namep;		/* pointer to name string */
	long		d_addr;			/* disk address in obj file */
	struct directory *d_forw;		/* link to next dir entry */
};

#define DIR_NULL	((struct directory *)0)

extern int	ged_fd;			/* FD of object file */

extern char	*strdup();
extern struct directory *dir_add();
extern struct directory *dir_lookup();

#define LOOKUP_NOISY	1
#define LOOKUP_QUIET	0
