/*
 *			E L L I P S E
 *
 *  Functions -
 *	ellipse		Aproximate an ellipse with 16 points
 *
 *  Author -
 *	Mike Muuss
 *  
 *  Source -
 *	SECAD/VLD Computing Consortium, Bldg 394
 *	The U. S. Army Ballistic Research Laboratory
 *	Aberdeen Proving Ground, Maryland  21005
 *  
 *  Copyright Notice -
 *	This software is Copyright (C) 1985 by the United States Army.
 *	All rights reserved.
 */
#ifndef lint
static char RCSid[] = "@(#)$Header: ellipse.c,v 2.2 85/08/07 05:19:03 mike Exp $ (BRL)";
#endif

#include "./machine.h"	/* special copy */
#include "../h/vmath.h"

/*
 * Output vector fields
 */
#define O1	ov+(1-1)*3
#define O2	ov+(2-1)*3
#define O3	ov+(3-1)*3
#define O4	ov+(4-1)*3
#define O5	ov+(5-1)*3
#define O6	ov+(6-1)*3
#define O7	ov+(7-1)*3
#define O8	ov+(8-1)*3
#define O9	ov+(9-1)*3
#define O10	ov+(10-1)*3
#define O11	ov+(11-1)*3
#define O12	ov+(12-1)*3
#define O13	ov+(13-1)*3
#define O14	ov+(14-1)*3
#define O15	ov+(15-1)*3
#define O16	ov+(16-1)*3

void
ellipse( ov, V, A, B )
register float *ov;
register float *V;
float *A, *B;
{
	static float c, d, e, f,g,h;

	e = h = .92388;
	c = d = .707107;
	g = f = .382683;

	VADD2( O1, V, A );
	VJOIN2( O2, V, e, A, f, B );
	VJOIN2( O3, V, c, A, d, B );
	VJOIN2( O4, V, g, A, h, B );
	VADD2( O5, V, B );
	VJOIN2( O6, V, -g, A, h, B );
	VJOIN2( O7, V, -c, A, d, B );
	VJOIN2( O8, V, -e, A, f, B );
	VSUB2( O9, V, A );
	VJOIN2( O10, V, -e, A, -f, B );
	VJOIN2( O11, V, -c, A, -d, B );
	VJOIN2( O12, V, -g, A, -h, B );
	VSUB2( O13, V, B );
	VJOIN2( O14, V, g, A, -h, B );
	VJOIN2( O15, V, c, A, -d, B );
	VJOIN2( O16, V, e, A, -f, B );
}
