/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) vdr_dskcdb.c: version 25.1 created on 11/27/91 at 15:27:46	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)vdr_dskcdb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* vdr_dskcdb -- cdb command format, vendor dependency */

#include	"sys/types.h"
#include	"dev_info.h"
#include	"sdk_cdb.h"
#include	"passthru.h"
#include	"timer.h"
#include	"ccs_dskcdb.h"


extern	struct dev_info	dev;
extern	b_flags;
extern struct scsi_cmd	cmd;
extern struct scsi_result result;

extern char	*memset();

cdb_inquiry(fp, buf, l)
unchar	*buf;
{
	return(ccs_inquiry(fp, buf,l));
}

cdb_read_cap(fp, buf, blk_no)
unchar *buf;
{
	return(ccs_read_cap(fp, buf, blk_no));
}

cdb_start_stop(fp, flag)
{
	return(ccs_start_stop(fp, flag));
}

cdb_medium_removal(fp, flag)
unchar	flag;
{
	return(ccs_medium_removal(fp, flag));
}
cdb_mode_sense(fp, buf, len, flag)
unchar *buf;
unchar flag;
{
	struct g0_cdb	*cdb;
	int	valid_len;

	if (dev.id != ID_RRO)
		return(ccs_mode_sense(fp, buf, len, flag));

	cdb = (struct g0_cdb *)cmd.cmd_dsc_blk;
vrro_retry:
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = 6;
	cdb->opcode = CDB_MODE_SENSE;
	cdb->lun_flags = 0x10;
	cdb->page_flags = flag;
	cdb->alloc_len = len;
	cmd.mil_sec = BASIC_TIMER + TRAN_TIMER;
	if ( (valid_len = issue_cmd (fp, buf, len, SCSI_READ)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				printf("medium changed!\n");
				return(-1);
			}
			if ( b_flags == B_RESET)
				goto vrro_retry;
			return(0);	
		}
	}
}

cdb_format(fp, use_grown)
{
	int	flags;
	long	data_hdr;

	if (dev.id == ID_RRO)
		return(0);
	if (dev.id == ID_IBM)
		flags = CP_LIST;
	else
		if (use_grown)
			flags = FMTDATA | FMTGWN_LIST; /* grown list */
		else	flags = FMTDATA | FMTCMP_LIST; /* delete grown list */
	data_hdr = 0;
	return(ccs_format(fp, &data_hdr, sizeof(data_hdr), flags));
}

cdb_reassign_blocks(fp, data, len)
unchar *data;
{
        return(ccs_reassign_blocks(fp, data, len));
}

cdb_mode_select(fp, data, len, flag)
unchar *data;
unchar	flag;
{
        return(ccs_mode_select(fp, data, len, flag));
}
cdb_write(fp, buf,blkno, len, noblks)
unchar	*buf;
{
	return(ccs_write(fp, buf,blkno, len, noblks));
}

cdb_read(fp, buf,blkno, len, noblks)
unchar *buf;
{
	return(ccs_read(fp, buf,blkno, len, noblks));
}
