/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) slice.c: version 25.1 created on 11/27/91 at 15:27:34	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)slice.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"iopmfmt.h"
#include	"macros.h"
#include	"sdk_cdb.h"
#include	"sdkcfg.h"
#include	"sdk_disk.h"
#include	"disksect.h"
#include	"ctype.h"
#if	defined(STANDALONE)
#include	"spm_debug.h"
#else
#include	"sys/debug.h"
#endif /* STANDALONE */

#if 0
static char		type_msg[] =
     "\nEnter type ((u)nix, (s)wap, (b)oot, (d)iag, de(f)ect, or (q)uit): ";
#endif
static char		type_msg[] =
     "\nEnter type ((u)nix, (s)wap, (b)oot, (d)iag, or (q)uit): ";

/* default slice no */
#define ROOT_SLICE	0
#define	SWAP_SLICE	1
#define USR_SLICE	2
#define BOOT_SLICE	15
#define DIAG_SLICE	17
#define UNUSED_SLICE	18
#define DEF_BOOT_SIZE	1000	/* Default boot size. */
#define DEF_ROOT_SIZE	20000	/* Default root slice size. */
#define DEF_SWAP_SIZE	16000	/* Default swap slice size. */
#define DEF_USR_SIZE	60000	/* Default usr slice size. */

/* defines for show_graph */
#define NUM_SHOW	64	/* number of meg per line in bar graph */
#define MIN(a, b)	((a) < (b) ? (a) : (b))
#define MAX(a, b)	((a) > (b) ? (a) : (b))
#define F_MEG(x)	((x) >> 10)	/* 1Mb = 1K * 1Kb sector	*/
#define T_MEG(x)	((x) << 10)
#define COLL_BIT	0x80
#define USED_BIT	0x40
#define SLICE_MASK	0x3f

extern char	*memset();
extern long	strtol();
extern void	exit();

static daddr_t	cur_disk_space;		/* number of available disk blocks */
static daddr_t	cur_block;		/* current block number		*/
static uint	align;			/* align-to-cyl-bounds flag	*/

#if 0 /* declan - no longer create defect slice */
      /* still need to recognize it though for backward compatibility */
/*
 * setup_dfect_slice -- Set up the default defect list slice, etc.
 *			Note: initializes cur_disk_space and cur_block.
 */
static
setup_dfect_slice()
{
	SLSIZE	*slp = &sltable[DEF_DEFCT_SLICE];

	cur_disk_space =
	  dev.lst_blkno + 1 - FIRST_DATA_BLOCK_NUM - DEF_DEFCT_SIZE;
	cur_block = FIRST_DATA_BLOCK_NUM + DEF_DEFCT_SIZE; /* 10 blocks */

	if (cur_disk_space < DEF_BOOT_SIZE / 2) {
		dev_print("Disk space error - not enough total blocks!");
		return(0);
	}

	/* The default defect slice is currently 16. */
	slp->offset = DEF_DEFCT_LIST; /* ..at block 2.. */
	slp->noblk = DEF_DEFCT_SIZE;  /* ..for 10 blocks */
	slp->type = LD_DEFCT_SLICE; /* currently slice 4 */

	return(1);
}
#endif 

/* get last block number on same cylinder, or disk's last block */
static daddr_t
cyln_last_block(blkno)
daddr_t	blkno;
{
	struct capacity	ca;

	/* cdb_read_cap - if param 3 (block number) is non-zero, finds the last
	 * block of the cylinder on which that block resides.  If zero, returns
	 * the last block on the disk. */

	if (cdb_read_cap(dsk_fd, &ca, blkno) < 0)
		return(blkno);

	return(CAT4(ca.lba_msb, ca.lba_2, ca.lba_1, ca.lba_lsb));
}

/*
 * Rounds blkno (which should not be zero) up to a cylinder boundary.
 */
static daddr_t
sdk_nice_blkno(blkno)
daddr_t	blkno;
{
	daddr_t	first_block;

	first_block = cyln_last_block(blkno - 1) + 1;
	ASSERT(first_block >= blkno);
	return(first_block);
}


static
set_slice(slp, size, cur_slice)
SLSIZE		*slp;
register daddr_t size;
uint		cur_slice;
{
	daddr_t	block;

	if (cur_disk_space <= 0)
		return(0);

	if (size > cur_disk_space)
		size = cur_disk_space;
	else if (align && dev.id != ID_OCU) {
		if (cur_slice != BOOT_SLICE) {
			block = sdk_nice_blkno(cur_block);
			cur_disk_space -= block - cur_block;
			cur_block = block;
		}
		size = sdk_nice_blkno(cur_block + size) - cur_block;
		/* Don't run off end of disk after alignment */
		if (size > cur_disk_space)
			size = cur_disk_space;
	}

	slp->offset = cur_block;
	slp->noblk = size;

	switch (cur_slice) {
	case SWAP_SLICE:
		slp->type = LD_SWAP_SLICE;
		break;
	case BOOT_SLICE:
		slp->type = LD_BOOT_SLICE;
		break;
	default:
		slp->type = LD_UNIX_SLICE;
	}

	cur_block += size;
	cur_disk_space -= size;

	return(1);
}

static
setup_boot_slice()
{
	if (!set_slice(&sltable[BOOT_SLICE], DEF_BOOT_SIZE, BOOT_SLICE)) {
		printf("Failed to setup the boot slice.\n");
		return(0);
	}
	return(1);
}

static daddr_t
get_cyln_size(blkno)
daddr_t	blkno;
{
	daddr_t	cur_cyln_lastblk, cur_cyln_first_blk,
		prev_cyln_lastblk, prev_blkno;

	if ((cur_cyln_lastblk = cyln_last_block(blkno)) == 0)
		return(0);

	prev_blkno = blkno;

	/* trying to get previous cylinder's last block */
	do {
		if((prev_blkno -= 100) <= 0)
			prev_blkno = 1;
		if ((prev_cyln_lastblk = cyln_last_block(prev_blkno)) == 0)
			return(0);
	} while ( prev_blkno != 1 && prev_cyln_lastblk == cur_cyln_lastblk);

	/* At this point, we found the different cylinder last blocks */
	/* and we are trying to get exact previous cylinder's last block */

	while (prev_cyln_lastblk != cur_cyln_lastblk) {
		prev_blkno = prev_cyln_lastblk + 1;
		if ((prev_cyln_lastblk = cyln_last_block(prev_blkno)) == 0)
			return(0);
	}

	if(prev_blkno == 1)
		cur_cyln_first_blk = 0;
	else
		cur_cyln_first_blk = prev_blkno;
	/* calculate total number of blocks in this cylinder */
	return( cur_cyln_lastblk - cur_cyln_first_blk + 1);
}

/* setup diagnostic slice, the most inner 2 cylinders */
static
setup_diag_slice()
{
	daddr_t	last, size;
	SLSIZE	*slp = &sltable[DIAG_SLICE];

	/* Get the size of the two innermost cylinders. */
	last = dev.lst_blkno - 1;
	if ((size = get_cyln_size(last)) == 0 ||
	    (last = get_cyln_size(last - size)) == 0)
		return (0);
	size += last;

	slp->type = LD_DIAG_SLICE;
	slp->offset = dev.lst_blkno + 1 - size;
	slp->noblk = size;
	cur_disk_space -= size;

	if (cur_disk_space <= 0) {
		dev_print("cannot allocate space for diagnositic slice");
		return(0);
	}
	return(1);
}

/*
 * prompt_num -- prompt for a number between low and high, inclusive
 *		Side effect note:  modifies cline_buf
 */

/*VARARGS3*/
ulong
prompt_num(low, high, fmt, a1, a2, a3)
ulong	low, high;
char	*fmt;
{
	ulong	num;
	char	*p;

	for (;;) {
		printf(fmt, a1, a2, a3);
		if (get_line(cline_buff, sizeof(cline_buff)) <= 0)
			exit(0);

		p = cline_buff;
		num = (ulong)strtol(cline_buff, &p, 0);
		if ((num == 0 && p == cline_buff) || (*p && !isspace(*p))) {
			printf("Invalid input string: %s\n", cline_buff);
			continue;
		}

		if (num < low || num > high) {
			printf("Invalid number: %u(0x%x) (use %u(0x%x) to \
%u(0x%x))\n", num, num, low, low, high, high);
			continue;
		}
		return (num);
	}
}

/*
 * default_num -- prompt for a number between low and high, with default value
 *		Side effect note:  modifies cline_buf
 */

long
default_num(low, high, def, msg)
long	low, high, def;
char	*msg;
{
	long	num;
	char	*p;

	for (;;) {
		printf("%s (default=%d, or %d to %d): ", msg, def, low, high);
		if (get_line(cline_buff, sizeof(cline_buff)) <= 0)
			exit(0);

		p = cline_buff;
		num = strtol(cline_buff, &p, 10);
		if (*p && !isspace(*p)) {
			printf("Invalid input string: %s\n", cline_buff);
			continue;
		}
		if (num == 0 && p == cline_buff)
			num = def;

		if (num < low || num > high) {
			printf("Invalid number: %d (use %d to %d)\n",
			  num, low, high);
			continue;
		}
		return (num);
	}
}

static long
size_prompt(slice, kbytes_left)
uint	slice;
daddr_t	kbytes_left;
{
	return (prompt_num(0L, kbytes_left,
	  "\nKbytes remaining %d\nSlice %d, enter slice size (Kbytes): ",
	  kbytes_left, slice));
}

/* setup_swap_slice() - set the swap slice data in the slice table.
 */
static
setup_swap_slice()
{
	long	swap_size;

	swap_size = size_prompt(SWAP_SLICE, cur_disk_space);

	if (!set_slice(&sltable[SWAP_SLICE], swap_size, SWAP_SLICE)) {
		printf("Failed to setup the swap slice.\n");
		return(0);
	}
	return(1);
}

static daddr_t
get_spt(blkno)
daddr_t	blkno;
{
	daddr_t	tot_blk;

	if (dev.id == ID_OCU)
		return(30);	/* pickup any number */
	if ((tot_blk = get_cyln_size(blkno)) == 0)
		return(0);
	else
		return((tot_blk * dev.blk_ratio / dev.heads) *
		       (dev.blk_len / dev.bps));
}

static
is_scsi_edt(s0)
struct edt_sector0 *s0;
{
	if (strncmp(s0->id, "INIT", 4) ||
	    s0->pd_ldmaxnum > LOGDR || s0->pd_ldnum > LOGDR)
		return(0);
	else
		return(1);
}

static
is_iopm_disk(s0)
struct sdk_block_0	*s0;
{
	return(strncmp((char *)s0->misc.disk_info.vol_id, "IOPMSCSI", 8) == 0);
}

static
is_old_disk(s0)
struct sdk_block_0	*s0;
{
	return(s0->misc.disk_info.date < VERSION_DATE );
}

static
set_edt_disk_table(s0)
struct edt_sector0	*s0;
{
	register SLSIZE		*ld;
	register struct logtype	*drp;
	register int		i;

	drp = s0->logdrive;
	for (i = 0, ld = sltable; i < LOGDR; i++, ld++, drp++) {
		switch (drp->ld_type) {
		case LD_UNIXFS:
		case LD_PWF:
		case LD_USERHOLE:
		case LD_USERSPARE:
		case LD_USERSKIP:
		case LD_USERSPLIT:
		default:
			ld->type = LD_UNIX_SLICE;
			break;
		case LD_SWAP:
			ld->type = LD_SWAP_SLICE;
			break;
		}
		ld->offset = drp->ld_strt;
		ld->noblk = drp->ld_size;
	}

	for (i = 0, ld = sltable; i < LOGDR; i++, ld++) {
		if (ld->noblk != 0)
			ld->spt = get_spt(ld->offset);
		else
			ld->spt = 0;
	}
	return(1);
}

static
set_old_disk_table(s0)
SECTOR0	*s0;
{
	register int		i;
	register SLSIZE		*ld;
	register OLD_SLSIZE	*osp;

	osp = s0->sltable;
	ld = sltable;
	for (i = 0; i < NEL(s0->sltable); i++, osp++, ld++) {
		if (osp->noblk == 0)
			continue;
		ld->type = LD_UNIX_SLICE;
		ld->offset = osp->offset + s0->phyblkno;
		ld->noblk = osp->noblk;
		if ((ld->spt = get_spt(ld->offset)) == 0)
			return(0);
	}
	return(1);
}

static
set_new_disk_table(s0)
struct sdk_block_0	*s0;
{
	register int		slice;
	register union _s0_blk1	*b1p = s0->slice_table;
	register SLSIZE		*sl = sltable;

	for (slice = 0; slice < MAX_IOPM_SLICES; slice++, sl++, b1p++) {
		sl->type   = b1p->ldrv.ld_type;
		sl->spt    = b1p->ldrv.ld_spt;
		sl->offset = b1p->ldrv.ld_strt;
		sl->noblk  = b1p->ldrv.ld_size;
	}

}

read_slice_table()
{
	register struct sdk_block_0	*s0;

	s0 = (struct sdk_block_0 *) buf;
	/* read config block */
       	if (cdb_read(dsk_fd, s0, CONFIG_BLOCK * dev.blk_ratio, BSIZE,
		     dev.blk_ratio) < 0)
		return(0);

	/* check if disk has been formated ? */

	if (is_scsi_edt((struct edt_sector0 *)s0)) {
		if (!set_geometry_info(dsk_fd))
			return(0);
		set_edt_disk_table((struct edt_sector0 *)s0);
		dev.format = FMT_EDT;
		return(1);
	}

	if (is_iopm_disk(s0)) {
		if (is_old_disk(s0)) {
			if (!set_geometry_info(dsk_fd) ||
			    !set_old_disk_table((SECTOR0 *)s0))
				return(0);
			dev.format = FMT_OLD;
		}
		else {
			set_new_disk_table(s0);
			dev.format = FMT_NEW;
			dev.bps = s0->misc.disk_info.bps;
			dev.heads = s0->misc.disk_info.heads;
		}
		return(1);
	}

	/* else, not formatted, or unrecognized */

	dev.format = FMT_NO;
	dev_print("device is not formatted");

	return(0);
}

write_slice_table()
{
	register union _s0_blk1	*b1p;
	register SLSIZE		*sp, *last, *others;
	register int		i;
	struct sdk_block_0	*s0;

	if (dev.format == FMT_EDT || dev.format == FMT_OLD) {
		printf(
"Cannot write out EDT or old IOPM config!  Reformat and try again.\n");
		return(0);
	}


	/* check each slice is ok */
	last = &sltable[MAX_IOPM_SLICES - 1];
	for (i = 0, sp = sltable; i < MAX_IOPM_SLICES; i++, sp++) {
		if (sp->noblk == 0)	/* empty slot */
			continue;

		/* check slice is in disk range */
		if (sp->offset < FIRST_DATA_BLOCK_NUM) {
			dev_print("ERROR: Slice %d is using reserved block %d!",
			  i, sp->offset);
			return(0);
		}
		if (sp->offset + sp->noblk - 1 > dev.lst_blkno) {
			dev_print("ERROR: Slice %d is off the end of the disk!",
			  i);
			return(0);
		}

		/* check if this slice is overlapped with others */
		for (others = sp + 1; others <= last; others++) {
			if (others->noblk == 0)
				continue;
			if (sp->offset >= others->offset + others->noblk ||
			    others->offset >= sp->offset + sp->noblk)
				continue;
			dev_print("ERROR: slices %d and %d overlap!",
			  i, others - sltable);
			return(0);
		}

		/* set sector per track */
		if ((sp->spt = get_spt(sp->offset)) == 0) {
			dev_print(
			  "ERROR: Unable to learn sectors-per-track value!");
			return(0);
		}
	}

	if (dev.format == FMT_NEW &&
	    question("\nReally overwrite existing slice table?") == NO)
		return(0);

	s0 = (struct sdk_block_0 *)buf;

	if (cdb_read(dsk_fd, s0, CONFIG_BLOCK*dev.blk_ratio, 1024,
		     dev.blk_ratio) < 0) {
		dev_print("ERROR: Slice table block read failed!");
		return(0);
	}

	sp = sltable;
	b1p = s0->slice_table;
	for (i = 0; i < MAX_IOPM_SLICES; i++, b1p++, sp++){
		b1p->ldrv.ld_type = sp->type;
		b1p->ldrv.ld_strt = sp->offset;
		b1p->ldrv.ld_size = sp->noblk;
		b1p->ldrv.ld_spt = sp->spt;
	}

	/* save in the disk */
	if (cdb_write(dsk_fd, s0, CONFIG_BLOCK*dev.blk_ratio, 1024,
		      dev.blk_ratio) < 0) {
		dev_print("ERROR: slice table block write failed!");
		return(0);
	}
	if (cdb_write(dsk_fd, s0, CONFIG_BLOCK_BKUP*dev.blk_ratio, 1024,
		      dev.blk_ratio) < 0)
		dev_print("ERROR: Backup slice table block write failed!");

	return(1);
}

/*
 * set_slice_type -- prompts for and sets a slice's type
 *		returns zero for 'quit', else non-zero if set a type
 */

static int
set_slice_type(slp)
SLSIZE	*slp;
{
	int	type;

	for (;;) {
		switch (type = tolower(prompt_char(type_msg))) {
		case 'u':
			slp->type = LD_UNIX_SLICE;
			break;
		case 's':
			slp->type = LD_SWAP_SLICE;
			break;
		case 'd':
			slp->type = LD_DIAG_SLICE;
			break;
#if 0
		case 'f':
			slp->type = LD_DEFCT_SLICE;
			break;
#endif
		case 'b':
			slp->type = LD_BOOT_SLICE;
			break;
		case 'q':
			return (-1);
		default:
			continue;
		}
		return (type);
	}
}


editing()
{
	register daddr_t	slice, offset, ssize;
	int			auto_flag;
	register SLSIZE		*slp;
	int	changed = 0;	/* had the slice table been modified */

	auto_flag = question("Align slices on cylinder boundries?");
	do {
		slice = prompt_num(0L, MAX_IOPM_SLICES - 1L,
		  "\nEnter the slice number (between 0 and %d): ",
		  MAX_IOPM_SLICES - 1);
		slp = &sltable[slice];

		if ((offset = slp->offset) > dev.lst_blkno)
			offset = slp->offset = dev.lst_blkno;
		else if (offset < FIRST_DATA_BLOCK_NUM)
			offset = FIRST_DATA_BLOCK_NUM;
		offset = default_num(FIRST_DATA_BLOCK_NUM, (long)dev.lst_blkno,
				     offset, "\nEnter starting block");

		if ((auto_flag && offset != 0 &&
		     (offset = sdk_nice_blkno(offset)) == 0)) {
			printf("\nNot a valid block number: %d\n", offset);
			continue;
	        }
		ssize = default_num(0L, dev.lst_blkno - offset + 1L,
				    slp->noblk, "\nEnter slice size");

		for (;;) {
			if (set_slice_type(slp) < 0)
				return(changed);
			if (slice >= NUM_UNIX_SLICES &&
			    slp->type == LD_UNIX_SLICE) {
				printf("Only slices 0 to %d may be UNIX\n",
				  NUM_UNIX_SLICES - 1);
				continue;
			}
			break;
		}

		slp->offset = offset;
		slp->noblk = ssize;
		show_table();
		changed = 1;
	} while (question("\nQuit editing?") == NO);
	return(changed);
}

static void
print_slice(cur_slice)
uint	cur_slice;
{
	SLSIZE	*sp = &sltable[cur_slice];
	char	*type_name;

	switch (sp->type) {
	case LD_UNUSED_SLICE:
		type_name = "UNUSED";
		break;
	case LD_UNIX_SLICE:
		type_name = "UNIX";
		break;
	case LD_SWAP_SLICE:
		type_name = "SWAP";
		break;
	case LD_DIAG_SLICE:
		type_name = "DIAG";
		break;
	case LD_DEFCT_SLICE:
		type_name = "DEFCT";
		break;
	case LD_BOOT_SLICE:
		type_name = "BOOT";
		break;
	default:
		type_name = "Unknown!";
		break;
	};
	printf("%3d %-6s %3d %7d %7d %7d",
	  cur_slice, type_name, sp->spt,
	  sp->offset, sp->noblk, sp->offset + sp->noblk - 1);
}

show_table()
{
	register uint 	ndx, hdx, half;
	register uint	total_valid;		/* total num slices to print */
	register uint	remainder;
	uchar		vs[MAX_IOPM_SLICES];	/* printable slice numbers */

	static char	theader[] = "\
Num  Type  S/T  Start    Size    End     Num  Type  S/T  Start    Size    End\
\n";

	/* find total_valid slice count and save those slices index in vs[]. */
	for (total_valid = ndx = 0; ndx < MAX_SLICE_NUM; ndx++)
		if (sltable[ndx].noblk != 0) {
			vs[total_valid] = ndx;
			total_valid++;
		}

	half = total_valid >> 1;
	remainder = total_valid & 1;
	hdx = half + remainder;

	printf(theader);

	/* Print two columns... */
	for (ndx = 0; ndx < half; ndx++, hdx++) {
		print_slice(vs[ndx]);		/* column 1 */
		printf("   ");
		print_slice(vs[hdx]);		/* column 2 */
		printf("\n");
	}
	/* If one more slice print it. */
	if (remainder) {
		print_slice(vs[ndx]);		/* column 1 */
		printf("\n");
	}
}

semi_auto_slice()
{
	uint	n;		/* Index into the slice data. */
	daddr_t	size;		/* Size of slice */
	uint	boot_flag;	/* Indicates processing bootable slice. */
	register SLSIZE	*slp;

	if (dev.format != FMT_NEW) {
		dev_print("Disk is not configured as IOPM layout.");
		return(0);
	}

	memset((char *)sltable, 0, sizeof(sltable));

	printf("\nSemi-auto slice sets the disk up with a diagnostic ");
	printf("slice.\n\n");

	/* align : global flag indicating we need cylinder alignment. */
	align = question("Align slices on cylinder boundries?");

	/* initialize statics */
	cur_block = FIRST_DATA_BLOCK_NUM;
	cur_disk_space = dev.lst_blkno + 1 - FIRST_DATA_BLOCK_NUM;

#if 0 /* declan : no longer use defect slice */
	/* set default defect list slice */
	if (!setup_dfect_slice())
		return(1);
#endif

	if ((boot_flag = question("Is bootable system disk?")) != NO) {
		if (cur_disk_space < DEF_BOOT_SIZE) {
			dev_print("Not enough boot space!");
			printf("Default boot slice needs: %d blocks, ",
			  DEF_BOOT_SIZE);
			printf("only %d block(s) remain.\n",
			  (cur_disk_space > 0) ? cur_disk_space : 0);
			return(1);
		}
		else if (!setup_boot_slice())
			return(1);
	}

	if (dev.id != ID_OCU && !setup_diag_slice())
		return(1);

	/* Proceed to semi auto-slice. */
	slp = sltable;
	for (n = 0; cur_disk_space > 0 && slp->noblk == 0
		&& n < NUM_UNIX_SLICES; slp++, n++) {
		if (boot_flag && n == SWAP_SLICE) {
			printf("\nSlice %d is by default the swap slice.\n", n);
			if (!setup_swap_slice())
				return(1);

			show_table();
			continue;
		}

		size = size_prompt(n, cur_disk_space);

		if (!set_slice(slp, size, n))
			break;

		/* Overides type set in set_slice. */
		if (set_slice_type(slp) < 0)
			return(1);

		show_table();
	}

	/* Collect any big leftover chunk into the unused slice */
	slp = &sltable[UNUSED_SLICE];
	if (cur_disk_space > 0) {
		slp->offset = cur_block;
		slp->noblk = cur_disk_space;
		slp->type = LD_UNUSED_SLICE;
	}
}

auto_slice()
{
	register uint	n;		/* Index into the slice data. */
	register uint	boot_flag;	/* bootable slice flag. */
	daddr_t		size, blks;	/* Size of slice in 1K sectors */
	register SLSIZE	*slp;

	if (dev.format != FMT_NEW) {
		dev_print("Disk is not configured as IOPM layout.");
		return(0);
	}

	memset((char *)sltable, 0, sizeof(sltable));


	/* initialize statics */
	cur_block = FIRST_DATA_BLOCK_NUM;
	cur_disk_space = dev.lst_blkno + 1 - FIRST_DATA_BLOCK_NUM;

#if 0 /* declan : no longer use defect slice */
	/* set default defect list slice */
	if (!setup_dfect_slice())
		return(1);
#endif

	if (dev.id != ID_OCU && !setup_diag_slice())
		return(1);

	printf("Available disk space = %d blocks\n\n", cur_disk_space);

	align = question("Align slices on cylinder boundries?");

	if ((boot_flag = question("Is bootable system disk?")) != NO) {
		if (cur_disk_space < DEF_BOOT_SIZE) {
			dev_print("Not enough boot space!");
			printf("Default boot slice needs: %d blocks, ",
			  DEF_BOOT_SIZE);
			printf("only %d block(s) remain.\n",
			  (cur_disk_space > 0) ? cur_disk_space : 0);

			printf("Continue auto-slice with NO bootable slice?");

			if (question("") == NO)
				return(1); /* to menu */

			boot_flag = 0;
		}
		else if (!setup_boot_slice())
			return(1);
	}

	size = prompt_num(1L, cur_disk_space, "Slice size(Kbytes): ");
	printf("\n");

	/* Proceed to auto-slice. */
	slp = sltable;
	for (n = 0; slp->noblk == 0 && n < NUM_UNIX_SLICES; slp++, n++) {
		if (boot_flag)
			switch (n) {
			case ROOT_SLICE:
				blks = DEF_ROOT_SIZE;
				break;
			case SWAP_SLICE:
				blks = DEF_SWAP_SIZE;
				break;
			case USR_SLICE:
				blks = DEF_USR_SIZE;
				break;
			default:
				blks = size;
			}
		else
			blks = size;

		if (!set_slice(slp, blks, n))
			break;
		if (!boot_flag && (n == SWAP_SLICE || n == BOOT_SLICE))
			slp->type = LD_UNIX_SLICE;
	}
	/*
	 * Add any leftover space to the unused slice
	 */
	if (cur_disk_space > 0) {
		slp = &sltable[UNUSED_SLICE];
		slp->offset = cur_block;
		slp->noblk = cur_disk_space;
		slp->type = LD_UNUSED_SLICE;
	}

	show_table();
	return(1);
}

/*
 * show_graph -- print a bar graph of the disk allocation
 */

show_graph()
{
	register int		n, i;
	register daddr_t	blk, start, count, end;
	daddr_t			num_blks;
	register SLSIZE		*slp;
	register uchar		*up;
	uchar			meg[NUM_SHOW + 4];

	static char	slice_c[] = "0123456789abcdefghijklmnopqrstuv";
	static char	coll_ch[] = ")!@#$%^&*(ABCDEFGHIJKLMNOPQRSTUV";
	static char	gheader[] = "\n\
#Meg 0       8       16      24      32      40      48      56     63\n\
     |.......|.......|.......|.......|.......|.......|.......|.......\n";

	printf(gheader);
	start = 0;
	num_blks = dev.lst_blkno + 1;
	do {
		memset((char *)meg, 0, sizeof(meg));

		count = MIN(T_MEG(NUM_SHOW), num_blks);
		end = start + count;

		/*
		 * set slice number in meg cooresponding to space used per slice
		 */
		slp = &sltable[MAX_IOPM_SLICES - 1];
		for (n = MAX_IOPM_SLICES; --n >= 0; --slp) {
			if (slp->noblk == 0 || slp->offset >= end ||
			    slp->offset + slp->noblk <= start)
				continue;

			blk = MAX(start, slp->offset) - start;
			i = MIN(end, slp->offset + slp->noblk) - start;
			for ( ; blk < i; up++, blk += T_MEG(1)) {
				up = &meg[F_MEG(blk)];
				if (*up)
					*up |= COLL_BIT;
				else
					*up = n | USED_BIT;
			}
		}

		/*
		 * convert to empty, slice, or collided slice chars and print
		 */
		n = F_MEG(count + T_MEG(1) - 1);
		for (up = meg; --n >= 0; up++) {
			if ((i = *up) == 0)
				*up = '-';
			else if (i & COLL_BIT)
				*up = coll_ch[i & SLICE_MASK];
			else
				*up = slice_c[i & SLICE_MASK];
		}
		printf("%04d:%s\n", F_MEG(start), meg);

		start += count;
	} while ((num_blks -= count) > 0);
}
