/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_ermsg.c: version 25.1 created on 11/27/91 at 15:27:15	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_ermsg.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_lerrmsg.c  */
#include "sys/types.h"
#include "sys/debug.h"

#define	MAX_SCSIERR_NUM	0x4F
#define MAX_SENSE_NUM	0xF
#define	NULL		0

char *sense_key_msg[] = {	 /* shared with the nine track driver */
/* 0 */ 	"no sense",
/* 1 */		"recovered error",
/* 2 */ 	"drive is not ready",
/* 3 */		"unrecoverable data error",
/* 4 */		"hardware error",
/* 5 */		"illegal request",
/* 6 */		"unit attention ", 
/* 7 */		"write protected",
/* 8 */		"blank check - A no-data condition was encountered on the tape",
/* 9 */		"unknown error code 09",
/* A */ 	"unknown error code 0a",
/* B */		"aborted command",
/* C */		"unknown error code 0c",
/* D */		"volume overflow",
/* E */		"unknown error code 0e",
/* F */ 	"unknown error code 0f"
};


char  *scsi_report_err[] = {
/* 0 */		"No error",
/* 1 */		"Invalid parameter in command mailbox",
/* 2 */		"Invalid unit id",
/* 3 */		"Device has been reset or media has been changed",
/* 4 */		"The length of CDB is 0 ",
/* 5 */		"The transfer data direction is inconsistent ",
/* 6 */		0,
/* 7 */		0,
/* 8 */		0,
/* 9 */		0,
/* a */		0,
/* b */		0,
/* c */		0,
/* d */		0,
/* e */		0,
/* f */		0,
/* 10 */	"SCSI bus accessing timeout",
/* 11 */	"Illegal select sequence number",
/* 12 */	"Illegal phase changed",
/* 13 */	"Parity error",
/* 14 */	"SCSI bus reset",
/* 15 */	"Unexpected disconnect",
/* 16 */	"Device is not on line",
/* 17 */	"Command excution timeout",
/* 18 */	0,
/* 19 */	0,
/* 1a */	0,
/* 1b */	0,
/* 1c */	0,
/* 1d */	0,
/* 1e */	0,
/* 1f */	0,
/* 20 */	"Unexpected message received",
/* 21 */	"Message was rejected by target",
/* 22 */	"Fatal error",
/* 23 */	"Device error, request sense data is available in error buffer",
/* 24 */	"Device busy",
/* 25 */	0,
/* 26 */	0,
/* 27 */	0,
/* 28 */	0,
/* 29 */	0,
/* 2a */	0,
/* 2b */	0,
/* 2c */	0,
/* 2d */	0,
/* 2e */	0,
/* 2f */	0,
/* 30 */	"DMA bus error",
/* 31 */	"DMA count error",
/* 32 */	0,
/* 33 */	0,
/* 34 */	0,
/* 35 */	0,
/* 36 */	0,
/* 37 */	0,
/* 38 */	0,
/* 39 */	0,
/* 3a */	0,
/* 3b */	0,
/* 3c */	0,
/* 3d */	0,
/* 3e */	0,
/* 3f */	0,
/* 40 */	"unexpected interrupt status ",
/* 41 */	"illegal ncr command ",
/* 42 */	0,
/* 43 */	0,
/* 44 */	0,
/* 45 */	0,
/* 46 */	0,
/* 47 */	0,
/* 48 */	0,
/* 49 */	0,
/* 4a */	0,
/* 4b */	0,
/* 4c */	0,
/* 4d */	0,
/* 4e */	0,
/* 4f */	0
};

/* entries that only contain 0 means reserved entry for future use */

/*
  scsi_err_msg -- return the error message pointer 
		This routine is called by high level drivers to get
		error message. the error message corresponds to the error code 
		which was set by low level driver.

   input:
	err_code: error code.
	
   output:
	a message pointer, if error code is a valid error code.
	otherwise, return 0.
*/
char *
scsi_err_msg(err_code)
ushort err_code;
{
	char	*err_msg;

	if (err_code > MAX_SCSIERR_NUM )
		return(NULL);

	if ((err_msg = scsi_report_err[err_code]) == NULL) {
		ASSERT(0);
		return(NULL);
	}

	return (err_msg);
}

char *
scsi_sns_msg(sense_key)
unchar sense_key;
{
	if (sense_key > MAX_SENSE_NUM) {
		ASSERT(0);
		return(NULL);
	}
	else
		return (sense_key_msg[sense_key]);
}
