/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fmt_menu.c: version 25.1 created on 11/27/91 at 15:26:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fmt_menu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* sdkfmt -- iopm scsi disk utilities */
/* log
   011989	add new option to initialize disk
   030889	eliminate the protection of slice 0
   082889	modify to get make new disk layout work 
   102589	using passthru driver
   121089	standalone version
   122189	format also include config disk
   010390	fix illegal request when doing IBM format
		Add SPECIAL prod id for RICHO optical drive
   010990       For WORM drive, don't do the alignment
   011590	Change interface with pt driver to fit in
		new interface
   011690	Fix illegal request problem and enhenced error
		message display for sense data
		change macros.h  file to use CAT instead of CTOI
   011790	give any number for spt on OCU to make mkfs happy
   012490	Give option for user to continue process if device is
		not included in the device list.
*/

#if	!defined(STANDALONE)
#include	<sys/stdio.h>
#endif

#include	"iopmfmt.h"
#include	"ctype.h"
#include	<sys/fcntl.h>
/* #include	"sys/elog.h" */
#include	"macros.h"
#include	<sys/debug.h>

char *main_menu[] = {
	"\n	     MAIN MENU\n",
	"1-Disk Format and initialization",
	"2-Slice table management",
	"3-Disktest",
	0
};
/* main menu select definitions */

#define M_FMTDSK	1
#define M_SLICE		2
#define M_DSKTST	3
#define M_EXIT		0

char *fmt_menu[] = {
	"\n	     FORMAT MENU\n",
	"1-Format and Configure disk",
	"2-Format, discard reassigned blocks and Configure disk",
	"3-Configure disk",
	0
};

/* fmt_menu select definitions */

#define F_FMTDSK	1
#define F_FULL_FMTDSK	2
#define F_CONFIG	3
#define F_EXIT		0

char *slice_menu[] = {
	"\n	     SLICE MENU\n",
	"1-Auto slicing",
	"2-Semi-auto slicing",
	"3-Editing slice table",
	"4-Display slice table",
	"5-Save slice table",
	"6-Show slice bar graph",
	0
};

/* slice menu select definitions */

#define S_AUTO		1
#define S_SEMI_AUTO	2
#define S_EDIT		3
#define S_DISPLAY	4
#define	S_SAVE		5
#define	S_BARGRAPH	6
#define S_EXIT		0

char *disktst_menu[] = {
	"\n	     DISKTEST MENU\n",
	"1-Select test type (read, write, compare)",
	"2-Select one block",
	"3-Select block range",
	"4-Select number of blocks per read/write operation",
	"5-Display read buffer",
	"6-Select write buffer",
	"7-Single test pass",
	"8-Loop on test",
	"9-Reassign Blocks",
	0
};

/* disktst menu select definitions */

#define D_TSTTYPE	1
#define D_ONEBLK	2
#define D_RANGE		3
#define D_NBLK		4
#define D_BUFDISP	5
#define D_BUFSEL	6
#define D_ONETST	7
#define D_LOOPTST	8
#define D_REASSIGN	9
#define D_EXIT		0

int		dsk_fd;				/* disk's file descriptor */
char		*device_name;
char		buf[BSIZE], altbuf[BSIZE];
SLSIZE		sltable[MAX_SLICE_NUM];
char		cline_buff[LINE_SIZE];		/* Command line buffer. */

#if defined(STANDALONE)
#define	DEV_NAMLEN	160
#endif

struct dev_info	dev;

static char	fmt_warn[] =
	"\nWARNING - Formatting will destroy any data on the device.\n\n";
static char	full_fmt_warn[] =
	"\nWARNING - Formatting will destroy any data on the device.\n\n";
static char	cfg_warn[] =
	"\nWARNING - Configuring will destroy any slicing information on the \
device.\n\n";
static char	white_sep[] = " \n\t";

extern int	errno;

extern char	*strchr();
extern long	strtol();
extern void	exit(), perror();


/*
 * get_line -- get a line of input from stdin, return number of chars or -1
 *		for ESC
 */

get_line(str, strsize)
char	*str;
uint	strsize;
{
#if	defined(STANDALONE)
	extern int	gets();

	if ((strsize = gets(str)) == 0)
		return (1);
	return (strsize);
#else
	fflush(stdin);
	if (fgets(str, strsize, stdin) == NULL)
		exit(0);
	if (strchr(str, '\033')) {
		*str = '\0';
		return (-1);
	}
	return (strlen(str));
#endif
}


/*
 * prompt_char -- prompt for and return the first character of the first
 *		word of input
 */

/*VARARGS1*/
prompt_char(fmt, a1, a2)
char	*fmt;
{
	char	*p, *strtok();

	for (;;) {
		printf(fmt, a1, a2);
		if (get_line(cline_buff, sizeof(cline_buff)) < 0)
			exit(0);
		if (p = strtok(cline_buff, white_sep))
			return (*p);
	}
}

question(str)
char	*str;
{
	for (;;) {
		switch (tolower(prompt_char("%s (y/n): ", str))) {
		case 'y':
			return(1);
		case 'n':
			return(0);
		}
	}
}


/*
 * display -- display and prompt for a menu
 *		Automatically adds a 0 selection and prompt
 *		Returns 0 for previous/exit, or menu selection
 */

static int
display(menu)
register char	*menu[];
{
	register long	i, cnt;
	register char	*s;
	char		*p;
	
	do {
		i = cnt = 0;
		while (s = menu[i++]) {
			printf("%s\n", s);
			if (isdigit(*s))
				++cnt;
		}

		printf("0-%s\n\nSelect: ",
		  (menu == main_menu) ? "Exit" : "Previous menu");

		if ((i = get_line(cline_buff, sizeof(cline_buff))) < 0)
			return (0);

		p = cline_buff;
		if ((i = strtol(cline_buff, &p, 10)) == 0 && p == cline_buff) {
			switch (tolower(*cline_buff)) {
			case 'e':
				return (0);		/* prev/exit */
			case 'q':
				exit(0);
			}
			i = -1;
		}
	} while (i < 0 || i > cnt);

	return (i);
}

/*
 * disk_init -- menu function
 */

static void
disk_init(fd)
int	fd;
{
	for (;;) {
		switch (display(fmt_menu)) {
		case F_FMTDSK:
			printf(fmt_warn);
			if (question("\nDo you really wish to format?") != NO)
				(void) disk_fmt(fd, 1);
			break; 
		case F_FULL_FMTDSK:
			printf(fmt_warn);
			if (question("\nDo you really wish to format?") != NO)
				(void) disk_fmt(fd, 0);
			break; 

		case F_CONFIG:
			printf(cfg_warn);
			if (question("\nReally reconfigure the disk?") != NO)
				(void) disk_config(fd);
			break;

		case F_EXIT:
			return;
		}
	}
}

/*
 * slice_management
 */

static void
slice_management(fd)
int	fd;
{
	int	slicing_changed = 0;

	if (!read_slice_table(fd, sltable))
		return;

	for (;;) {
		switch (display(slice_menu)) {
		case S_AUTO:
			if (!verify_iopm_disk())
				return;
			slicing_changed |= auto_slice();
			break; 
		case S_SEMI_AUTO:
			if (!verify_iopm_disk())
				return;
			slicing_changed |= semi_auto_slice();
			break;
		case S_EDIT:
			if (!verify_iopm_disk())
				return;
			slicing_changed |= editing();
			break;
		case S_DISPLAY:
			show_table();
			break;
		case S_SAVE:
			if (write_slice_table()) {
				dev_print("Configuration written to disk.");
				slicing_changed = 0;
			}
			else
				dev_print("Save aborted!");
			break;
		case S_BARGRAPH:
			show_graph();
			break;
		case S_EXIT:
			if (!slicing_changed)
				return;
			if (question("Save the new configuration?") == NO)
				return;
			if (write_slice_table())
				dev_print("Configuration written to disk.");
			else
				dev_print("Save aborted!");
			return;
		}
	}
}

static	char *tst_menu[] = {
	"SELECT TEST TYPE",
	"1-read",
	"2-write",
	"3-write, read, compare",
	0
};

#define TST_READ	1	/* read only test */
#define TST_WRITE	2	/* write only test */
#define TST_WRC		3	/* write read compare test */
#define TST_EXIT	0

dtst_tsttype()
{
	int	sel;

	for (;;) {
		switch (sel = display(tst_menu)) {
		case TST_READ :
			set_tsttype('r');
			return;
		case TST_WRITE :
			set_tsttype('w');
			return;
		case TST_WRC :
			set_tsttype('c');
			return;
		case TST_EXIT :
			return;
		default :
			/* loop */
			;
		}
	}
}

static	char *wrb_menu [] = {
	"SELECT WRITE BUFFER",
	"1-incrementing",
	"2-constant",
	"3-shifted ones",
	0
};

#define WRB_INC		1	/* incrementing */
#define WRB_FXD		2	/* constant value */
#define WRB_SHFT	3	/* shifted ones */
#define WRB_EXIT	0

/*
 * dtst_sel_wrbuff - select write buffer
 *
 */
dtst_sel_wrbuff()
{
	int	sel;

	for (;;) {
		switch (sel = display(wrb_menu)) {
		case WRB_INC :
			set_wrbuff('i');
			return;
		case WRB_FXD :
			set_wrbuff('f');
			return;
		case WRB_SHFT :
			set_wrbuff('s');
			return;
		case WRB_EXIT :
			return;
		default :
			/* loop */
			;
		}
	}
}

/*
 * disktst
 */
static void
disktst(fd)
int	fd;
{
	dtst_set_defaults();
	for (;;) {
		switch (display(disktst_menu)) {
		case D_TSTTYPE :
			dtst_tsttype();
			disp_test_settings();
			break;
		case D_ONEBLK :
			dtst_selblk(fd);
			disp_test_settings();
			break;
		case D_RANGE :
			dtst_range(fd);
			disp_test_settings();
			break;
		case D_NBLK :
			dtst_nblks(fd);
			disp_test_settings();
			break;
		case D_BUFDISP :
			dtst_disp_rbuff();
			disp_test_settings();
			break;
		case D_BUFSEL :
			dtst_sel_wrbuff();
			disp_test_settings();
			break;
		case D_ONETST :
			dtst_once(fd);
			disp_test_settings();
			break;
		case D_LOOPTST :
			dtst_looptst(fd);
			disp_test_settings();
			break;
		case D_REASSIGN :
			reassign_blk(fd);
			break;
		case D_EXIT :
			return;
		}
	}
}

/*
 * main_menu_loop -- do the main menu -- Side effect: closes fd when done!
 */

static void
main_menu_loop(fd)
int	fd;
{
	int	loop = 1;
		
	if (!check_device(fd))
		exit(0);
	
	show_disk_layout(fd); /* FIX joe, remove at a later date. Not needed
			       * for fully iopm system. */

	while (loop) {
		switch (display(main_menu)) {
			case M_FMTDSK:
				disk_init(fd);
			  	break; 
			case M_SLICE:
				slice_management(fd);
				break;
			case M_DSKTST:
				disktst(fd);
				break;
			case M_EXIT:
				(void) unlock_device(fd);
				loop = 0;
				break;
		}
	}
	close(fd);
	dsk_fd = -1;
}

static int
open_dev(name)
char	*name;
{
	int	fd;

	if ((dsk_fd = fd = open(name, O_RDWR)) < 0) {
		printf("%s: device open error!\n", name);
#ifndef STANDALONE
		perror("");
#endif
		exit(0);
	}

	return (fd);
}

#if	defined(STANDALONE)

static char	device_string[DEV_NAMLEN];

static void
stand_main_loop()
{
	device_name = device_string;

	printf("default base is decimal; for octal use 0NNNNN; for hex use \
0xNNNNN\n");
	do {
		printf("Enter device name: ");
		if (get_line(device_string, sizeof(device_string)) <= 0)
			break;

		main_menu_loop(open_dev(device_string));

	} while (question("Would you like to run iopmfmt on another disk?") != NO);
}

#else /* STANDALONE */

static void
usage()
{
	printf("usage: iopmfmt /dev/scsi_pt/c[X]d[Y]\n");
	printf("          where /dev/scsi_pt/cXdY is the pass through node\n");
	printf("          mapped to controller X, SCSI disk drive Y.\n\n");
	printf("       To avoid the menus for formating, use:\n");
	printf("       iopmfmt -F /dev/scsi_pt/c[X]d[Y] ....\n");
	exit(-1);
}

static void
unix_main_loop(argc, argv)
int	argc;
char	**argv;
{
	int		c, fd, did_cmd = 0;
	extern char	*optarg;
	extern int	optind;
	extern uint	sleep();

	while ((c = getopt(argc, argv, "F:")) != EOF)
		switch (c) {
		case 'F':	/* format disk */
			++did_cmd;
			fd = open_dev(device_name = optarg);
			printf("\nReady to format device %s\n", device_name);
			printf(fmt_warn);
			printf("Hit DEL in 10 seconds to abort.\n");
			fflush(stdout);
			sleep(11);
			(void) disk_fmt(fd, 1);
			close(fd);
			dsk_fd = fd = -1;
			break;
		default:
			usage();
		}

	/*
	 * if the -F option not specified then do menus with specified
	 * device.
	 */

	if (!did_cmd) {
		if (argc > 1) {
			printf("default base is decimal; for octal use 0NNNNN;\
 for hex use 0xNNNNN\n");
			main_menu_loop(open_dev(device_name = argv[1]));
		}
		else
			usage();
	}
}
#endif

main(argc,argv)
int	argc;
char	*argv[];
{
#if	defined(STANDALONE)
	stand_main_loop();
#else
	unix_main_loop(argc, argv);
#endif	/* STANDALONE */

	exit(0);
	/*NOTREACHED*/
}

/*VARARGS1*/
dev_print(fmt, a1, a2, a3)
char	*fmt;
{
	printf("%s : ", device_name);
	if (fmt) {
		printf(fmt, a1, a2, a3);
		printf("\n");
	}
}


#if	defined(STANDALONE)
	/* FIX MSS, kludge to make standalone happy */
char	**environ;
#endif	/* STANDALONE */
