/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) disktest.c: version 25.1 created on 11/27/91 at 15:26:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)disktest.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#if	!defined(STANDALONE)
#include	<sys/stdio.h>
#endif

#include	"iopmfmt.h"
#include	"ctype.h"
#include	<sys/fcntl.h>
/* #include	"sys/elog.h" */
#include	"macros.h"
#include	"sdk_cdb.h"
#include	"sdk_disk.h"
#include	<sys/debug.h>

struct	test_info {
	char	test_type;
	char	wrbuff_type;	/* incrementing, constant, shifted ones */
	uint	pattern;
	daddr_t	lower_limit, upper_limit;
	uint	n_blks;
	uint	read_fails;
	uint	write_fails;
	uint	cmp_fails;
} test_info;

#define min(x,  y) (((x) < (y)) ? (x) : (y))
#define max(x,  y) (((x) > (y)) ? (x) : (y))

/* this is limited by the size of sa_mem_requirement */
#define MAX_DSK_BLKS 256 /* number of blocks for one operation */

typedef union {
	long	dummy;	/* force longword alignment */
	unchar	buffer[BSIZE * MAX_DSK_BLKS];
} al_arr;

static	al_arr	read_array;
static	al_arr	write_array;

#define read_buff (read_array.buffer)
#define write_buff (write_array.buffer)

static	uint	read_valid = 0; /* amount of read buffer to valid */

/*
 * dtst_set_defaults() - set up default values for test
 */
dtst_set_defaults()
{
	test_info.test_type = 'r';
	test_info.wrbuff_type = 'i';
	set_wrbuff('i');
	test_info.pattern = 0;
	test_info.lower_limit = test_info.upper_limit =
		(daddr_t)FIRST_DATA_BLOCK_NUM;
	test_info.n_blks = 1;
}

/*
 * set_tsttype - set type of test
 *
 * Provide warning if write selected.
 */
set_tsttype(sel)
{
	test_info.test_type = sel;
	if (sel == 'w' || sel == 'c')
		printf("WARNING - write tests will cause loss of data\n");
}

/*
 * check_save()
 */
#define RSVD_END (daddr_t)(DEF_DEFCT_LIST - 1)
static
check_safe()
{
	if (test_info.lower_limit > RSVD_END)
		return;
	printf("WARNING : blocks 0 to %u are reserved.\n", RSVD_END);
	printf("Writing to them will destroy configuration and slicing \
information\n");
	if (question("change limits to avoid reserved area") == YES) {
		test_info.lower_limit = RSVD_END + 1;
		test_info.upper_limit = max(test_info.upper_limit,
			RSVD_END + 1) ;
	}
	else {
		printf("If this area is written, the configure command will \
need to be used to setup\nthe drive. ");
		printf("Also any slicing will need to be redone.\n");
	}
}

/*
 * dtst_selblk - select single block for test.
 *
 * ensure in range.
 */
dtst_selblk(fd)
{
	test_info.lower_limit = test_info.upper_limit =
		(daddr_t)prompt_num(0L, dev.lst_blkno,
		"select block number %u to %u : ", 0, dev.lst_blkno);
	check_safe();
	return(1);
}

/*
 * dtst_range - select range for test.
 *
 * ensure legal range.
 */
dtst_range(fd)
{
	test_info.lower_limit = (daddr_t)default_num(0L, dev.lst_blkno,
	0L, "select lower block number");
	test_info.upper_limit = (daddr_t)default_num(test_info.lower_limit,
		dev.lst_blkno, dev.lst_blkno, "select upper block number");
	check_safe();
	return(1);
}

/*
 * dtst_nblks - select number of blocks per read, write operation.
 */
dtst_nblks()
{

	test_info.n_blks =
		prompt_num(0L, MAX_DSK_BLKS,
		"select number of blocks %u to %u : ", 0, MAX_DSK_BLKS);
	check_safe();
}

/*
 * cmp_buffs() - compare read and write buffers
 */
cmp_buffs(n_bytes)
uint	n_bytes;
{
	register uint	i;
	register unchar	*p, *q;
	int	miscompare = 0;

	p = read_buff;
	q = write_buff;

	for (i = 0; i != n_bytes; i++, p++, q++) {
		if (*p != *q) {
			printf("byte %u (0x%x) miscompare  ", i, i);
			miscompare = 1;
		}
	}
	return(!miscompare);
}

/*
 * test_one_chunk - perform test iteration on one block
 *
 */
static
test_one_chunk(fd, block_no)
daddr_t	block_no;
{
	uint	n_blocks;
	uint	n_bytes;

	lseek(fd, 0, 0); /* read and write tests on drives > 1 gig could
			cause u_uoffset overflow */
	/* ensure don't reach past upper limit */
	n_blocks = min(test_info.n_blks,
		test_info.upper_limit + 1 - block_no);
	/* hanna FIX: is dev.blk_len up to date if changed during format? */
	n_bytes = dev.blk_len * n_blocks; /* hanna FIX */

	switch (test_info.test_type) {
	case 'r' : /* read test */
		if (cdb_read(fd, read_buff, (int)block_no, n_bytes, n_blocks)
			== -1) {
			printf("read failed for block %u (0x%x)\n", block_no,
			block_no);
			test_info.read_fails++;
			break;
		}
		read_valid = n_bytes;
		break;
	case 'w' : /* write test */
		if (cdb_write(fd, write_buff, (int)block_no, n_bytes, n_blocks)
			== -1) {
			printf("write failed for block %u (0x%x)\n", block_no,
			block_no);
			test_info.write_fails++;
			break;
		}
		break;
	case 'c' : /* write, read & compare test */
		if (cdb_write(fd, write_buff, (int)block_no, n_bytes, n_blocks)
			== -1) {
			printf("write failed for block %u (0x%x)\n",
			block_no, block_no);
			test_info.write_fails++;
			break;
		}
		if (cdb_read(fd, read_buff, (int)block_no, n_bytes, n_blocks)
			== -1) {
			printf("read failed for block %u (0x%x)\n",
			block_no, block_no);
			test_info.read_fails++;
			break;
		}
		read_valid = n_bytes;

		if (!cmp_buffs(n_bytes)) {
			printf("\ncompare failed for block %u (0x%x)\n",
			block_no, block_no);
			test_info.cmp_fails++;
		}
		break;
	default :
		ASSERT(0);
	}
	return(1);
}

/*
 * do_tst - perform test over range
 *
 */
static
do_tst(fd)
{
	daddr_t	blk_no;

	for (blk_no = test_info.lower_limit; blk_no <= test_info.upper_limit;
		blk_no += test_info.n_blks)
		if (!test_one_chunk(fd, blk_no))
			return(0);
	return(1);
}

/*
 * dtst_once - do one pass of test.
 *
 */
dtst_once(fd)
{
	if (!check_limits(fd))
		return(0);
	test_info.read_fails = test_info.write_fails = test_info.cmp_fails = 0;
	if (!do_tst(fd))
		return(0);
	printf("completed\n");
	disp_results();
	return(1);
}

/*
 * dtst_looptst - loop on test.
 *
 * perform n iterations.
 */
dtst_looptst(fd)
{
	uint	num_tests;
	uint	count = 0;

	if (!check_limits())
		return(0);

	test_info.read_fails = test_info.write_fails = test_info.cmp_fails = 0;
	num_tests = prompt_num(0L, 0xffffffff, "number of iterations : ");
	printf("looping %u times\n", num_tests);
#ifndef STANDALONE
	setbuf(stdout, NULL, 0);
#endif /* STANDALONE */
	printf("%10u", count + 1);
	for ( ; count != num_tests; count++) {
		printf("\b\b\b\b\b\b\b\b\b\b%10u", count + 1);
		if (!do_tst(fd)) {
			printf("test %u failed\n", count + 1);
			printf("continuing : test %10u", count + 1);
		}
	}
	printf("\n%u tests completed\n", num_tests);
	disp_results();
	return(1);
}

static
disp_results()
{
	switch (test_info.test_type) {
	case 'r' :
		printf("%u read failures\n", test_info.read_fails);
		break;
	case 'w' :
		printf("%u write failures\n", test_info.write_fails);
		break;
	case 'c' :
		printf("%u write failures, ", test_info.write_fails);
		printf("%u read failures, ", test_info.read_fails);
		printf("%u compare failures\n", test_info.cmp_fails);
		break;
	}
	printf("hit RETURN to continue");
	flush_in();
}

/*
 * flush_in() - flush standard input
 */
static
flush_in()
{
	char	ch;
	int	retval = 1;

	do
		if ((ch = getchar()) != ' ' && ch != '\n')
			retval = 0;
	 while (ch != '\n' && ch != -1);
	 return(retval);
}

/*
 * disp_line - show one line of buffer
 */
static
disp_line(buff, start, cnt)
unchar	*buff;
uint	start, cnt;
{
	uint	i;

	printf("%04x:", start);
	for (i = 0; i != cnt; i++, buff++)
		printf(" %02x", *buff);
	printf("\n");
}

#define	NUM_PER_LINE 24

/*
 * dtst_disp_rbuff - display read buffer.
 */
dtst_disp_rbuff()
{
	register unchar *ptr = read_buff;
	register uint	cnt = 0;
	register uint	line_cnt = 0;
	uint	this_cnt;

	while (cnt < read_valid) {
		line_cnt = 0;
		while (line_cnt != 23 && cnt < read_valid) {
			this_cnt = min(NUM_PER_LINE, read_valid - cnt);
			disp_line(ptr, cnt, this_cnt);
			ptr += this_cnt;
			cnt += this_cnt;
			line_cnt++;
		}
		if (!flush_in())
			return;
	}
}

/*
 * set_wrbuff - set write buffer
 *
 */
set_wrbuff(sel)
char	sel;
{
	register uint	i;
	/* hanna FIX: is dev.blk_len up to date if changed during format? */
	uint	n_bytes = dev.blk_len * MAX_DSK_BLKS;	/* hanna FIX */

	test_info.wrbuff_type = sel;
	switch (test_info.wrbuff_type) {
	case 'i' : {
			register unchar	*ptr = write_buff;

			/* have extra word to handle overlap */
			for (i = 0; i != n_bytes; i++, ptr++)
				*ptr = (unchar)(i & 0xff);
		}
		break;
	case 'f' : {
			register uint	*ptr;
			register uint	pattern;
			
			/* align to uint boundary*/
			ptr = (uint *)write_buff;

			test_info.pattern = prompt_num(0L, 0xffffffff,
			"enter 4 byte pattern (for hex begin with 0x) : ");
			for (i = 0; i != n_bytes / 4; i++, ptr++)
				*ptr = test_info.pattern;
		}
		break;
	case 's' : {
			register unchar	*ptr = write_buff;
			register unchar	pattern = 1;
			int	invert = 0;

			for (i = 0; i != n_bytes; i++, ptr++) {
				*ptr = pattern;
				if (pattern == ((invert) ? 0x7f : 0x80)) {
					pattern = ((invert) ? 1 : 0xfe);
					invert = !invert;
				}
				else pattern =
					(pattern << 1) | ((invert) ? 1 : 0);
			}
		}
		break;
	default :
		ASSERT(0);
	}
}

/*
 * check_limits - ensure limits are legal for this drive
 *
 * needs to be done at start of each test in case drive is changed.
 */
static
check_limits(fd)
{
	ASSERT(test_info.lower_limit <= test_info.upper_limit);

	if (test_info.upper_limit > dev.lst_blkno) {
		printf("upper limit (%u) too high for this drive, maximum %u",
		test_info.upper_limit, dev.lst_blkno);
		return(0);
	}
	return(1);
}

/*
 * disp_test_settings - display current test settings
 */
disp_test_settings()
{
	printf("\nRange : %u(0x%x) - %u(0x%x)\n", test_info.lower_limit,
	test_info.lower_limit, test_info.upper_limit, test_info.upper_limit);
	printf("number of blocks per operation : %u (0x%x)\n",
	test_info.n_blks, test_info.n_blks);
	printf("test type = ");
	switch (test_info.test_type) {
		case 'r' :
			printf("read\n");
			break;
		case 'w' :
			printf("write\n");
			break;
		case 'c' :
			printf("write, read, compare\n");
			break;
		default :
			ASSERT(0);
	}
	printf("write buffer pattern is ");
	switch (test_info.wrbuff_type) {
		case 'i' :
			printf("incrementing\n");
			break;
		case 'f' :
			printf("constant = 0x%08x\n", test_info.pattern);
			break;
		case 's' :
			printf("shifted ones\n");
			break;
		default :
			ASSERT(0);
	}
	return(1);
}
