/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ccs_dskcdb.c: version 25.1 created on 11/27/91 at 15:26:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ccs_dskcdb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* ccs_dskcdb.c -- a library file of all scsi disk cdb commands format and 
	issue command */

#include	"sys/types.h"
#include	"macros.h"
#include	"passthru.h"
#include	"sdk_cdb.h"
#include	"scsi_error.h"
#include	"timer.h"
#include	"ccs_dskcdb.h"
#include	"iopmfmt.h"


extern char	*memset();
extern void	perror();
extern char	*scsi_err_msg(), *scsi_sns_msg();

int	b_flags;
static  unchar *data_buffer;
static  int	data_length;
struct scsi_cmd	cmd;
struct scsi_result result;

ccs_inquiry(fp, buf, l)
unchar	*buf;
{
	struct g0_cdb	*cdb;
	int	valid_len;

	cdb = ( struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cdb->opcode = CDB_INQUIRY;
	cdb->alloc_len = INQUIRY_LEN;
	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cmd.mil_sec = BASIC_TIMER + TRAN_TIMER;

	if ( (valid_len = issue_cmd (fp, buf, l, SCSI_READ)) < 0 )
		return(-1);
	else 
		if (!check_scsi_err())
			return(-1);
		else
			return(valid_len);	
}

ccs_read_cap(fp, buf, blk_no)
unchar *buf;
{
	
	struct g1_cdb	*cdb;
	int	valid_len;

	cdb = (struct g1_cdb *)cmd.cmd_dsc_blk;

	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = 10;
	cmd.mil_sec = BASIC_TIMER + TRAN_TIMER;

	cdb->opcode = CDB_READ_CAPACITY;
	ITOC4(cdb->calba_msb, cdb->calba_2,cdb->calba_1, cdb->calba_lsb, blk_no);
	if (blk_no != 0)
		cdb->ca_pmi = PMI;

cap_retry:
	if ( (valid_len = issue_cmd (fp, buf, CA_DATA_SIZE, SCSI_READ)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				dev_print("medium changed");
				return(-1);
			}
			if ( b_flags == B_RESET) {
				b_flags = 0;
				goto cap_retry;
			}
			return(valid_len);	
		}
	}
}

ccs_start_stop(fp, flag)
{
	struct g0_cdb	*cdb;
	int	valid_len;

	cdb = (struct g0_cdb *)cmd.cmd_dsc_blk;
start_retry:
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cmd.mil_sec = START_TIMER;
	cdb->opcode = CDB_START_STOP;
	cdb->start_flags = flag;
	if ( (valid_len = issue_cmd (fp, 0, 0, SCSI_NODATA)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		if ( b_flags != 0)
			goto start_retry;
		return(valid_len);	
	}
}

ccs_medium_removal(fp, flag)
unchar	flag;
{
	struct g0_cdb	*cdb;

	cdb =(struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cmd.mil_sec = BASIC_TIMER + TRAN_TIMER;
	cdb->opcode = CDB_MEDIUM_REMOVAL;
	cdb->prvnt = flag;
remov_retry:
	if ( issue_cmd (fp, 0, 0, SCSI_NODATA) < 0)
		return(-1);
	if (!check_scsi_err())
		return(-1);
	else {
		if ( b_flags == B_NEWMDM) {
			dev_print("medium changed");
			return(-1);
		}
		if ( b_flags == B_RESET)
			goto remov_retry;
		return(0);	
	}
}
ccs_mode_sense(fp, buf, len, flag)
unchar *buf;
unchar flag;
{
	struct g0_cdb	*cdb;
	int	valid_len;

	cdb = (struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cdb->opcode = CDB_MODE_SENSE;
	cdb->page_flags = flag;
	cdb->alloc_len = len;
	cmd.mil_sec = BASIC_TIMER + TRAN_TIMER;
msns_retry:
	if ( (valid_len = issue_cmd (fp, buf, len, SCSI_READ)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				dev_print("medium changed");
				return(-1);
			}
			if ( b_flags == B_RESET)
				goto msns_retry;
			return(0);	
		}
	}
}

ccs_format(fp, buf, len, flag)
unchar *buf;
unchar flag;
{
	struct g0_cdb	*cdb;
	int	valid_len;
	unchar	command_type = (flag & FMTDATA) ? SCSI_WRITE : SCSI_NODATA;

	cdb =(struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);

	/* The minimum timeout for formatting is 1hr.
	 * add another 15 minutes for each GB of disk!
	 * Note lst_blkno is in units of 1KB, so divide by 1MB to get GBs
	 */
	cmd.mil_sec = FORMAT_TIMER  + 
		( dev.lst_blkno/0x100000 * 15 * MS_PER_MIN) ;
	printf("Allow up to %d hr. %d min. for formatting.\n", 
		cmd.mil_sec/MS_PER_HR, (cmd.mil_sec%MS_PER_HR)/MS_PER_MIN);
	cdb->opcode =  CDB_FORMAT_UNIT;
	cdb->lun_flags |= flag;
/* REE - don't use the flag */
	cdb->lun_flags = 0;
		/* setup interleave factor	*/
	ITOC2(cdb->interleave_msb, cdb->interleave_lsb, 1);
fmt_retry:
	if ( (valid_len = issue_cmd (fp, buf, len, command_type)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				dev_print("medium changed");
				return(-1);
			}
			if ( b_flags == B_RESET)
				goto fmt_retry;
			return(0);	
		}
	}
}

ccs_reassign_blocks (fp, data, len)
unchar  *data;
{
	struct g0_cdb	*cdb;
	int	valid_len;

	cdb =(struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cmd.mil_sec = REASSIGN_TIMER;
	cdb->opcode = CDB_REASSIGN;
reassign:
	if ( (valid_len = issue_cmd (fp, data, len, SCSI_WRITE)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				dev_print("medium changed");
				return(-1);
			}
			if ( b_flags == B_RESET)
				goto reassign;
			return(0);	
		}
	}
}
ccs_mode_select(fp, data, len, flag)
unchar *data;
unchar	flag;
{
	struct g0_cdb	*cdb;
	int	valid_len;

	cdb =(struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cmd.mil_sec = MODE_TIMER;
	cdb->opcode = CDB_MODE_SELECT;
	cdb->lun_flags = flag;
	cdb->alloc_len = len;
sel_retry:
	if ( (valid_len = issue_cmd (fp, data, len, SCSI_WRITE)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				dev_print("medium changed");
				return(-1);
			}
			if ( b_flags == B_RESET)
				goto sel_retry;
			return(0);	
		}
	}
}
ccs_write(fp, buf,blkno, len, noblks)
unchar	*buf;
{
	struct g0_cdb	*cdb;
	int	valid_len;

	cdb =(struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cmd.mil_sec = BASIC_TIMER + RWUNIT_TIMER * noblks;
	cdb->opcode = CDB_WRITE;
			
	ITOC3(cdb->lbaddr_msb, cdb->lbaddr, cdb->lbaddr_lsb, blkno);
	cdb->lbaddr_msb &= 0x1F;
	cdb->xfer_len = noblks;
wrt_retry:
	if ( (valid_len = issue_cmd (fp, buf, len, SCSI_WRITE)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				dev_print("medium changed");
				return(-1);
			}
			if ( b_flags == B_RESET)
				goto wrt_retry;
			return(0);	
		}
	}
}
ccs_read(fp, buf,blkno, len, noblks)
unchar *buf;
{
	struct g0_cdb	*cdb;
	int	valid_len;

	cdb =(struct g0_cdb *)cmd.cmd_dsc_blk;
	memset(cdb, 0, 14);

	cmd.cmd_dsc_len = sizeof (struct g0_cdb);
	cmd.mil_sec =BASIC_TIMER + RWUNIT_TIMER * noblks;
	cdb->opcode = CDB_READ;
			
	ITOC3(cdb->lbaddr_msb, cdb->lbaddr, cdb->lbaddr_lsb, blkno);
	cdb->lbaddr_msb &= 0x1F;
	cdb->xfer_len = noblks;
rd_retry:
	if ( (valid_len = issue_cmd (fp, buf, len, SCSI_READ)) < 0 )
		return(-1);
	else {
		if (!check_scsi_err())
			return(-1);
		else {
			if ( b_flags == B_NEWMDM) {
				dev_print("medium changed");
				return(-1);
			}
			if ( b_flags == B_RESET) {
				b_flags = 0;
				goto rd_retry;
			}
			return(0);	
		}
	}
}

check_scsi_err()
{
	EX_SENSE_DATA *sd;
	unchar	sense_key;
	
	b_flags = 0;
	if (result.err_code == 0)
		return(1);

	if( result.err_code != SCSIERR_SENSE) {
		dev_print(scsi_err_msg(result.err_code));
			return(0);
	}
	else {
		sd = (EX_SENSE_DATA *)result.error;
		if ((sd->err_class & ERR_CLASS_MASK) != ANSI_CLASS ){
			dev_print(" vendor unique error");
			return(0);
		}
		else {
			if ((sense_key = sd->sense_key & SENSE_KEY) ==
 					SNSKEY_UNIT_ATTN) {
				if (sd->err_code  == ASNS_MDMCHNG )
					b_flags |= B_NEWMDM;
				else
					b_flags = B_RESET;
				return(1);
			}
			else {
				dev_print(scsi_sns_msg(result.error[2]& 0x0F));
				display_sense_detail(result.error);
				return(0);
			}
		}
	}
}

display_sense_detail(sense_data)
EX_SENSE_DATA *sense_data;
{
	int xlen;

	printf("request sense data:\n");
	printf("\tsense key: %x\n",sense_data->sense_key);
	if (sense_data->err_class & INFO_VALID) {
		printf("\tinformation bytes:");
		printf("%x\n",CAT4(sense_data->info_msb, sense_data->info_2,
				sense_data->info_1, sense_data->info_lsb));
	}
	if ((xlen = sense_data->xsense_len) == 0)
		return;
	xlen -= 4;
	if (xlen <= 0)
		return;
	printf("\terror code: %x\n", sense_data->err_code);
	if (--xlen <= 0) 	/* skip reserved byte */
		return;
	if (--xlen <= 0) 	/* point to FRU code */
		return;
	printf("\tFRU field: %x\n",sense_data->frucode);
	if (--xlen <= 0)	/* point to flag	*/
		return;
	if (sense_data->flags & FPV) {

		printf("\tfield pointer:");

		printf("byte %x ", 
		CAT2(sense_data->field_hi, sense_data->field_lo));
		if (sense_data->flags & CDBIT) {
			printf("in CDB field\n");
			printf("\t CDB :\n");
			print_array(cmd.cmd_dsc_blk, cmd.cmd_dsc_len);
		} else {
		   	printf("in data field\n");
			printf("\t CDB :\n");
			print_array(cmd.cmd_dsc_blk, cmd.cmd_dsc_len);
			printf("\tdata buffer:\n");
			print_array(data_buffer, data_length);
		}

		if (sense_data->flags & BPV)
			printf ("\tbit pointer: %x\n", 
					(sense_data->flags & BIT_POINTER_MASK));
	}
}
				
print_array(data, len)
unchar	*data;
int	len;
{
	int i = 15;
	if (len == 0)
		printf("\t\tinvalid\n");
	else {
		while(len--) {
			if (i == 15) {
				printf("\t\t");
				i = 0;
			}
			printf("%x ",*data++);
			i++;
		}
		printf("\n");
	}
}
		
issue_cmd(fp, buf, l, scsi_flag)
unchar *buf;
{
	int	data_valid;
	
	result.err_code = 0; /* clear error */
	if (ioctl(fp, PT_SET_CMD, &cmd) < 0) {
		perror("ioctl PT_SET_CMD");
		return(-1);
	}
	data_buffer = buf;
	data_length = l;
	/* declan question : should the PT_GET_RESULTS ioctl be done even if
	 * the read/write/ioctl fails
	 */
	switch (scsi_flag) {
		case SCSI_NODATA:
			if (ioctl(fp, PT_EXECUTE) < 0) {
				perror("ioctl PT_EXECUTE");
				return(-1);
			}
			break;
		case SCSI_READ:
			data_valid = read(fp, buf, l);
			if (data_valid < 0) {
				perror("read");
				return(-1);
			}
			break;
		case SCSI_WRITE:
			data_valid = write(fp, buf, l);
			if (data_valid < 0) {
				perror("write");
				return(-1);
			}
			break;
		default:
		        dev_print("dma flag is wrong");
			return(-1);
	}


	if (ioctl(fp, PT_GET_RESULTS, &result) < 0) {
		perror("ioctl PT_GET_RESULTS");
		return(-1);
	}
	if (scsi_flag == SCSI_NODATA)
		return(0);
	else
		return(data_valid);

}
