/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)sockpair.c (TWG)        1.2      16:58:34 - 89/06/27"

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <sys/stropts.h>
#include <fcntl.h>
#include <sys/stream.h>

#include <sys/inet.h>
#include <sys/ip.h>
#include <sys/inetioctl.h>
#include <sys/socket.h>

#define	AFUSTREAMDEV	"/dev/uds"

int
socketpair (af, type, protocol, sv)
	int af, type, protocol, sv[];
{
	int	s1, s2;
	int	num_minor = 0;
	struct	strioctl strioc;

	if (af != AF_UNIX) {
		errno = EAFNOSUPPORT;
		return -1;
	}

	if (type != SOCK_STREAM) {
		errno = ESOCKTNOSUPPORT;
		return -1;
	}

	if ((s1 = open(AFUSTREAMDEV, 2)) < 0)
		return -1;

	num_minor = getminor(s1);

#ifdef DEBUG
	printf("s1 is open minor = %d\n", num_minor);
#endif

	if ((s2 = open(AFUSTREAMDEV, 2)) < 0) {
		close(s1);
		return -1;
	}

#ifdef DEBUG
	printf("s2 is open %d\n", s2);
#endif

	strioc.ic_cmd = UDSIOC_PAIR;
	strioc.ic_timout = 60;
	strioc.ic_len = sizeof(int);
	strioc.ic_dp = (char *)&num_minor;

	if (ioctl(s2, I_STR, &strioc) < 0) {
		perror("ioctl");
		close(s1);
		close(s2);
#ifdef DEBUG
		printf("ioctl failed\n");
#endif
		return -1;
	}

#ifdef DEBUG
	printf("ioctl is ok\n");
#endif
	sv[0] = s1;
	sv[1] = s2;
	return 0;
}


static int
getminor(fd)
int fd;
{
	struct stat st;

	if (fstat(fd, &st) == -1)
		return(-1);

	return(minor((dev_t )st.st_rdev));
}
