/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)sendto.c (TWG)        1.2      16:57:32 - 89/06/27"

/* LINTLIBRARY */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/inetioctl.h"
#include "errno.h"
#include "sys/somod.h"
#include "sys/un.h"
extern int slmsgsz;

sendto(s, msg, len, flags, to, tolen)
char *msg;
struct sockaddr *to;
{
	struct S_sndto_req *Sp;
	struct stat buf;
	struct sockaddr_un afun_name;
	int afun_len = sizeof(afun_name);
	unsigned size;
	caddr_t saved_sp;
	extern caddr_t _ssp();
	extern void _rsp();

	saved_sp = _ssp();

	if (flags & ~MSG_DONTROUTE) {	/* MSG_DONTROUTE is NOP for now */
		errno = EINVAL;
		_rsp(saved_sp);
		return -1;
	}

	if (!slmsgsz && !_s_setmsgsz(s)){
		_rsp(saved_sp);
		return -1;
	}

	if (to && to->sa_family == AF_UNIX) {
		if ( tolen > AFULEN) {
			errno = EINVAL;
			_rsp(saved_sp);
			return -1;
		}
		if (getsockname(s, &afun_name, &afun_len) < 0) {
			tmpnam(afun_name.sun_path);
			afun_name.sun_family = AF_UNIX;
			if (bind(s, &afun_name, 
				strlen(afun_name.sun_path)+2) < 0) {
				(void) unlink(afun_name.sun_path);
				_rsp(saved_sp);
				return -1;
			}
		}
		if (stat(to->sa_data, &buf) == -1) {
			errno = EADDRNOTAVAIL;
			_rsp(saved_sp);
			return -1;
		}
		(void) unlink(afun_name.sun_path);
	}

	if (!to) {
		/* send the user buffer directly */
		if (len > slmsgsz) {
			errno = EMSGSIZE;
			_rsp(saved_sp);
			return -1;
		}
		if (!_s_ioctl(s, msg, len, SIOC_SENDTO, 0)) {
			_rsp(saved_sp);
			return -1;
		}
	} else {
		/* 
		 * construct a S_sndto_req primitive, 
		 * copy the msg to it, and do an ioctl.
		 */
		if (len > slmsgsz - sizeof(struct S_sndto_req) - tolen) {
			errno = EMSGSIZE;
			_rsp(saved_sp);
			return -1;
		}
		size = sizeof(struct S_sndto_req) + tolen + len;
		if ((Sp = (struct S_sndto_req *)alloca(size)) == NULL){
			errno = ENOBUFS;
			_rsp(saved_sp);
			return -1;
		}
		bzero(Sp, size);
		Sp->cmd = SIOC_SENDTO2;		/* for verification */
		Sp->flags = 0;			/* ignore flags for now */

		Sp->DEST_length = tolen;
		Sp->DEST_offset = sizeof(struct S_sndto_req);
		bcopy((caddr_t)to, (caddr_t)Sp + Sp->DEST_offset, tolen); 

		Sp->DATA_length = len;
		Sp->DATA_offset = sizeof(struct S_sndto_req) + tolen;
		bcopy(msg, (caddr_t)Sp + Sp->DATA_offset, len);
			
		if (!_s_ioctl(s, (caddr_t)Sp, size, SIOC_SENDTO2, 0)){
			_rsp(saved_sp);
			return -1;
		}
		_rsp(saved_sp);
		return len;
	}
}
