/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)recvfrom.c (TWG)        1.2      16:57:24 - 89/06/27"

/* LINTLIBRARY */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/inetioctl.h"
#include "errno.h"
#include "sys/somod.h"
extern int errno;

recvfrom(s, buf, len, flags, from, fromlen) 
	char *buf;
	struct sockaddr *from;
	int *fromlen;
{
	int retval;
	
	if (flags) {
		errno = EINVAL;	
		return -1;
	}

	if (!_s_ioctl(s, (caddr_t)from, *fromlen, SIOC_RECVFROM, fromlen))
		return -1;
	
	return read(s, buf, len);
}
