/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)accept.c (TWG)        1.4      10:08:46 - 89/08/07"

/* LINTLIBRARY */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/in.h"
#include "sys/socket.h"
#include "errno.h"
#include "sys/somod.h"
#include "sys/un.h"
#include "syslog.h"


accept(s, addr, addrlen)
	struct sockaddr_in *addr;
	int *addrlen;
{
	struct s_info info;
	int fd;
	char *buf;
	int error;
	queue_t *qptr;
	int size;
	caddr_t saved_sp;
	extern caddr_t _ssp();
	extern char *alloca();
	extern void _rsp();
	struct strbuf cbuf, dbuf;
	char c_buf[4], d_buf[4];
	int n, flag, retval;
	

	saved_sp = _ssp();

	if (!_s_ioctl(s, (caddr_t)&info, sizeof(info), SIOC_GETINFO, 0)){
		_rsp(saved_sp);
		return -1;
	}
	
	if (!(info.options & SO_ACCEPTCONN)) {
		errno = EOPNOTSUPP;
		_rsp(saved_sp);
		return -1;
	}

	fd = socket(info.domain, info.type, info.proto);
	if (fd < 0) {
		_rsp(saved_sp);
		return -1;
	}
	
	/* 
	 * bind it and get the TCP queue pointer
	 */
	if (addrlen && (*addrlen > 0)) {
		buf = (char *)addr;	
		size = *addrlen;
	} else {
		if (info.domain == AF_INET) 
			size = sizeof(struct sockaddr_in);
		else
			size = AFUADDRLEN;

		if ((buf = alloca(size)) == NULL) {
			errno = ENOBUFS;
			_rsp(saved_sp);
			return -1;
		}
		bzero(buf, size);
	}

	if (!_s_ioctl(fd, buf, size, SIOC_BINDQPTR, 0)) 
		goto err_ret;

	if (!_s_ioctl(s, buf, size, SIOC_ACCEPT, addrlen)) {
err_ret:
		error = errno;
		(void) close(fd);
		errno = error;
		_rsp(saved_sp);
		return -1;
	}

	/*
	 * At this time, there better be a 0 len 
	 * message on the read queue indicating
	 * the connection indication we just did
	 * the accept on. Eat this 0 len msg now.
	 */
	cbuf.maxlen = 4;
	cbuf.len = 0;
	cbuf.buf = c_buf;
	dbuf.maxlen = 4;
	dbuf.len = 0;
	dbuf.buf = d_buf;
	flag = 0;

	retval = ioctl(s, I_NREAD, &n);
	if ((retval == 1) && (n == 0)) {
		n = getmsg(s, &cbuf, &dbuf, &flag);
		if ((n != 0) || (dbuf.len != 0)) 
		   syslog(LOG_WARNING, 
			"accept: getmsg got %d bytes instead of 0 byte !!!",
			dbuf.len);
	} else
		syslog(LOG_WARNING, 
			"accept:I_NREAD returned: retval = %d n = %d !!!",
			 retval, n);

	_rsp(saved_sp);
	return fd;
}
