#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)writev.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>

writev(fd, iov, iovcnt)
	register struct iovec *iov;
{
	register int total = 0, i;
	register struct iovec *p = iov;
	register char *cp, *ptr;
	extern errno;
	int ret_val = 0;
	caddr_t saved_sp;
	extern caddr_t _ssp();
	extern void _rsp();

	saved_sp = _ssp();
	
	for (i = 0; i < iovcnt; i++, p++)
		total += p->iov_len;

	if ((cp = (char *) alloca(total)) == (char *) 0){
		errno = ENOMEM;
		_rsp(saved_sp);
		return -1;
	}
	
	for (i = 0, ptr = cp; i < iovcnt; iov++,i++) {
		(void) bcopy(iov->iov_base, ptr, iov->iov_len);
		ptr += iov->iov_len;
	}

	ret_val = write(fd, cp, total);
	_rsp(saved_sp);
	return ret_val;
}
