#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)sig.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/* LINTLIBRARY */
#include <signal.h>
#include <sys/errno.h>
/*
 * Block the signals.
 * Deliver them at an appropriate time.
 */
static int Sigs_blocked, Sigs_rcvd, Sigs_paused;
static int (*Sigs_func[NSIG+1])();

/*
 * If the signal is currently
 * Blocked then don't deliver it.
 */
static int
Sigs_routine(signo)
{
	register int mask = 1<<signo;

	/*
	 * There is a window here.
	 */
	(void) signal(signo, Sigs_routine);
	if (Sigs_blocked & mask) {
		Sigs_rcvd |= mask;
		return;
	}
	if (Sigs_paused & (1<<31)) {
		Sigs_blocked = Sigs_paused & ~(1<<31);
		Sigs_paused = 0;
	}
	/*
	 * This signal is not blocked.
	 */
	if ((int)(Sigs_func[signo]) == (int)SIG_DFL) {
		(void) signal(signo, SIG_DFL);
		(void) kill(getpid(), signo);
	}
	else {
		Sigs_rcvd &= ~mask;
		(*Sigs_func[signo])(signo);
	}
}

sigblock(mask)
	register int mask;
{
	register int signo;
	register int oldmask = Sigs_blocked;
	int (*oldsig)();

	for (signo = 1; signo <= NSIG; signo++) {
		if (mask & (1<<signo)) {
			/*
			 * Block this signal.
			 */
			oldsig = (int (*)())signal(signo, Sigs_routine);
			/*
			 * There is a little window of screwup here.
			 */
			if (oldsig != Sigs_routine)
				Sigs_func[signo] = oldsig;
			Sigs_blocked |= (1<<signo);
		}
	}
	return oldmask;
}
/*
 *  Block the specified Signals
 */
sigsetmask(mask)
	register int mask;
{
	register int signo, tmask;
	register int oldmask = Sigs_blocked;
	int (*oldsig)();

	for (signo = 1; signo <= NSIG; signo++) {
		tmask = 1<<signo;
		if (mask & tmask) {
			/*
			 * Block this signal.
			 */
			oldsig = (int (*)())signal(signo, Sigs_routine);
			/*
			 * There is a little window of screwup here.
			 */
			if (oldsig != Sigs_routine)
				Sigs_func[signo] = oldsig;
			Sigs_blocked |= tmask;
		}
		else {
			/*
			 * If the signal is blocked.
			 * And was received them deliver it.
			 */
			if (Sigs_blocked & tmask) {
				Sigs_blocked &= ~tmask;
				if (Sigs_rcvd & tmask) {
					/*
					 * Deliver the signal.
					 */
					Sigs_rcvd &= ~tmask;
					Sigs_routine(signo);
				}
			}
		}
	}
	return oldmask;
}
/*
 * Create a mask.
 */
#undef sigmask
sigmask(signo)
{
	extern errno;

	if (signo < 0 || signo > NSIG) {
		errno = EINVAL;
		return -1;
	}
	return 1<<signo;
}
/*
 * Pause until 
 */
_sigpause(mask)
{
	Sigs_paused = Sigs_blocked | (1<<31);
	Sigs_blocked = mask;
	return pause();
}
sigvec(sig, vec, ovec)
	int sig;
	struct sigvec *vec, *ovec;
{
	int (*oldvec)();
	extern errno;
	/*
	 * Don't want to bother with signal
	 * Stacks that are different.
	 */

	if (sig < 0 || sig > NSIG || sig == SIGKILL) {
		errno = EINVAL;
		return -1;
	}
	oldvec = Sigs_func[sig];
	if (vec) {
		Sigs_func[sig] = vec->sv_handler;
		if (vec->sv_handler == (int (*)()) SIG_IGN)
			(void) signal(sig, SIG_IGN);
		else
			(void) signal(sig, Sigs_routine);
	}
	if (ovec) {
		ovec->sv_handler = oldvec;
		ovec->sv_mask = 0;
		ovec->sv_flags = 0;
	}
	return 0;
}
