#include <signal.h>

/*
 * startcreg():
 * protect critical regions of code against interrupts.
 * Arguments: none
 * Returns: void
 * Side effects: holds signals until endcreg() is called
 */
startcreg()
{
	sighold(SIGHUP);
#ifdef notdef
	sighold(SIGINT);
	sighold(SIGQUIT);
	sighold(SIGILL);
	sighold(SIGTRAP);
	sighold(SIGIOT);
	sighold(SIGABRT);
	sighold(SIGEMT);
	sighold(SIGCHK);
	sighold(SIGFPE);
#endif /* notdef */
	sighold(SIGKILL);
#ifdef notdef
	sighold(SIGBUS);
	sighold(SIGSEGV);
	sighold(SIGSYS);
#endif /* notdef */
	sighold(SIGPIPE);
	sighold(SIGALRM);
	sighold(SIGTERM);
	sighold(SIGUSR1);
	sighold(SIGUSR2);
	sighold(SIGCLD);
	sighold(SIGPWR);
	sighold(SIGWINCH);
#ifdef P4
	sighold(SIGUSR4);
#endif
	sighold(SIGPOLL);
#ifdef _POSIX_SOURCE
	sighold(SIGSTOP);
	sighold(SIGCONT);
	sighold(SIGTSTP);
	sighold(SIGTTIN);
	sighold(SIGTTOU);
	sighold(SIGCHLD);
#endif /* _POSIX_SOURCE */
}

/*
 * endcreg():
 * allow interrupts to occur once again.
 * Arguments: none
 * Returns: void
 * Side effects: allows signals to occur.
 */
endcreg()
{
	sigrelse(SIGHUP);
	sigrelse(SIGINT);
#ifdef notdef
	sigrelse(SIGQUIT);
	sigrelse(SIGILL);
	sigrelse(SIGTRAP);
	sigrelse(SIGIOT);
	sigrelse(SIGABRT);
	sigrelse(SIGEMT);
	sigrelse(SIGCHK);
	sigrelse(SIGFPE);
#endif /* notdef */
	sigrelse(SIGKILL);
#ifdef notdef
	sigrelse(SIGBUS);
	sigrelse(SIGSEGV);
	sigrelse(SIGSYS);
#endif /* notdef */
	sigrelse(SIGPIPE);
	sigrelse(SIGALRM);
	sigrelse(SIGTERM);
	sigrelse(SIGUSR1);
	sigrelse(SIGUSR2);
	sigrelse(SIGCLD);
	sigrelse(SIGPWR);
	sigrelse(SIGWINCH);
#ifdef P4
	sigrelse(SIGUSR4);
#endif
	sigrelse(SIGPOLL);
#ifdef _POSIX_SOURCE
	sigrelse(SIGSTOP);
	sigrelse(SIGCONT);
	sigrelse(SIGTSTP);
	sigrelse(SIGTTIN);
	sigrelse(SIGTTOU);
	sigrelse(SIGCHLD);
#endif /* _POSIX_SOURCE */
}
