#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)tcp_conn.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * Make a connection to a remote machine and
 * return a File descriptor that has
 * read write semantics.
 */
#include <sys/types.h>
#include "sys/inet.h"
#include "sys/socket.h"

#include "sys/in.h"
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/errno.h>
#include <sys/fcntl.h>
#include "sys/ip.h"
#include "sys/tcp.h"

#include <stdio.h>
#include "netdb.h"
#include <sys/tiuser.h>

extern	 errno, t_errno;


/*
 * Connect to a remote machine.
 */
tcp_connect(service, machine)
	char *service, *machine;
{
	struct servent *sp;

	if ((sp = getservbyname(service, "tcp")) == 0){
		errno = ENOENT;
		return -1;
	}

	return tcp_conport(machine, sp->s_port);
}

tcp_conport(machine, port)
	char *machine;
	unsigned short port;
{
	register struct hostent *host;
	register int net;
	register int serrno;
	struct t_call scall;
	struct sockaddr_in sin;

	/*
	 * Convert the hostname to a internet
	 * address.
	 */
	host = gethostbyname(machine);
	if (host) {
		sin.sin_family = host->h_addrtype;
		bcopy(host->h_addr, (caddr_t)&sin.sin_addr, host->h_length);
	} else {
		sin.sin_family = AF_INET;
		sin.sin_addr.s_addr = inet_addr(machine);
		if (sin.sin_addr.s_addr == -1) {
			errno = ENOENT;
			return -1;
		}
	}
	sin.sin_port = port;
	if((net = t_open(DEV_TCP,O_RDWR,0)) < 0)
		return -1;
	/*
	 * TLI specifies that the file descriptor
	 * should be bound XXXX
	 */
	if(t_bind(net, 0, 0) < 0) {
		if (t_errno != TSYSERR)
			errno = EIO;
		serrno = errno;
		(void)t_close(net);
		errno = serrno;
		return -1;
	}
	scall.addr.buf = (char *)&sin;
	scall.addr.len = TCP_BINDADDRLEN;
	scall.udata.len = scall.opt.len = 0;
	if (t_connect(net, &scall, 0) < 0){
		serrno = errno;
		(void)t_close(net);
		errno = serrno;
		return -1;
	}
	/*
	 * POP the TIMOD module and put the tirdwr
	 */
	if (ioctl(net, I_POP, 0) < 0){
		serrno = errno;
		(void)t_close(net);
		errno = serrno;
		return -1;
	}
	if (ioctl(net, I_PUSH, "tirdwr") < 0){
		serrno = errno;
		(void)t_close(net);
		errno = serrno;
		return -1;
	}
	return net;
}
