#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)rcmd.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */


#include <stdio.h>
#include <sys/types.h>
#include "sys/inet.h"
#include "sys/socket.h"

#include <sys/stream.h>
#include <sys/stropts.h>
#include "sys/in.h"
#include "sys/ip.h"
#include "sys/tcp.h"
#include "sys/inetioctl.h"

#include "netdb.h"
#include <errno.h>
#include <sys/tiuser.h>
#include <fcntl.h>

extern	errno, t_errno;
char	*index() /*, *sprintf() */;

rcmd(ahost, rport, locuser, remuser, cmd, fd2p)
	char **ahost;
	int rport;
	char *locuser, *remuser, *cmd;
	int *fd2p;
{
	int s, timo = 1;
	struct sockaddr_in sin, from;
	struct t_bind ret;
	struct t_bind req;
	char c;
	int lport = IPPORT_RESERVED - 1;
	struct t_call Scall, *sndcall = &Scall;
	struct hostent *hp;

	hp = gethostbyname(*ahost);
	if (hp == 0) {
		fprintf(stderr, "%s: unknown host\n", *ahost);
		return (-1);
	}
	*ahost = hp->h_name;
retry:
	s = rresvport(&lport, 0);
	if (s < 0)
		return (-1);
	sin.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr, (caddr_t)&sin.sin_addr, hp->h_length);
	sin.sin_port = htons(rport);
	sndcall->addr.buf = (char *)&sin;
	sndcall->addr.len = TCP_BINDADDRLEN;
	sndcall->udata.len = sndcall->opt.len = 0;
	if (t_connect(s, sndcall, 0) < 0) 
	{
		if (timo++ > 2) { 
			(void) t_close(s);
			sleep(timo << 1);
			goto retry;
		}
		if (t_errno == TSYSERR)
			perror(hp->h_name);
		else if (t_errno == TBADADDR) {
			errno = ENETUNREACH;
			perror(hp->h_name);
		} else
			t_error(hp->h_name);
		return (-1);
	}
	lport--;
	if (ioctl(s, I_POP, 0) < 0){
		perror("Rcmd: I_POP");
		t_close(s);
		goto bad;
	}
	if (ioctl(s, I_PUSH, "tirdwr") < 0){
		perror("Rcmd: I_PUSH");
		t_close(s);
		goto bad;
	}
	if (fd2p == 0) {
		write(s, "", 1);
		lport = 0;
	} else {
		char num[8];
		int s2 = rresvport(&lport,1), s3;

		if (s2 < 0) {
			(void) close(s);
			return (-1);
		}
		(void) sprintf(num, "%d", lport);
		if (write(s, num, strlen(num)+1) != strlen(num)+1) {
			perror("write: setting up stderr");
			(void) t_close(s2);
			goto bad;
		}
		{ int len = sizeof (from);
		struct t_call *scall;

		if((scall = (struct t_call *)t_alloc(s2, T_CALL, T_ADDR)) < 0) {
			t_error("t_alloc");
			(void)t_close(s2);
			goto bad;
		}
		if(t_listen(s2,scall) < 0) {
			t_error("t_listen error for stderr");
			(void)t_close(s2); 
			goto bad;
		}
		if((s3 = t_open(DEV_TCP, O_RDWR, 0)) < 0) {
			t_error("Can't open stderr");
			(void)t_close(s2);
			goto bad;
		}

		/*
		 * The TLI Spec's tell that the second
		 * endpoint must be bound ( BARF..).
		 */
		sin.sin_port = htons(lport);
		req.addr.buf = (char *)&sin;
		req.addr.len = TCP_BINDADDRLEN;
		req.qlen = 1;

		/* bzero((caddr_t) &from, sizeof(from)); */
		ret.addr.maxlen = sizeof(from);
		ret.addr.len = TCP_BINDADDRLEN;
		ret.qlen = 0;
		ret.addr.buf = (char *)&from;

		if (t_bind(s3, &req, &ret) < 0) {
			t_error("Can't bind stderr");
			(void) t_close(s2); (void) t_close(s3);
			goto bad;
		}

		if (t_accept(s2, s3, scall) < 0) {
			t_error("Can't accept stderr");
			t_close(s2); (void) t_close(s3);
			goto bad;
		}
		t_close(s2);
		if (ioctl(s3, I_POP, 0) < 0){
			perror("rcmd: I_POP");
			t_close(s3);
			goto bad;
		}
		if (ioctl(s3, I_PUSH, "tirdwr") < 0){
			perror("rcmd: I_PUSH");
			t_close(s3);
			goto bad;
		}
		getpeername(s3, &from, &len);
		}
		*fd2p = s3;
		if ( ntohs(from.sin_port) >= IPPORT_RESERVED) {
			fprintf(stderr,
			    "Protocol failure in circuit setup.\n");
			goto bad2;
		}
	}
	(void) write(s, locuser, strlen(locuser)+1);
	(void) write(s, remuser, strlen(remuser)+1);
	(void) write(s, cmd, strlen(cmd)+1);
	if (read(s, &c, 1) != 1) {
		perror(*ahost);
		goto bad2;
	}
	if (c != 0) {
		while (read(s, &c, 1) == 1) {
			(void) write(2, &c, 1);
			if (c == '\n')
				break;
		}
		goto bad2;
	}
	return (s);
bad2:
	if (lport)
		(void) _nolinger_close (*fd2p);
bad:
	(void) _nolinger_close (s);
	return (-1);
}

rresvport(alport, lqlen)
	int *alport;
{
	register int s;
	struct t_bind  Req, Rep;
	register struct t_bind   *req = &Req, *rep = &Rep;
	struct sockaddr_in sin, ret_addr;
	struct strioctl ioc;


	if ((s = t_open(DEV_TCP, O_RDWR, 0)) < 0)
		return (-1);
	/*
	 * This is added so that we get a new port.
	 */
	ioc.ic_len = 0; ioc.ic_dp = (char *)NULL;
	ioc.ic_cmd = TCPIOC_NEWPORT; ioc.ic_timout = 60;
	(void) ioctl (s, I_STR, &ioc);
	rep->qlen = lqlen; rep->addr.len = rep->addr.maxlen = TCP_BINDADDRLEN;
	req->qlen = lqlen; req->addr.len = req->addr.maxlen = TCP_BINDADDRLEN;
	sin.sin_addr.s_addr = INADDR_ANY;
	req->addr.buf = (char *)&sin;
	rep->addr.buf = (char *)&ret_addr;
	for (;;) {
		sin.sin_port = htons((u_short)*alport);
		if (t_bind(s, req, rep) >= 0){
			*alport = ntohs(ret_addr.sin_port);
			return s;
		}

		/*
		 * Could not bind to the requested port #
		 * See if this port is already in use
		 * If so try another one.
		 */
		(*alport)--;
		if (*alport == IPPORT_RESERVED/2) {
			fprintf(stderr, "All network ports in use\n");
			return (-1);
		}
	}
}

t_rcmd(ahost, rport, locuser, remuser, cmd, fd2p)
	char **ahost;
	int rport;
	char *locuser, *remuser, *cmd;
	int *fd2p;
{
	int s, timo = 1;
	struct sockaddr_in sin, from;
	struct t_bind ret;
	struct t_bind req;
	char c;
	int lport = IPPORT_RESERVED - 1;
	struct t_call Scall, *sndcall = &Scall;
	struct hostent *hp;
	int flags = 0;

	/* only superuser is allowed */
	if (geteuid()) {
		t_errno = TSYSERR;
		errno = EPERM;
		fprintf(stderr, "rcmd: not a superuser\n");
		return -1;
	}

	hp = gethostbyname(*ahost);
	if (hp == 0) {
		fprintf(stderr, "%s: unknown host\n", *ahost);
		return (-1);
	}
	*ahost = hp->h_name;
retry:
	s = rresvport(&lport, 0);
	if (s < 0)
		return (-1);
	sin.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr, (caddr_t)&sin.sin_addr, hp->h_length);
	sin.sin_port = htons(rport);
	sndcall->addr.buf = (char *)&sin;
	sndcall->addr.len = TCP_BINDADDRLEN;
	sndcall->udata.len = sndcall->opt.len = 0;
	if (t_connect(s, sndcall, 0) < 0) 
	{
		if (timo++ > 3) {
			(void) t_close(s);
			sleep(timo << 1);
			goto retry;
		}
		if (t_errno == TSYSERR) {
			if (errno != EINTR)
				perror(hp->h_name);
		} else if (t_errno == TBADADDR) {
			errno = ENETUNREACH;
			perror(hp->h_name);
		} else
			t_error(hp->h_name);
		(void) t_close(s);
		return (-1);
	}
	lport--;
	if (fd2p == 0) {
		t_snd(s, "", 1, 0);
		lport = 0;
	} else {
		char num[8];
		int s2, s3;
		s2 = rresvport(&lport,1);

		if (s2 < 0) {
			(void) t_close(s);
			return (-1);
		}
		(void) sprintf(num, "%d", lport);
		if (t_snd(s, num, strlen(num)+1, 0) != strlen(num)+1) {
			(void) t_close(s2);
			goto bad;
		}
		{ int len = sizeof (from);
		struct t_call *scall;

		if((scall = (struct t_call *)t_alloc(s2, T_CALL, T_ADDR)) < 0) {
			t_error("t_alloc");
			(void)t_close(s2);
			goto bad;
		}
		if(t_listen(s2,scall) < 0) {
			if (t_errno == TSYSERR && errno != EINTR)
				t_error("t_listen error for stderr");
			(void)t_close(s2); 
			goto bad;
		}
		if((s3 = t_open(DEV_TCP, 2, 0)) < 0) {
			t_error("Can't open stderr");
			(void)t_close(s2);
			goto bad;
		}
		/*
		 * The TLI Spec's tell that the second
		 * endpoint must be bound ( BARF..).
		 */
		sin.sin_port = htons(lport);
		req.addr.buf = (char *)&sin;
		req.addr.len = TCP_BINDADDRLEN;
		req.qlen = 1;

		/* bzero((caddr_t) &from, sizeof(from)); */
		ret.addr.maxlen = sizeof(from);
		ret.addr.len = TCP_BINDADDRLEN;
		ret.qlen = 0;
		ret.addr.buf = (char *)&from;

		if (t_bind(s3, &req, &ret) < 0) {
			t_error("Can't bind stderr");
			(void) t_close(s2); (void) t_close(s3);
			goto bad;
		}

		if (t_accept(s2, s3, scall) < 0) {
			t_error("Can't accept stderr");
			t_close(s2); (void) t_close(s3);
			goto bad;
		}
		t_close(s2);
		getpeername(s3, &from, &len);
		}
		*fd2p = s3;
		from.sin_port = ntohs((u_short)from.sin_port);
		if ( from.sin_port >= IPPORT_RESERVED) {
			fprintf(stderr,
			    "Protocol failure in circuit setup.\n");
			goto bad2;
		}
	}
	(void) t_snd(s, locuser, strlen(locuser)+1, 0);
	(void) t_snd(s, remuser, strlen(remuser)+1, 0);
	(void) t_snd(s, cmd, strlen(cmd)+1, 0);
	if (t_rcv(s, &c, 1, &flags) != 1) {
		if (t_errno == TSYSERR && errno != EINTR)
			t_error(*ahost);
		goto bad2;
	}
	if (c != 0) {
		while (t_rcv(s, &c, 1, &flags) == 1) {
			(void) write(2, &c, 1);
			if (c == '\n')
				break;
		}
		goto bad2;
	}
	return (s);
bad2:
	if (lport)
		(void) _nolinger_tclose(*fd2p);
bad:
	(void) _nolinger_tclose (s);
	return (-1);
}

/*
 * Set a file descriptor to be no-linger and close it.
 */
_nolinger_close (fd)
{
	int off = 0;

	(void)setsockopt(fd, SOL_SOCKET, SO_LINGER, &off, sizeof(int));
	(void) close (fd);
}
_nolinger_tclose (fd)
{
	int off = 0;

	(void)setsockopt(fd, SOL_SOCKET, SO_LINGER, &off, sizeof(int));
	(void) t_close (fd);
}
