#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)inetnetwrk.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */
/*	@(#)inet_network.c	4.2	10/7/82	*/

#include <sys/types.h>
#include <ctype.h>
#include "sys/inet.h"

/*
 * Internet network address interpretation routine.
 * The library routines call this routine to interpret
 * network numbers.
 */
ulong
inet_network(cp)
	register char *cp;
{
	register ulong val, base, n;
	register char c;
	ulong parts[4], *pp = parts;
	register int i;

	if(!cp)
		return(-1);
again:
	val = 0; base = 10;
	if (*cp == '0')
		base = 8, cp++;
	if (*cp == 'x' || *cp == 'X')
		base = 16, cp++;
	while (c = *cp) {
		if (isdigit(c)) {
			if(base == 8 && c >= '8' )
				return -1;
			val = (val * base) + (c - '0');
			cp++;
			continue;
		}
		if (base == 16 && isxdigit(c)) {
			val = (val << 4) + (c + 10 - (islower(c) ? 'a' : 'A'));
			cp++;
			continue;
		}
		break;
	}
	if (*cp == '.') {
		if (pp >= parts + 4)
			return (-1);
		*pp++ = val, cp++;
		goto again;
	}
	if (*cp && !isspace(*cp))
		return (-1);
	*pp++ = val;
	n = pp - parts;
	if (n > 4)
		return (-1);
	for (val = 0, i = 0; i < n; i++) {
		if(parts[i] > 0xff)
			return(-1);
		val <<= 8;
		val |= parts[i] & 0xff;
	}
	return (val);
}
