#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)bzero.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */
/* @(#)bzero.s	4.2 1/14/83 */
/* bzero(base, length) */

bzero(base,len)
register char *base;
register int len;
{
	register int fill = 0;

	/**
	 ** Align to full word
	 **/
	while ( len > 0 && ((int) base & 03) ){
		*base++ = fill;
		len--;
	}
	if (len <= 0) return;
	/**
	 ** Now that we are aligned, Store full words of zeros
	 **/
	while (( len -= 4 ) > 0){
		*(int *)base = fill;
		base += 4;
	}
	/**
	 ** At the most 4 bytes are left
	 **/
	len += 4;
	do {
		*base++ = fill ;
	} while ( --len > 0 );
}
