#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)tftpd.c (TWG)  1.1     89/05/19 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * Trivial file transfer protocol server.
 */

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/tiuser.h>

#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/ip.h>
#include <sys/udp.h>
#include <sys/in.h>

#include <arpa/tftp.h>

#include <signal.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <netdb.h>
#include <setjmp.h>

#define	TIMEOUT		5

extern	int errno;
struct	sockaddr_in sin; 
int	f;
int	rexmtval = TIMEOUT;
int	maxtimeout = 5*TIMEOUT;
char	buf[SEGSIZE*2];
struct t_unitdata unitdata;
int flags;

int dpath = 0;   /* Variables introduced to handle default paths */
char path[256];
char temp[256];

struct sockaddr_in from;
static FILE *ffp;

main(argc, argv)
int argc;
char *argv[];
{
	register struct tftphdr *tp;
	register int n;
	struct servent *sp;
	register sodebug = 0;
	int fromlen;
	struct t_bind req;

		
	sp = getservbyname("tftp", "udp");
	if (sp == 0) {
		fprintf(stderr, "tftpd: udp/tftp: unknown service\n");
		exit(1);
	}
	sin.sin_port = sp->s_port; sin.sin_family = AF_INET;

/* Argument Processing *******************************************************/
 
/* Rewritten by J.T. Harris on 17th March 1992                               */
/* Changes made to include a default file path specification.                */
/* This was done to allow devices that use non-absolute filenames            */
/* to use the ARIX System 90 as a boot server using tftp                     */
/*                                                                           */
/* Usage: tftpd [-d] [-p default_path] [-n port_number]                      */
/*                                                                           */
/* Note: default_path must begin with a "/"                                  */

 argc--; argv++;
 while( argc > 0 )
 {
  if( strcmp( *argv, "-d" ) == 0 )  /* set the debugging option */
  {
  
   sodebug = 1;
   argc--; argv++;
   continue;
 
  }
  else
  if( strcmp( *argv, "-p" ) == 0 ) /* set the default path name */
  {

   argc--; argv++;
   if( **argv != '/' )
   {
    printf("tftpd: Invalid Default Path %s. Path must begin with /.\n", *argv);
    exit(1);
   }
   if( strlen( *argv ) == 1 )
   {
    printf("tftpd: Invalid Default Path. Root directory may not be used.\n");
    exit(1);
   }
   if( strlen( *argv ) >= 201 )
   {
    printf("tftpd: Invalid Default Path. Path name too long (max 200 chars)\n");
    exit(1);
   }
   strcpy( path, *argv );
   dpath = 1;
   argc--; argv++;
   continue;

  }
  else
  if( strcmp( *argv, "-n" ) == 0 ) /* set the port number */
  {

   argc--; argv++;
   sin.sin_port = htons( atoi( *argv ));
   if( sin.sin_port == 0 )
   {
    printf( "tftpd: %s: invalid port number\n", *argv );
    exit(1);
   }
   argc--; argv++;
   continue;

  }
  else /* failure : bad command options */
  {

   printf("Usage: tftpd [-d] [-p default_path] [-n port_number]\n");
   exit(1);
  
  }
 }

/*****************************************************************************/

	if (fork())
		exit(0);
	for (f = 0; f < 10; f++)
		(void) close(f);
	(void) open("/dev/console", 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
	setpgrp(); /* To ignore Keyboard signals */
	signal(SIGCLD,SIG_IGN); /* This insures that no Zombies hang around */
	f = t_open(DEV_UDP, O_RDWR, 0);
	if (f < 0) {
		t_error("tftpd: Can't open UDP device");
		exit(1);
	}
	sin.sin_addr.s_addr = INADDR_ANY;
	req.addr.buf = (char *)&sin;
	req.addr.len = UDP_BINDADDRLEN;
	req.qlen = 5;
	if (t_bind(f, (caddr_t)&req, 0) < 0) {
		t_error ("tftdp: Can't bind to TFTP port");
		exit (1);
	}
	for (;;) {
		do {
			extern errno, t_errno;

			fromlen = sizeof (from);
			unitdata.addr.len = unitdata.addr.maxlen = 
						UDP_BINDADDRLEN;
			unitdata.addr.buf = (char *)&from;
			unitdata.opt.buf = (char *) 0;
			unitdata.opt.len = unitdata.opt.maxlen = 0;
			unitdata.udata.maxlen = sizeof(buf);
			unitdata.udata.buf = (char *) buf;
			if (t_rcvudata(f, &unitdata, &flags) < 0) {
				sleep (1);
				continue;
			}
			n = unitdata.udata.len;
		} while (n <= 0);
		tp = (struct tftphdr *)buf;
#if defined(vax) || defined(SWAP)
		tp->th_opcode = ntohs(tp->th_opcode);
#endif
		if (tp->th_opcode == RRQ || tp->th_opcode == WRQ){
			if (fork() == 0) {
				(void) t_close (f);
				(void) setpgrp ();
				(void) tftp(&from, tp, n);
			}
		} 
	}
}


int	validate_access();
int	sendfile(), recvfile();

struct format {
	char	*f_mode;
	int	(*f_validate)();
	int	(*f_send)();
	int	(*f_recv)();
} formats[] = {
	{ "netascii",	validate_access,	sendfile,	recvfile },
	{ "octet",	validate_access,	sendfile,	recvfile },
#ifdef notdef
	{ "mail",	validate_user,		sendmail,	recvmail },
#endif
	{ 0 }
};

FILE   *fptr;			/* file being transferred */

/*
 * Handle initial connection protocol.
 */
tftp(client, tp, size)
	struct sockaddr_in *client;
	struct tftphdr *tp;
	int size;
{
	register char *cp;
	int first = 1, ecode;
	register struct format *pf;
	char *filename, *mode;

	filename = cp = ((struct TFtphdr *)tp)->th_stuff;

/* Handle default path specification ****************************************/

 if ( dpath && ( *filename != '/' ))
 {
   sprintf( temp, "%s/%s", path, filename );
   filename = temp;
 }

/****************************************************************************/

	/*
	 * Pick a new TID which we can use for sending replies
	 */
	f = t_open (DEV_UDP, O_RDWR, 0);
	if (f < 0) {
		Message ("tftpd: t_open, Can't create new port\n");
		exit(1);
	}
	if (t_bind (f, 0, 0) < 0) {
		Message ("tftpd: Can't bind to any port\n");
		exit (1);
	}
again:
	while (cp < buf + size) {
		if (*cp == '\0')
			break;
		cp++;
	}
	if (*cp != '\0') {
		nak(EBADOP);
		exit(1);
	}
	if (first) {
		mode = ++cp;
		first = 0;
		goto again;
	}
	for (cp = mode; *cp; cp++)
		if (isupper(*cp))
			*cp = tolower(*cp);
	for (pf = formats; pf->f_mode; pf++)
		if (strcmp(pf->f_mode, mode) == 0)
			break;
	if (pf->f_mode == 0) {
		nak(EBADOP);
		exit(1);
	}
	ecode = (*pf->f_validate)(filename, client, tp->th_opcode);
	if (ecode) {
		nak(ecode);
		exit(1);
	}
	nvtinit();
	if (tp->th_opcode == WRQ)
		(*pf->f_recv)(pf);
	else
		(*pf->f_send)(pf);
	exit(0);
}

/*
 * Validate file access.  Since we
 * have no uid or gid, for now require
 * file to exist and be publicly
 * readable/writable.
 * Note also, full path name must be
 * given unless default path is set.
 */
validate_access(file, client, mode)
	char *file;
	struct sockaddr_in *client;
	int mode;
{
	struct stat stbuf;
	register int oldmask, ffd;

	if ( *file != '/' )
	 return( EACCESS );

	if (stat(file, &stbuf) < 0) {
		if (mode == RRQ)
			return (errno == ENOENT ? ENOTFOUND : EACCESS);
		oldmask = umask(0);
		ffd = creat(file,0666);
		if (ffd < 0 )
			return (errno + 100);
		close(ffd);
		umask(oldmask);
		goto fileok;
	}
	if (mode == RRQ) {
		if ((stbuf.st_mode & (S_IREAD >> 6)) == 0)
			return (EACCESS);
	} else {
		if ((stbuf.st_mode & (S_IWRITE >> 6)) == 0)
			return (EACCESS);
		ffd = creat(file, stbuf.st_mode & 0777);
		if( ffd < 0) 
			return(errno+100);
		close(ffd);
	}
fileok:
	fptr = fopen(file, mode == RRQ ? "r" : "w");
	if (fptr == NULL)
		return (errno + 100);
	return (0);
}

int	timeout;
jmp_buf	timeoutbuf;

timer()
{

	timeout += rexmtval;
	if (timeout >= maxtimeout)
		exit(1);
	longjmp(timeoutbuf, 1);
}

/*
 * Send the requested file.
 */
sendfile(pf)
	struct format *pf;
{
	register struct tftphdr *tp;
	register int block = 1, size, n;
	struct t_unitdata unitdata;
	int flags;

	unitdata.udata.buf = buf;
	unitdata.addr.len = unitdata.addr.maxlen = UDP_BINDADDRLEN;
	unitdata.opt.buf = (char *) 0;
	unitdata.opt.len = unitdata.opt.maxlen = 0;

	signal(SIGALRM, timer);
	tp = (struct tftphdr *)buf;
	do {
		size = nvtread(fptr, tp->th_data, SEGSIZE, pf->f_mode);
		if (size < 0) {
			perror("read");
			nak(errno + 100);
			goto abort;
		}
		tp->th_opcode = htons((u_short)DATA);
		tp->th_block = htons((u_short)block);
		timeout = 0;
		(void) setjmp(timeoutbuf);
		unitdata.udata.len = size + 4; 
		unitdata.addr.buf = (char *)&from;
		n = t_sndudata(f, &unitdata);
		if ((n < 0) || (n = unitdata.udata.len) != size + 4) {
			perror("tftp: sendto");
			goto abort;
		}
		do {
			int fromlen = sizeof(from);
			alarm(rexmtval);
			unitdata.udata.maxlen = sizeof(buf);
			unitdata.addr.buf = (char *)&from;
			if (t_rcvudata(f, &unitdata, &flags) < 0){
				WIN_error("t_rcvudata");
				alarm(0);
				goto abort;
			}
			alarm(0);
			n = unitdata.udata.len;
			if (n < 0) {
				WIN_error("tftpd: t_rcvudata");
				goto abort;
			}
			tp->th_opcode = ntohs((u_short)tp->th_opcode);
			tp->th_block = ntohs((u_short)tp->th_block);
			if (tp->th_opcode == ERROR)
				goto abort;
		} while (tp->th_opcode != ACK || tp->th_block != block);
		block++;
	} while (size == SEGSIZE );
abort:
	(void) fclose(fptr);
	
}

/*
 * Receive a file.
 */
recvfile(pf)
	struct format *pf;
{
	register struct tftphdr *tp;
	register int block = 0, n, size;
	struct t_unitdata unitdata;
	int flags;

	unitdata.udata.buf = buf;
	unitdata.addr.len = unitdata.addr.maxlen = UDP_BINDADDRLEN;
	unitdata.opt.buf = (char *) 0;
	unitdata.opt.len = unitdata.opt.maxlen = 0;

	signal(SIGALRM, timer);
	tp = (struct tftphdr *)buf;
	do {
		timeout = 0;
		tp->th_opcode = htons((u_short)ACK);
		tp->th_block = htons((u_short)block);
		block++;
		(void) setjmp(timeoutbuf);
		unitdata.udata.len = 4;
		unitdata.addr.buf = (char *)&from;
		n = t_sndudata(f, &unitdata);
		if ((n < 0) || (n = unitdata.udata.len) != 4) {
			WIN_error("tftpd: t_sndudata");
			goto abort;
		}
		do {
			alarm(rexmtval);
			unitdata.udata.maxlen = sizeof(buf);
			unitdata.addr.buf = (char *)&from;
			if (t_rcvudata(f, &unitdata, &flags) < 0){
				WIN_error("t_rcvudata");
				alarm(0);
				goto abort;
			}
			alarm(0);
			n = unitdata.udata.len;
			if (n < 0) {
				WIN_error("tftpd: t_rcvudata");
				goto abort;
			}
			tp->th_opcode = ntohs((u_short)tp->th_opcode);
			tp->th_block = ntohs((u_short)tp->th_block);
			if (tp->th_opcode == ERROR) 
				goto abort;
		} while (tp->th_opcode != DATA || block != tp->th_block);
		size = nvtwrite(fptr, tp->th_data, n - 4, pf->f_mode);
		if (size < 0) {
			nak(errno + 100);
			goto abort;
		}
	} while (size == SEGSIZE);
abort:
	nvtwflush(fptr, pf->f_mode);
	tp->th_opcode = htons((u_short)ACK);
	tp->th_block = htons((u_short)(block));
	unitdata.udata.len = 4;
	unitdata.addr.buf = (char *)&from;
	(void)t_sndudata(f, &unitdata);
	(void) fclose(fptr);
}

struct errmsg {
	int	e_code;
	char	*e_msg;
} errmsgs[] = {
	{ EUNDEF,	"Undefined error code" },
	{ ENOTFOUND,	"File not found" },
	{ EACCESS,	"Access violation" },
	{ ENOSPACE,	"Disk full or allocation exceeded" },
	{ EBADOP,	"Illegal TFTP operation" },
	{ EBADID,	"Unknown transfer ID" },
	{ EEXISTS,	"File already exists" },
	{ ENOUSER,	"No such user" },
	{ -1,		0 }
};

/*
 * Send a nak packet (error message).
 * Error code passed in is one of the
 * standard TFTP codes, or a UNIX errno
 * offset by 100.
 */
nak(error)
	int error;
{
	register struct tftphdr *tp;
	int length;
	register struct errmsg *pe;
	extern char *sys_errlist[];

	tp = (struct tftphdr *)buf;
	tp->th_opcode = htons((u_short)ERROR);
	tp->th_code = htons((u_short)error);
	for (pe = errmsgs; pe->e_code >= 0; pe++)
		if (pe->e_code == error)
			break;
	if (pe->e_code < 0)
		pe->e_msg = sys_errlist[error - 100];
	strcpy(tp->th_msg, pe->e_msg);
	length = strlen(pe->e_msg);
	tp->th_msg[length] = '\0';
	length += 5;
	unitdata.udata.buf = buf; unitdata.udata.len = 4; 
	unitdata.addr.len = unitdata.addr.maxlen = UDP_BINDADDRLEN;
	unitdata.opt.len = unitdata.opt.maxlen = 0;
	unitdata.opt.buf = (char *) 0;
	unitdata.addr.buf = (char *)&from;
	(void)t_sndudata(f, &unitdata);
}

void
perror(s)
char *s;
{
	extern errno;
	extern char *sys_errlist[];
	char buf[200];

	sprintf(buf,"%s: %s\n",s,sys_errlist[errno]);
	Message("%s",buf);
}
static FILE *fp;
/* VARARGS */
Message(fmt,s1,s2,s3,s4,s5)
{
	fp = fopen("/tmp/tftpdlog","a+");
	if (fp){
		fprintf(fp,fmt,s1,s2,s3,s4,s5);
		fclose(fp);
	}
}
static	int nvtholdlf;	/*flag=1 if building CRLF for output and CR generated*/
static	int nvtcrseen;	/*flag=1 if last char rcvd is a CR */

nvtinit()
{
nvtholdlf = 0;
nvtcrseen = 0;
}

nvtread(fdes, buffr, bsize, xfrmode)
	FILE *fdes;	/* file descriptor to read from */
	char *buffr;	/* buffer into which the data is to be placed */
	int bsize;	/* buffer size in bytes, must be > 0 */
	char *xfrmode;	/* type of transfer, netascii or octet */
{
if (strcmp(xfrmode, "octet") == 0)
	{
	return fread(buffr, sizeof (char), bsize, fdes);
	}
   else {
	register char *bp, *ebp;
	register char c;
	bp = buffr;
	ebp = bp + bsize;
	while (bp != ebp)
		{
		if (nvtholdlf != 0)
			{
			nvtholdlf = 0;
			*bp++ = '\n';
			}
		   else {
			c = getc(fdes);
			if (feof(fdes) || ferror(fdes)) return (int)(bp-buffr);
			if (c == '\n')
				{
				*bp++ = '\r';
				nvtholdlf = 1;
				}
			   else *bp++ = c;
			}
		}
	return bsize;
	}
}

nvtwflush(fdes, xfrmode)
	FILE *fdes;	/* file descriptor to write to */
	char *xfrmode;	/* type of transfer, netascii or octet */
{
if ((nvtcrseen == 1) && (strcmp(xfrmode, "octet") != 0)) putc('\r', fdes);
}

nvtwrite(fdes, buffr, bsize, xfrmode)
	FILE *fdes;	/* file descriptor to write to */
	char *buffr;	/* buffer from which the data is to be taken */
	int bsize;	/* buffer size in bytes, must be > 0 */
	char *xfrmode;	/* type of transfer, netascii or octet */
{
if (strcmp(xfrmode, "octet") == 0)
	{
	fwrite(buffr, sizeof (char), bsize, fdes);
	return bsize;
	}
   else {
	register char *bp, *ebp;
	register char c;
	bp = buffr;
	ebp = bp + bsize;
	while (bp != ebp)
		{
		c = *bp++;
		switch (c)
			{
			case '\n':
				nvtcrseen = 0;
				putc('\n', fdes);
				break;
			case '\r':
				if (nvtcrseen != 0) putc('\r', fdes);
				   else nvtcrseen = 1;
				break;
			default:
				if (nvtcrseen != 0)
					{
					nvtcrseen = 0;
					putc('\r', fdes);
					}
				putc(c, fdes);
			}
		}
	return bsize;
	}
}
Debug(fmt, a1, a2, a3, a4)
{
	register FILE *fp;
	if ((fp = fopen("/dev/console", "w")) == NULL)
		return;
	fprintf(fp, fmt, a1, a2, a3, a4);
	fclose(fp);
}
