
#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)telnetd.c (TWG)  1.4     89/09/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * Telnet Server
 */

/* Fix Log
 *
 * 04/29/91	TWU	Kill all the processes which having the same group
 *		        id as child instead of myself.
 * 04/29/91	TWU	Change process type to INIT_PROCESS instead of EMPTY
 *
 * 05/08/91	TWU	Set keepalive option
 * 05/13/91	TWU	Keep sync between child and parent processes when 
 *			child process is setting tty.
 */

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/signal.h>
#include <sys/errno.h>
#include <tiuser.h>
#include <utmp.h>
#ifdef USG
#include <termio.h>
#else
#include <sgtty.h>
#endif /* USG */

#include <netdb.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/ip.h>
#include <sys/tcp.h>	/* Pull in TCP_BINDADDRLEN */
#include <sys/in.h>
#include <arpa/telnet.h>
#include <stat.h>

#ifndef	SIGCHLD
#define	SIGCHLD	SIGCLD
#endif

#define	BELL	'\07'
#define AYTReply "\r\nWIN Server Telnet Operational\r\n"
#define BANNER	"\r\n ARIX System90 V3.0 (%s)\r\n\r\n\r%s"

/* External definitions */

extern	char **environ;
extern	int t_errno;
extern	int errno;
extern	char *ttyname(), *strrchr();

/* FORWARD procedure declarations */

int cleanup();

/* Global Variables */

unsigned char iacdm[2] = { IAC,DM };
oobflag = 0;

char	hisopts[256];
char	myopts[256];

char	doopt[] = { IAC, DO, '%', 'c', 0 };
char	dont[] = { IAC, DONT, '%', 'c', 0 };
char	will[] = { IAC, WILL, '%', 'c', 0 };
char	wont[] = { IAC, WONT, '%', 'c', 0 };

/*
 * I/O data buffers, pointers, and counters.
 */
unsigned char	ptyibuf[BUFSIZ], *ptyip = ptyibuf;
unsigned char	ptyobuf[BUFSIZ], *pfrontp = ptyobuf, *pbackp = ptyobuf;
unsigned char	netibuf[BUFSIZ], *netip = netibuf;
unsigned char	netobuf[BUFSIZ], *nfrontp = netobuf, *nbackp = netobuf;
int	pcc, ncc;

int	pty, net = 0;
int	inter;
char	*line;
char	defeot;
int 	pid;
/* TWU 05/13/91 flag to sync between child and parent processes */
int	childready = 0;
void childok();

main(argc, argv)
	char *argv[];
{
	int s, pid, options;
	struct servent *sp;
	struct t_bind req;
	struct	sockaddr_in from;


	setpgrp();
	/*
	 * The new tcplisten program sets up stdin and stdout and fires us up.
	 */
	doit(0, argv[1]);
}


/*
 * Get a pty, scan input lines.
 */
doit(f, host)
	int f;
	char *host;
{
	char c;
	char *ttyn;
	int	on = 1;
	int i, p, cc, t;
#ifdef USG
	struct termio b;
#else
	struct sgttyb b;
#endif /* USG */
	struct hostent *hp;

	/*
	 * POP the TIRDWR module form the path
	 * and push in the TIMOD module.
	 */
	if (ioctl(f, I_POP, 0 /*"tirdwr"*/) < 0){
		ConPrint("telnetd: Can't I_POP tirdwr(%d)\n",errno);
		exit(1);
	}
	if (ioctl(f, I_PUSH, "timod") < 0){
		ConPrint("telnetd: Can't TIMOD module %d\n", errno);
		exit(1);
	}
	/* TWU 05/08/91 Set keepalive options to make sure the tcp session
	   will not be disconnected if clint is doing nothing */

	if (setsockopt(f, SOL_SOCKET, SO_KEEPALIVE, (char *)&on, sizeof (on))
		< 0) {
		ConPrint("telnetd: Can't set KEEP ALIVE option %d\n", errno);
		exit(1);
	}

		
	for (i = 0 ; i <= 999 ; i++) {
		struct stat stb;
		line = "/dev/ptypXXX";
		sprintf(&line[9], "%.3d", i);
		if (stat(line, &stb) < 0)
			break;
		p = open(line, O_RDWR /*|O_NDELAY*/ );
		if (p >= 0)
			goto gotpty;
	}
	fatal(f, "All network ports in use");
	/*NOTREACHED*/
gotpty:
	/* fprintf(stderr,"telnetd: Got Pty\n",0); */
	/* dup2(f, 0); */
	line[strlen("/dev/")] = 't';

	signal(SIGCHLD, cleanup);
	/* TWU 05/13/91 call childok routine when child ready */  
	signal(SIGUSR1, childok);

	if ((pid = fork()) < 0)
		fatalperror(f, "fork", errno);

	if (pid) { /* parent */
		signal(SIGINT,SIG_IGN);
		signal(SIGHUP,SIG_IGN);
		signal(SIGQUIT,SIG_IGN);
#ifdef SIGTSTP
		signal(SIGTSTP, SIG_IGN);
#endif /* SIGTSTP */
/* TWU 05/13/91 sync with child process */
		while (childready == 0)
			pause(); /* pause until child ready (pty is setup) */
		telnet(f, p);
	}

	/* child */

	signal(SIGCHLD, SIG_DFL);

	setpgrp();
	t = open( line, O_RDWR );
	if (t < 0)
		fatalperror(f, line, errno);
#ifdef USG
	/* The pty controller and the pty slave share same tp */
	ioctl(p,TCGETA,&b);
	b.c_oflag = OPOST|ONLCR|TAB3;
	b.c_iflag = IGNPAR|ISTRIP|ICRNL;
	b.c_lflag = ISIG|ICANON|ECHO|ECHOE|ECHOK;
	b.c_cflag = EXTB|HUPCL|CS8;
	defeot = b.c_cc[VEOF];
	ioctl(t,TCSETA,&b);
#else
	ioctl(t, TIOCGETP, &b);
	b.sg_flags = CRMOD|XTABS|ANYP;
	ioctl(t, TIOCSETP, &b);
	ioctl(p, TIOCGETP, &b);
#endif /* USG */
/* TWU 05/13/91 tell parent child is ready */
	kill (getppid(), SIGUSR1);

	ttyn = ttyname(t);
	close(f);
	close(p);
	dup2(t, 0);
	dup2(t, 1);
	dup2(t, 2);
	close(t);

#ifdef OLDLOGIN
	{
	struct utmp up;
	int w;
	char *ttytail, *devtail;

	ttytail = strrchr(ttyn, 'p');
	devtail = strrchr(ttyn, '/');
	ttyn = devtail +1;

	w = open( UTMP_FILE, O_RDWR );
	while (read(w, &up, sizeof(up)) == sizeof(up)) {
		if (strncmp(up.ut_line, ttyn, strlen(ttyn)) == 0) {
			up.ut_id[0] = *ttytail++;
			up.ut_id[1] = *ttytail++;
			up.ut_id[2] = *ttytail++;
			up.ut_id[3] = *ttytail++;
			strcpy(up.ut_line, ttyn);
			up.ut_pid = getpid();
			up.ut_type = LOGIN_PROCESS;
			lseek(w, -(long)sizeof(up), 1);
			write(w, (char *)&up, sizeof(up));
			close(w);
			goto log;
		}
	}			
	lseek(w, 0L, 2);
	up.ut_type = LOGIN_PROCESS;
	up.ut_pid = getpid();
	strcpy(up.ut_line, ttyn);
	up.ut_id[0] = *ttytail++;
	up.ut_id[1] = *ttytail++;
	up.ut_id[2] = *ttytail++;
	up.ut_id[3] = *ttytail++;
	write(w, (char *)&up, sizeof(up));
	close(w);
	}
log:
	execl("/bin/login", "login",  0);
	execl("/etc/login", "login",  0);
#else /* OLDLOGIN */
	execl("/bin/login", "login", "-h", host, 0);
	execl("/etc/login", "login", "-h", host, 0);
#endif /* OLDLOGIN */
	execl("/usr/etc/netlogin","login", "-h", host, 0);
	execl("/etc/netlogin","login", "-h", host, 0);
	execl("/bin/netlogin", "login", "-h", host, 0);

	/* we have no file here on which to complain, so exit silently */
	exit(1);
	/*NOTREACHED*/
}

fatal(f, msg)
	int f;
	char *msg;
{
	int flags = 0;
	char buf[BUFSIZ];

	(void) sprintf(buf, "telnetd: %s.\n", msg);
/*
	(void) write(f, buf, strlen(buf));
*/
	(void) t_snd(f, buf, strlen(buf),flags);
	exit(1);
}

fatalperror(f, msg, errno)
	int f;
	char *msg;
	int errno;
{
	char buf[BUFSIZ];
	extern char *sys_errlist[];

	(void) sprintf(buf, "%s: %s", msg, sys_errlist[errno]);
	fatal(f, buf);
}


/*
 * Fire up the IO to the stream fd.
 */
/* ARGSUSED */
sig_poll(sig)
{
	int flags;
	sighold(SIGPOLL);

	/*
	 * Read from the FD.
	 */
	for(;;) {
		/*
		 * Something to read from the network...
		 */
		flags = 0;
		ncc = t_rcv(net, netibuf, BUFSIZ,&flags);
		if (flags & T_EXPEDITED){
			oobflag ++;
			if (ncc == 0) continue;
		}

		if ( ncc > 0 ) {
			netip = netibuf;
			telrcv();
			if ((pfrontp-pbackp) > 0)
				ptyflush();
		} else {
			if ( ncc < 0 && t_errno == TNODATA )
				break;
			cleanup();
			/* NOTREACHED */
		}
	}
	sigrelse(SIGPOLL);
}

/*
 * Main loop.  Select from pty and network, and
 * hand data to telnet receiver finite state machine.
 */
telnet(f, p)
{
	int on = 1;
	char hostname[32];
	int pid;
	register int c;
	register int i;
	struct strioctl ioc;

	net = f, pty = p;

	/*
	 * Request to do remote echo.
	 */
	dooption(TELOPT_ECHO);
	myopts[TELOPT_ECHO] = 1;
	dooption(TELOPT_SGA);
	myopts[TELOPT_SGA] = 1;
	/*
	 * Show banner that getty never gave.
	 */
	gethostname(hostname, sizeof (hostname));
	sprintf(nfrontp, BANNER, hostname, "");
	nfrontp += strlen(nfrontp);
	net = f;
	(void)t_sync(net);
	(void)fcntl(f, F_SETFL, O_NDELAY);  /* non Blocking I/O */
	sigset(SIGPOLL, sig_poll);
	(void)ioctl(f, I_SETSIG, S_INPUT|S_MSG);
	sig_poll(SIGPOLL);	/* Pretend that we just got a signal */
	for (;;) {
		/*
		 * Something to read from the pty...
		 */
		pcc = read(p, ptyibuf, BUFSIZ);

		if ( pcc > 0 )
			ptyip = ptyibuf;
		else if (pcc < 0 && (errno == EINTR||errno == EAGAIN) )
			pcc = 0;
		else
			break;
		if (pcc > 0)
			telsnd();
		if ((nfrontp - nbackp) > 0)
			netflush();

	}
	cleanup();
}

/*
 * State for recv fsm
 */
#define	TS_DATA		0	/* base state */
#define	TS_IAC		1	/* look for double IAC's */
#define	TS_CR		2	/* CR-LF ->'s CR */
#define	TS_BEGINNEG	3	/* throw away begin's... */
#define	TS_ENDNEG	4	/* ...end's (suboption negotiation) */
#define	TS_WILL		5	/* will option negotiation */
#define	TS_WONT		6	/* wont " */
#define	TS_DO		7	/* do " */
#define	TS_DONT		8	/* dont " */
#define TS_STATUS	9	/* subnegotiation of status */
#define TS_IS		10	/* Subnegotiation. status is ...*/
#define TS_EXOPL	11	/* Subnegotiation of EXOPL */
#define TS_EXOPL_OPT	12	/* 	    " " 	   */
#define TS_END_IAC	13


/*
 *	Take stuff from pty and place on network buffer.
 */
 
telsnd()
{
	static char state = TS_DATA;
	register int c;

	while (pcc > 0) {
		if ((&netobuf[BUFSIZ] - nfrontp) < 2)
			break;
		c = *ptyip++ & 0xff;
		--pcc;
		switch( state ) {

		  case TS_DATA:
			if (c == IAC)		/* If not binary mode, */
				*nfrontp++ = c;	/* you lose anyway */
			else
			if (c == '\r' && !myopts[TELOPT_BINARY])
				state = TS_CR;
			break;

		  case TS_CR:
			if (c != '\n' && c != '\0' && !myopts[TELOPT_BINARY])
				*nfrontp++ = '\0';
			state = TS_DATA;
			break;
		}
		*nfrontp++ = c;
	}
}

telrcv()
{
	register int c,i;
	static int state = TS_DATA;
	static unsigned char Reply[] = {IAC,SB,TELOPT_EXOPL,0,0,IAC,SE,0};
#ifdef USG
	struct termio b;
#else
	struct sgttyb b;
#endif /* USG */

	while (ncc > 0) {
		if ((&ptyobuf[BUFSIZ] - pfrontp) < 2)
			return;
		c = *netip++ & 0377, ncc--;
		switch (state) {

		case TS_CR:
			state = TS_DATA;
			if(c == '\n' || c == 0) break;
			/* FALL THROUGH */

		case TS_DATA:
			if (c == IAC) {
				state = TS_IAC;
				break;
			}
			if (inter > 0)
				break;
			if ( !oobflag )
				*pfrontp++ = c;
			if (!myopts[TELOPT_BINARY] && c == '\r')
				state = TS_CR;
			break;

		case TS_IAC:
			switch (c) {

			/*
			 * Send the process on the pty side an
			 * interrupt.  Do this with a NULL or
			 * interrupt char; depending on the tty mode.
			 */
			case BREAK:
			case IP:
				interrupt();
				break;

			/*
			 * Are You There?
			 */
			case AYT:
				ptyflush();
				strcpy(nfrontp,AYTReply);
				nfrontp += 33;
				*nfrontp++ = BELL;
				break;

			/*
			 * Erase Character and
			 * Erase Line
			 */
			case EC:
			case EL:
				ptyflush();	/* half-hearted */
#ifdef USG
				ioctl(pty,TCGETA,&b);
				*pfrontp++ = (c == EC) ?
					b.c_cc[VERASE] : b.c_cc[VKILL];
#else
				ioctl(pty, TIOCGETP, &b);
				*pfrontp++ = (c == EC) ?
					b.sg_erase : b.sg_kill;
#endif /* USG */
				break;

			/*
			 * Check for urgent data...
			 */
			case DM:
				oobflag = 0;
				break;

			/*
			 * Begin option subnegotiation...
			 */
			case SB:
				state = TS_BEGINNEG;
				continue;

			case WILL:
			case WONT:
			case DO:
			case DONT:
				state = TS_WILL + (c - WILL);
				continue;


			/*
			*    Abort Output requires a SYNCH for a response.
			*/
			case AO:
				{
				int flags = 0;
				int i, n = 0;
				
				for(i=0,flags=0; i<2; i++,flags=T_EXPEDITED) {
					while((n=t_snd(net,&iacdm[i],1,flags))
							!= 1) {
						if (n>=0)
							break;
						if ((t_errno !=TFLOW &&
							t_errno != TSYSERR)
						    ||
						    (t_errno == TSYSERR &&
							errno != EAGAIN &&
							errno != EWOULDBLOCK &&
							errno != EINTR)) {
							cleanup();
							break;
						}
					}
				}
				interrupt();
				break;

				}
			case IAC:
				*pfrontp++ = c;
				break;
			}
			state = TS_DATA;
			break;

		case TS_BEGINNEG:
			if (c == TELOPT_STATUS) state = TS_STATUS;
			else if (c == TELOPT_EXOPL) state = TS_EXOPL;
			else state = TS_ENDNEG;
			break;

		case TS_STATUS:
			if (c == IS)
				state = TS_IS;
			else if (c == SEND) {
				sendstatus();
				state = TS_END_IAC;
			}
			break;

		case TS_IS:
			state = TS_END_IAC;
			break;

		case TS_EXOPL:
			switch(c) {
			case DO:
			case DONT:
				state = TS_EXOPL_OPT;
				Reply[3] = WONT;
				break;
			case WILL:
			case WONT:
				state = TS_EXOPL_OPT;
				Reply[3] = DONT;
				break;
			case SB:
			default:
				state = TS_END_IAC;
				break;
			}
			break;

		case TS_EXOPL_OPT:
			Reply[4] = c;
			strcpy(nfrontp,Reply);
			nfrontp += strlen(Reply);
			state = TS_END_IAC;
			break;

		case TS_END_IAC:
			if ( c == IAC )
				state = TS_ENDNEG;
			break;

		case TS_ENDNEG:
			if (c == SE)
				state = TS_DATA;
			break;

		case TS_WILL:
			if (!hisopts[c])
				willoption(c);
			state = TS_DATA;
			continue;

		case TS_WONT:
			if (hisopts[c])
				wontoption(c);
			state = TS_DATA;
			continue;

		case TS_DO:
			if (!myopts[c])
				dooption(c);
			state = TS_DATA;
			continue;

		case TS_DONT:
			if (myopts[c])
				dontoption(c);
			state = TS_DATA;
			continue;

		default:
			printf("telnetd: panic state=%d\n", state);
			exit(1);
			/* NOTREACHED */
		}
	}
}



willoption(option)
	int option;
{
	char *fmt;
	static unsigned char StatusSend[]={IAC,SB,TELOPT_STATUS,SEND,IAC,SE,0};
#ifdef USG
	struct termio b;
#endif /* USG */

	switch (option) {

	case TELOPT_BINARY:
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_lflag &= ~ICANON;
		b.c_cc[VMIN]= 1; b.c_cc[VTIME]= -1; /* Ignore time */
		ioctl(pty,TCSETA,&b);
#else
		mode(RAW, 0);
#endif /* USG */
		goto common;

	case TELOPT_ECHO:
		/* Only one side is allowed to echo */
		if(myopts[TELOPT_ECHO]) {
			fmt = dont;
			break;
		}
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_lflag &= ~(ECHO|ECHOE|ECHOK);
		b.c_oflag &= ~ONLCR;
		b.c_iflag &= ~ICRNL;
		ioctl(pty,TCSETA,&b);
#else
		mode(0, ECHO|CRMOD);
#endif /* USG */
		/*FALL THRU*/

	case TELOPT_SGA:
	case TELOPT_EXOPL:
common:
		hisopts[option] = 1;
	case TELOPT_STATUS:
		fmt = doopt;
		break;

	case TELOPT_TM:
		fmt = dont;
		break;

	default:
		fmt = dont;
		break;
	}
	sprintf(nfrontp, fmt, option);
	nfrontp += sizeof (dont) - 2;
	if(option == TELOPT_STATUS) {
		strcpy(nfrontp,StatusSend);
		nfrontp += strlen(StatusSend);
	}
}

wontoption(option)
	int option;
{
	char *fmt;
#ifdef USG
	struct termio b;
#endif /* USG */

	switch (option) {

	case TELOPT_ECHO:
#ifdef notdef
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_oflag |= ONLCR;
		b.c_iflag |= ICRNL;
		b.c_lflag |= ICANON|ECHO|ECHOE|ECHOK;
		ioctl(pty,TCSETA,&b);
#else
		mode(ECHO|CRMOD, 0);
#endif /* USG */
#endif /* notdef */
		goto common;

	case TELOPT_BINARY:
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_lflag |= ICANON|ISIG|ECHO|ECHOE|ECHOK;
		b.c_cc[VEOF] = defeot;
		ioctl(pty,TCSETA,&b);
#else
		mode(0, RAW);
#endif /* USG */
		/*FALL THRU*/

	case TELOPT_SGA:
	case TELOPT_EXOPL:
common:
		hisopts[option] = 0;
		fmt = dont;
		break;

	default:
		fmt = dont;
	}
	sprintf(nfrontp, fmt, option);
	nfrontp += sizeof (doopt) - 2;
}

dooption(option)
	int option;
{
	char *fmt;
#ifdef USG
	struct termio b;
#endif /* USG */

	switch (option) {

	case TELOPT_TM:
		fmt = wont;
		break;

	case TELOPT_ECHO:
		/* Only one side is allowed to echo */
		if(hisopts[option]) {
			fmt = wont;
			break;
		}
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_oflag |= ONLCR;
		b.c_iflag |= ICRNL;
		b.c_lflag |= ICANON|ECHO|ECHOE|ECHOK;
		ioctl(pty,TCSETA,&b);
#else
		mode(ECHO|CRMOD, 0);
#endif /* USG */
		goto common;

	case TELOPT_BINARY:
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_cc[VMIN] = 1;
		b.c_cc[VTIME] = -1;
		b.c_lflag &= ~ICANON;
		ioctl(pty,TCSETA,&b);
#else
		mode(RAW, 0);
#endif /* USG */
		/*FALL THRU*/

	case TELOPT_SGA:
	case TELOPT_EXOPL:
common:
		myopts[option] = 1;
	case TELOPT_STATUS:
		myopts[option] = 1;
		fmt = will;
		break;

	default:
		fmt = wont;
		break;
	}
	sprintf(nfrontp, fmt, option);
	nfrontp += sizeof (doopt) - 2;
}

dontoption(option)
	int option;
{
	char *fmt;
#ifdef USG
	struct termio b;
#endif /* USG */

	switch (option) {

	case TELOPT_ECHO:
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_lflag &= ~(ECHO|ECHOE|ECHOK);
/*
		b.c_oflag &= ~ONLCR;
		b.c_iflag &= ~ICRNL;
*/
		ioctl(pty,TCSETA,&b);
#else
		mode(0, ECHO|CRMOD);
#endif /* USG */
		goto common;

	case TELOPT_BINARY:
#ifdef USG
		ioctl(pty,TCGETA,&b);
		b.c_lflag |= ICANON|ISIG|ECHO|ECHOE|ECHOK;
		b.c_cc[VEOF] = defeot;
		ioctl(pty,TCSETA,&b);
#else
		mode(0, RAW);
#endif /* USG */
		/*FALL THRU*/

	case TELOPT_SGA:
	case TELOPT_EXOPL:
	case TELOPT_STATUS:

common:
		myopts[option] = 0;
	case TELOPT_TM:
	default:
		fmt = wont;
		break;
	}
	sprintf(nfrontp, fmt, option);
	nfrontp += sizeof (doopt) - 2;
}

sendstatus()
{
	register int n;

	*nfrontp++ = IAC;
	*nfrontp++ = SB;
	*nfrontp++ = TELOPT_STATUS;
	*nfrontp++ = IS;
	for(n=0; n<256; n++) {
		if(myopts[n]) {
			*nfrontp++ = WILL;
			*nfrontp++ = n;
		}
		if(hisopts[n]) {
			*nfrontp++ = DO;
			*nfrontp++ = n;
		}
	}
	*nfrontp++ = IAC;
	*nfrontp++ = SE;
}


#ifndef USG
mode(on, off)
	int on, off;
{
	struct sgttyb b;

	ptyflush();
	ioctl(pty, TIOCGETP, &b);
	b.sg_flags |= on;
	b.sg_flags &= ~off;
	ioctl(pty, TIOCSETP, &b);
}
#endif /*USG */

/*
 * Send interrupt to process on other side of pty.
 * If it is in raw mode, just write NULL;
 * otherwise, write intr char.
 */
interrupt()
{
#ifdef USG	
	struct termio b;
#else
	struct sgttyb b;
	struct tchars tchars;
#endif /* USG */

	ptyflush();	/* half-hearted */
#ifdef USG
	ioctl(pty,TCGETA,&b);
	if ((b.c_lflag & ICANON)==0){
		*pfrontp++ = '\0';
		return ;
	}
	*pfrontp++ = b.c_cc[VINTR];
#else
	ioctl(pty, TIOCGETP, &b);
	if (b.sg_flags & RAW) {
		*pfrontp++ = '\0';
		return;
	}
	*pfrontp++ = ioctl(pty, TIOCGETC, &tchars) < 0 ?
		'\177' : tchars.t_intrc;
#endif /* USG */
}

ptyflush()
{
	int n;

try_again:
	if ((n = pfrontp - pbackp) > 0)
		n = write(pty, pbackp, n);
	if ( n >= 0 ) {
		pbackp += n;
		if (pbackp == pfrontp)
			pbackp = pfrontp = ptyobuf;
	} else if (errno == EINTR)
		goto try_again;
	return;
}

netflush()
{
	int n;
	int flags = 0;

try_again:
	if ((n = nfrontp - nbackp) > 0){
		flags = 0;
		n = t_snd(net, nbackp, n,flags);
	}
	if ( n >= 0 ) {
		nbackp += n;
		if (nbackp == nfrontp)
			nbackp = nfrontp = netobuf;
		return;
	}
	if ( t_errno == TFLOW ||
	     ( t_errno == TSYSERR &&
		(errno == EAGAIN||errno == EWOULDBLOCK||errno == EINTR))) {
			goto try_again;
	}
	/* should blow this guy away... */
#ifdef USG
	ConPrint("telnetd: write error %d\n",errno);
	cleanup();
#else
	return;
#endif /* USG */
}

cleanup()
{
	int val;
	int status;

	rmut();
#ifdef BSD
	vhangup();	/* XXX */
#endif /* BSD */
	(void) t_rcvrel(net);
	(void) t_sndrel(net);
/* TWU This is not necessary 04/29/91
	kill(0, SIGHUP);
*/
/* TWU should killed all the process which having the same group id as child
   instead of myself  04/29/91
	kill(-getpid(), SIGHUP);
*/
	kill(-pid, SIGHUP);
	while ((val = wait(&status)) != pid) {
		if ( val < 0 && errno != EINTR)
			break;
	}
	exit(1);
}


struct	utmp wtmp;

#ifdef SYSTEM5
char	wtmpf[]	= WTMP_FILE;
char	utmpf[] = UTMP_FILE;
#else
char	wtmpf[]	= "/usr/adm/wtmp";
char	utmp[] = "/etc/utmp";
#endif /* SYSTEM5 */

#define SCPYN(a, b)	strncpy(a, b, sizeof (a))
#define SCMPN(a, b)	strncmp(a, b, sizeof (a))

rmut()
{
	register f;
	int found = 0;

	f = open(utmpf, O_RDWR );
	if (f >= 0) {
		while(read(f, (char *)&wtmp, sizeof (wtmp)) == sizeof (wtmp)) {
#if defined(SYSTEM5) && !defined(ARIX)
			if (strncmp(wtmp.ut_line, line+5,5) || wtmp.ut_name[0]==0)
#else
			if (SCMPN(wtmp.ut_line, line+5) || wtmp.ut_name[0]==0)
#endif /* SYSTEM5 */
				continue;
			lseek(f, -(long)sizeof (wtmp), 1);
			SCPYN(wtmp.ut_name, "");
#ifdef BSD
			SCPYN(wtmp.ut_host, "");
#endif /* BSD */
			time(&wtmp.ut_time);
#ifdef SYSTEM5
/* TWU 04/29/91  Change type to INIT_PROCESS. This make utmp work 
			wtmp.ut_type = EMPTY;
*/
			wtmp.ut_type = INIT_PROCESS;
#endif /* SYSTEM5 */
			write(f, (char *)&wtmp, sizeof (wtmp));
			found++;
		}
		close(f);
	}
	if (found) {
		f = open(wtmpf, O_WRONLY );
		if (f >= 0) {
			SCPYN(wtmp.ut_line, line+5);
			SCPYN(wtmp.ut_name, "");
#ifdef BSD
			SCPYN(wtmp.ut_host, "");
#endif /* BSD */
			time(&wtmp.ut_time);
			lseek(f, (long)0, 2);
			write(f, (char *)&wtmp, sizeof (wtmp));
			close(f);
		}
	}
	chmod(line, 0666);
	chown(line, 0, 0);
	line[strlen("/dev/")] = 'p';
	chmod(line, 0666);
	chown(line, 0, 0);
}

/* VARARGS */
ConPrint(fmt,a1,a2,a3,a4)
	char *fmt;
{
	FILE *f1;

	if ((f1 = fopen("/dev/console","w"))==NULL)
		return;
	fprintf(f1,fmt,a1,a2,a3,a4);
	fclose(f1);
}

/* TWU 05/13/91 */
void
childok()
{
	childready = 1;
	(void) signal(SIGUSR1, SIG_DFL);
}

