#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)rfsaddr.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 *  @(#) Copyright (c) 1988  The Wollongong Group, Inc.  All Rights Reserved
 */

/*
 *  Purpose:  To produce an address in the format required by AT&T's Network 
 *  	      Listener Service and RFS.
 *
 *  Inputs:  (1) Internet host name or alias, from command line or stdin.
 *	     (2) Optional TCP port number, from command line only.  Default 
 *	     value is 1025 (lowest unprivileged port).
 *
 *  Outputs: (1) NLS/RFS-formatted address on stdout.
 *	     (2) Exit values:  -1 for errors, +1 for successful completion.
 *
 *  Author:  Patrick Snyder, 11 February 1988.
 */

#include <stdio.h>
#include <sys/types.h>
#include "netdb.h"
#include "sys/in.h"
#include "sys/socket.h"

/* diagnostic messages */
#define USAGE 		"usage:  rfsaddr [-h hostname] [-p portno]\n"
#define NOHOST 		"rfsaddr:  hostname required\n"
#define NOADDR 		"rfsaddr:  unable to retrieve address of host %s\n"
#define NOCONV		"rfsaddr:  unable to convert address to ascii\n"
#define BADTYPE		"rfsaddr:  non-Internet addresses not supported\n"
#define BADPTNO		"rfsaddr:  invalid port number\n"

/* miscellaneous constants */
#define DEFAULTPORTNO 	"1025"	/* lowest unprivileged port number */
#define MINPORTNO 	1025
#define MAXPORTNO	65535	/* since port number is an unsigned short */
#define ADDRLEN 	5	/* length of IP addr + 1 */
#define ARGLEN 		100	/* arbitrary length for opt arg buffer */

extern struct hostent 	*_gethtbyname();
extern struct in_addr 	*inet_addr();
extern char		*inet_ntoa();

main(argc, argv)
	int argc;
	char **argv;
{
	/* for command line arguments */
	int c;
	extern char	*optarg;
	extern int	optind, opterr;

	/* for internet address data */
	char 		*hostname = NULL, *portstr = NULL;
	ushort		portnum;
	struct hostent 	*hp;	
	struct in_addr   ia;
	char		*asciiaddr;

	/* for printing parts of internet address */
	int 		looplimit, j, i, addrpart;
	char 		buf[ADDRLEN];

	/* ============================================== */

	/* process optional args */
	while	((c = getopt(argc, argv, "h:p:")) != -1)
		switch (c) {
		case 'h':
			hostname = optarg;
			break;
		case 'p':
			portstr = optarg;
			break;
		default:
			/* tilt!  illegal usage */
			(void) fprintf(stderr, USAGE);
			exit(1);
	}

	/* make sure we have hostname */
	if (hostname == NULL) {
		/* get hostname from stdin */
	 	int n, i;
		char argbuf[ARGLEN];  /* buffer for name from stdin */
		hostname = argbuf;  
		argbuf[0] = NULL;
		n = scanf("%s", hostname);
		if (n != 1 || *hostname == NULL) {
			(void) fprintf(stderr, NOHOST);
			exit(1);
		}
	}

	/* make a good port number, unless we're handed bad input */
	if (portstr == NULL) 
		portstr = DEFAULTPORTNO;
	else
		if (portstr[0] == '-' ||
		   (atoi(portstr) < MINPORTNO || atoi(portstr) > MAXPORTNO)) {
			fprintf(stderr, BADPTNO);
			exit(1);
	}
	portnum = (ushort) atoi(portstr);

	/* get the Internet address */
	if ((hp = _gethtbyname(hostname)) <= NULL) {
		fprintf(stderr, NOADDR, hostname);
		exit(1);
	}

	/* reject non-internet address types */
	if (hp->h_addrtype != AF_INET) {
		fprintf(stderr, BADTYPE);
		exit(1);
	}

	/* convert address to ascii */
	ia.s_addr = *((ulong *)hp->h_addr);
	if ((asciiaddr = inet_ntoa(ia)) < 0)  {
		(void) fprintf(stderr, NOCONV);
		exit(1);
	}

	/* output address in AT&T format */
	printf("\\x%04x%04x", hp->h_addrtype, portnum);
	looplimit = strlen(asciiaddr);
	j = 0;
	for (i = 0; i <= looplimit; i++) {
		if (asciiaddr[i] != '\.' && asciiaddr[i] != '\0') 
			buf[j++] = asciiaddr[i];
		else {
			buf[j] = '\0';
			addrpart = atoi(buf);
			printf("%02x", addrpart);
			buf[0] = '\0';
			j = 0;  /* reinitialize buf index */
		}
	}
	printf("\n\n");

	/* bye bye */
	exit(0);
}
