#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)rexecd.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 *   @(#) Copyright (c) 1985  The Wollongong Group, Inc.  All Rights Reserved
 */
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/in.h>
#ifdef T_TLI
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/tiuser.h>
#include <sys/ip.h>
#include <sys/tcp.h>
#include <sys/fcntl.h>
#endif /* T_TLI */
#include <stdio.h>
#include <errno.h>
#include <pwd.h>
/* #include <sys/wait.h> */
#include <signal.h>
#include <netdb.h>

extern int	errno;

int Parent, Child;
struct	sockaddr_in sin ;
struct	passwd *shgetpwnam();
int pv[2], neterr, readfrom, pid;
char	*index(), *rindex() /*, *sprintf() */;
int	options;
int sig_poll();
/* VARARGS 1 */
int	error();
#define trace(x,y)


char	username[20] = "USER=";
char	logname[20] = "LOGNAME=";
char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
char	*envinit[] =
	    {homedir, shell, "PATH=:/usr/ucb:/bin:/usr/bin:/usr/lbin", 
		logname, username, 0};
extern char	**environ;

/*
 * remote execute server:
 *	username\0
 *	password\0
 *	command\0
 *	data
 */
main(argc,argv)
int argc;
char *argv[];
{
#ifdef NOTCPLISTNER
	int s;
	struct servent *sp;
	struct sockaddr_in sin;
	int lostconn();

	if((sp = getservbyname("exec","tcp")) == 0) {
		fprintf(stderr,"rexecd: tcp/exec: unknown service\r\n");
		exit(1);
	}
	sin.sin_port = sp->s_port;
	signal(SIGPIPE,lostconn);
#ifndef DEBUG
	if (fork())
		exit(0);
	for (s = 0; s < 10; s++)
		(void) close(s);
	(void) open("/", 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
	setpgrp();
#endif
	if((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("rexecd: socket");;
		exit(1);
	}
	if (bind(s, (caddr_t)&sin, sizeof (sin), 0) < 0) {
		perror("rexecd: bind");
		exit(1);
	}
#ifndef V7
	signal(SIGCHLD,SIG_IGN); /* The Zombies will then go away */
#endif /* V7 */
	listen(s, 10);
	for (;;) {
		struct sockaddr_in from;
		int s2, fromlen = sizeof (from);
		int pid;

		s2 = accept(s, (caddr_t)&from, &fromlen);
		if (s2 < 0) {
			if (errno == EINTR)
				continue;
			perror("rexecd: accept");
			sleep(1);
			continue;
		}
		if ((pid = fork()) < 0)
			printf("Out of processes\r\n");
		else if (pid == 0) {
			dup2(s2,0); dup2(0,1); dup2(0,2);
			signal(SIGCHLD, SIG_DFL);
			rexecd(&from);
			exit(0);
		}
		close(s2);
#ifdef V7
		reapchild();
#endif /* V7 */
	}
#else	/* NOTCPLISTNER */
	struct sockaddr_in from;
	int fromlen = sizeof (from);

	/* -ac should get the peer name not local name
	if (getsockname(0, &from, &fromlen) < 0) {	*/
	if (getpeername(0, &from, &fromlen) < 0) {
		error("getpeername fail");
		exit(1);
	}
	rexecd(&from);
#endif /* NOTCPLISTNER */
}
#ifdef V7
sigalrm()
{}
reapchild(){
	signal(SIGALRM,sigalrm);
	alarm(2);
	while(wait(0) > 0)
		;	/* Extract Zombies */
	alarm(0);
}
#endif /* V7 */

rexecd(from)
struct sockaddr_in *from;
{
	char cmdbuf[NCARGS+1], *cp;
	char user[16], pass[16];
	struct passwd *pwd;
	int s;
	struct hostent *hp;
	short port;
	int   ready,  cc;
	char *xpasswd;
	char buf[BUFSIZ], sig;
	int one = 1;

	(void) signal(SIGINT, SIG_DFL);
	(void) signal(SIGQUIT, SIG_DFL);
	(void) signal(SIGTERM, SIG_DFL);

	(void) alarm(60);
	port = 0;
	for (;;) {
		char c;
		if (read(0, &c, 1) != 1) {
			exit(1);
		}
		if (c == 0)
			break;
		port = port * 10 + c - '0';
	}
	(void) alarm(0);
	if (port != 0) {
#ifndef T_TLI
		if((s = socket(AF_INET, SOCK_STREAM, 0, 0)) < 0)
#else
		struct t_call scall, *sndcall = &scall;

		if ((s = t_open(DEV_TCP, O_RDWR, 0)) < 0)
#endif /* T_TLI */
		{
			error("unable to open stderr connection\n");
			exit(1);
		}
		(void) alarm(60);
		from->sin_port = htons((u_short)port);
#ifndef T_TLI
		if (connect(s, from, sizeof (*from), 0) < 0) {
			error("unable to establish stderr connection\n");
			exit(1);
		}
#else /* T_TLI */
		if(t_bind(s,0,0) < 0) {
			error("Can't Bind");
			exit(1);
		}
		sndcall->addr.buf = (char *)from;
		/* -ac The len is not for binding
		sndcall->addr.len = TCP_BINDADDRLEN;	*/
		sndcall->addr.len = sizeof(*from);
		sndcall->udata.len = sndcall->opt.len = 0;
		if (t_connect(s, sndcall, 0) < 0) {
			error("Unable to establish stderr connection");
			exit(2);
		}
#endif /* T_TLI */
		(void) alarm(0);
		dup2(s,2);
		close(s);
		/* -ac establish and syncronize stderr channal */
		neterr = 2;
		t_sync(neterr);
	}
	getstr(user, sizeof(user), "username");
	getstr(pass, sizeof(pass), "password");
	getstr(cmdbuf, sizeof(cmdbuf), "command");
	setpwent();
	pwd = shgetpwnam(user);
	endpwent();
	if (pwd == NULL || passwdrequired(user) == 0){
		error("Login incorrect.\n");
		exit(1);
	}
	if (useraccess(user) == 0 || passwdok(user, pass) == 0) {
		error("Login incorrect.\n");
		exit(1);
	}
	if (chdir(pwd->pw_dir) < 0) {
		error("No remote directory.\n");
		exit(1);
	}
	(void) write(2, "\0", 1);

	/* -ac  signal handling code */
	if (port) {
		int cleanup();
		if (pipe(pv) < 0) {
			error("Can't make pipe.\n");
			exit(1);
		}
		signal (SIGCLD, cleanup);
		pid = fork();
		if (pid == -1)  {
			error("Try again.\n");
			exit(1);
		}
		if (pid) {
			extern exit();
			int cleanup();
			/*
			 * Read From Pipe and write to the
			 * network.
			 */
			(void) close(0); (void) close(1);
			(void) close(pv[1]);
			readfrom =  (1<<neterr) | (1<<pv[0]);
			signal(SIGCLD, cleanup);
			Parent = getpid();
#ifdef TWO_PROCS
			/*
			 * If the shell process dies
			 * Then we can kill off the child
			 */
			Child = fork();
			if (Child < 0){
				error("No more processes\n");
				exit(1);
			}
			if (Child == 0){
				trace("Child reading from net.\n",0);
				sig_poll(SIGPOLL);
				kill(Parent, SIGKILL);
				exit(1);
			}
			(void)t_close(neterr);
			(void)setpgrp();/* We don't want to be kill */
#else
			t_sync(neterr);
			fcntl(neterr, F_SETFL, (O_NDELAY| fcntl(neterr,F_GETFL,0)));
			sigset(SIGPOLL, sig_poll);
			ioctl(neterr, I_SETSIG, S_INPUT);
			sig_poll(SIGPOLL);/* Pretend we just got a signal */
#endif /* TWO_PROCS */
			do {
				int cc1;
				errno = 0;
				if (readfrom & (1<<pv[0])) {
					errno = 0;
					try_read:
					cc = read(pv[0], buf, sizeof (buf));
					trace("read %d from pipe\n",cc);
					if (cc < 0 && errno == EINTR)
						goto try_read;
					if (cc <= 0) {
						(void)t_sndrel(neterr);
						sleep(1);
#ifdef TWO_PROCS
						exit(1);
#else
						readfrom &= ~(1<<pv[0]);
#endif
					} else 
					{
							cc1 = t_snd(neterr,
								 buf, cc, 0);
					}
				}
				/*
				 * If network error is set pause.
				 */
				else  if (readfrom & (1<<neterr)){
					exit (0); /* Is this OK ??? */
				}
				else break;
			} while (readfrom);
  			kill(0,15);
			_nolinger_tclose(neterr);
			exit(0);
		}
		(void) t_close(neterr);(void) close(pv[0]);
		dup2(pv[1], 2);
		close(pv[1]);
		fcntl(2, F_SETFL, (O_NDELAY| fcntl(2,F_GETFL,0)));
		t_sync(0);
		t_sync(1);
	}

	if (!pwd->pw_shell || (*pwd->pw_shell == '\0'))
		pwd->pw_shell = "/bin/sh";
#ifdef BSD42
	setegid(pwd->pw_gid);
	seteuid(pwd->pw_uid);
	initgroups(pwd->pw_name, pwd->pw_gid);
#else
	setuid(pwd->pw_uid);
	setgid(pwd->pw_gid);
#endif /* BSD42 */
	environ = envinit;
	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	strncat(shell, pwd->pw_shell, sizeof(shell)-7);
	strncat(username, pwd->pw_name, sizeof(username)-6);
	strncat(logname, pwd->pw_name, sizeof(username)-8);
	cp = rindex(pwd->pw_shell, '/');
	if (cp)
		cp++;
	else
		cp = pwd->pw_shell;
	execlp(pwd->pw_shell, cp, "-c", cmdbuf, 0);
	perror(pwd->pw_shell);
	exit(1);

	/* -ac  replaced by the above code
	if (fork() == 0) {
		execlp(pwd->pw_shell, cp, "-c", cmdbuf, 0);
		perror(pwd->pw_shell);
		exit(1);
	}
#ifndef T_TLI
	wait(&s);
#endif /* T_TLI *
	exit(0);
	*/
}

/* VARARGS 1 */
error(fmt)
	char *fmt;
{
	char buf[BUFSIZ];

	buf[0] = 1;
	(void) sprintf(buf+1, fmt);
	(void) write(2, buf, strlen(buf));
}

getstr(buf, cnt, err)
	char *buf;
	int cnt;
	char *err;
{
	char c;

	do {
		if (read(0, &c, 1) != 1)
			exit(1);
		*buf++ = c;
		if (--cnt == 0) {
			error("%s too long\n", err);
			exit(1);
		}
	} while (c != 0);
}
lostconn()
{
	_exit();
}

void
perror(msg)
char *msg;
{
	FILE *fp;
	extern errno;
	extern char *sys_errlist[];
	
	if((fp = fopen("/dev/console","w"))==NULL)
		return;
	fprintf(fp,"%s: %s\r\n",msg,sys_errlist[errno]);
	fclose(fp);
}

sig_poll(sig)
{
	register int cc;
	unsigned char sig;
	int flags;
	extern t_errno;

	sighold(SIGPOLL);

	for(;readfrom & (1<<neterr);){
		cc = t_rcv(neterr, &sig, 1, &flags);
		if (cc < 0 && t_errno == TNODATA)
			break;
		else
		 if (cc <= 0) {
			/*
			 * Turn off the neterr bit.
			 * The other end will come out of the pause
			 * and exit.
			 */
			_nolinger_tclose(neterr);
			readfrom &= ~(1<<neterr);
			break;
		}
 		if (kill(-Parent, sig) < 0 ) {
  			cc = kill(pid, sig);
		}
	}
#ifdef TWO_PROCS
	exit(0);
#endif
	sigrelse(SIGPOLL);
}

cleanup()
{
	char buf [1000];
	register int cnt;

	fcntl (pv[0], F_SETFL, O_NDELAY);
#ifdef TWO_PROCS
	kill(Child, SIGKILL);
	exit(0);
#endif /* TWO_PROCS */
	for (;;){
		cnt = read(pv[0],buf,sizeof(buf));
		if (cnt == 0) return;
		if (cnt <  0 && errno == EINTR)
			continue;
		if (cnt < 0) {
			(void)t_sndrel(neterr);
			readfrom &= ~(1 << neterr);
			return;
		}
		else 
			(void)t_snd(neterr,buf,cnt,0);
	}
}
