#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)namedsigs.c (TWG)  1.2     89/08/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 *  @(#) Copyright (c) 1985  The Wollongong Group, Inc.  All Rights Reserved
 */

#include <stdio.h>
#include <errno.h>
#include <signal.h>

#ifdef PIDFILE 				/* file to store current named PID */
char	*PidFile = PIDFILE;
#else
char	*PidFile = "/etc/named.pid";	
#endif

#ifdef SERVER_NAME                     /* The command to exec the server. */
char *server_name = SERVER_NAME
#else
char *server_name = "/usr/etc/named";
#endif

#define NRST 1                        /* Set to re-run /etc/named */

extern int errno;

struct nrec {
  char *nr_name;
  int  nr_sig;
  int  nr_flag;
};

#define NCMDS 8
struct nrec ncmds[NCMDS] = { { "named.kill", SIGKILL, 0 },
	      { "named.debug", SIGUSR1, 0 },
	      { "named.restart", SIGKILL, NRST },
	      { "named.undebug", SIGUSR2, 0 },
	      { "named.dump", SIGINT, 0 },
	      { "named.reload", SIGHUP, 0 },
	      { "named.stats", SIGIOT, 0 },
	      { "\0", 0, 0 }
		      };

main(argc,argv)
int argc; char **argv;
{
	char	buf[20];
	int	fd, i, n, sig = 0, nrst = 0;
	char *ar = *argv; 
	char *arx = *argv;
	struct nrec *nrp ;

	while (*ar++) {
	  if (*ar == '/') { arx = ar; arx++; }
	}
	if (arx) {
	  for (nrp = ncmds; nrp->nr_name ; nrp++) {
	    if (!strcmp(arx, nrp->nr_name )) {
	      sig = nrp->nr_sig;
	      nrst = nrp->nr_flag;
	      break;
	    }
	  }
	}
	if (!arx || !nrp->nr_name) {
	    printf("This must be invoked as one of:");
	    for (nrp = ncmds, i = 0; nrp->nr_name ; nrp++, i++) {
	       if (!(i % 3)) printf("\n");
	       printf("\t%s",nrp->nr_name);
	    }
	    printf("\n");
	    exit(1);
	}

	if ((fd = open(PidFile, 0)) < 0 ||
	    (n = read(fd, buf, sizeof(buf)-1)) < 0) {
		perror(PidFile);
		exit(1);
	}
	(void) close(fd);
	if (n == 0) {
		fprintf(stderr, "%s is empty.\n", PidFile);
		exit(1);
	}
	buf[sizeof(buf)-1] = 0;
	if ((n = atoi(buf)) <= 1) {
		fprintf(stderr, "Bad pid value in %s (%d)\n", PidFile, n);
		exit(1);
	}
#ifdef DEBUG
	fprintf(stderr, "Found nameserver (pid %d): ", n);
#endif

	if (kill(n, sig) < 0) {
		switch (errno) {
		case ESRCH:
			fprintf(stderr, "the nameserver is dead.\n");
			break;
		default:
			perror("signal");
			break;
		}
		if (!nrst) exit(1);
	}
	if (nrst) {
#ifdef DEBUG
	   printf("Starting %s.\n", server_name);
#endif
	   if (!fork()) {
	       execl(server_name,server_name,0);
	   }
	} 
#ifdef DEBUG
	else {
	   fprintf(stderr, "OK\n");
	}
#endif
	exit(0);
}
