/*
 *  @(#) Copyright (c) 1988  The Wollongong Group, Inc.  All Rights Reserved
 */

#ident "@(#)ftpd.c (TWG)  1.4     89/08/03 "

/*
 * FTP server.
 */
#include <sys/types.h>
#include <fcntl.h>
#define MAXPATHLEN	128
#define getwd(path)	getcwd(path,MAXPATHLEN)

#include <sys/param.h>
#include <sys/stat.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/poll.h>
#include <sys/ip.h>
#include <sys/tcp.h>	/* Pull in TCP_BINDADDRLEN */
#include <sys/inetioctl.h>
#include <sys/file.h>

#include <sys/in.h>

#include <arpa/ftp.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <sys/dir.h>
#include <dirent.h>
#include <tiuser.h>
#include <signal.h>
#include <pwd.h>
#include <setjmp.h>
#include <netdb.h>
#include <errno.h>
#include "comdef.h"
#ifdef SECURITY
#include <auth.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/security.h>
#include <sys/audit.h>
#endif  /* SECURITY */

#include <utmp.h>
int wtmp;

/*
 * File containing login names
 * NOT to be used on this machine.
 * Commonly used to disallow uucp.
 */
#define	FTPUSERS	"/etc/ftpusers"

/* Comment out the following statement to put trace info into FTPDLOG. */
#define Trace(a, b, c) {}
#define FTPDLOG		"/tmp/ftpdlog"

extern	int errno;
extern	char *globerr;
extern	char *sys_errlist[];
/*extern	char *crypt();		**Replaced by userok(), etc. */
extern	char version[];
extern	char *home;		/* pointer to home directory for glob */
extern	FILE *popen(), *fopen();
extern	int pclose(), fclose();
extern	int t_errno;
extern	char *t_errlist[];

struct	sockaddr_in ctrl_addr;
struct	sockaddr_in data_source;
struct	sockaddr_in data_dest;
struct	sockaddr_in his_addr;

struct	hostent *hp;

int	data;
jmp_buf	errcatch;
int	logged_in;
struct	passwd *pw;
int	debug;
int 	command = 0;
int	timeout;
int	logging;
int	guest;
int	type;
int	form;
int	stru;			/* avoid C keyword */
int	mode;
int	usedefault = 1;		/* for data transfers */
char	hostname[32];
char	remotehost[32];
struct	servent *sp;
char	*getcwd();
jmp_buf lostdata;
int	tclose();

/*
 * Timeout intervals for retrying connections
 * to hosts that don't accept PORT cmds.  This
 * is a kludge, but given the problems with TCP...
 */
#define	SWAITMAX	10	/* wait at most 10 seconds */
#define	SWAITINT	5	/* interval between retries */

int	swaitmax = SWAITMAX;
int	swaitint = SWAITINT;

int	lostconn();
int	lostdataconn();
int	getdatasock();
int	dataconn();

static 	FILE *fp;
int	fd;
time_t t;
struct stat stb;
static	char savename[128];

main(argc, argv)
int argc;
char *argv[];
{
	int ctrl, s, options = 0;
	char *cp;
	int sizeofaddr;

	ctrl = 0;
	sizeofaddr = sizeof (his_addr);
	getpeername(0, &his_addr, &sizeofaddr);
	his_addr.sin_family = AF_INET;

	hp = gethostbyaddr(&his_addr.sin_addr,
		sizeof (struct in_addr), his_addr.sin_family);
	if (hp)
		strcpy(remotehost, hp->h_name);
	else	sprintf(remotehost, "%d.%d.%d.%d",
			((char *)&his_addr.sin_addr)[0],
			((char *)&his_addr.sin_addr)[0],
			((char *)&his_addr.sin_addr)[2],
			((char *)&his_addr.sin_addr)[3]);

	if (stat(FTPDLOG, &stb)   == 0 && 
	   (stb.st_mode & S_IFMT) == S_IFREG) {
		fp = fopen(FTPDLOG,"a+");
		if (fp != NULL) {
			fd = fileno(fp);
			lockf(fd,1,0);
			t = time(0);
			if (hp) 
				fprintf(fp,"FTPD: connection from %s at %s",
					hp->h_name, ctime(&t));
			else {
				unchar *ucp;
				char host[4];

				ucp = (unchar *)&his_addr.sin_addr.s_addr;
				sprintf(host, "%u.%u.%u.%u", ucp[0], 
					ucp[1], ucp[2], ucp[3]);
				fprintf(fp,"FTPD: connection from %s at %s",
					host, ctime(&t));
			}
			fflush(fp);
			lockf(fd,0,0);
			fclose(fp);
		}
	}

	logged_in = 0;
	data = -1;
	type = TYPE_A;
	form = FORM_N;
	stru = STRU_F;
	mode = MODE_S;
	sizeofaddr = sizeof(ctrl_addr);
	if (getsockname(0, &ctrl_addr, &sizeofaddr) < 0) {
		fprintf(stderr, "ftpd: getsockname failure");
		exit(1);
	}
	gethostname(hostname, sizeof (hostname));
	reply(220, "%s FTP server (%s) ready.",
		hostname, version);

	for (;;) {
		setjmp(errcatch);
		yyparse();
	}

}	/* end of main() */

lostconn()
{
	if (debug)
		fprintf(stderr, "Lost connection.\n");
	_exit(-1);

}	/* end of lostconn() */
  
/*
 * Helper function for sgetpwnam().
 */
char *
sgetsave(s)
	char *s;
{
#ifdef notdef
	char *new = strdup(s);
#else
	char *malloc();
	char *new = malloc((unsigned) strlen(s) + 1);
#endif
	
	if (new == NULL) {
		reply(553, "Local resource failure");	/* ??? */
		dologout(1);
	}
#ifndef notdef
	(void) strcpy(new, s);
#endif
	return (new);
}

/*
 * Save the result of a getpwnam.  Used for USER command, since
 * the data returned must not be clobbered by any other command
 * (e.g., globbing).
 */
struct passwd *
sgetpwnam(name)
	char *name;
{
	static struct passwd save;
	register struct passwd *p;
	char *sgetsave();
	extern struct passwd *getpwnam();

	if (!useraccess(name, "ftp"))
		return (NULL);
	if ((p = getpwnam(name)) == NULL)
		return (p);
	if (save.pw_name) {
		free(save.pw_name);
		free(save.pw_passwd);
		free(save.pw_comment);
		free(save.pw_gecos);
		free(save.pw_dir);
		free(save.pw_shell);
	}
	save = *p;
	save.pw_name = sgetsave(p->pw_name);
	save.pw_passwd = sgetsave(p->pw_passwd);
	save.pw_comment = sgetsave(p->pw_comment);
	save.pw_gecos = sgetsave(p->pw_gecos);
	save.pw_dir = sgetsave(p->pw_dir);
	save.pw_shell = sgetsave(p->pw_shell);
	return (&save);
}

pass(passwd)
	char *passwd;
{

	if ( pw == NULL ){
		reply(503, "Login failed.");
		return;
	}
	if ( logged_in ){
		reply(503, "Already Logged in.");
		return;
	}
	if (!guest) {		/* "ftp" is only account allowed no password */
		if ( pw->pw_passwd && *pw->pw_passwd){
			if (passwdok(pw->pw_name, passwd) == NULL) {
				reply(503, "Login failed.");
				pw = NULL;
				return;
			}
		}
		/** begining of code for checking null passwd entry **/

		else if (passwdrequired(pw->pw_name)) {
			reply(503,"Logins not allowed with null passwd.");
			pw = NULL;
			return;
		}
		/** ending of code for checking null passwd entry **/
	}
	if (chdir(pw->pw_dir)) {
		reply(550, "User %s: can't change directory to %s.",
			pw->pw_name, pw->pw_dir);
		goto bad;
	}
	wtmp = open(WTMP_FILE, O_WRONLY|O_APPEND);
	if (guest && chroot(pw->pw_dir) < 0) {
		reply(550, "Can't set guest privileges.");
		if (wtmp >= 0) {
			(void) close(wtmp);
			wtmp = -1;
		}
		goto bad;
	}
	if (!guest)
		reply(230, "User %s logged in.", pw->pw_name);
	else
		reply(230, "Guest login ok, access restrictions apply.");
	logged_in = 1;
	audit(pw->pw_name, 0);
	dologin(pw);

	if (setgid(pw->pw_gid) < 0) {
		fatal("setgid failure.");
	}
	if (setuid(pw->pw_uid) < 0) {
		fatal("setuid failure.");
	}
	home = pw->pw_dir;		/* home dir for globbing */
	return;
bad:
	pw = NULL;

}	/* end of pass() */

static int (*closefunc)();
retrieve(cmd, name)
	char *cmd, *name;
{
	FILE *fin;
	struct stat st;
	int (*oldsig)();
	int result;

	savename[0] = '\0';

	if (cmd == 0) {
		if(!globulize(&name))
			return;
#ifdef notdef
		/* no remote command execution -- it's a security hole */
		if (*name == '|')
			fin = popen(name + 1, "r"), closefunc = pclose;
		else
#endif
			fin = fopen(name, "r"), closefunc = fclose;
	} else {
		static char line[BUFSIZ];

		sprintf(line, cmd, name), name = line;
		fin = popen(line, "r"), closefunc = pclose;
	}
	if (fin == NULL) {
		if (errno != 0) {
		     if (savename[0] != '\0')
			reply(550, "%s: %s.", savename, sys_errlist[errno]);
		     else if (command == RETR)
			reply(550, "%s: %s.", name, sys_errlist[errno]);
		     else
			reply(451, "%s: %s.", name, sys_errlist[errno]);
		}
		return;
	}
	st.st_size = 0;
	if (cmd == 0 &&
	    (stat(name, &st) < 0 || (st.st_mode&S_IFMT) != S_IFREG)) {
		reply(550, "%s: not a plain file.", name);
		goto done;
	}
	data = dataconn(name, st.st_size);
	if (data == -1)
		goto done;

	oldsig = (int (*)())signal(SIGPIPE, lostdataconn);
	if(setjmp(lostdata)) {
	     if (command == RETR)
		reply(550, "%s", sys_errlist[ECONNRESET]);
	     else
		reply(451, "%s", sys_errlist[ECONNRESET]);
	}
	else
		if ((result = send_data(fin, data)) < 0) {
		     if (command == RETR)
			if (result == -1)
			    reply(550, "%s: %s.", name, sys_errlist[errno]);
			else
			    reply(550, "%s: %s.", name, t_errlist[t_errno]);
		     else
			if (result == -1)
			    reply(451, "%s: %s.", name, sys_errlist[errno]);
			else
			    reply(451, "%s: %s.", name, t_errlist[t_errno]);

		     /* since we have an error goto done & close data stream */
		     (void) signal(SIGPIPE, oldsig);
		     goto done;
		}
		else
			reply(226, "Transfer complete.");

	Trace("ftpd: done sending data..\n", 0, 0);
	(void) signal(SIGPIPE, oldsig);

done:
	(void)(*closefunc)(fin);
	if (data != -1) {
		t_close(data);
	}
	data = -1;

}	/* end of retrieve() */

lostdataconn()
{
	longjmp(lostdata, 1);
}

store(name, mode)
	char *name, *mode;
{
	FILE *fout;
	int dochown = 0;
	int result;

	if(!globulize(&name))
		return;
#ifdef notdef
	/* no remote command execution -- it's a security hole */
	if (name[0] == '|')
		fout = popen(&name[1], "w"), closefunc = pclose;
	else
#endif
	{
		struct stat st;

		if (stat(name, &st) < 0)
			dochown++;
		fout = fopen(name, mode), closefunc = fclose;
	}
	if (fout == NULL) {
	     if (command == APPE)
		reply(550, "%s: %s.", name, sys_errlist[errno]);
	     else
		reply(553, "%s: %s.", name, sys_errlist[errno]);
		return;
	}
	data = dataconn(name, (off_t)-1);
	if (data == -1)
		goto done;
	Trace("ftpd: din setup receiving data..\n", 0, 0);

	if ((result = receive_data(data, fout)) < 0) {
	     if (command == APPE)
		if (result == -1)
			reply(550, "%s: %s.", name, sys_errlist[errno]);
		else
			reply(550, "%s: %s.", name, t_errlist[t_errno]);
	     else
		if (result = -1)
			reply(553, "%s: %s.", name, sys_errlist[errno]);
		else
			reply(553, "%s: %s.", name, t_errlist[t_errno]);

	     goto done;
	}
	else
		reply(226, "Transfer complete.");
	Trace("ftpd: received data.. sending release..\n",0, 0);

done:
	if (dochown)
		(void) chown(name, pw->pw_uid, pw->pw_gid);
	(*closefunc)(fout);
	t_close(data);
/*	_nolinger_tclose(data);*/
	data = -1;

}	/* end of store() */

getdatasock()
{
	int s, on = 1;
	int dlen = sizeof(data_source);
	struct t_bind req;

	sp = getservbyname("ftp", "tcp");
	if (sp == 0) {
		return(-1);
	}

	if((s = t_open(DEV_TCP, O_RDWR, 0)) < 0) {
		return (s);
	}

	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on)))
	    Trace("FTPD: setsockop failed\n",0,0);

	/* anchor socket to avoid multi-homing problems */
	bzero((char *)&data_source, sizeof(data_source));
	data_source.sin_addr = ctrl_addr.sin_addr;
	req.addr.buf = (char *)&data_source;
	req.addr.len = TCP_BINDADDRLEN;
	req.qlen = 0;
	data_source.sin_port = htons(ntohs(sp->s_port) - 1); /*always port 20*/

	if (t_bind(s, (caddr_t)&req , 0) < 0) {
	    Trace("FTPD: Bind fails errno=%d t_errno=%d\n",errno,t_errno);
		goto bad;
	    }
	if (getsockname(s, &data_source, &dlen) < 0)
		goto bad;

	Trace("ftpd: data(%x.%d)\n",
		 data_source.sin_addr.s_addr, data_source.sin_port);

	return (s);
bad:
	(void)t_close(s);
	return (-1);

}	/* end of getdatasock() */

dataconn(name, size)
	char *name;
	off_t size;
{
	char sizebuf[32];
	int retry = 0;
	struct t_call scall,  *sndcall = &scall;
	struct strioctl ioc;
	int result;

	if (size >= 0)
		sprintf (sizebuf, " (%ld bytes)", size);
	else
		(void) strcpy(sizebuf, "");
	if (data >= 0) {
		reply(125, "Using existing data connection for %s%s.",
		    name, sizebuf);
		usedefault = 1;
		return (data);
	}
	if (usedefault)
		data_dest = his_addr;
	usedefault = 1;

	data = getdatasock();
	if (data < 0) {
		reply(425, "Data socket not created (%s,%u).",
		    inet_ntoa(data_source.sin_addr),
		    ntohs((ushort) data_source.sin_port));
		return (data);
	}

	reply(150, "Opening data connection for %s (%s,%u)%s.",
	    name, inet_ntoa(data_dest.sin_addr.s_addr),
	    ntohs((ushort) data_dest.sin_port), sizebuf);
	sndcall->addr.buf = (char *)&data_dest;
	sndcall->addr.len = TCP_BINDADDRLEN;
	sndcall->udata.len = sndcall->opt.len = 0;

	while ((result = t_connect(data, sndcall, 0)) < 0) {

		if (retry < swaitmax) {
			sleep(swaitint);
			retry += swaitint;
			continue;
		}

		reply(425, "Can't build data connection: %s.",
		    t_errlist[t_errno]);
		tclose();	/* close the stream */
		data = -1;
		return (data);
	}

	Trace("ftpd: connected to %x\n", data_dest.sin_addr, 0);
	return (data);

}	/* end of dataconn() */

/*
 * Tranfer the contents of "instr" to
 * "outstr" peer using the appropriate
 * encapulation of the date subject
 * to Mode, Structure, and Type.
 *
 * NB: Form isn't handled.
 */
send_data(instr, netfd)
	FILE *instr;
	int netfd;
{
	register int c;
	int filefd, cnt;
	char buf[BUFSIZ*8];
	register char *cp;

	filefd = fileno(instr);

#define Xputc(c) { if (cp >= (buf+sizeof(buf))) { \
			if (t_snd(netfd, buf, cp-buf, 0) < 0) { \
				if (t_errno == TSYSERR) \
					return(-1); \
				else \
					return(-2); \
			} \
		cp = buf;} *cp++ = c; \
		}

	switch (type) {

	case TYPE_A:
		cp = buf;
		while ((c = getc(instr)) != EOF) {
			if (c == '\n') {
				Xputc('\r');
				/* putc('\r', outstr); */
			}
			Xputc(c);
			/* putc(c, outstr); */
			if (c == '\r'){
				Xputc(0);
				/* putc ('\0', outstr); */
			}
		}

		if (cp != buf) {
			if (t_snd(netfd, buf, cp-buf, 0) < 0) {
				if (t_errno == TSYSERR)
					return(-1);
				else
					return(-2);
			}
		}
		if (ferror (instr))
			return (-1);
		return (0);
		
	case TYPE_I:
	case TYPE_L:

		while ((cnt = read(filefd, buf, sizeof (buf))) > 0) {
			int nsent;

			nsent = 0;
			send_again:
			if ((nsent = t_snd(netfd, buf + nsent, cnt, 0)) < 0)
				if (t_errno == TSYSERR)
					return (-1);
				else
					return (-2);
			if (nsent < cnt) {
				cnt -= nsent;
				goto send_again;
			}
		}

		if (cnt < 0)
			return (-1);
		else
			return (0);

	}
	reply(504,"Unimplemented TYPE %d in send_data", type);
	return (-1);

}	/* end of send_data() */

/*
 * Transfer data from peer to
 * "outstr" using the appropriate
 * encapulation of the data subject
 * to Mode, Structure, and Type.
 *
 * N.B.: Form isn't handled.
 */
receive_data(netfd, outstr)
	int netfd;
	FILE *outstr;
{
	register int c;
	int cnt;
	register char *cp;
	int flags;
	unsigned char buf[BUFSIZ*8];


	switch (type) {

	case TYPE_I:
	case TYPE_L:
		while ((cnt = t_rcv(netfd, buf, sizeof(buf), &flags)) > 0){
			Trace("ftpd: got %d bytes from net %d\n", cnt, 0);
			if (write(fileno(outstr), buf, cnt) < 0)
				return (-1);
		}
		Trace("ftpd: done receiving I type..\n", 0, 0);

		/*
		 * t_rcv will return -1 upon recieving
		 * T_ORDREL_IND.
		 */
		if (cnt < 0 && t_errno == TLOOK) {
			if (t_look(data) == T_ORDREL)
				return 0;	/* EOF */
			else
				return (-2);
		}
		else
			return (-2);	/* unexpected error */

	case TYPE_E:
		reply(451, "TYPE E not implemented.");
		return (-1);

	case TYPE_A:
		while ((cnt = t_rcv(netfd, buf, sizeof(buf), &flags)) > 0){
			cp = (char *)buf;
			while (cnt-- > 0){
				c = *cp++;
				if (c == '\r') {
					if (ferror (outstr))
						return (-1);
					if (cnt == 0) {
						cnt = t_rcv(netfd,
						  buf, sizeof(buf), &flags);
						if (cnt <= 0){
							putc(c, outstr);
							break;
						}
						cp = (char *)buf;
					}
					cnt-- ;
					if ((c = *cp++) != '\n')
						putc ('\r', outstr);
					if (c == '\0')
						continue;
				}
				putc (c, outstr);
			}
		}

		/*
		 * Check for Orderly release.
		 */
		if (cnt < 0 && t_errno == TLOOK) {
			if (t_look(data) == T_ORDREL)
				return 0;	/* EOF */
			else
				return (-2);
		}

		if (ferror(outstr))
			return (-1);

		return (-2);	/* unexpected error */

	}	/* end of switch */

	fatal("Unknown type in receive_data.");
	/*NOTREACHED*/

}	/* end of receive_data() */

fatal(s)
	char *s;
{
	reply(451, "Error in server: %s\n", s);
	reply(221, "Closing connection due to server error.");
	_exit(0);

}	/* end of fatal() */

reply(n, s, args)
	int n;
	char *s;
{
	printf("%d ", n);
	_doprnt(s, &args, stdout);
	printf("\r\n");
	fflush(stdout);
	if (debug) {
		fprintf(stderr, "<--- %d ", n);
		_doprnt(s, &args, stderr);
		fprintf(stderr, "\n");
		fflush(stderr);
	}
}	/* end of reply() */

lreply(n, s, args)
	int n;
	char *s;
{
	printf("%d-", n);
	_doprnt(s, &args, stdout);
	printf("\r\n");
	fflush(stdout);
	if (debug) {
		fprintf(stderr, "<--- %d-", n);
		_doprnt(s, &args, stderr);
		fprintf(stderr, "\n");
	}
}	/* end of lreply() */

replystr(s)
	char *s;
{
	printf("%s\r\n", s);
	fflush(stdout);
	if (debug)
		fprintf(stderr, "<--- %s\n", s);

}	/* end of replystr() */

ack(s)
	char *s;
{
	switch(command) {
	case (XMKD):
		reply(257, "%s command okay.", s);
		break;

	case (PORT):
	case (ALLO):
	case (NOOP):
		reply(200, "%s command okay.", s);
		break;

	default:
		reply(250, "%s command okay.", s);
		break;

	}
}	/* end of ack() */

nack(s)
	char *s;
{
	reply(502, "%s command not implemented.", s);

}	/* end of nack() */

delete(name)
	char *name;
{
	struct stat st;

	if(!globulize(&name))
		return;
	if (stat(name, &st) < 0) {
		reply(550, "%s: %s.", name, sys_errlist[errno]);
		return;
	}
	if ((st.st_mode&S_IFMT) == S_IFDIR) {
		reply(550, "%s: is a directory.", name);
		return;
	}
	if (unlink(name) < 0) {
		reply(550, "%s: %s.", name, sys_errlist[errno]);
		return;
	}
done:
	ack("DELE");

}	/* end of delete() */

cwd(path)
	char *path;
{

	if(!globulize(&path))
		return;
	if (chdir(path) < 0) {
		reply(550, "%s: %s.", path, sys_errlist[errno]);
		return;
	}
	ack("CWD");

}	/* end of cwd() */

makedir(name)
	char *name;
{
	struct stat st;
	int dochown = stat(name, &st) < 0;
	if(!globulize(&name))
		return;
	if (mkdir(name, 0777) < 0) {
		reply(550, "%s: %s.", name, sys_errlist[errno]);
		return;
	}
	if (dochown)
		(void) chown(name, pw->pw_uid, pw->pw_gid);
	ack("MKDIR");

}	/* end of makedir() */

removedir(name)
	char *name;
{
	if(!globulize(&name))
		return;
	if (rmdir(name) < 0) {
		reply(550, "%s: %s.", name, sys_errlist[errno]);
		return;
	}
	ack("RMDIR");

}	/* end of removedir() */

pwd()
{
	char path[MAXPATHLEN + 1];

	FILE *popen();
	FILE *p;
	register char *ptr = path;
	register int c;

	p = popen("/bin/pwd","r");
	if ( p==NULL) {
		reply(451,"/bin/pwd: %s", sys_errlist[errno]);
		return;
	}
	while((c=getc(p)) != EOF) {
		if(c == '\n') break;
		*ptr++ = c;
	}
	*ptr = '\0';
	pclose(p);
	reply(257, "\"%s\" is current directory.", path);

}	/* end of pwd() */

char *
renamefrom(name)
	char *name;
{
	struct stat st;

	if(!globulize(&name))
		return ((char *)0);
	if (stat(name, &st) < 0) {
		reply(550, "%s: %s.", name, sys_errlist[errno]);
		return ((char *)0);
	}
	reply(350, "File exists, ready for destination name");
	return (name);

}	/* end of renamefrom() */

renamecmd(from, to)
	char *from, *to;
{

	if(!globulize(&to))
		return;
	if (rename(from, to) < 0) {
		reply(553, "rename: %s.", sys_errlist[errno]);
		return;
	}
	ack("RNTO");

}	/* end of renamecmd() */


#define	SCPYN(a, b)	strncpy(a, b, sizeof (a))
struct	utmp utmp;

/*
 * Record login in wtmp file.
 */
dologin(p)
	struct passwd *p;
{
	char line[32];

	if (wtmp >= 0) {
		/* hack, but must be unique and no tty line */
		sprintf(line, "ftp%d", getpid());
		SCPYN(utmp.ut_line, line);
		SCPYN(utmp.ut_name, p->pw_name);
		utmp.ut_type = USER_PROCESS;
		utmp.ut_time = time(0);
		(void) write(wtmp, (char *)&utmp, sizeof (utmp));
		if (!guest) {
			(void) close(wtmp);
			wtmp = -1;
		}
	}

}	/* end of dologin() */

/*
 * Record logout in wtmp file
 * and exit with supplied status.
 */
dologout(status)
	int status;
{
	int wtmp;

	if (!logged_in)
		_exit(status);
#ifdef BSD
	seteuid(0);
	wtmp = open(WTMP_FILE, O_WRONLY|O_APPEND);
	if (wtmp >= 0) {
		SCPYN(utmp.ut_name, "");
		SCPYN(utmp.ut_host, "");
		utmp.ut_time = time(0);
		(void) write(wtmp, (char *)&utmp, sizeof (utmp));
		(void) close(wtmp);
	}
#endif /* BSD */
	/* beware of flushing buffers after a SIGPIPE */
	_exit(status);

}	/* end of dologout() */

/*
 * Special version of popen which avoids
 * call to shell.  This insures no one may 
 * create a pipe to a hidden program as a side
 * effect of a list or dir command.
 */
#define	tst(a,b)	(*mode == 'r'? (b) : (a))
#define	RDR	0
#define	WTR	1
static	int popen_pid[21];

static char *
nextarg(cpp)
	char *cpp;
{
	register char *cp = cpp;

	if (cp == 0)
		return (cp);
	while (*cp && *cp != ' ' && *cp != '\t')
		cp++;
	if (*cp == ' ' || *cp == '\t') {
		*cp++ = '\0';
		while (*cp == ' ' || *cp == '\t')
			cp++;
	}
	if (cp == cpp)
		return ((char *)0);
	return (cp);

}	/* end of nextarg() */

#define	N_ARGS		20	/* number of args in "cmd" */
#define N_GARGS		512	/* Number of globbed args */

#define	NAMESIZE	DIRSIZ+3

FILE *
popen(cmd, mode)
	char *cmd, *mode;
{
	int p[2], ac, gac;
	register int acc;
	register myside, hisside, pid;
	char *av[N_ARGS+1], *gav[N_GARGS+1];	/* Need an extra one for NULL */
	register char *cp;
	struct stat status;
	char dirfile[NAMESIZE];
	FILE *fptemp = NULL;
	char s[MAXPATHLEN];

	cp = cmd, ac = 0;
	/* break up string into pieces */
	do {
		av[ac++] = cp;
		cp = nextarg(cp);
	} while (cp && *cp && ac < N_ARGS);
	av[ac] = (char *)0;
	gav[0] = av[0];
	/* glob each piece */
	for (acc = gac = ac = 1; av[ac] != NULL; ac++) {
		char **pop;
		extern char **glob();

		pop = glob(av[ac]);
		if (pop) {
			av[acc++] = (char *)pop;	/* save to free later */
			while (*pop && gac < N_GARGS)
				gav[gac++] = *pop++;
		}
	}
	av[acc] = NULL;
	gav[gac] = (char *)0;

	/* if file doesn't exist then return NULL */
	strcpy(savename, gav[gac-1]);
	if ((strncmp("/bin/ls", gav[0], 7) == 0) && (savename[0] != '\0')
				&& (savename[0] != '-') && (gac == 2)) {
		closefunc = fclose;
		if (stat(savename, &status) < 0) {
			fptemp = NULL;
			goto done;
		} else {
			strcpy(dirfile, "/tmp/ftpd1XXXXXX");
			mktemp(dirfile);
			if ((fptemp = fopen(dirfile, "w+")) == NULL)
				goto done;

			if ((stat(gav[1], &status) == 0)
				    && ((status.st_mode & S_IFMT) != S_IFDIR)) {
				fprintf(fptemp, "%s\n", gav[1]);
			} else {
				strcpy(s, "");
				if (checkdir(gav[1], fptemp, s) < 0) {
					fclose(fptemp);
					fptemp = NULL;
					goto done;
				}
			}
			rewind(fptemp);
			goto done;
		}
	}

	if (pipe(p) < 0) {
		fptemp = NULL;
		goto done;
	}

	myside = tst(p[WTR], p[RDR]);
	hisside = tst(p[RDR], p[WTR]);

	if ((pid = fork()) == 0) {
		/* myside and hisside reverse roles in child */
		close(0); close(1); close(2);
		close(myside);
		dup2(hisside, tst(0, 1));
		close(hisside);
		execv(gav[0], gav);
		_exit(1);
	}
	for (ac = 1; av[ac] != NULL; ac++) {
		blkfree((char **)av[ac]);
		free(av[ac]);
	}
	if (pid == -1) {
		close(hisside);
		return (NULL);
	}
	popen_pid[myside] = pid;
	close(hisside);
	return (fdopen(myside, mode));

done:
	/* we can remove dirfile even though caller may still read from it */
	if (stat(dirfile, &status) == 0)
		unlink(dirfile);

	for (ac = 1; av[ac] != NULL; ac++) {
		blkfree((char **)av[ac]);
		free(av[ac]);
	}
	return(fptemp);

}	/* end of popen() */


static int
checkdir(filename, fp, s)
	char *filename;
	FILE *fp;
	char *s;
{
	struct stat st;
	DIR *dirp;
	struct dirent *ent;
	char fname[128];

	dirp = NULL;

	if ((dirp = opendir(filename)) != NULL) {

		while ((ent = readdir(dirp)) != NULL) {
			if ((strcmp(ent->d_name,".") == 0) ||
					(strcmp(ent->d_name,"..") == 0)) {
				continue;
			}
			strcpy(s, filename);
			strcat(s, "/");
			strcat(s, ent->d_name);
			fprintf(fp, "%s\n", s);
		}

		closedir(dirp);
		return(0);
	}
	return(-1);

}	/* end of checkdir() */


pclose(ptr)
	FILE *ptr;
{
	register f, r, (*hstat)(), (*istat)(), (*qstat)();
	int status;

	f = fileno(ptr);
	fclose(ptr);
	istat = (int (*)())signal(SIGINT, SIG_IGN);
	qstat = (int (*)())signal(SIGQUIT, SIG_IGN);
	hstat = (int (*)())signal(SIGHUP, SIG_IGN);
	while ((r = wait(&status)) != popen_pid[f] && r != -1)
		;
	if (r == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	signal(SIGHUP, hstat);
	return (status);

}	/* end of pclose() */

/*
 * Check user requesting login priviledges.
 * Disallow anyone mentioned in the file FTPUSERS
 * to allow people such as uucp to be avoided.
 */
checkuser(name)
	register char *name;
{
	char line[BUFSIZ], *index();
	FILE *fd;
	struct passwd *p;
	int found = 0;
	extern struct passwd *shgetpwnam();

	p = shgetpwnam(name);
	if (p == NULL)
		return (0);
	
	fd = fopen(FTPUSERS, "r");
	if (fd == NULL)
		return (1);
	while (fgets(line, sizeof (line), fd) != NULL) {
		register char *cp = index(line, '\n');

		if (cp)
			*cp = '\0';
		if (strcmp(line, name) == 0) {
			found++;
			break;
		}
	}
	fclose(fd);
	return (!found);

}	/* end of checkuser() */
/*
 * Glob a local file name specification with
 * the expectation of a single return value.
 * Return a error if multiple values are expanded
 * from the expression.
 */
globulize(cpp)
	char **cpp;
{
	char **globbed;
	extern char **glob();

	globbed = glob(*cpp);
	if (globerr != NULL) {
		if (globbed)
		{
			blkfree(globbed);
			free(globbed);
		}
		switch(command) {

			case LIST:
			case NLST:	
				reply(501, "%s: %s.", *cpp, globerr);
				break;

			case STOR:
			case RNTO:
				reply(553, "%s: %s.", *cpp, globerr);
				break;

			default:
				reply(550, "%s: %s.", *cpp, globerr);
				break;

			}
		return (0);
	}
	if (globbed && *globbed) {
		if(*(globbed+1)) {
			blkfree(globbed);
			free(globbed);
			reply(550, "%s: Not unique.", *cpp);
			return(0);
		}
		*cpp = *globbed;
		return (1);
	}
	reply(550, "%s: %s.", *cpp, sys_errlist[ENOENT]);
	return(0);

}	/* end of globulize() */

#ifndef Trace
Trace(fmt,a, b)
{
	FILE *fp;
	fp = fopen("/tmp/ftpdlog", "a");
	if (fp){
		fprintf(fp, fmt, a, b);
		fclose(fp);
	}
}	/* end of Trace() */
#endif /* Trace */

tclose()
{
	if (data != -1) {
		/* fcntl(data, F_SETFL, O_NDELAY); */
		t_close(data);
		data = -1;
	}
}	/* end of tclose() */

/* write audit record */
audit(uname, mode)
char *uname;
int mode;
{	
#ifdef SECURITY
	sat_login_t buf;

	buf.flag = LOGIN_ID;
	if ( mode )
		buf.flag |= LOGIN_FAIL;
	buf.mode = mode;
	buf.tty = 0;
	strcpy( buf.uname, uname, DIRSIZ ); 
	if ( audit_add_event( AUD_LOGIN, &buf, sizeof( sat_login_t )) < 0 )
		if ( errno != ENOSYS )
			fprintf( stderr, "login: can't write audit record\n" );
#endif	/* SECURITY */
}
