#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)fingerd.c (TWG)  1.3     89/07/19 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * This finger Daemon It recieves a connection
 * made by tcplisten. It's stdin and stdout are set up.
 * Fires up the finger programs.
 */

#include	<sys/types.h>
#include	<sys/inet.h>
#include 	<sys/stream.h>
#include 	<sys/stropts.h>
#include	<sys/ip.h>
#include	<sys/tcp.h>
#include	<sys/inetioctl.h>
#include	<signal.h>
#include	<stdio.h>
#include	<sys/socket.h>
#include	<errno.h>
#include	<sys/in.h>
#include	<netdb.h>
#include	<tiuser.h>
extern  errno;

main(argc,argv)
int argc;
char *argv[];
{
	char arg[256];
	char *Argv[3];
	int Argc;
	char  *cp;
	int c;
#ifdef NOTCPLISTENER
	int s, pid, options;
	struct servent *sp;
	struct sockaddr_in sin;
	int lostconn();
	struct strioctl ioc;
	struct	t_bind req;

	if((sp = getservbyname("finger","tcp")) == 0) {
		fprintf(stderr,"fingerd: tcp/finger: unknown service\r\n");
		exit(1);
	}

	sin.sin_port = sp->s_port;
	sin.sin_family = AF_INET;
	signal(SIGPIPE,lostconn);
	options = 0;
	argc--, argv++;
	if (argc > 0) {
		sin.sin_port = atoi(*argv);
		if (sin.sin_port <= 0) {
			fprintf(stderr, "fingerd: %s: bad port #\r\n", *argv);
			exit(1);
		}
		sin.sin_port = htons(sin.sin_port);
	}
#ifndef DEBUG
	if (fork())
		exit(0);
	for (s = 0; s < 10; s++)
		(void) close(s);
	(void) open("/dev/console", 2);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
	setpgrp();
#endif
	s = t_open(DEV_TCP, 2, 0);
	if (s < 0) {
		t_error("fingerd: t_open");
		exit(1);
	}
	req.addr.buf = (char *)&sin;
	req.addr.len = TCP_BINDADDRLEN;
	req.qlen = 5;
	if (t_bind(s, (caddr_t)&req, 0) < 0) {
		t_error("t_bind");
		exit(1);
	}
#ifndef V7
	signal(SIGCHLD,SIG_IGN); /* The Zombies will then go away */
#endif /* V7 */
	for (;;) {
		struct sockaddr_in from;
		int s2, fromlen = sizeof (from);
		struct t_call *scall;

		if((scall = (struct t_call *)t_alloc(s, T_CALL, T_ADDR)) < 0) {
			t_error("t_alloc");
			exit(1);
		}
		if(t_listen(s,scall) < 0) {
			t_error("t_listen");
			exit(1);
		}
		bcopy(scall->addr, (char *)&from, sizeof(from));
		/*
		 * Let the child process accept the
		 * Connection.
		 */
		if((s2 = t_open(DEV_TCP, 2, 0)) < 0) {
			t_error("t_open2");
			continue;
		}
		/*
		 * The TLI Spec's tell that the second
		 * endpoint must be bound ( BARF..).
		 */
		if (t_bind(s2, 0, 0) < 0){
			t_error("t_bind");
			t_close(s2);
			continue;
		}
		if (t_accept(s, s2, scall) < 0) {
			t_error("t_accept");
			t_close(s2);
			continue;
		}

		if ((pid = fork()) < 0)
			printf("Out of processes\n");
		else if (pid == 0) {

#ifndef notdef
			/*
			 * POP the TIMOD module form the path
			 * and push in the TIRDWR module.
			 */
			if (ioctl(s2, I_POP, 0) < 0){
				perror("I_POP");
				exit(1);
			}
			if (ioctl(s2, I_PUSH, "tirdwr") < 0){
				perror("I_PUSH");
				exit(1);
			}
			ioc.ic_cmd = TCPIOC_LINGER;
			ioc.ic_timout = 60;
			ioc.ic_len = 0;
			ioc.ic_dp = (char *) 0;
			if (ioctl(s2, I_STR, &ioc) < 0){
				perror("TCPIOC_LINGER Failed");
				exit(1);
			}
#else /* notdef */
			/*
			 * Set this to read write
			 */
			if (tcp_rdwr(s2) < 0){
				perror("RDWR-TCP");
				exit(1);
			}
#endif	/* notdef */
			dup2(s2,0); dup2(0,1); dup2(0,2);
			signal(SIGCHLD, SIG_DFL);
#else /* NOTCPLISTENER */

#ifdef notdef
			ioc.ic_cmd = TCPIOC_LINGER;
			ioc.ic_timout = 60;
			ioc.ic_len = 0;
			ioc.ic_dp = (char *) 0;
			if (ioctl(0, I_STR, &ioc) < 0){
				perror("TCPIOC_LINGER Failed");
				exit(1);
			}
#endif /* notdef */
#endif /* NOTCPLISTENER */
			Argv[0] = "finger";
			Argv[1] = 0;
			Argv[2] = 0;
			cp = arg;
			while((c = getc(stdin)) != -1) {
				if( c == '\r') {
					*cp = 0; break;
				}
				*cp++ = c;
			}
			if(arg[0] !=0) {Argc = 2; Argv[1] = arg;}
			else Argc = 1;
			if (fork() == 0) {
				execv("/usr/bin/finger",Argv);
				execv("/usr/ucb/finger",Argv);
				execv("/usr/lbin/finger",Argv);
				execvp("finger",Argv);
			
				Fprint("fingerd: Can't Exec finger\n");
				fprintf(stderr,"Can't Exec Finger\n");
			}
			else  /* parent */
				wait(0);
			exit(0);
#ifdef NOTCPLISTENER
		}
		t_sndrel(s2);
		t_close(s2);
#ifdef V7
		reapchild();
#endif /* V7 */
	}
#endif /* NOTCPLISTENER */
	/*NOTREACHED*/
}

#ifdef V7
sigalrm()
{}
reapchild(){
	signal(SIGALRM,sigalrm);
	alarm(2);
	while(wait(0) > 0)
		;	/* Extract Zombies */
	alarm(0);
}
#endif /* V7 */

lostconn()
{
	_exit();
}
void
perror(msg)
char *msg;
{
	FILE *fp;
	extern errno;
	extern char *sys_errlist[];
	
	if((fp = fopen("/dev/console","a+"))==NULL)
		return;
	fprintf(fp,"fingerd: %s\r\n",sys_errlist[errno]);
	fclose(fp);
}
Fprint(fmt,a1,a2,a3,a4)
char *fmt;
{
	FILE *fp;
	
	if((fp = fopen("/dev/console","a+"))==NULL)
		return;
	fprintf(fp,fmt, a1, a2, a3, a4);
	fclose(fp);
}
