#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)telnet.c (TWG)  1.3     89/09/20 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * User telnet program.
 */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <setjmp.h>
#include <termio.h>
#include <tiuser.h>
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/fcntl.h>

#include <netdb.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/in.h>
#include <sys/ip.h>

#define	TELOPTS
#define	TELCMDS
#include <arpa/telnet.h>

#define	strip(x)	((x)&0177)

char	ttyobuf[BUFSIZ], *tfrontp = ttyobuf, *tbackp = ttyobuf;
char	netobuf[BUFSIZ], *nfrontp = netobuf, *nbackp = netobuf;

unsigned char sibuf[BUFSIZ], *sbp;
unsigned char tibuf[BUFSIZ], *tbp;
int scc,tcc;
char Current_Char = 0;	/* For 2 Escapes in a row to be transmitted */ 

#define DO_DONT		1
#define WILL_WONT	2

char	hisopts[256];
char	myopts[256];
char	needreply[256];

char	doopt[] = { IAC, DO, '%', 'c', 0 };
char	dont[] = { IAC, DONT, '%', 'c', 0 };
char	will[] = { IAC, WILL, '%', 'c', 0 };
char	wont[] = { IAC, WONT, '%', 'c', 0 };
static unsigned char StatusSend[] = { IAC,SB,TELOPT_STATUS,SEND,IAC,SE };

int	connected;
int	net;
int	showoptions = 0;
int	options;
int	crmod = 0;
int	dmflag = 0;
char	*prompt;
char	escape = '~';
char	flushline = 1;
char	enbline = 0;
char 	nolocecho = 0;

char	line[200];
int	margc;
char	*margv[20];

jmp_buf	toplevel;
jmp_buf	peerdied;

extern	int errno, t_errno;

int	tn(), quit(), suspend(), bye(), help();
int	setescape(), status(), toggle(), setoptions();
int	setcrmod(), transnvt(), setlinemod();
int	negotiate(), noecho();

#define HELPINDENT (sizeof ("negotiate"))

struct cmd {
	char	*name;		/* command name */
	char	*Help;		/* help string */
	int	(*handler)();	/* routine which executes command */
};

char	openhelp[] =	"connect to a site";
char	closehelp[] =	"close current connection";
char	quithelp[] =	"exit telnet";
char	zhelp[] =	"suspend telnet (Local Shell- System 5)";
char	escapehelp[] =	"set escape character";
char	statushelp[] =	"print status information";
char	helphelp[] =	"print help information";
char	optionshelp[] =	"toggle viewing of options processing";
char	crmodhelp[] =	"toggle mapping of received carriage returns";
char	nvthelp[] =	"transmit NVT control functions";
char	linehelp[] =	"toggle line mode function ";
char	echohelp[] =	"toggle local echo ";
char	negohelp[] =	"negotiate telnet options";

struct cmd cmdtab[] = {
	{ "open",	openhelp,	tn },
	{ "close",	closehelp,	bye },
	{ "quit",	quithelp,	quit },
	{ "z",		zhelp,		suspend },
	{ "escape",	escapehelp,	setescape },
	{ "status",	statushelp,	status },
	{ "transnvt",	nvthelp,	transnvt },
	{ "options",	optionshelp,	setoptions },
	{ "crmod",	crmodhelp,	setcrmod },
	{ "linemode",	linehelp,	setlinemod },
	{ "localecho",  echohelp,	noecho },
	{ "negotiate",	negohelp,	negotiate },
	{ "?",		helphelp,	help },
	0
};


struct telopt {
	char *optname;
	char option;
	char *helP;
};

struct telopt iaclist[] = {
	{ "ao", AO, "transmit Abort output" },
	{ "ayt", AYT, "transmit Are You There" },
	{ "brk", BREAK, "transmit Break" },
	{ "ec", EC, "transmit Erase Character" },
	{ "el", EL, "transmit Erase Line" },
	{ "dm", DM, "transmit Data Mark (SYNCH)" },
	{ "ip", IP, "transmit Interrupt Process" },
	{ "nop", NOP, "transmit Nop" },
	{ "?", 0, "print help information on NVT formats" },
	0 
};

struct sockaddr_in sin;

int	intr(), deadpeer();
char	*control();
struct	cmd *getcmd();
struct	servent *sp;

struct termio ottyb;
struct termio noterm;


main(argc, argv)
int argc;
char *argv[];
{
	sp = getservbyname("telnet", "tcp");
	if (sp == 0) {
		fprintf(stderr, "telnet: tcp/telnet: unknown service\n");
		exit(1);
	}
	ioctl(0,TCGETA,&ottyb);
	noterm = ottyb;
	setbuf(stdin, 0);
	setbuf(stdout, 0);
	prompt = argv[0];
	if (argc != 1) {
		if (setjmp(toplevel) != 0)
			exit(0);
		tn(argc, argv);
	} 
	setjmp(toplevel);
	for (;;)
		command(1);
}

char	*hostname;
char	hnamebuf[32];
int	net_fd;

tn(argc, argv)
int argc;
char *argv[];
{
	register int c;
	register struct hostent *host;
	struct t_call scall,  *sndcall = &scall;

	if (connected) {
		printf("?Already connected to %s\n", hostname);
		return;
	}
	if (argc < 2) {
		strcpy(line, "Connect ");
		printf("(to) ");
		gets(&line[strlen(line)]);
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc > 3) {
		printf("usage: %s host-name [port]\n", argv[0]);
		return;
	}
	host = gethostbyname(argv[1]);
	if (host) {
		sin.sin_family = host->h_addrtype;
		bcopy(host->h_addr, (caddr_t)&sin.sin_addr, host->h_length);
		hostname = host->h_name;
	} else {
		sin.sin_family = AF_INET;
		sin.sin_addr.s_addr = inet_addr(argv[1]);
		if (sin.sin_addr.s_addr == -1) {
			printf("%s: invalid address\n", argv[1]);
			return;
		}
		strcpy(hnamebuf, argv[1]);
		hostname = hnamebuf;
	}
	sin.sin_port = sp->s_port;
	if (argc == 3) {
		if (isdigit(argv[2][0]))
			sin.sin_port = atoi(argv[2]);
		else {
			sp = getservbyname(argv[2], "tcp");
			if (sp)
				sin.sin_port = sp->s_port;
			else {
				printf("%s: bad port value\n",argv[2]);
				return;
			}
		}
		if (sin.sin_port < 0) {
			printf("%s: bad port value\n", argv[2]);
			return;
		}
		sin.sin_port = htons(sin.sin_port);
	}
	if((net = t_open(DEV_TCP,O_RDWR,0)) < 0) {
		WIN_error("t_open");
		return;
	}
	if(t_bind(net,0,0) < 0) {
		WIN_error("t_bind");
		return;
	}
	signal(SIGINT, intr);
	signal(SIGPIPE, deadpeer);
	printf("Trying %s...",inet_ntoa(sin.sin_addr));
	fflush(stdout);
	sndcall->addr.buf = (char *)&sin;
	sndcall->addr.len = sizeof sin;
	sndcall->udata.len = sndcall->opt.len = 0;
	if (t_connect(net, sndcall, 0) < 0) {
	        errno &= 0xff;
		if (t_errno == TBADADDR) {
			t_errno = TSYSERR;
			errno = ENETUNREACH;
		}
		WIN_error("t_connect");
		signal(SIGINT, SIG_DFL);
		return;
	}
#ifdef notdef
	/*
	 * POP the TIMOD module and put the tirdwr
	 */
	if (ioctl(net, I_POP, 0) < 0){
		perror("I_POP");
		Closeit(net);
		return;
	}
	if (ioctl(net, I_PUSH, "tirdwr") < 0){
		perror("I_PUSH");
		Closeit(net);
		return;
	}
#endif
	fcntl(net, F_SETFL, O_NDELAY); /* non Blocking I/O */
	connected++;
	call(status, "status", 0);
	if (setjmp(peerdied) == 0)
		telnet(net);
	bye();
	fflush(stdout);fflush(stderr);
	fprintf(stderr, "Connection closed by foreign host.\n");
	ioctl(fileno(stdin),TCSETAW,&ottyb);
	signal(SIGINT, SIG_DFL);
	longjmp(toplevel,1);
}

/*
 * Print status about the connection.
 */
/*VARARGS*/
status()
{
	register opt, first=1;

	if (connected)
		printf("Connected to %s.\n", hostname);
	else
		printf("No connection.\n");
	for(opt=0;opt<256;opt++) {
		if(!myopts[opt])
			continue;
		if(first) {
			printf("local telnet options in effect:\n");
			first=0;
		}
		if(opt <= TELOPT_SUPDUP)
			printf("\tWILL %s\n",telopts[opt]);
		else 
			printf("\tWILL %d\n",opt);
	}
	if( enbline )
		fprintf(stderr,"Line mode is enabled.\n");
	else
		fprintf(stderr,"Character mode is enabled.\n");
	fprintf(stderr,"Escape character is '%s'.\n", control(escape));
	fflush(stderr);
}


/* 
*	transmit Network Virtual Terminal codes
*/
transnvt(argc,argv)
int argc;
char *argv[];
{
	register struct telopt *c;
	struct telopt *getopt();
	static unsigned char cmd[20];

	if(! connected) {
	    fprintf(stderr,"no open connection to transmit NVT options.\r\n");
	    return;
	}
	if(argc == 1) {
		strncpy(line,"NEG ",4);
		printf("transnvt> ");
		gets(&line[4]);
		makeargv();
		argc = margc; argv = margv;
	}
	if((argc >= 2) && (argv[1][0] == '?')) {
		iachelp();
		return;
	}

	cmd[0] = IAC;
	c = getopt( margv[1], iaclist);
	if( c == ( struct telopt *) - 1 ) {
		write( 1, "?Ambiguous command\r\n",20);
		return;
	}
	if( c == 0 ) {
		write( 1, "?Invalid command\r\n",18);
		return;
	}
	cmd[1] = c->option;

	if( cmd[1] == 0) {
		iachelp();
		return;
	}

	/* If a DM is to be sent put urgent on the DM */
	
	
	if( cmd[1] == DM ) {
		int i=0;
		int flags = 0;
		try_again1:
		i = t_snd(net_fd,&cmd[0],1,flags);
		if (i < 0) {
			if (errno == EAGAIN || errno == EWOULDBLOCK){
				sleep(1);
				goto try_again1;
			}
		}
		try_again2:
		flags |= T_EXPEDITED;
		i = t_snd( net_fd,&cmd[1],1,flags);
		if (i < 0) {
			if (errno == EAGAIN || errno == EWOULDBLOCK){
				sleep(1);
				goto try_again2;
			}
		}
	}
	else  {
		if ( cmd[1] == AO )
			dmflag = 1;
		*nfrontp++ = cmd[0];
		*nfrontp++ = cmd[1];
		netflush(net);
	}

	if( showoptions )
		printf("SENT IAC %s\r\n",telcmds[cmd[1]-240]);
}

/*
*	toggle local echo 
*/
noecho()
{
	if(! connected) {
		fprintf(stderr,"no open connection to modify echo\r\n");
		return;
	}
	if( nolocecho ) {
		mode( 2 );
		printf("Local echo enabled.\r\n");
		nolocecho = 0;
	}
	else {
		nolocecho++;
		mode( 1 );
		printf("Local echo disabled.\r\n");
	}
}
/*
*	SET mode to line mode transmission
*/
setlinemod()
{
	if( myopts[TELOPT_BINARY] )  {
		if( enbline ) {
			printf("Must stay in character mode with BINARY enabled.\r\n");
			enbline = !enbline;
			return;
		}
		else {
			printf("Must stay in character mode with BINARY enabled.\r\n");

			return;
		}
	}
	if( enbline ) 
		printf("Character mode enabled.\r\n");
	else
		printf("Line mode enabled.\r\n");
	enbline = !enbline;
}
/*
*	Print help screen for NVT control functions
*/   
iachelp()
{
	register struct telopt *c;

	printf("Help for NVT control functions.\r\n");
	printf("\r\nFunctions may be abbreviated. Functions are:\r\n");
	for( c = iaclist; c->optname; c++ )
		printf("%-11s %s\r\n",c->optname,c->helP);
	return;
}

makeargv()
{
	register char *cp;
	register char **argp = margv;

	margc = 0;
	for (cp = line; *cp;) {
		while (isspace(*cp))
			cp++;
		if (*cp == '\0')
			break;
		*argp++ = cp;
		margc += 1;
		while (*cp != '\0' && !isspace(*cp))
			cp++;
		if (*cp == '\0')
			break;
		*cp++ = '\0';
	}
	*argp++ = 0;
}

static int prevmode = 0;
/*
 * In system 5 can't send SIGTSTP 
 * So I will just suspend by creating
 * a local Shell
 */

/*VARARGS*/
suspend()
{
	register int save;
	register int pid;
	int (*osigint)(), (*osigquit)();

	ioctl(0,TCSETAW,&ottyb); /* Reset the terminal to old mode */
	osigint = (int (*)())signal(SIGINT, SIG_IGN);
	osigquit = (int (*)())signal(SIGQUIT, SIG_IGN);
	(void)sighold(SIGPOLL);
	if (( pid = fork()) < 0 ){
		perror("Cant fork");
		goto done;
	}
	if ( pid == 0 ){
		/*
		 * Fire up the shell
		 * in the child
		 */
		register char *shell;

		(void)signal(SIGINT, SIG_DFL);
		(void)signal(SIGQUIT, SIG_DFL);
		(void)close(net);
		shell = (char * )getenv("SHELL");
		if (!shell) shell  = "/bin/sh";
		setuid(getuid()); /* Do it as user */
		execl(shell,shell,0);
		perror("Exec");
		_exit(1);
		/*NOTREACHED */
	}

	while (pid != wait((int *)0)); /* Wait for the shell to complete */
done:
	(void) signal(SIGINT, osigint);
	(void) signal(SIGQUIT, osigquit);
	(void)sigrelse(SIGPOLL);
	ioctl(0,TCSETAW,&noterm); /* Reset the terminal to old mode */
}

/*VARARGS*/
bye()
{
	register char *op;

	ioctl(fileno(stdin),TCSETAW,&ottyb);
	if (connected) {
		printf("Connection closed.\n");
		fflush(stdout);fflush(stderr);
		Closeit(net_fd);
		connected = 0;
		/* reset telnet options */
		for (op = hisopts; op < &hisopts[256]; op++)
			*op = 0;
		for (op = myopts; op < &myopts[256]; op++)
			*op = 0;
	}
}

/*VARARGS*/
quit()
{
	call(bye, "bye", 0);
	exit(0);
}

/*
 * Help command.
 */
help(argc, argv)
int argc;
char *argv[];
{
	register struct cmd *c;

	if (argc == 1) {
		printf("Commands may be abbreviated.  Commands are:\n\n");
		for (c = cmdtab; c->name; c++)
			printf("%-*s\t%s\n", HELPINDENT, c->name, c->Help);
		return;
	}
	while (--argc > 0) {
		register char *arg;
		arg = *++argv;
		c = getcmd(arg);
		if (c == (struct cmd *)-1)
			printf("?Ambiguous help command %s\n", arg);
		else if (c == (struct cmd *)0)
			printf("?Invalid help command %s\n", arg);
		else
			printf("%s\n", c->Help);
	}
}


/*
 * Call routine with argc, argv set from args (terminated by 0).
 * VARARGS2
 */
call(routine, args)
int (*routine)();
int args;
{
	register int *argp;
	register int argc;

	for (argc = 0, argp = &args; *argp++ != 0; argc++)
		;
	(*routine)(argc, &args);
}

struct termio noterm;

mode(f)
register int f;
{
	fflush(stdout);fflush(stderr);
	switch (f) {

	case 0:
		break;

	case 1:
	case 2:
		noterm.c_lflag=0;
		noterm.c_cc[VMIN] = 1;
		noterm.c_cc[VTIME] = -1;
		noterm.c_iflag |= IGNBRK;
		if ( f == 1){
			noterm.c_lflag &= ~(ECHO|ECHOE|ECHOK);
			noterm.c_oflag &= ~ONLCR;
			noterm.c_iflag &= ~ICRNL;
		} else{
			noterm.c_lflag |= (ECHO|ECHOE|ECHOK);
			noterm.c_iflag |= ICRNL;
			noterm.c_oflag |= ONLCR;
			noterm.c_iflag &= ~IGNCR;
		}
		break;

	default:
		return;
	}
	ioctl(fileno(stdin),TCSETAW,&noterm);
	return;
}


/*
 * Fire up the IO to the stream fd.
 */
/* ARGSUSED */
sig_poll(sig)
{

	sighold(SIGPOLL);
	/*
	 * Read from the FD.
	 */
	for(;;) {
		int flags = 0;	
		scc = t_rcv(net_fd, sibuf, sizeof (sibuf), &flags);
		if (flags & T_EXPEDITED) {
			if (scc == 0) continue;
		}
		if (scc < 0 && t_errno == TNODATA)
			break;
		else if (scc < 0 && t_errno == EINTR)
			break;
		
		else {
			if (scc <= 0) {
				/*
				 *  Generated by M_HANGUP from TCP
				 */
				ioctl(0,TCSETAW,&ottyb);
				sigrelse(SIGPOLL);
				longjmp(peerdied);
				/* NOTREACHED */
			}
			sbp = sibuf;
		}
		if (scc > 0)
			telrcv();
		if ( (tfrontp - tbackp) > 0)
			ttyflush(fileno(stdout));
		/*
		 * We need to catch XON/XOFF properly
		 */
		(void) fcntl(0, F_SETFL, O_NDELAY);
		Read_tty(1);
		(void) fcntl(0, F_SETFL, O_RDWR);
	}
	sigrelse(SIGPOLL);
}


/*
 * Select from tty and network...
 */
telnet(s)
int s;
{
	register int c;
	int tin = fileno(stdin), tout = fileno(stdout);
	int on = 1;
	register int ESC = 0;
	short cnt;
	int cleanup();

	/* negotiate initial options - only if connecting to telnet port */
	sp = getservbyname("telnet", "tcp");
	if (sin.sin_port == sp->s_port) {
		/* negotiate initial options */
		*nfrontp++ = IAC;
		*nfrontp++ = WILL;
		*nfrontp++ = TELOPT_SGA;
		needreply[TELOPT_SGA] = DO_DONT;
		printoption("SENT",WILL,TELOPT_SGA);
		*nfrontp++ = IAC;
		*nfrontp++ = DO;
		*nfrontp++ = TELOPT_ECHO;
		needreply[TELOPT_ECHO] = WILL_WONT;
		printoption("SENT",DO,TELOPT_ECHO);
	}
	net_fd = s;

	(void) mode(2);

	(void)ioctl(s, I_SETSIG, S_INPUT|S_MSG);
	sigset(SIGPOLL, sig_poll);
	sig_poll(SIGPOLL);	/* Pretend that we just got a signal */
	for (;;) {

		if (scc < 0 && tcc < 0)
			break;
		/*
		 * Read from the TTY and write to the Net.
		 */
		Read_tty(2);
	}
	(void) mode(0);
}

command(top)
int top;
{
	register struct cmd *c;

	(void)ioctl(0,TCSETAW,&ottyb);
	if (!top)
		putchar('\n');
	else
		signal(SIGINT, SIG_DFL);
	printf("%s> ", prompt);
	/*
	 * Current_Char is set so that we can send an escape char
	 * Current_char is the char that is typed following an
	 * escape character. SO if it is set then we must
	 * echo it out. (Called as command(0) )
	 */
	if ( Current_Char){
		if( Current_Char == ottyb.c_cc[VEOF])
			quit();
		if( Current_Char != '\r' && Current_Char != '\n' ) {
			putchar(Current_Char);
			line[0] = Current_Char;
		} else
			Current_Char = 0;
	}
	if (Current_Char == 't')
		(void) fcntl(0, F_SETFL, O_RDWR);
	for (;;printf("%s> ",prompt)) {
		errno = 0;
		if (gets(Current_Char ? &line[1] : line ) == 0) {
			if (feof(stdin))
				quit();
			clearerr(stdin);
			putchar('\n');
			break;
		}
		Current_Char = 0;
		if (line[0] == 0)
			break;
		makeargv();
		c = getcmd(margv[0]);
		if (c == (struct cmd *)-1) {
			printf("?Ambiguous command\n");
			continue;
		}
		if (c == 0) {
			printf("?Invalid command\n");
			continue;
		}
		(*c->handler)(margc, margv);
		if (c->handler != help)
			break;
	}
	if (!top) {
		if (!connected)
			longjmp(toplevel, 1);
		fflush(stdout);fflush(stderr);
		ioctl(0,TCSETAW,&noterm); /* Reset it to what it was */
	}
}

/*
 * Telnet receiver states for fsm
 */
#define	TS_DATA		0
#define	TS_IAC		1
#define	TS_WILL		2
#define	TS_WONT		3
#define	TS_DO		4
#define	TS_DONT		5
#define	TS_BEGINNEG	10
#define	TS_STATUS	11
#define	TS_IS		12
#define	TS_EXOPL	13
#define	TS_EXOPL_OPT	14
#define	TS_ENDNEG	15
#define TS_END_IAC	16

#define	TELOPT_LAST	TELOPT_SUPDUP

telrcv()
{
	register int c;
	register int n;
	static int state = TS_DATA;
	static unsigned char Reply[] = {IAC,SB,TELOPT_EXOPL,0,0,IAC,SE};
	static int print_status = 0;

	while (scc > 0) {
		c = *sbp++ & 0377, scc--;
		switch (state) {

		case TS_DATA:
			if (c == IAC) {
				state = TS_IAC;
				continue;
			}
			if( !dmflag )
				*tfrontp++ = c;
			/* If we are supposed to remote echo, then...*/
			if(myopts[TELOPT_ECHO]) *nfrontp++ = c;
			/*
			 * This hack is needed since we can't set
			 * CRMOD on output only.  Machines like MULTICS
			 * like to send \r without \n; since we must
			 * turn off CRMOD to get proper input, the mapping
			 * is done here (sigh).
			 */
			if (c == '\r' && crmod) {
				if( !dmflag )
					*tfrontp++ = '\n';
			}
			continue;

		case TS_IAC:
			switch (c) {
			
			case WILL:
				state = TS_WILL;
				continue;

			case WONT:
				state = TS_WONT;
				continue;

			case DO:
				state = TS_DO;
				continue;

			case DONT:
				state = TS_DONT;
				continue;

			case SB:
				state = TS_BEGINNEG;
				continue;

		
			case DM:
				dmflag = 0;
				(void)ioctl(fileno(stdout),TCFLSH,1);
				fflush(stdout);fflush(stderr);
				(void)ioctl(0,TCSETAW,&noterm);
				break;

			case NOP:
			case GA:
				break;

			default:
				break;
			}
			state = TS_DATA;
			continue;

		case TS_WILL:
			printoption("RCVD", WILL, c);
			if (!hisopts[c])
				WillOption(c);
			state = TS_DATA;
			continue;

		case TS_WONT:
			printoption("RCVD", WONT, c);
			if (hisopts[c])
				WontOption(c);
			state = TS_DATA;
			continue;

		case TS_DO:
			printoption("RCVD", DO, c);
			if (!myopts[c])
				DoOption(c);
			state = TS_DATA;
			continue;

		case TS_DONT:
			printoption("RCVD", DONT, c);
			if (myopts[c]) {
				DontOption(c);
				myopts[c] = 0;
				sprintf(nfrontp, wont, c);
				nfrontp += sizeof (wont) - 2;
				printoption("SENT", WONT, c);
			}
			state = TS_DATA;
			continue;
		case TS_BEGINNEG:
			/*
			 * Perform option negotiation and sub-negotiations
			 */
			if(c == TELOPT_STATUS) state = TS_STATUS;
			else if(c == TELOPT_EXOPL) state = TS_EXOPL;
			else state = TS_ENDNEG;
			continue;
		case TS_STATUS:
			if (c == IS) {
				for(n=0; n<256; n++)
					myopts[n] = hisopts[n] = 0;
				print_status = 1;
				state=TS_IS;
			} else if (c == SEND) {
				SendStatus();
				state = TS_END_IAC;
			}
			continue;
		case TS_IS:
			{
			static int dowill;

			if (print_status) {
				printf("STATUS IS :\r\n");
				print_status = 0;
			}
			switch(c) {
			    case DO:
				dowill = DO_DONT;
				printf("        DO   ");
				break;
			    case WILL:
				dowill = WILL_WONT;
				printf("        WILL ");
				break;
			    case IAC:
				state = TS_ENDNEG;
				break;
			    default:	/* these are the options */
				if ( dowill == DO_DONT ) {
					needreply[c] = DO_DONT;
					DoOption(c);
				} else if ( dowill == WILL_WONT ) {
					needreply[c] = WILL_WONT;
					if ( c == TELOPT_STATUS )
						hisopts[c] = 1;
					else
						WillOption(c);
				}
				if ( c <= TELOPT_LAST )
					printf("%s\r\n", telopts[c]);
				else if ( c == TELOPT_EXOPL )
					printf("EXOPL\r\n");
				else
					printf("%d\r\n",c);
				break;
			}
			continue;
			}
		case TS_EXOPL:
			switch(c) {
			case DO   :
			case DONT :
				   state = TS_EXOPL_OPT;
				   Reply[3] = WONT;
				   break;
			case WONT :
			case WILL :
				   state = TS_EXOPL_OPT;
				   Reply[3] = DONT;
				   break;
			case SB   :
			default   :
				   state = TS_END_IAC;
				   break;
			}
			continue;
		case TS_EXOPL_OPT:
			Reply[4] = c;
			strcpy(nfrontp,Reply);
			nfrontp += strlen(Reply);
			state = TS_END_IAC;
			continue;
		case TS_END_IAC:
			if ( c == IAC )
				state = TS_ENDNEG;
			break;
		case TS_ENDNEG:
			if (c == SE)
				state = TS_DATA;
			continue;
		}
	}
}

/*
 * Set the escape character.
 */
setescape(argc, argv)
int argc;
char *argv[];
{
	register char *arg;
	char buf[50];

	if (argc > 2)
		arg = argv[1];
	else {
		printf("new escape character: ");
		gets(buf);
		arg = buf;
	}
	if (arg[0] != '\0')
		escape = arg[0];
	fprintf(stderr,"Escape character is '%s'.\n", control(escape));
	fflush(stderr);
}

/*VARARGS*/
setoptions()
{

	showoptions = !showoptions;
	fprintf(stderr,"%s show option processing.\n", showoptions ? "Will" : "Wont");
	fflush(stderr);
}

/*VARARGS*/
setcrmod()
{

	crmod = !crmod;
	fprintf(stderr,"%s map carriage return on output.\n", crmod ? "Will" : "Wont");
	fflush(stderr);
}

/*VARARGS*/

/*
 * Construct a control character sequence
 * for a special character.
 */
char *
control(c)
register int c;
{
	static char buf[3];

	if (c == 0177)
		return ("^?");
	if (c >= 040) {
		buf[0] = c;
		buf[1] = 0;
	} else {
		buf[0] = '^';
		buf[1] = '@'+c;
		buf[2] = 0;
	}
	return (buf);
}

char *
lower(str)
char *str;
{
	register char *cp = str;

	while (*cp ) {
		if(isupper(*cp)) *cp = tolower(*cp);
		cp++;
	}
	return(str);
}

struct cmd *
getcmd(name)
register char *name;
{
	register char *p, *q;
	register struct cmd *c, *found;
	register int nmatches, longest;

	longest = 0;
	nmatches = 0;
	found = 0;
	(void) lower(name);
	for (c = cmdtab; p = c->name; c++) {
		for (q = name; *q == *p++; q++)
			if (*q == 0)		/* exact match? */
				return (c);
		if (!*q) {			/* the name was a prefix */
			if (q - name > longest) {
				longest = q - name;
				nmatches = 1;
				found = c;
			} else if (q - name == longest)
				nmatches++;
		}
	}
	if (nmatches > 1)
		return ((struct cmd *)-1);
	return (found);
}

deadpeer()
{
	(void) mode(0);
	longjmp(peerdied, -1);
}

intr()
{
	if(connected) {
		signal(SIGINT, intr);
		*nfrontp++ = IAC;
		*nfrontp++ = BREAK;
		netflush(net);
	} else {
		(void) mode(0);
		longjmp(toplevel, -1);
	}
}

ttyflush(fd)
{
	int n;

	if ((n = tfrontp - tbackp) > 0) {
			n = write(fd, tbackp, n);
	}	
	if (n < 0)
		return;
	tbackp += n;
	if (tbackp == tfrontp)
		tbackp = tfrontp = ttyobuf;
}

netflush(fd)
{
	int n;

	if ((n = nfrontp - nbackp) > 0)
		n = write(fd, nbackp, n);
	if (n < 0) {
		if (errno != ENOBUFS && errno != EWOULDBLOCK) {
			(void) mode(0);
			printf("net can't write..(%d)\r\n",errno);
			perror(hostname);
			printf("\r"); /* need a CR in this mode */
			Closeit(fd);
			longjmp(peerdied, -1);
			/*NOTREACHED*/
		}
		n = 0;
	}
	nbackp += n;
	if (nbackp == nfrontp)
		nbackp = nfrontp = netobuf;
}

/*VARARGS*/
cleanup()
{
	ioctl(0,TCSETAW,&ottyb); /* Reset it to what it was */
	exit(0);
}

struct telopt optlist[] = {
	{ "binary", TELOPT_BINARY , "transmit binary" },
	{ "echo", TELOPT_ECHO, "remote echoing" },
	{ "sga", TELOPT_SGA, "suppress go ahead" },
	{ "tm", TELOPT_TM, "timing mark" },
	{ "status", TELOPT_STATUS, "current status of options" },
	{ "exopl", TELOPT_EXOPL, "negotiate options on the extended options list"},
	0 };

struct telopt optcmd[] = {
	{ "will", WILL, "desire to begin performing indicated option"},
	{ "wont", WONT, "refusal to continue performing indicated option"},
	{ "do", DO, "request that other party begin performing indicated option"},
	{ "dont", DONT, "demand that other party stop performing indicated option"},
	/* { "sb", SB, "begin subnegotiation"}, */
	{ "?", 0, "print help information on option negotiation" },
	0};

negotiate(argc,argv)
int argc;
char *argv[];
{
	register struct telopt *c;
	struct telopt *getopt();
	static unsigned char cmd[20];

	if(! connected) {
		fprintf(stderr,"no open connection to negotiate options\r\n");
		return;
	}
	if(argc == 1) {
		strncpy(line,"NEG ",4);
		printf("negotiate> ");
		gets(&line[4]);
		makeargv();
		argc = margc; argv = margv;
	}
	if((argc >= 2) && (argv[1][0] == '?')) {
		opthelp();
		return;
	}
	if(argc < 3) {
		write(1,"?Invalid option\r\n",17);
		return;
	}
	c = getopt(argv[1], optcmd);
	if(c == 0) {
		write(1,"?Invalid command\r\n",18);
		return;
	}
	if(c == (struct telopt *)-1) {
		write(1,"?Ambiguous command\r\n",20);
		return;
	}
	cmd[0] = IAC;
	cmd[1] = c->option;
	
	c = getopt(argv[2], optlist);
	if(c == 0) {
		write(1,"?Invalid option\r\n",17);
		return;
	}
	if(c == (struct telopt *)-1) {
		write(1,"?Ambiguous option\r\n",19);
		return;
	}
	cmd[2] = c->option;
	switch(cmd[1]) {
		case DO  : if(hisopts[cmd[2]]) {
				if (cmd[2] == TELOPT_STATUS) {
					strcpy(nfrontp,StatusSend);
					nfrontp += sizeof(StatusSend);
					if (showoptions)
						printf("SENT IAC SB STATUS SEND IAC SE\r\n");
				}
				return;
			   }
		           needreply[cmd[2]] = WILL_WONT;
			   break;
		case DONT: if(! hisopts[cmd[2]])
				return;
		           needreply[cmd[2]] = WILL_WONT;
			   break;
		case WILL: if(myopts[cmd[2]])
				return;
		           needreply[cmd[2]] = DO_DONT;
			   break;
		case WONT: if(! myopts[cmd[2]])
				return;
		           needreply[cmd[2]] = DO_DONT;
			   break;
	}
	/* SEND THE OPTION */
	*nfrontp++ = cmd[0];
	*nfrontp++ = cmd[1];
	*nfrontp++ = cmd[2];
	printoption("SENT",cmd[1],cmd[2]);
}	

/*
 * getopt() searches the 'table' for the entry corresponding to 'name'.
 * 	    Returns the pointer to this entry, if the 'name' was found.
 *	    Returns  0 for an illegal 'name'.
 *	    Returns -1 if the name is ambiguous.
 *	    Exactly similar to function getcmd() except that a different table
 *	    is searched.
 */
struct telopt *
getopt(name,table)
register char *name;
struct telopt *table;
{
	register char *p, *q;
	register struct telopt *c, *found;
	register int nmatches, longest;
	
	longest = 0;
	nmatches = 0;
	found = 0;
	(void) lower(name);
	for (c = table; p = c->optname; c++) {
		for (q = name; *q == *p++; q++)
			if (*q == 0)		/* exact match? */
				return (c);
		if (!*q) {			/* the name was a prefix */
			if (q - name > longest) {
				longest = q - name;
				nmatches = 1;
				found = c;
			} else if (q - name == longest)
				nmatches++;
		}
	}
	if (nmatches > 1)
		return ((struct telopt *)-1);
	return (found);
}

opthelp()
{
	register struct telopt *c;

	printf("format for negotiation>  COMMAND   OPTION\r\n");
	printf("\r\nCommands may be abbreviated. Commands are:\r\n");
	for(c=optcmd; c->optname; c++)
		printf("%-10s %s\r\n",c->optname,c->helP);
	printf("\r\nOptions may be abbreviated. Options are:\r\n");
	for(c=optlist; c->optname; c++)
		printf("%-10s %s\r\n",c->optname,c->helP);
	return;
}

#define NO_LOCAL_ECHO	1
#define LOCAL_ECHO 	2
WillOption(opt)
register unsigned char opt;
{
	static unsigned char Reply[10];

	if(opt >= 255) return;
	if(needreply[opt] == WILL_WONT){
		needreply[opt] = 0;
		switch(opt) {
		case TELOPT_ECHO :  /* turn off local echoing */
				mode(NO_LOCAL_ECHO);
		case TELOPT_SGA :
		case TELOPT_BINARY :
		case TELOPT_EXOPL :
		case TELOPT_STATUS :
			hisopts[opt] = 1;
			break;
		}
	}
	else {
		if(hisopts[opt] == 1)
			return;	
		Reply[0] = IAC;
		switch(opt) {
		case TELOPT_ECHO : if(myopts[TELOPT_ECHO]) {
					/* only one end is allowed to echo */
					Reply[1] = DONT;
					break;
				    } 
				    /* turn off local echoing */
				    mode(NO_LOCAL_ECHO);
		case TELOPT_SGA :
		case TELOPT_BINARY :
		case TELOPT_EXOPL :
				hisopts[opt]=1;
		case TELOPT_TM :
		case TELOPT_STATUS :
				Reply[1] = DO;
      				break;
		default : 	Reply[1] = DONT;
			  	break;	
		}
		Reply[2] = opt;
		*nfrontp++ = Reply[0];
		*nfrontp++ = Reply[1];
		*nfrontp++ = Reply[2];
		printoption("SENT", Reply[1], Reply[2]);
	}
	if(opt == TELOPT_STATUS) {
		strcpy(nfrontp,StatusSend);
		nfrontp += sizeof(StatusSend);
		if(showoptions)
			printf("SENT IAC SB STATUS SEND IAC SE\r\n");
	}
}
DoOption(opt)
register unsigned char opt;
{
	static unsigned char Reply[10];

	if(opt > 255) return;
	if(needreply[opt] == DO_DONT){
		needreply[opt] = 0;
		switch(opt) {
		case TELOPT_ECHO :
		case TELOPT_BINARY :
			myopts[opt] = 1;
			setlinemod();
			break;
		case TELOPT_SGA :
		case TELOPT_EXOPL :
			myopts[opt] = 1;
			break;
		}
		myopts[opt] = 1;
		return;
	}
	if(myopts[opt] == 1)
		return;	
	Reply[0] = IAC;
	switch(opt) {
	case TELOPT_ECHO : if(hisopts[TELOPT_ECHO]) {
				/* only one end is allowed to echo */
				Reply[1] = WONT;
				break;
			    }
	case TELOPT_BINARY :
	case TELOPT_SGA :
	case TELOPT_EXOPL :
			myopts[opt]=1;
	case TELOPT_TM :
	case TELOPT_STATUS :
			Reply[1] = WILL;
      			break;
	default : 	Reply[1] = WONT;
		  	break;	
	}
	Reply[2] = opt;
	*nfrontp++ = Reply[0];
	*nfrontp++ = Reply[1];
	*nfrontp++ = Reply[2];
	printoption("SENT", Reply[1], Reply[2]);
}
WontOption(opt)
register unsigned char opt;
{
	if(opt >= 255) return;
	if(needreply[opt] == WILL_WONT){
		needreply[opt] = 0;
		hisopts[opt] = 0;
		if(opt == TELOPT_ECHO)  /* turn on local echo */
			mode(LOCAL_ECHO);
		return;
	}
	if(hisopts[opt] == 0)
		return;	
	if(opt == TELOPT_ECHO)  /* turn on local echo */
		mode(LOCAL_ECHO);
	*nfrontp++ = IAC;
	*nfrontp++ = DONT;
	*nfrontp++ = opt;
	hisopts[opt] = 0;
	printoption("SENT", DONT, opt);
	netflush(net);
}

DontOption(opt)
register unsigned char opt;
{
	if(opt >= 255) return;
	if(needreply[opt] == DO_DONT){
		needreply[opt] = 0;
		myopts[opt] = 0;
		return;
	}
	if(myopts[opt] == 0)
		return;	
	*nfrontp++ = IAC;
	*nfrontp++ = WONT;
	*nfrontp++ = opt;
	myopts[opt] = 0;
	printoption("SENT", WONT, opt);
}
SendStatus()
{
	register int n;

	*nfrontp++ = IAC;
	*nfrontp++ = SB;
	*nfrontp++ = TELOPT_STATUS;
	*nfrontp++ = IS;
	for(n=0; n<256; n++) {
		if(myopts[n]) {
			*nfrontp++ = WILL;
			*nfrontp++ = (char) n;
		}
		if(hisopts[n]) {
			*nfrontp++ = DO;
			*nfrontp++ = (char) n;
		}
	}
	*nfrontp++ = IAC;
	*nfrontp++ = SE;
	
	if(showoptions)
		printf("SENT STATUS\r\n");
}

printoption(direction,cmd,opt)
char *direction;
unsigned char cmd,opt;
{
	if(showoptions) {
		printf("%s IAC %s ",direction, telcmds[cmd-240]);
		if(opt <= TELOPT_SUPDUP)
			printf("%s\r\n",telopts[opt]);
		else 
			printf("%d\r\n",opt);
	}
	return;
}
Closeit(fd)
{
/***
 *** Send a orderly release.
 ***/
	(void)t_sndrel(fd);
	(void)t_rcvrel(fd);
	close(fd);
	
}
/*
 * Read From the tty.
 */
Read_tty(n)
int n;
{
	static  int ESC  = 0;

reread:
	tcc = read(0, tibuf, sizeof (tibuf));
	if (n == 2) sighold(SIGPOLL);
	if (tcc < 0 && (errno == EINTR || errno == EAGAIN))
		tcc = 0;
	else {
		if (tcc <= 0){
			if (n == 2)
				sigrelse(SIGPOLL);
			return;
		}
		tbp = tibuf;
	}
	while (tcc > 0) {
		register int c;

		if ((&netobuf[BUFSIZ] - nfrontp) < 2)
			break;
		c = *tbp++ & 0377, tcc--;
		/*
		 * If two escapes in a row
		 * Send one of them
		 * Current_char is set so that it can
		 * Be echoed out with the prompt
		 */
		if(!myopts[TELOPT_BINARY])
			c = strip(c);
		if(ESC) {
			ESC = 0;
			if(c != escape) {
				Current_Char=c;
				command(0);
				tcc = 0;
				break;
			}
		} else if(c == escape) {
			ESC = 1;
			if (!tcc)
				goto reread;
			continue;
		}
		if ( myopts[TELOPT_BINARY] ) {
			*nfrontp++ = c;
			if (c == IAC)
				*nfrontp++ = c;
		}
		else  {
		/* telnet spec recommends that Carriage Return 
		   not be transmitted by itself over the network
		   and that newline == CR/LF               */
		switch (c)   {
			case '\n':
				*nfrontp++ = '\r';
				*nfrontp++ = '\n';
				flushline = 1;
				break;
			case '\r':
				*nfrontp++ = c;
				*nfrontp++ = '\n';
				flushline = 1;
				break;
			default:
				*nfrontp++ = c;
				if( enbline )
					flushline = 0;

			}
       		}
	}
	/*
	 * Flush every line if in binary mode.
	 */
	if ( myopts[TELOPT_BINARY] )
		flushline = 1;
	/*
	 * Write out to the network.
	 */
	if ((nfrontp - nbackp) > 0) {
		if (flushline)
			netflush(net_fd);
	}
	if (n == 2) sigrelse(SIGPOLL);
}
