#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)main.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include <sys/types.h>
#include <sys/inet.h>
#if (vax || i386 )
#if (USG || XENIX)
#include "sys/page.h"
#else
#include "sys/vmmac.h"
#include "machine/pte.h"
#endif /*  USG */
#endif /* vax */
#include "ctype.h"
#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include <sys/stat.h>

#ifdef NCR
struct nlist nl[] = {
#define	N_ETTAL		0	/* somebody will have to create an ioctl */
	{ "ettallies" },	/* to replace this NCR-specific stuff    */
	"",
};
#endif /* NCR */

extern	int tcppr(), udppr();
extern	int tcp_stats(), udp_stats(), ip_stats(), icmp_stats();

struct protox {
	int	(*pr_cblocks)();	/* control blocks printing routine */
	int	(*pr_stats)();		/* statistics printing routine */
	char	*pr_name;		/* well-known name */
	u_char	pr_wanted;		/* 1 if wanted, 0 otherwise */
} protox[] = {
	{ tcppr,  tcp_stats,	"tcp",  1, },
	{ udppr,  udp_stats,	"udp",  1, },
	{ 0,      ip_stats,	"ip",   1, },
	{ 0,	  icmp_stats,	"icmp", 1, },
	{ 0,	  0,		0,      0, }
};

char	*tcpf  = DEV_TCP_CTL;
char	*udpf  = DEV_UDP_CTL;
char	*ipf   = DEV_IP_CTL;
int	fdtcp, fdip, fdudp;
int	kflag;
int	Aflag;
int	aflag;
#ifndef NCR
int	hflag;
#endif /* NCR */
int	iflag;
int	nflag;
int	rflag;
int	sflag;
#ifndef NCR32_200
int	tflag;
#endif /* NCR32_200 */
int	pflag;
char	*protocol;
int	interval;
#ifdef NCR
char	usage[] = "[ -Aainrs ] [ -p protocol ] [ interval ]";
#else
char	usage[] = "[ -Aaihnrs ] [ -p protocol ] [ interval ]";
#endif /* NCR */

main(argc, argv)
	int argc;
	char *argv[];
{
	int i;
	char *cp, *name;
	register struct protoent *p;
	struct stat sbunix, sbdata;
	register int tempfd;

	name = argv[0];
	argc--, argv++;
  	while (argc > 0 && **argv == '-') {
		for (cp = &argv[0][1]; *cp; cp++)
		switch(*cp) {

		case 'A':
			Aflag++;
			break;

		case 'a':
			aflag++;
			break;

#ifndef NCR
		case 'h':
			hflag++;
			break;
#endif /* NCR */

		case 'i':
			iflag++;
			break;

		case 'n':
			nflag++;
			break;

		case 'r':
			rflag++;
			break;

		case 's':
			sflag++;
			break;

		case 'p':
			pflag++;
			argv++;
			argc--;
			if(argc == 0) goto use;
			protocol = *argv;
			break;
		default:
use:
			printf("usage: %s %s\n", name, usage);
			exit(1);
		}
		argv++, argc--;
	}
	if (argc > 0 && isdigit(argv[0][0])) {
		interval = atoi(argv[0]);
		if (interval <= 0)
			goto use;
		argv++, argc--;
		iflag++;
	}

	fdtcp = open(tcpf, 0);
	if (fdtcp < 0) {
		fprintf(stderr, "cannot open ");
		perror(tcpf);
		exit(1);
	}
	fdudp = open(udpf, 0);
	if (fdudp < 0) {
		fprintf(stderr, "cannot open ");
		perror(udpf);
		exit(1);
	}
	fdip = open(ipf, 0);
	if (fdip < 0) {
		fprintf(stderr, "cannot open ");
		perror(ipf);
		exit(1);
	}
	/*
	 * Keep file descriptors open to avoid overhead
	 * of open/close on each call to get* routines.
	 */
	sethostent(1);
	setnetent(1);
	if (iflag) {
#ifdef NCR
		intpr(interval, 0, nl[N_ETTAL].n_value);
#else
		intpr(interval, 0);
#endif /* NCR */
		exit(0);
	}
	if (rflag) {
		if (sflag)
			rt_stats(0);
		else
			routepr(0, 0);
		exit(0);
	}
	setprotoent(1);
	setservent(1);
	while (p = getprotoent()) {
		register struct protox *tp;

		if(pflag && strcmp(protocol,p->p_name))
			continue;
		for (tp = protox; tp->pr_name; tp++)
			if (strcmp(tp->pr_name, p->p_name) == 0)
				break;
		if (tp->pr_name == 0 || tp->pr_wanted == 0)
			continue;
		if (sflag && tp->pr_stats) {
			(*tp->pr_stats)(0, p->p_name);
			continue;
		}
		if (tp->pr_cblocks)
			(*tp->pr_cblocks)(0, p->p_name);
	}
	endprotoent();
}

/*
 * Seek into the kernel for a value.
 */
klseek(fd, base, off)
	int fd, base, off;
{

#ifdef i386
	if (lseek(fd, base, off) == -1 ){
#else /* i386 */
	if (lseek(fd, base&0x7fffffff, off) == -1 ){
#endif /*i386 */
		fprintf(stderr,"Bad lseek fd=%d,bas=%x,off=%d ",fd,base,off);
		perror("");
		exit(1);
	}
}

char *
plural(n)
	int n;
{

	return (n != 1 ? "s" : "");
}

#ifdef BYTESWAP
/* hostorder = htons(netorder) */
short htons(x)
short x;
{
	short tmp;
	char *ptmp = (char *)&tmp;
	char *px = (char *)&x;

	tmp = x;
	px[0] = ptmp[1];
	px[1] = ptmp[0];
	
	return(x);
}

/* netorder = htonl(hostorder) */
long htonl(x)
long x;
{
	long tmp;
	char *ptmp = (char *)&tmp;
	char *px = (char *)&x;

	tmp = x;
	px[0] = ptmp[3];
	px[1] = ptmp[2];
	px[2] = ptmp[1];
	px[3] = ptmp[0];
	
	return(x);
}
#endif /* BYTESWAP */
