/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)inet.c (TWG)        1.4      13:40:28 - 89/08/09"

#include <errno.h>
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/stropts.h>	/* for I_STR */

#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/in.h>
#include <sys/ip.h>
#include <sys/ip_var.h>
#include <sys/ip_icmp.h>
#include <sys/icmp_var.h>
#include <sys/route.h>
#define TCPSTATES
#include <sys/tcp.h>
#include <sys/udp.h>
#include <sys/inetioctl.h>
#include <netdb.h>

extern	int fdtcp, fdudp, fdip;
extern	int Aflag;
extern	int aflag;
extern	int nflag;
extern  char * index();

static	int first = 1;
char	*inetname();

static
firstpr()
{
	printf("Active Internet connections");
	if (aflag)
		printf(" (including servers)");
	putchar('\n');
	if (Aflag)
		printf("%-8.8s ", "PCB");
	printf(Aflag ?
		"%-5.5s %-6.6s %-6.6s  %-18.18s %-18.18s %s\n" :
		"%-5.5s %-6.6s %-6.6s  %-22.22s %-22.22s %s\n",
		"Proto", "Recv-Q", "Send-Q",
		"Local Address", "Foreign Address", "(state)");
	first = 0;
}

/*
 * Print a summary of connections related to an Internet protocol.  
 * For TCP, also give state of connection.
 * Listening processes (aflag) are suppressed unless the
 * -a (all) flag is specified.
 */
tcppr(off, name)
	off_t		off;		/* value from "tcb" */
	char		*name;
{
	struct strioctl strioctl;
	struct tcpglob  tcpglob;

	if ( strcmp(name, "tcp") )
		return;
	if (first) 
		firstpr();
	tcpglob.tcb.b_next = (mblk_t *)1; /* force return of first list item */
	tcpglob.tcb.b_cont = (mblk_t *)0;
	while (tcpglob.tcb.b_next != tcpglob.tcb.b_cont ) {
		/*
		 * tcpglob.tcb.b_next points to next mblk tcb in line.
		 * Read in the tcb, tcpcb, and tcpd, all in one operation.
		 * Upon return, tcpglob.tcb.b_cont contains the address of the 
		 * list head.  If tcpglob.tcb.b_cont is NULL then the tcpcb
		 * list is empty.
		 */
		strioctl.ic_cmd = TCPIOC_GETTCB;
		strioctl.ic_timout = 0;
		strioctl.ic_len = sizeof tcpglob;
		strioctl.ic_dp  = (char *)&tcpglob;
		if (ioctl(fdtcp, I_STR, &strioctl )<0) {
			if (errno != EADDRNOTAVAIL )
				perror( "netstat: tcppr" );
			break;		
		}
		if ( tcpglob.tcb.b_cont == (mblk_t *)0 )
			break;
		if (!aflag  &&
		   inet_lnaof(tcpglob.tcpcb.t_laddr) == INADDR_ANY) 
			continue;
		if (Aflag) 
#ifdef i386
			printf("%8x ", tcpglob.tcpd.td_tcpcb);
#else
			printf("%8x ", tcpglob.tcb.b_rptr);
#endif
		printf("%-5.5s %6d %6d ", name, tcpglob.tcpd.td_rcount, 
						tcpglob.tcpd.td_wcount);
		inetprint(&tcpglob.tcpcb.t_laddr, tcpglob.tcpcb.t_lport, name);
		inetprint(&tcpglob.tcpcb.t_faddr, tcpglob.tcpcb.t_fport, name);
		if (tcpglob.tcpcb.t_state < 0 
		||  tcpglob.tcpcb.t_state >= TCP_NSTATES)
			printf(" %d", tcpglob.tcpcb.t_state);
		else
			printf(" %s", tcpstates[tcpglob.tcpcb.t_state]);
		putchar('\n');
	}
}

/*
 * Print a summary of connections related to an Internet protocol.  
 * Listening processes (aflag) are suppressed unless the
 * -a (all) flag is specified.
 */
udppr(off, name)
	off_t off;
	char *name;
{
	struct strioctl strioctl;
	struct udpd 	udpd;

	if (strcmp(name, "udp"))
		return;
	if (first) 
		firstpr();
	udpd.ud_next = (struct udpd *)1; /* out-of-range value */
	while (udpd.ud_next ) {
		strioctl.ic_cmd = UDPIOC_GETUDPD;
		strioctl.ic_timout = 0;
		strioctl.ic_len = sizeof udpd;
		strioctl.ic_dp  = (char *)&udpd;
		if (ioctl(fdudp, I_STR, &strioctl )<0) {
			if (errno != EADDRNOTAVAIL )
				perror( "netstat: udppr" );
			return;		
		}
		if (udpd.ud_sport == 0)
			continue;
		if (!aflag &&
		   inet_lnaof(udpd.ud_laddr) == INADDR_ANY) 
			continue;
		printf("%-5.5s %6d %6d ", name,
			/* socket.so_rcv.sb_cc, socket.so_snd.sb_cc); */ 
			0, 0);
		inetprint(&udpd.ud_laddr, udpd.ud_sport, name);
		inetprint(&udpd.ud_faddr, udpd.ud_fport, name);
		putchar('\n');
	}
}

/*
* Dump TCP statistics structure.
*/
tcp_stats(off, name)
off_t off;
char *name;
{
	struct strioctl strioctl;
	struct tcpstat tcpstat;

	strioctl.ic_cmd = TCPIOC_GETTCPSTAT;
	strioctl.ic_timout = 0;
	strioctl.ic_len = sizeof tcpstat;
	strioctl.ic_dp  = (char *)&tcpstat;
	if (ioctl(fdtcp, I_STR, &strioctl )<0) {
		if (errno != EADDRNOTAVAIL )
			perror( "netstat: tcp_stats" );
		return;		
	}

#define	p(f, m)		printf(m, tcpstat.f, plural(tcpstat.f))
#define	p2(f1, f2, m)	printf(m, tcpstat.f1, plural(tcpstat.f1), tcpstat.f2, plural(tcpstat.f2))
  
	printf("%s:\n", name);
	p(tcps_sndtotal, "\t%d packet%s sent\n");
	p2(tcps_sndpack,tcps_sndbyte,
		"\t\t%d data packet%s (%d byte%s)\n");
	p2(tcps_sndrexmitpack, tcps_sndrexmitbyte,
		"\t\t%d data packet%s (%d byte%s) retransmitted\n");
	p2(tcps_sndacks, tcps_delack,
		"\t\t%d ack-only packet%s (%d delayed)\n");
	p(tcps_sndurg, "\t\t%d URG only packet%s\n");
	p(tcps_sndprobe, "\t\t%d window probe packet%s\n");
	p(tcps_sndwinup, "\t\t%d window update packet%s\n");
	p(tcps_sndctrl, "\t\t%d control packet%s\n");
	p(tcpInSegs, "\t%d packet%s received\n");
	p2(tcps_rcvackpack, tcps_rcvackbyte, "\t\t%d ack%s (for %d byte%s)\n");
	p(tcps_rcvdupack, "\t\t%d duplicate ack%s\n");
	p(tcps_rcvacktoomuch, "\t\t%d ack%s for unsent data\n");
	p2(tcps_rcvpack, tcps_rcvbyte,
		"\t\t%d packet%s (%d byte%s) received in-sequence\n");
	p2(tcps_rcvduppack, tcps_rcvdupbyte,
		"\t\t%d completely duplicate packet%s (%d byte%s)\n");
	p2(tcps_rcvpartduppack, tcps_rcvpartdupbyte,
		"\t\t%d packet%s with some dup. data (%d byte%s duped)\n");
	p2(tcps_rcvoopack, tcps_rcvoobyte,
		"\t\t%d out-of-order packet%s (%d byte%s)\n");
	p2(tcps_rcvpackafterwin, tcps_rcvbyteafterwin,
		"\t\t%d packet%s (%d byte%s) of data after window\n");
	p(tcps_rcvwinprobe, "\t\t%d window probe%s\n");
	p(tcps_rcvwinupd, "\t\t%d window update packet%s\n");
	p(tcps_rcvafterclose, "\t\t%d packet%s received after close\n");
	p(tcps_rcvbadsum, "\t\t%d discarded for bad checksum%s\n");
	p(tcps_rcvbadoff, "\t\t%d discarded for bad header offset field%s\n");
	p(tcps_rcvshort, "\t\t%d discarded because packet too short\n");
	p(tcps_connattempt, "\t%d connection request%s\n");
	p(tcpPassiveOpens, "\t%d connection accept%s\n");
	p(tcps_connects, "\t%d connection%s established (including accepts)\n");
	p2(tcps_closed, tcps_drops,
		"\t%d connection%s closed (including %d drop%s)\n");
	p(tcps_conndrops, "\t%d embryonic connection%s dropped\n");
	p2(tcps_rttupdated, tcps_segstimed,
		"\t%d segment%s updated rtt (of %d attempt%s)\n");
	p(tcps_rexmttimeo, "\t%d retransmit timeout%s\n");
	p(tcps_timeoutdrop, "\t\t%d connection%s dropped by rexmit timeout\n");
	p(tcps_persisttimeo, "\t%d persist timeout%s\n");
	p(tcps_keeptimeo, "\t%d keepalive timeout%s\n");
	p(tcps_keepprobe, "\t\t%d keepalive probe%s sent\n");
	p(tcps_keepdrops, "\t\t%d connection%s dropped by keepalive\n");
#undef p
#undef p2
}

/*
* Dump UDP statistics structure.
*/
udp_stats(off, name)
off_t off;
char *name;
{
	struct strioctl strioctl;
	struct udpstat udpstat;

	strioctl.ic_cmd = UDPIOC_GETUDPSTAT;
	strioctl.ic_timout = 0;
	strioctl.ic_len = sizeof udpstat;
	strioctl.ic_dp  = (char *)&udpstat;
	if (ioctl(fdudp, I_STR, &strioctl )<0) {
		if (errno != EADDRNOTAVAIL )
			perror( "netstat: udp_stats" );
		return;		
	}

	printf("%s:\n\t%d bad header checksum%s\n", name,
		udpstat.udps_badsum, plural(udpstat.udps_badsum));
	printf("\t%d incomplete header%s\n",
		udpstat.udps_hdrops, plural(udpstat.udps_hdrops));
	printf("\t%d bad data length field%s\n",
		udpstat.udps_badlen, plural(udpstat.udps_badlen));
}

/*
* Dump IP statistics structure.
*/
ip_stats(off, name)
off_t off;
char *name;
{
	struct strioctl strioctl;
	struct ipstat ipstat;

	strioctl.ic_cmd = IPIOC_GETIPSTAT;
	strioctl.ic_timout = 0;
	strioctl.ic_len = sizeof ipstat;
	strioctl.ic_dp  = (char *)&ipstat;
	if (ioctl(fdip, I_STR, &strioctl )<0) {
		if (errno != EADDRNOTAVAIL )
			perror( "netstat: ip_stats" );
		return;		
	}
	printf("%s:\n\t%u total packets received\n", name, ipstat.ips_total);
	printf("\t%d bad header checksum%s\n",
		ipstat.ips_badsum, plural(ipstat.ips_badsum));
	printf("\t%d with size smaller than minimum\n", ipstat.ips_tooshort);
	printf("\t%d with data size < data length\n", ipstat.ips_toosmall);
	printf("\t%d with header length < data size\n", ipstat.ips_badhlen);
	printf("\t%d with data length < header length\n", ipstat.ips_badlen);
	printf("\t%u fragment%s received\n",
		ipstat.ips_fragments, plural(ipstat.ips_fragments));
	printf("\t%u fragment%s dropped (dup or out of space)\n",
		ipstat.ips_fragdropped, plural(ipstat.ips_fragdropped));
	printf("\t%u fragment%s dropped after timeout\n",
		ipstat.ips_fragtimeout, plural(ipstat.ips_fragtimeout));
	printf("\t%u packet%s forwarded\n",
		ipstat.ips_forward, plural(ipstat.ips_forward));
	printf("\t%u packet%s not forwardable\n",
		ipstat.ips_cantforward, plural(ipstat.ips_cantforward));
	printf("\t%u redirect%s sent\n",
		ipstat.ips_redirectsent, plural(ipstat.ips_redirectsent));
}

static	char *icmpnames[] = {
	"echo reply",
	"#1",
	"#2",
	"destination unreachable",
	"source quench",
	"routing redirect",
	"#6",
	"#7",
	"echo",
	"#9",
	"#10",
	"time exceeded",
	"parameter problem",
	"time stamp",
	"time stamp reply",
	"information request",
	"information request reply",
	"address mask request",
	"address mask reply"
};

/*
 * Dump ICMP statistics.
 */
icmp_stats(off, name)
	off_t off;
	char *name;
{
	struct strioctl strioctl;
	struct icmpstat icmpstat;
	register int i, first;

	strioctl.ic_cmd = IPIOC_GETICMPSTAT;
	strioctl.ic_timout = 0;
	strioctl.ic_len = sizeof icmpstat;
	strioctl.ic_dp  = (char *)&icmpstat;
	if (ioctl(fdip, I_STR, &strioctl )<0) {
		if (errno != EADDRNOTAVAIL )
			perror( "netstat: icmp_stats" );
		return;		
	}

	printf("%s:\n\t%d call%s to icmp_error\n", name,
		icmpstat.icps_error, plural(icmpstat.icps_error));
	printf("\t%d error%s not generated 'cuz old message too short\n",
		icmpstat.icps_oldshort, plural(icmpstat.icps_oldshort));
	printf("\t%d error%s not generated 'cuz old message was icmp\n",
		icmpstat.icps_oldicmp, plural(icmpstat.icps_oldicmp));
	for (first = 1, i = 0; i < ICMP_MAXTYPE + 1; i++)
		if (icmpstat.icps_outhist[i] != 0) {
			if (first) {
				printf("\tOutput histogram:\n");
				first = 0;
			}
			printf("\t\t%s: %d\n", icmpnames[i],
				icmpstat.icps_outhist[i]);
		}
	printf("\t%d message%s with bad code fields\n",
		icmpstat.icps_badcode, plural(icmpstat.icps_badcode));
	printf("\t%d message%s < minimum length\n",
		icmpstat.icps_tooshort, plural(icmpstat.icps_tooshort));
	printf("\t%d bad checksum%s\n",
		icmpstat.icps_checksum, plural(icmpstat.icps_checksum));
	printf("\t%d message%s with bad length\n",
		icmpstat.icps_badlen, plural(icmpstat.icps_badlen));
	for (first = 1, i = 0; i < ICMP_MAXTYPE + 1; i++)
		if (icmpstat.icps_inhist[i] != 0) {
			if (first) {
				printf("\tInput histogram:\n");
				first = 0;
			}
			printf("\t\t%s: %d\n", icmpnames[i],
				icmpstat.icps_inhist[i]);
		}
	printf("\t%d message response%s generated\n",
		icmpstat.icps_reflect, plural(icmpstat.icps_reflect));
}

/*
 * Pretty print an Internet address (net address + port).
 * If the nflag was specified, use numbers instead of names.
 */
inetprint(addr, port, proto)
	register unsigned long *addr;
	unsigned short port;
	char *proto;
{
	struct servent *sp = 0;
	char line[80], *cp;
	struct in_addr in;
	int width;
	
	in.s_addr = *addr;
	sprintf(line, "%.*s.", (Aflag && !nflag) ? 12 : 16, inetname(in));
	cp = index(line, '\0');
	if (!nflag && port)
		sp = getservbyport(port, proto);
	if (sp || port == 0)
		sprintf(cp, "%.8s", sp ? sp->s_name : "*");
	else {
		port = ntohs(port);
		sprintf(cp, "%d", port);
	}
	width = Aflag ? 18 : 22;
	printf(" %-*.*s", width, width, line);
}

/*
 * Construct an Internet address representation.
 * If the nflag has been supplied, give 
 * numeric value, otherwise try for symbolic name.
 */
#define MAXHOSTNAMELEN  255	/* arbitrarily large */

char *
inetname(in)
	struct in_addr in;
{
	register char *cp = 0;
	static char line[50];
	struct hostent *hp;
	struct netent *np;
	static char domain[MAXHOSTNAMELEN + 1];

	static int first = 1;
	domain[0] = 0;

	if (first && !nflag) {
		first = 0;
		if (gethostname(domain, MAXHOSTNAMELEN) == 0) 
			/* now get the full name including the domain */
			if ((hp = gethostbyname(domain))) {
				strcpy(domain, hp->h_name);
		   		if (cp = index(domain, '.'))
					(void) strcpy(domain, cp + 1);
			}
	}
	cp = 0;
	if (!nflag && in.s_addr != INADDR_ANY)  {
		if (inet_lnaof(in) == INADDR_ANY) {
			np = getnetbyaddr(inet_netof(in), AF_INET);
			if (np)
				cp = np->n_name;
		} 
		if (cp == 0)  {
			hp = gethostbyaddr(&in, sizeof (struct in_addr),
				AF_INET);
			if (hp) {
				if ((cp = index(hp->h_name, '.')) &&
				   !strncmp(cp + 1, domain, strlen(domain)))
					*cp = 0;
				cp = hp->h_name;
			}
		}
	}
	if (in.s_addr == INADDR_ANY)
		strcpy(line, "*");
	else if (cp)
		strcpy(line, cp);
	else {
		unchar *ucp = (unchar *)&in;
		sprintf(line, "%u.%u.%u.%u", ucp[0], ucp[1], ucp[2], ucp[3]);
	}
	return (line);
}

kread(fd,buf,size){
	if ( read(fd,buf,size) < 0 ){
		perror("kread: read");
		exit(2);
	}
}
