/*
 *  @(#) Copyright (c) 1985  The Wollongong Group, Inc.  All Rights Reserved
 */

#ident "@(#)ftp.c (TWG)  1.5     89/09/15 "

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/poll.h>
#include <sys/ip.h>
#include <sys/tcp.h>
#include <sys/inetioctl.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/in.h>
#include <arpa/ftp.h>

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#include <tiuser.h>
#include <sys/fcntl.h>

/*
 * FTP global variables.
 */

/*
 * Options and other state info.
 */
extern int	hash;		/* print # for each buffer transferred */
extern int	verbose;	/* print messages coming back from server */
extern int	connected;	/* connected to server */
extern int	debug;		/* debugging level */
extern int	type;		/* file transfer type */
extern int	options;	/* used during socket creation */
extern char	*hostname;	/* name of host connected to */

#include <setjmp.h>

int	sendport = -1;		/* use PORT cmd for each data connection */
struct	sockaddr_in hisctladdr;
struct	sockaddr_in ret_addr;
struct	sockaddr_in data_addr;
int	data = -1;
int	ReplyCode;
extern 	errno, t_errno;
struct	sockaddr_in myctladdr;
static	int _result;
extern	int trace;

#define Trace(a, b, c) {if (trace) Tracer(a,b,c);}
#define FTPLOG		"/tmp/ftplog"

FILE	*cin, *cout;
int	dataconn();
extern int pio;
int	do_getreply = 1;

struct hostent *
hookup(host, port)
	char *host;
	int port;
{
	register struct hostent *hp;
	int s, s1, len;
	struct t_bind rep;
	struct t_call scall,  *sndcall = &scall;

	bzero((char *)&hisctladdr, sizeof (hisctladdr));
	hp = gethostbyname(host);
	if (hp == NULL) {
		static struct hostent def;
		static struct in_addr defaddr;
		static char namebuf[128];
		static ulong adr = (ulong)&defaddr;
		int inet_addr();

		defaddr.s_addr = inet_addr(host);
		if (defaddr.s_addr == -1) {
			fprintf(stderr, "%s: Unknown host.\n", host);
			return ((struct hostent *)0);
		}
		strcpy(namebuf, host);
		def.h_name = namebuf;
		hostname = namebuf;
		def.h_addr_list = (char **)&adr;
		def.h_length = sizeof (struct in_addr);
		def.h_addrtype = AF_INET;
		def.h_aliases = 0;
		hp = &def;
	}
	hostname = hp->h_name;
	hisctladdr.sin_family = hp->h_addrtype;
	hisctladdr.sin_port = port;
	bcopy((caddr_t)hp->h_addr, (char *)&hisctladdr.sin_addr, hp->h_length);
	if((s = t_open(DEV_TCP,O_RDWR,0)) < 0) {
		t_error("ftp: t_open failure");
		return ((struct hostent *)0);
	}
	bzero((caddr_t) &myctladdr, sizeof(myctladdr));
	rep.addr.maxlen = sizeof(myctladdr);
	rep.addr.len = TCP_BINDADDRLEN;
	rep.qlen = 0;
	rep.addr.buf = (char *)&myctladdr;
	if(t_bind(s, 0, &rep) < 0) {
		t_error("ftp: t_bind failure");
		goto bad;
	}
	sndcall->addr.buf = (char *)&hisctladdr;
	sndcall->addr.len = TCP_BINDADDRLEN;
	sndcall->udata.len = sndcall->opt.len = 0;
	if (t_connect(s, sndcall, 0) < 0) {
	    errno &= 0xff;
		if (t_errno == TSYSERR)
			perror("ftp: connect");
		else if (t_errno == TBADADDR) {
			errno = ENETUNREACH;
			perror("ftp: connect");
		} else
			t_error("ftp: t_connect");
		signal(SIGINT, SIG_DFL);
		goto bad;
	}
	if ((s1 = dup(s)) < 0) {
	    perror("ftp: dup");
	    goto bad;
	    }
	if(t_sync(s1) < 0) {
	    t_error("ftp: t_sync failure");
	    goto bad;
	    }
	/*
	 * POP the TIMOD module and put the tirdwr
	 */
	if (ioctl(s, I_POP, 0) < 0){
		perror("ftp: I_POP");
		goto bad;
	}
	if (ioctl(s, I_PUSH, "tirdwr") < 0){
		perror("ftp: I_PUSH");
		goto bad;
	}
	len = sizeof (myctladdr);
	if (getsockname(s, (char *)&myctladdr, &len) < 0) {
		perror("ftp: getsockname");
		goto bad;
	}
	cin = fdopen(s, "r");
	cout = fdopen(s1, "w");
	if (cin == NULL || cout == NULL) {
		fprintf(stderr, "ftp: fdopen failed.\n");
		if (cin)
			fclose(cin);
		if (cout)
			fclose(cout);
		goto bad;
	}
	connected = 1;
	if (verbose)
		printf("Connected to %s.\n", hp->h_name);
	(void) getreply(0); 		/* read startup message from server */
	return (hp);
bad:
	t_close(s);
	return ((struct hostent *)0);
}

login(hp)
	struct hostent *hp;
{
	char acct[80];
	char *user, *pass;
	int n;

	user = pass = 0;
	rusername(hp->h_name, &user, &pass);
	n = command("USER %s", user);
	if(ReplyCode == 331) {
		ruserpasswd(hp->h_name, &user, &pass);
		n = command("PASS %s", pass);
	}
	if(ReplyCode == 332) {
		printf("Account: "); (void) fflush(stdout);
		(void) fgets(acct, sizeof(acct) - 1, stdin);
		acct[strlen(acct) - 1] = '\0';
		n = command("ACCT %s", acct);
	}
	if (n != COMPLETE) {
		fprintf(stderr, "Login failed.\n");
		return (0);
	}
	return (1);
}
/*VARARGS 1*/
command(fmt, args)
	char *fmt;
{
	int (*old_int)();
	int result;

	if (debug) {
		printf("---> ");
		_doprnt(fmt, &args, stdout);
		printf("\n");
		(void) fflush(stdout);
	}
	if (cout == NULL) {
		perror ("ftp: no control connection for command");
		return (0);
	}

	/* We ignore interrupts around this code, since otherwise ftp and 
	 * ftpd can get out of sync if the user enters a command and then 
	 * very quickly hits the del key.
	 */
	old_int = (int (*) ()) signal (SIGINT, SIG_IGN);
	_doprnt(fmt, &args, cout);
	fprintf(cout, "\r\n");
	(void) fflush(cout);
	if (do_getreply)
		result = getreply(!strcmp(fmt, "QUIT"));
	else
		result = 1; 	/* dummy value */
	(void)signal (SIGINT, old_int);
	return(result);
}

#include <ctype.h>

getreply(expecteof)
	int expecteof;
{
	register int c, n;
	register int code, dig;
	int originalcode = 0, continuation = 0;
	ReplyCode = 0;
	for (;;) {
		dig = n = code = 0;
		while ((c = getc(cin)) != '\n') {
			dig++;
			if (c == EOF) {
				if (expecteof)
					return (0);
				lostpeer();
				exit(1);
			}
			if (verbose && c != '\r' ||
			    (n == '5' && dig > 4))
				putchar(c);
			if (dig < 4 && isdigit(c))
				code = code * 10 + (c - '0');
			if (dig == 4 && c == '-')
				continuation++;
			if (n == 0)
				n = c;
		}
		if (verbose || n == '5') {
			putchar(c);
			(void) fflush (stdout);
		}
		if (continuation && code != originalcode) {
			if (originalcode == 0)
				originalcode = code;
			continue;
		}
		ReplyCode = code;
#ifdef notdef			/* read only one line and return. */
		if (expecteof || empty(cin))
#endif /* notdef */
			return (n - '0');
	}
}

#ifdef notdef			/* read only one line and return. */
empty(f)
	FILE *f;
{
	int data = 0;
	struct timeval t;

	if (f->_cnt > 0)
		return (0);
	ioctl(fileno(f), I_NREAD, &data);
	return (data == 0);
}
#endif /* notdef */

jmp_buf	sendabort;

abortsend()
{

	fflush(stdout);
	longjmp(sendabort, 1);
}

sendrequest(cmd, local, remote)
	char *cmd, *local, *remote;
{
	FILE *fin, *popen();
	int (*closefunc)(), pclose(), fclose(), (*oldintr)();
	char buf[BUFSIZ*8];
	long bytes = 0, hashbytes = sizeof (buf);
	register int c, d;
	register char *cp;
	struct stat st;
	int datastarted = 0;
	int (*old_int)();
	long start, stop;
	struct tms startbuf, stopbuf;
	int pid, ret = 0;
	
	_result = 0;
	closefunc = NULL;
	if (setjmp(sendabort)) {
		_result = -1;	/* -1 to indicate we've been interrupted */
		goto bad;
	}
	oldintr = (int (*)())signal(SIGINT, abortsend);
	if (strcmp(local, "-") == 0)
		fin = stdin;
	else if (*local == '|') {
		fin = popen(local + 1, "r");
		if (fin == NULL) {
			perror(local + 1);
			goto bad;
		}
		closefunc = pclose;
	} else {
		fin = fopen(local, "r");
		if (fin == NULL) {
			perror(local);
			goto bad;
		}
		closefunc = fclose;
		if (fstat(fileno(fin), &st) < 0 ||
		    (st.st_mode&S_IFMT) != S_IFREG) {
			fprintf(stderr, "%s: not a plain file.\n", local);
			goto bad;
		}
	}

	old_int = (int (*) ()) signal (SIGINT, SIG_IGN);
	if (initconn())
		goto bad;

	do_getreply = 0;
	if (remote) 
		(void) command("%s %s", cmd, remote);
	 else
		(void) command("%s", cmd);
	do_getreply = 1;
	if ((pid = fork()) == 0) {
		data = dataconn("w");
		exit(data);
	} 
	if(getreply(!strcmp(cmd, "QUIT")) != PRELIM) {
		kill(pid, SIGKILL); 
		(void) wait((int *) 0);
		goto bad;
	}
	datastarted = 1;
	(void) wait(&ret);
	data = (ret >> 8) & 0xff;
	if (data == 0xff)
		data = -1;
	if (data == -1)
		goto bad;

	start = times(&startbuf);
	(void)signal (SIGINT, old_int);

	switch (type) {

	case TYPE_I:
	case TYPE_L:
		errno = d = 0;
		while ((c = read(fileno (fin), buf, sizeof (buf))) > 0) {
			if ((d = t_snd(data, buf, c, 0)) != c) {
				/*
				 * We can really recover but not now XX
				 */
				t_error("ftp: t_snd failure");
				goto bad;
			}
			Trace("read %d sent %d\n", c, d);
			bytes += c;
			if (hash) {
				putchar('#');
				fflush(stdout);
			}
		}
		if (hash && bytes > 0) {
			putchar('\n');
			fflush(stdout);
		}
		if (c < 0)
			perror(local);
		break;

	case TYPE_A:
#define Xputc(c)  {if (cp >= (buf+sizeof(buf))){ \
			if (t_snd(data, buf, cp-buf, 0) < 0 ) { \
				t_error("ftp: t_snd failure"); \
				goto bad; \
			} \
			cp = buf; \
		    } \
		    *cp++ = c; }

		cp = buf;
		while ((c = getc(fin)) != EOF) {
			if (c == '\n') {
				while (hash && (bytes >= hashbytes)) {
					putchar('#');
					fflush(stdout);
					hashbytes += sizeof (buf);
				}
				Xputc('\r');
				/* putc('\r', dout); */
				bytes++;
			}
			Xputc(c);
			/* putc(c, dout); */
			bytes++;
			if (c == '\r') {
				/* putc('\0', dout); */
				Xputc(0);
				bytes++;
			}
		}
		if (cp != buf){
			if (t_snd(data, buf, cp-buf, 0) < 0) {
				t_error("ftp: t_snd failure");
				goto bad;
			}
			cp = buf;
		}
		if (hash) {
			if (bytes < hashbytes)
				putchar('#');
			putchar('\n');
			fflush(stdout);
		}
		if (ferror(fin))
			perror(local);
		break;
	}
	stop = times(&stopbuf);
	if (closefunc != NULL)
		(*closefunc)(fin);

	if (data != -1) {
		t_sndrel(data);
		t_rcvrel(data);
/*		_nolinger_tclose(data);*/
		t_close(data);
	}
	data = -1;

	(void) getreply(0);
	_result = 0;
done:
	signal(SIGINT, oldintr);
	if (bytes > 0 && verbose)
		ptransfer("sent", bytes, &start, &startbuf, &stop, &stopbuf);
	return(_result);
bad:
	stop = times(&stopbuf);
	if (_result == 0)
		_result = -1; /* an error return, but we weren't interrupted */
	if (closefunc != NULL && fin != NULL)
		(*closefunc)(fin);
	if (data >= 0) {
		/* if it's an error we want to close the connection asap */
		fcntl(data, F_SETFL, O_NDELAY);
		t_close(data);
		data = -1;
	}
	if(hash) {
		printf("\n");
		fflush(stdout);
	}
	if(datastarted)
		(void) getreply(0);
	goto done;
}

jmp_buf	recvabort;

abortrecv()
{

	fflush(stdout);
	longjmp(recvabort, 1);
}

recvrequest(cmd, local, remote, mode)
	char *cmd, *local, *remote, *mode;
{
	FILE *fout, *popen();
	int (*closefunc)(), pclose(), fclose(), (*oldintr)();
	char buf[BUFSIZ*8];
	long bytes = 0, hashbytes = sizeof (buf);
	register int c, d;
	register int cnt;
	register char *cp;
	int datastarted = 0;
	int flags;
	long start, stop;
	struct tms startbuf, stopbuf;
	int (*old_int)();
	struct stat status;
	int pid, ret = 0;

	_result = 0;
	fout = NULL;
	closefunc = NULL;
	if (setjmp(recvabort)) {
		_result = -1;	/* -1 to indicate we've been interrupted */
		goto bad;
	}
	oldintr = (int (*)())signal(SIGINT, abortrecv);
	if (strcmp(local, "-") && *local != '|')
		if (access(local, 2) < 0) {
			char *dir = (char *)rindex(local, '/');

			if (dir != NULL && dir != local)
				*dir = 0;
			if (access(dir ? (dir==local ? "/" :local) : ".", 2) < 0) {
				perror(local);
				goto bad;
			}
			if (dir != NULL)
				*dir = '/';
		}
	if (strcmp(local, "-") == 0)
		fout = stdout;
	else if (*local == '|') {
		fout = popen(local + 1, "w");
		closefunc = pclose;
		pio++;
		if (fout == NULL) {
			perror(local + 1);
			goto bad;
		}
	} else {
		if (stat(local, &status) == 0)
			if ((status.st_mode & S_IFMT) == S_IFDIR) {
				/* the local file exists and is a directory */
				char tmpbuf[256];
				char *dir  =  (char *)rindex(remote,'/');
				if(dir == NULL) dir = remote;
				else dir++;
				sprintf(tmpbuf,"%s/%s",local,dir);
				local = tmpbuf;
				/* open the file later */
			}

		if (strcmp(mode, "w") == 0)
			if (stat(local, &status) == 0)
				if (access(local, 02) < 0) {
					/* local file exists but does not have
					 * write permissions.
					 */
					perror(local);
					goto bad;
				}
	}
	old_int = (int (*) ()) signal (SIGINT, SIG_IGN);
	if (initconn()) {
		goto bad;
	}
	do_getreply = 0;
	if (remote) 
		(void) command("%s %s", cmd, remote);
	 else
		(void) command("%s", cmd);
	do_getreply = 1;
	if ((pid = fork()) == 0) {
		data = dataconn("r");
		exit(data);
	} 
	if(getreply(!strcmp(cmd, "QUIT")) != PRELIM) {
		kill(pid, SIGKILL); 
		(void) wait((int *) 0);
		goto bad;
	}
	datastarted = 1;
	(void) wait(&ret);
	data = (ret >> 8) & 0xff;
	if (data == 0xff)
		data = -1;
	if (data == -1)
		goto bad;

	if (fout == NULL) {
		fout = fopen(local, mode);
		if (fout == NULL) {
			perror(local);
			goto bad;
		}
		closefunc = fclose;
	}

	start = times(&startbuf);
	(void)signal (SIGINT, old_int);
	switch (type) {

	case TYPE_I:
	case TYPE_L:
		errno = d = 0;
		while ((cnt = t_rcv(data, buf, sizeof (buf), &flags)) > 0) {
			Trace("Got %d bytes\n", cnt, 0);
			bytes += cnt;
			hashbytes += cnt;
			if ((d = write(fileno(fout), buf, cnt)) < 0)
				break;
			if (hash && (hashbytes & ~(sizeof (buf) - 1))) {
				putchar('#');
				fflush(stdout);
				hashbytes &= sizeof (buf) -1;
			}
		}
		if (hash && hashbytes > 0) {
			putchar('\n');
			fflush(stdout);
		}
		if (d < 0)
			perror(local);
		break;

	case TYPE_A:
		while ((cnt = t_rcv(data, buf, sizeof(buf), &flags)) > 0){
			cp = buf;
			while (cnt-- > 0) {
				c = *cp++;
				if (c == '\r') {
					while (hash && (bytes >= hashbytes)) {
						putchar('#');
						fflush(stdout);
						hashbytes += sizeof (buf);
					}
					bytes++;
					if (cnt == 0){
						cnt=t_rcv(data, buf,
							sizeof(buf), &flags);
						if (cnt < 0) {
							goto Done;
						}
						cp = buf;
						if (cnt == 0) goto Putit;
					}
					cnt-- ;
					if ((c = *cp++) != '\n') {
						if (ferror (fout))
							break;
						putc ('\r', fout);
					}
					if (c == '\0') {
						bytes++;
						continue;
					}
				}
Putit:
				putc (c, fout);
				bytes++;
			}
		}
Done:
		if (hash) {
			if (bytes < hashbytes)
				putchar('#');
			putchar('\n');
			fflush(stdout);
		}
		if (ferror (fout))
			perror (local);
		break;
	}
	stop = times(&stopbuf);

	if (data != -1)
	    t_close(data);
/*		_nolinger_tclose(data);*/
	data = -1;
	if (closefunc != NULL) {
		(*closefunc)(fout);
		pio = 0;
	}
	(void) getreply(0);
	_result = 0;
done:
	signal(SIGINT, oldintr);
	if (bytes > 0 && verbose)
		ptransfer("received", bytes, &start, &startbuf, &stop, &stopbuf);
	return(_result);;
bad:
	stop = times(&stopbuf);
	if (_result == 0)
		_result = -2; /* an error return, but we weren't interrupted */

	if (closefunc != NULL && fout != NULL) {
		(*closefunc)(fout);
		pio = 0;
	}

	if (data >= 0) {
	    t_close(data);
/*		_nolinger_tclose(data);*/
		data = -1;
	}

	if (hash) printf("\n");
	if(datastarted)
		(void) getreply(0);
	goto done;
}

/*
 * Need to start a listen on the data channel
 * before we send the command, otherwise the
 * server's connect may fail.
 */

initconn()
{
	register char *p, *a;
	int result, len, on=1;
	struct t_call *scall;
	struct t_bind ret;
	struct t_bind req;
	struct strioctl ioc;

noport:
	data_addr = myctladdr;
	if (sendport)
		data_addr.sin_port = 0;	/* let system pick one */ 
	    
	if (data != -1)
		(void) t_close (data);

	/*
	 * Open the data stream
	 */
	if ((data = t_open(DEV_TCP,O_RDWR,0)) < 0) {
		t_error("ftp: t_open failure");
		return (1);
	}
	if (!sendport)
	    if (setsockopt(data, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on))) {
		t_error("ftp: unable to reuse port");
		goto bad;
		}
	/*
	 * Bind with size of one connection.
	 */
	req.addr.buf = (char *) &data_addr;
	req.addr.len = TCP_BINDADDRLEN;
	req.qlen = 1;

	bzero((caddr_t) &ret_addr, sizeof(ret_addr));
	ret.addr.maxlen = sizeof(ret_addr);
	ret.addr.len = TCP_BINDADDRLEN;
	ret.qlen = 0;
	ret.addr.buf = (char *)&ret_addr;

	if (t_bind(data, &req, &ret) < 0) {
		t_error("ftp: t_bind failure");
		goto bad;
	}

	data_addr = ret_addr; /* use the address the system chose */
	len = sizeof (data_addr);
	if (getsockname(data, (char *)&data_addr, &len) < 0) {
		perror("ftp: getsockname");
		goto bad;
	}

	if (sendport) {
		a = (char *)&data_addr.sin_addr.s_addr;
		p = (char *)&data_addr.sin_port;
#define	UC(b)	(((int)b)&0xff)
		result =
		    command("PORT %d,%d,%d,%d,%d,%d",
		      UC(a[0]), UC(a[1]), UC(a[2]), UC(a[3]),
		      UC(p[0]), UC(p[1]));
		if (result == ERROR && sendport == -1) {
			sendport = 0;
			goto noport;
		}
		return (result != COMPLETE);
	}
	return (0);
bad:
	if (data != -1) {
		t_close(data);
	}
	data = -1;
	return (1);
}

jmp_buf listenabort;

static
listabort()
{
	fflush(stdout);
	longjmp(listenabort, 1);
}

dataconn(typ)
	char *typ;
{
	struct t_call *scall;
	int i = 0;

	/*
	 * Accept a connection from the network.
	 */

	if((scall = (struct t_call *)t_alloc(data, T_CALL, T_ADDR)) < 0) {
		t_error("ftp: t_alloc failure");
		goto bad;
	}

	if (setjmp(listenabort) == 0) {
		signal(SIGINT, listabort); /* must allow interrupts here */
		if (t_listen(data,scall) < 0) {
			t_error("ftp: t_listen failure");
			goto bad;
		}
	} else {
		_result = -1;	/* -1 indicates an interrupt has occurred */
		goto bad;	/* we've been interrupted */
	}
	(void)signal (SIGINT, SIG_IGN);

	if (t_accept(data, data, scall) < 0) {
		t_error("ftp: t_accept failure");
		goto bad;
	}
	(void) t_free (scall, T_CALL);
	if (*typ == 'w') for (;;) {
		/*
		 * Due to an incompatibilty in TLI, and TCP
		 * We get to a TLI state of Established before
		 * we get into a TCP Established state. Here
		 * we just check for this.
		 */
		struct strioctl ioc;
		long tc_state;

		ioc.ic_dp = (char *)&tc_state; ioc.ic_len = sizeof (long);
		ioc.ic_cmd = TCPIOC_GETMYSTATE;
		ioc.ic_timout = 60;
		if (ioctl (data, I_STR, &ioc) < 0) {
			perror("ftp: I_STR ioctl failure - can't get TCP state");
			exit(1);
		}else  if (tc_state < TV_ESTABLISHED) {
			sleep (1);
		}
		else {
			break;
		}
		if (i++ > 10) { /* we don't want to stay in this loop forever */
			fprintf(stderr, "ftp: TCP can't get to Established State\n");
			exit(1);
		}
	} 

	Trace("Accepted connection on data..\n", 0, 0);
	return (data);
bad:
	if (data != -1) {
		t_close(data);
	}
	data = -1;
	return (data);
}

ptransfer(direction, bytes, t0, ts0, t1, ts1)
	char *direction;
	long bytes;
	long *t0, *t1;
        struct tms *ts0, *ts1;
{
	long ticks, uticks;
	unsigned long bs;	/* bytes per second */

	ticks = *t1 - *t0;
	uticks = (ts1->tms_utime - ts0->tms_utime) + (ts1->tms_stime - ts0->tms_stime);
	printf("%ld bytes %s in %ld.%02ld seconds",
	       bytes, direction, ticks/HZ, ((ticks%HZ)*100)/HZ);

	if(ticks > 0)
		printf(" (%ld bytes/s)",(bytes*HZ)/ticks);
	printf("\n");
}

Tracer(fmt,a, b)
{
	FILE *fp;
	fp = fopen(FTPLOG, "a");
	if (fp){
		fprintf(fp, fmt, a, b);
		fclose(fp);
	}
}
